/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.sql.SqlColumnMetadata;

public final class SqlColumnMetadataCodec {
    private static final int TYPE_FIELD_OFFSET = 0;
    private static final int NULLABLE_FIELD_OFFSET = 4;
    private static final int INITIAL_FRAME_SIZE = 5;

    private SqlColumnMetadataCodec() {
    }

    public static void encode(ClientMessage clientMessage, SqlColumnMetadata sqlColumnMetadata) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[5]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, sqlColumnMetadata.getType());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 4, sqlColumnMetadata.isNullable());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, sqlColumnMetadata.getName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static SqlColumnMetadata decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        boolean isNullableExists = false;
        boolean nullable = false;
        if (initialFrame.content.length >= 5) {
            nullable = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 4);
            isNullableExists = true;
        }
        String name = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createSqlColumnMetadata(name, type, isNullableExists, nullable);
    }
}

