/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.cp;

import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public class CPMapConfig {
    public static final int DEFAULT_MAX_SIZE_MB = 100;
    private static final int LIMIT_MAX_SIZE_MB = 2000;
    private String name;
    private int maxSizeMb = 100;

    public CPMapConfig() {
    }

    public CPMapConfig(String name) {
        this(name, 100);
    }

    public CPMapConfig(String name, int maxSizeMb) {
        this.setName(name).setMaxSizeMb(maxSizeMb);
    }

    public CPMapConfig(CPMapConfig config) {
        this.setName(config.name).setMaxSizeMb(config.maxSizeMb);
    }

    public int getMaxSizeMb() {
        return this.maxSizeMb;
    }

    public CPMapConfig setMaxSizeMb(int maxSizeMb) {
        Preconditions.checkPositive("maxSizeMb", maxSizeMb);
        if (maxSizeMb > 2000) {
            throw new IllegalArgumentException("maxSizeMb is " + maxSizeMb + " but must be <= 2000");
        }
        this.maxSizeMb = maxSizeMb;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public CPMapConfig setName(String name) {
        this.name = Preconditions.checkNotNull(name, "Name must not be null");
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CPMapConfig that = (CPMapConfig)object;
        return this.maxSizeMb == that.maxSizeMb && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.maxSizeMb);
    }

    public String toString() {
        return "CPMapConfig{name='" + this.name + "', maxSizeMb=" + this.maxSizeMb + "}";
    }
}

