/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ArrayDataSerializableFactory
implements DataSerializableFactory {
    private final Supplier<IdentifiedDataSerializable>[] constructors;
    private final int len;

    public ArrayDataSerializableFactory(Supplier<IdentifiedDataSerializable>[] ctorArray) {
        if (ctorArray == null || ctorArray.length <= 0) {
            throw new IllegalArgumentException("ConstructorFunction array cannot be null");
        }
        this.len = ctorArray.length;
        this.constructors = new Supplier[this.len];
        System.arraycopy(ctorArray, 0, this.constructors, 0, this.len);
    }

    @Override
    @Nullable
    public IdentifiedDataSerializable create(int typeId) {
        if (typeId >= 0 && typeId < this.len) {
            Supplier<IdentifiedDataSerializable> factory = this.constructors[typeId];
            return factory != null ? factory.get() : null;
        }
        return null;
    }

    public void mergeConstructors(@Nonnull Supplier<IdentifiedDataSerializable>[] ctorArray) {
        if (this.constructors.length < ctorArray.length) {
            throw new IllegalArgumentException("Too many constructors");
        }
        for (int i = 0; i < ctorArray.length; ++i) {
            if (ctorArray[i] == null) continue;
            if (this.constructors[i] != null) {
                throw new IllegalArgumentException("Overwriting a constructor");
            }
            this.constructors[i] = ctorArray[i];
        }
    }
}

