/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.json.JsonReducedValueParser;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.serialization.impl.ByteArrayObjectDataInput;
import com.hazelcast.internal.serialization.impl.NavigableJsonInputAdapter;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.query.impl.getters.JsonPathCursor;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonFactory;
import com.hazelcast.shaded.com.fasterxml.jackson.core.JsonParser;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationThread;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class DataInputNavigableJsonAdapter
extends NavigableJsonInputAdapter {
    private final int initialOffset;
    private BufferObjectDataInput input;

    public DataInputNavigableJsonAdapter(BufferObjectDataInput input, int initialOffset) {
        this.input = input;
        this.input.position(initialOffset);
        this.initialOffset = initialOffset;
    }

    @Override
    public void position(int position) {
        this.input.position(position + this.initialOffset);
    }

    @Override
    public int position() {
        return this.input.position() - this.initialOffset;
    }

    @Override
    public void reset() {
        this.input.position(this.initialOffset);
    }

    @Override
    public boolean isAttributeName(JsonPathCursor cursor) {
        try {
            byte[] nameBytes = cursor.getCurrentAsUTF8();
            if (!this.isQuote()) {
                return false;
            }
            for (int i = 0; i < nameBytes.length; ++i) {
                if (nameBytes[i] == this.input.readByte()) continue;
                return false;
            }
            return this.isQuote();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public JsonValue parseValue(JsonReducedValueParser parser, int offset) throws IOException {
        this.input.position(offset + this.initialOffset);
        return parser.parse(new UTF8Reader(this.input));
    }

    @Override
    public JsonParser createParser(JsonFactory factory) throws IOException {
        return factory.createParser(SerializationUtil.convertToInputStream(this.input, this.initialOffset));
    }

    private boolean isQuote() throws IOException {
        return this.input.readByte() == 34;
    }

    static class UTF8Reader
    extends Reader {
        static final ThreadLocal<CharsetDecoder> DECODER_THREAD_LOCAL = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);
        private final CharsetDecoder decoder;
        private final ByteBuffer inputBuffer;
        private boolean hasLeftoverChar;
        private int leftoverChar;

        UTF8Reader(BufferObjectDataInput input) {
            byte[] data = this.obtainBytes(input);
            this.inputBuffer = ByteBuffer.wrap(data);
            this.inputBuffer.position(input.position());
            this.decoder = Thread.currentThread() instanceof OperationThread ? DECODER_THREAD_LOCAL.get() : StandardCharsets.UTF_8.newDecoder();
        }

        @Override
        public int read() throws IOException {
            if (this.hasLeftoverChar) {
                this.hasLeftoverChar = false;
                return this.leftoverChar;
            }
            char[] buffer = new char[2];
            int charsRead = this.read(buffer, 0, 2);
            switch (charsRead) {
                case -1: {
                    return -1;
                }
                case 2: {
                    this.leftoverChar = buffer[1];
                    this.hasLeftoverChar = true;
                    return buffer[0];
                }
                case 1: {
                    return buffer[0];
                }
            }
            throw new IllegalStateException("Unexpected result from read: " + charsRead);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (off < 0 || off + len > cbuf.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int countRead = 0;
            if (this.hasLeftoverChar) {
                cbuf[off] = (char)this.leftoverChar;
                this.hasLeftoverChar = false;
                ++off;
                --len;
                ++countRead;
            }
            if (len == 0) {
                return countRead;
            }
            if (!this.inputBuffer.hasRemaining()) {
                return -1;
            }
            this.decoder.reset();
            if (len == 1) {
                int charRead = this.read();
                if (charRead == -1) {
                    return countRead == 0 ? -1 : countRead;
                }
                cbuf[off] = (char)charRead;
                return countRead + 1;
            }
            CharBuffer charbuffer = CharBuffer.wrap(cbuf, off, len);
            CoderResult result = this.decoder.decode(this.inputBuffer, charbuffer, true);
            if (result.isError()) {
                result.throwException();
            }
            if (result.isUnderflow() && !this.inputBuffer.hasRemaining()) {
                this.decoder.flush(charbuffer);
            }
            return countRead + charbuffer.position() - off;
        }

        private byte[] obtainBytes(BufferObjectDataInput input) {
            if (input instanceof ByteArrayObjectDataInput) {
                ByteArrayObjectDataInput dataInput = (ByteArrayObjectDataInput)input;
                return dataInput.data;
            }
            throw new IllegalArgumentException("All BufferObjectDataInput are instances of ByteArrayObjectDataInput");
        }

        @Override
        public void close() throws IOException {
        }
    }
}

