/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.jet.impl.execution.BroadcastItem;
import com.hazelcast.jet.impl.execution.OutboundCollector;
import com.hazelcast.jet.impl.util.ProgressState;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConveyorCollector
implements OutboundCollector {
    private final ConcurrentConveyor<Object> conveyor;
    private final int queueIndex;
    private final int[] partitions;

    public ConveyorCollector(@Nonnull ConcurrentConveyor<Object> conveyor, int queueIndex, @Nullable int[] partitions) {
        this.conveyor = Objects.requireNonNull(conveyor);
        this.queueIndex = queueIndex;
        this.partitions = partitions;
    }

    @Override
    public ProgressState offer(Object item) {
        return this.offerToConveyor(item);
    }

    @Override
    public ProgressState offerBroadcast(BroadcastItem item) {
        return this.offerToConveyor(item);
    }

    @Override
    public int[] getPartitions() {
        return this.partitions;
    }

    protected ProgressState offerToConveyor(Object item) {
        return this.conveyor.offer(this.queueIndex, item) ? ProgressState.DONE : ProgressState.NO_PROGRESS;
    }
}

