/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.record.DataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.SimpleRecord;
import com.hazelcast.map.impl.record.SimpleRecordWithLFUEviction;
import com.hazelcast.map.impl.record.SimpleRecordWithLRUEviction;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RecordReaderWriter {
    DATA_RECORD_WITH_STATS_READER_WRITER(2){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getRawCreationTime());
            out.writeInt(record.getRawLastAccessTime());
            out.writeInt(record.getRawLastUpdateTime());
            out.writeInt(record.getHits());
            out.writeInt(record.getVersion());
            out.writeInt(record.getRawLastStoredTime());
        }

        @Override
        public Record readRecord(ObjectDataInput in) throws IOException {
            DataRecordWithStats record = new DataRecordWithStats();
            record.setValue(IOUtil.readData(in));
            record.setRawCreationTime(in.readInt());
            record.setRawLastAccessTime(in.readInt());
            record.setRawLastUpdateTime(in.readInt());
            record.setHits(in.readInt());
            record.setVersion(in.readInt());
            record.setRawLastStoredTime(in.readInt());
            return record;
        }
    }
    ,
    SIMPLE_DATA_RECORD_READER_WRITER(3){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getVersion());
        }

        @Override
        public Record readRecord(ObjectDataInput in) throws IOException {
            SimpleRecord<Data> record = new SimpleRecord<Data>();
            record.setValue(IOUtil.readData(in));
            record.setVersion(in.readInt());
            return record;
        }
    }
    ,
    SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER(4){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getVersion());
            out.writeInt(record.getRawLastAccessTime());
        }

        @Override
        public Record readRecord(ObjectDataInput in) throws IOException {
            SimpleRecordWithLRUEviction<Data> record = new SimpleRecordWithLRUEviction<Data>();
            record.setValue(IOUtil.readData(in));
            record.setVersion(in.readInt());
            record.setRawLastAccessTime(in.readInt());
            return record;
        }
    }
    ,
    SIMPLE_DATA_RECORD_WITH_LFU_EVICTION_READER_WRITER(5){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getVersion());
            out.writeInt(record.getHits());
        }

        @Override
        public Record readRecord(ObjectDataInput in) throws IOException {
            SimpleRecordWithLFUEviction<Data> record = new SimpleRecordWithLFUEviction<Data>();
            record.setValue(IOUtil.readData(in));
            record.setVersion(in.readInt());
            record.setHits(in.readInt());
            return record;
        }
    };

    private byte id;

    private RecordReaderWriter(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static RecordReaderWriter getById(int id) {
        switch (id) {
            case 2: {
                return DATA_RECORD_WITH_STATS_READER_WRITER;
            }
            case 3: {
                return SIMPLE_DATA_RECORD_READER_WRITER;
            }
            case 4: {
                return SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_READER_WRITER;
            }
            case 5: {
                return SIMPLE_DATA_RECORD_WITH_LFU_EVICTION_READER_WRITER;
            }
        }
        throw new IllegalArgumentException("Not known RecordReaderWriter type-id: " + id);
    }

    abstract void writeRecord(ObjectDataOutput var1, Record var2, Data var3) throws IOException;

    public abstract Record readRecord(ObjectDataInput var1) throws IOException;

    private static class TypeId {
        private static final byte DATA_RECORD_WITH_STATS_TYPE_ID = 2;
        private static final byte SIMPLE_DATA_RECORD_TYPE_ID = 3;
        private static final byte SIMPLE_DATA_RECORD_WITH_LRU_EVICTION_TYPE_ID = 4;
        private static final byte SIMPLE_DATA_RECORD_WITH_LFU_EVICTION_TYPE_ID = 5;

        private TypeId() {
        }
    }
}

