/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.calendar;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.bind.adapter.AppointmentReminderAdapter;
import org.apache.openmeetings.db.bind.adapter.BooleanAdapter;
import org.apache.openmeetings.db.bind.adapter.DateAdapter;
import org.apache.openmeetings.db.bind.adapter.LongAdapter;
import org.apache.openmeetings.db.bind.adapter.OmCalendarAdapter;
import org.apache.openmeetings.db.bind.adapter.RoomAdapter;
import org.apache.openmeetings.db.bind.adapter.UserAdapter;
import org.apache.openmeetings.db.entity.HistoricalEntity;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;

@Entity
@Table(name="appointment", indexes={@Index(name="title_idx", columnList="title")})
@NamedQueries(value={@NamedQuery(name="getAppointmentById", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.id = :id"), @NamedQuery(name="getAppointmentByIdAny", query="SELECT a FROM Appointment a WHERE a.id = :id"), @NamedQuery(name="getAppointments", query="SELECT a FROM Appointment a WHERE a.deleted = false ORDER BY a.id"), @NamedQuery(name="appointmentsInRange", query="SELECT a FROM Appointment a WHERE a.deleted = false   AND (     (a.start BETWEEN :start AND :end)       OR (a.end BETWEEN :start AND :end)       OR (a.start < :start AND a.end > :end)     )  AND a.owner.id = :userId"), @NamedQuery(name="joinedAppointmentsInRange", query="SELECT a FROM MeetingMember mm INNER JOIN mm.appointment a WHERE mm.deleted = false AND mm.user.id <> a.owner.id AND mm.user.id = :userId   AND a.id NOT IN (SELECT a.id FROM Appointment a WHERE a.owner.id = :userId)  AND mm.connectedEvent = false   AND (     (a.start BETWEEN :start AND :end)       OR (a.end BETWEEN :start AND :end)       OR (a.start < :start AND a.end > :end)   )"), @NamedQuery(name="appointmentsInRangeRemind", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.reminderEmailSend = false  AND (a.reminder <> :none)   AND (     (a.start BETWEEN :start AND :end)       OR (a.end BETWEEN :start AND :end)       OR (a.start < :start AND a.end > :end)   )"), @NamedQuery(name="getAppointmentByRoomId", query="SELECT a FROM Appointment a WHERE a.room.id = :roomId"), @NamedQuery(name="getAppointmentByOwnerRoomId", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.owner.id = :userId AND a.room.id = :roomId"), @NamedQuery(name="appointmentsInRangeByUser", query="SELECT a FROM MeetingMember mm, IN(mm.appointment) a WHERE mm.deleted = false AND mm.user.id <> a.owner.id AND mm.user.id = :userId   AND (     (a.start BETWEEN :start AND :end)       OR (a.end BETWEEN :start AND :end)       OR (a.start < :start AND a.end > :end)   )"), @NamedQuery(name="appointedRoomsInRangeByUser", query="SELECT a.room FROM MeetingMember mm, IN(mm.appointment) a WHERE mm.deleted = false AND mm.user.id <> a.owner.id AND mm.user.id = :userId   AND (     (a.start BETWEEN :start AND :end)       OR (a.end BETWEEN :start AND :end)       OR (a.start < :start AND a.end > :end)   )"), @NamedQuery(name="getNextAppointment", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.start > :start AND a.owner.id = :userId"), @NamedQuery(name="getAppointmentsByTitle", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.title LIKE :title AND a.owner.id = :userId"), @NamedQuery(name="getAppointmentsbyCalendar", query="SELECT a FROM Appointment a WHERE a.deleted = false AND a.calendar.id = :calId ORDER BY a.id"), @NamedQuery(name="getHrefsforAppointmentsinCalendar", query="SELECT a.href FROM Appointment a WHERE a.deleted = FALSE AND a.calendar.id = :calId ORDER BY a.id"), @NamedQuery(name="deleteAppointmentsbyCalendar", query="UPDATE Appointment a SET a.deleted = true WHERE a.calendar.id = :calId")})
@XmlRootElement(name="appointment")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Appointment
extends HistoricalEntity
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final int REMINDER_NONE_ID = 1;
    public static final int REMINDER_EMAIL_ID = 2;
    public static final int REMINDER_ICAL_ID = 3;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @XmlElement(name="appointmentId")
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long id;
    @Column(name="title")
    @XmlElement(name="appointmentName", required=false)
    private String title;
    @Column(name="location")
    @XmlElement(name="appointmentLocation", required=false)
    private String location;
    @Column(name="app_start")
    @XmlElement(name="appointmentStarttime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date start;
    @Column(name="app_end")
    @XmlElement(name="appointmentEndtime")
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date end;
    @Lob
    @Column(name="description", length=2048)
    @XmlElement(name="appointmentDescription", required=false)
    private String description;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="user_id", nullable=true)
    @ForeignKey(enabled=true)
    @XmlElement(name="users_id", required=false)
    @XmlJavaTypeAdapter(value=UserAdapter.class)
    private User owner;
    @Column(name="reminder")
    @Enumerated(value=EnumType.STRING)
    @XmlElement(name="typId", required=false)
    @XmlJavaTypeAdapter(value=AppointmentReminderAdapter.class)
    private Reminder reminder = Reminder.NONE;
    @Column(name="isdaily")
    @XmlElement(name="isDaily", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    private Boolean isDaily;
    @Column(name="isweekly")
    @XmlElement(name="isWeekly", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    private Boolean isWeekly;
    @Column(name="ismonthly")
    @XmlElement(name="isMonthly", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    private Boolean isMonthly;
    @Column(name="isyearly")
    @XmlElement(name="isYearly", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class)
    private Boolean isYearly;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="room_id", nullable=true)
    @ForeignKey(enabled=true)
    @XmlElement(name="room_id", required=false)
    @XmlJavaTypeAdapter(value=RoomAdapter.class)
    private Room room;
    @Column(name="icalId")
    @XmlElement(name="icalId", required=false)
    private String icalId;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="appointment_id")
    @XmlTransient
    private List<MeetingMember> meetingMembers;
    @Column(name="language_id")
    @XmlElement(name="language_id", required=false)
    @XmlJavaTypeAdapter(value=LongAdapter.class)
    private Long languageId;
    @Column(name="is_password_protected", nullable=false)
    @XmlElement(name="isPasswordProtected", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean passwordProtected;
    @Column(name="password")
    @XmlElement(name="icalId", required=false)
    private String password;
    @Column(name="is_connected_event", nullable=false)
    @XmlElement(name="connectedEvent", required=false)
    @XmlJavaTypeAdapter(value=BooleanAdapter.class, type=boolean.class)
    private boolean connectedEvent;
    @Column(name="is_reminder_email_send", nullable=false)
    @XmlTransient
    private boolean reminderEmailSend;
    @ManyToOne
    @JoinColumn(name="calendar_id", nullable=true)
    @ForeignKey(enabled=true)
    @XmlElement(name="calendar_id", required=false)
    @XmlJavaTypeAdapter(value=OmCalendarAdapter.class)
    private OmCalendar calendar;
    @Column(name="href")
    @XmlElement(name="href", required=false)
    private String href;
    @Column(name="etag")
    @XmlElement(name="etag", required=false)
    private String etag;
    private static int pcInheritedFieldCount = HistoricalEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    @Override
    public Long getId() {
        return Appointment.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        Appointment.pcSetid(this, id);
    }

    public User getOwner() {
        return Appointment.pcGetowner(this);
    }

    public void setOwner(User owner) {
        Appointment.pcSetowner(this, owner);
    }

    public String getTitle() {
        return Appointment.pcGettitle(this);
    }

    public void setTitle(String title) {
        Appointment.pcSettitle(this, title);
    }

    public String getLocation() {
        return Appointment.pcGetlocation(this);
    }

    public void setLocation(String location) {
        Appointment.pcSetlocation(this, location);
    }

    public Date getStart() {
        return Appointment.pcGetstart(this);
    }

    public static Date allowedStart(Date start) {
        return new Date(start.getTime() - (long)(OpenmeetingsVariables.getAppointmentPreStartMinutes() * 60 * 1000));
    }

    public Calendar startCalendar(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTime(Appointment.pcGetstart(this));
        return cal;
    }

    public void setStart(Date start) {
        Appointment.pcSetstart(this, start);
    }

    public Date getEnd() {
        return Appointment.pcGetend(this);
    }

    public Calendar endCalendar(TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTime(Appointment.pcGetend(this));
        return cal;
    }

    public void setEnd(Date end) {
        Appointment.pcSetend(this, end);
    }

    public String getDescription() {
        return Appointment.pcGetdescription(this);
    }

    public void setDescription(String description) {
        Appointment.pcSetdescription(this, description);
    }

    public Reminder getReminder() {
        return Appointment.pcGetreminder(this);
    }

    public void setReminder(Reminder reminder) {
        Appointment.pcSetreminder(this, reminder);
    }

    public Boolean getIsWeekly() {
        return Appointment.pcGetisWeekly(this);
    }

    public void setIsWeekly(Boolean isWeekly) {
        Appointment.pcSetisWeekly(this, isWeekly);
    }

    public Boolean getIsMonthly() {
        return Appointment.pcGetisMonthly(this);
    }

    public void setIsMonthly(Boolean isMonthly) {
        Appointment.pcSetisMonthly(this, isMonthly);
    }

    public Boolean getIsYearly() {
        return Appointment.pcGetisYearly(this);
    }

    public void setIsYearly(Boolean isYearly) {
        Appointment.pcSetisYearly(this, isYearly);
    }

    public Boolean getIsDaily() {
        return Appointment.pcGetisDaily(this);
    }

    public void setIsDaily(Boolean isDaily) {
        Appointment.pcSetisDaily(this, isDaily);
    }

    public List<MeetingMember> getMeetingMembers() {
        return Appointment.pcGetmeetingMembers(this);
    }

    public void setMeetingMembers(List<MeetingMember> meetingMembers) {
        Appointment.pcSetmeetingMembers(this, meetingMembers);
    }

    public Room getRoom() {
        return Appointment.pcGetroom(this);
    }

    public void setRoom(Room room) {
        Appointment.pcSetroom(this, room);
    }

    public String getIcalId() {
        return Appointment.pcGeticalId(this);
    }

    public void setIcalId(String icalId) {
        Appointment.pcSeticalId(this, icalId);
    }

    public Long getLanguageId() {
        return Appointment.pcGetlanguageId(this);
    }

    public void setLanguageId(Long languageId) {
        Appointment.pcSetlanguageId(this, languageId);
    }

    public boolean isPasswordProtected() {
        return Appointment.pcGetpasswordProtected(this);
    }

    public void setPasswordProtected(boolean isPasswordProtected) {
        Appointment.pcSetpasswordProtected(this, isPasswordProtected);
    }

    public String getPassword() {
        return Appointment.pcGetpassword(this);
    }

    public void setPassword(String password) {
        Appointment.pcSetpassword(this, password);
    }

    public boolean isConnectedEvent() {
        return Appointment.pcGetconnectedEvent(this);
    }

    public void setConnectedEvent(boolean isConnectedEvent) {
        Appointment.pcSetconnectedEvent(this, isConnectedEvent);
    }

    public boolean isReminderEmailSend() {
        return Appointment.pcGetreminderEmailSend(this);
    }

    public void setReminderEmailSend(boolean isReminderEmailSend) {
        Appointment.pcSetreminderEmailSend(this, isReminderEmailSend);
    }

    public OmCalendar getCalendar() {
        return Appointment.pcGetcalendar(this);
    }

    public void setCalendar(OmCalendar calendar) {
        Appointment.pcSetcalendar(this, calendar);
    }

    public String getHref() {
        return Appointment.pcGethref(this);
    }

    public void setHref(String href) {
        Appointment.pcSethref(this, href);
    }

    public String getEtag() {
        return Appointment.pcGetetag(this);
    }

    public void setEtag(String etag) {
        Appointment.pcSetetag(this, etag);
    }

    public boolean isOwner(Long userId) {
        return Appointment.pcGetowner(this).getId().equals(userId);
    }

    public String toString() {
        return "Appointment [id=" + Appointment.pcGetid(this) + ", title=" + Appointment.pcGettitle(this) + ", start=" + String.valueOf(Appointment.pcGetstart(this)) + ", end=" + String.valueOf(Appointment.pcGetend(this)) + ", owner=" + String.valueOf(Appointment.pcGetowner(this)) + ", deleted=" + this.isDeleted() + ", icalId=" + Appointment.pcGeticalId(this) + ", calendar=" + String.valueOf(Appointment.pcGetcalendar(this)) + ", href=" + Appointment.pcGethref(this) + ", etag=" + Appointment.pcGetetag(this) + "]";
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        pcPCSuperclass = HistoricalEntity.class;
        pcFieldNames = new String[]{"calendar", "connectedEvent", "description", "end", "etag", "href", "icalId", "id", "isDaily", "isMonthly", "isWeekly", "isYearly", "languageId", "location", "meetingMembers", "owner", "password", "passwordProtected", "reminder", "reminderEmailSend", "room", "start", "title"};
        pcFieldTypes = new Class[]{OmCalendar.class, Boolean.TYPE, String.class, Date.class, String.class, String.class, String.class, Long.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Long.class, String.class, List.class, User.class, String.class, Boolean.TYPE, Reminder.class, Boolean.TYPE, Room.class, Date.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26};
        PCRegistry.register(Appointment.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Appointment", (PersistenceCapable)new Appointment());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.calendar = null;
        this.connectedEvent = false;
        this.description = null;
        this.end = null;
        this.etag = null;
        this.href = null;
        this.icalId = null;
        this.id = null;
        this.isDaily = null;
        this.isMonthly = null;
        this.isWeekly = null;
        this.isYearly = null;
        this.languageId = null;
        this.location = null;
        this.meetingMembers = null;
        this.owner = null;
        this.password = null;
        this.passwordProtected = false;
        this.reminder = null;
        this.reminderEmailSend = false;
        this.room = null;
        this.start = null;
        this.title = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Appointment appointment = new Appointment();
        if (bl) {
            appointment.pcClearFields();
        }
        appointment.pcStateManager = stateManager;
        appointment.pcCopyKeyFieldsFromObjectId(object);
        return appointment;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Appointment appointment = new Appointment();
        if (bl) {
            appointment.pcClearFields();
        }
        appointment.pcStateManager = stateManager;
        return appointment;
    }

    protected static int pcGetManagedFieldCount() {
        return 23 + HistoricalEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.calendar = (OmCalendar)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.connectedEvent = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.end = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.etag = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.href = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.icalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.isDaily = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.isMonthly = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.isWeekly = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.isYearly = (Boolean)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.languageId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.location = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.meetingMembers = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.owner = (User)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.passwordProtected = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.reminder = (Reminder)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 19: {
                this.reminderEmailSend = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.room = (Room)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.start = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 22: {
                this.title = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.calendar);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.connectedEvent);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.end);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.etag);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.href);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.icalId);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isDaily);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isMonthly);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isWeekly);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.isYearly);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.languageId);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.location);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.meetingMembers);
                return;
            }
            case 15: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.owner);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 17: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.passwordProtected);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.reminder);
                return;
            }
            case 19: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.reminderEmailSend);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.room);
                return;
            }
            case 21: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.start);
                return;
            }
            case 22: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.title);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(Appointment appointment, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(appointment, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.calendar = appointment.calendar;
                return;
            }
            case 1: {
                this.connectedEvent = appointment.connectedEvent;
                return;
            }
            case 2: {
                this.description = appointment.description;
                return;
            }
            case 3: {
                this.end = appointment.end;
                return;
            }
            case 4: {
                this.etag = appointment.etag;
                return;
            }
            case 5: {
                this.href = appointment.href;
                return;
            }
            case 6: {
                this.icalId = appointment.icalId;
                return;
            }
            case 7: {
                this.id = appointment.id;
                return;
            }
            case 8: {
                this.isDaily = appointment.isDaily;
                return;
            }
            case 9: {
                this.isMonthly = appointment.isMonthly;
                return;
            }
            case 10: {
                this.isWeekly = appointment.isWeekly;
                return;
            }
            case 11: {
                this.isYearly = appointment.isYearly;
                return;
            }
            case 12: {
                this.languageId = appointment.languageId;
                return;
            }
            case 13: {
                this.location = appointment.location;
                return;
            }
            case 14: {
                this.meetingMembers = appointment.meetingMembers;
                return;
            }
            case 15: {
                this.owner = appointment.owner;
                return;
            }
            case 16: {
                this.password = appointment.password;
                return;
            }
            case 17: {
                this.passwordProtected = appointment.passwordProtected;
                return;
            }
            case 18: {
                this.reminder = appointment.reminder;
                return;
            }
            case 19: {
                this.reminderEmailSend = appointment.reminderEmailSend;
                return;
            }
            case 20: {
                this.room = appointment.room;
                return;
            }
            case 21: {
                this.start = appointment.start;
                return;
            }
            case 22: {
                this.title = appointment.title;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Appointment appointment = (Appointment)object;
        if (appointment.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(appointment, nArray[i]);
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(7 + pcInheritedFieldCount, (Object)longId.getId());
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = longId.getId();
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        return new LongId(Appointment.class, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        return new LongId(Appointment.class, this.id);
    }

    private static final OmCalendar pcGetcalendar(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.calendar;
        }
        int n = pcInheritedFieldCount + 0;
        appointment.pcStateManager.accessingField(n);
        return appointment.calendar;
    }

    private static final void pcSetcalendar(Appointment appointment, OmCalendar omCalendar) {
        if (appointment.pcStateManager == null) {
            appointment.calendar = omCalendar;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 0, (Object)appointment.calendar, (Object)omCalendar, 0);
    }

    private static final boolean pcGetconnectedEvent(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.connectedEvent;
        }
        int n = pcInheritedFieldCount + 1;
        appointment.pcStateManager.accessingField(n);
        return appointment.connectedEvent;
    }

    private static final void pcSetconnectedEvent(Appointment appointment, boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.connectedEvent = bl;
            return;
        }
        appointment.pcStateManager.settingBooleanField((PersistenceCapable)appointment, pcInheritedFieldCount + 1, appointment.connectedEvent, bl, 0);
    }

    private static final String pcGetdescription(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.description;
        }
        int n = pcInheritedFieldCount + 2;
        appointment.pcStateManager.accessingField(n);
        return appointment.description;
    }

    private static final void pcSetdescription(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.description = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 2, appointment.description, string, 0);
    }

    private static final Date pcGetend(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.end;
        }
        int n = pcInheritedFieldCount + 3;
        appointment.pcStateManager.accessingField(n);
        return appointment.end;
    }

    private static final void pcSetend(Appointment appointment, Date date) {
        if (appointment.pcStateManager == null) {
            appointment.end = date;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 3, (Object)appointment.end, (Object)date, 0);
    }

    private static final String pcGetetag(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.etag;
        }
        int n = pcInheritedFieldCount + 4;
        appointment.pcStateManager.accessingField(n);
        return appointment.etag;
    }

    private static final void pcSetetag(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.etag = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 4, appointment.etag, string, 0);
    }

    private static final String pcGethref(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.href;
        }
        int n = pcInheritedFieldCount + 5;
        appointment.pcStateManager.accessingField(n);
        return appointment.href;
    }

    private static final void pcSethref(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.href = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 5, appointment.href, string, 0);
    }

    private static final String pcGeticalId(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.icalId;
        }
        int n = pcInheritedFieldCount + 6;
        appointment.pcStateManager.accessingField(n);
        return appointment.icalId;
    }

    private static final void pcSeticalId(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.icalId = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 6, appointment.icalId, string, 0);
    }

    private static final Long pcGetid(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.id;
        }
        int n = pcInheritedFieldCount + 7;
        appointment.pcStateManager.accessingField(n);
        return appointment.id;
    }

    private static final void pcSetid(Appointment appointment, Long l) {
        if (appointment.pcStateManager == null) {
            appointment.id = l;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 7, (Object)appointment.id, (Object)l, 0);
    }

    private static final Boolean pcGetisDaily(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isDaily;
        }
        int n = pcInheritedFieldCount + 8;
        appointment.pcStateManager.accessingField(n);
        return appointment.isDaily;
    }

    private static final void pcSetisDaily(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isDaily = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 8, (Object)appointment.isDaily, (Object)bl, 0);
    }

    private static final Boolean pcGetisMonthly(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isMonthly;
        }
        int n = pcInheritedFieldCount + 9;
        appointment.pcStateManager.accessingField(n);
        return appointment.isMonthly;
    }

    private static final void pcSetisMonthly(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isMonthly = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 9, (Object)appointment.isMonthly, (Object)bl, 0);
    }

    private static final Boolean pcGetisWeekly(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isWeekly;
        }
        int n = pcInheritedFieldCount + 10;
        appointment.pcStateManager.accessingField(n);
        return appointment.isWeekly;
    }

    private static final void pcSetisWeekly(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isWeekly = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 10, (Object)appointment.isWeekly, (Object)bl, 0);
    }

    private static final Boolean pcGetisYearly(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.isYearly;
        }
        int n = pcInheritedFieldCount + 11;
        appointment.pcStateManager.accessingField(n);
        return appointment.isYearly;
    }

    private static final void pcSetisYearly(Appointment appointment, Boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.isYearly = bl;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 11, (Object)appointment.isYearly, (Object)bl, 0);
    }

    private static final Long pcGetlanguageId(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.languageId;
        }
        int n = pcInheritedFieldCount + 12;
        appointment.pcStateManager.accessingField(n);
        return appointment.languageId;
    }

    private static final void pcSetlanguageId(Appointment appointment, Long l) {
        if (appointment.pcStateManager == null) {
            appointment.languageId = l;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 12, (Object)appointment.languageId, (Object)l, 0);
    }

    private static final String pcGetlocation(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.location;
        }
        int n = pcInheritedFieldCount + 13;
        appointment.pcStateManager.accessingField(n);
        return appointment.location;
    }

    private static final void pcSetlocation(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.location = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 13, appointment.location, string, 0);
    }

    private static final List pcGetmeetingMembers(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.meetingMembers;
        }
        int n = pcInheritedFieldCount + 14;
        appointment.pcStateManager.accessingField(n);
        return appointment.meetingMembers;
    }

    private static final void pcSetmeetingMembers(Appointment appointment, List list) {
        if (appointment.pcStateManager == null) {
            appointment.meetingMembers = list;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 14, appointment.meetingMembers, (Object)list, 0);
    }

    private static final User pcGetowner(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.owner;
        }
        int n = pcInheritedFieldCount + 15;
        appointment.pcStateManager.accessingField(n);
        return appointment.owner;
    }

    private static final void pcSetowner(Appointment appointment, User user) {
        if (appointment.pcStateManager == null) {
            appointment.owner = user;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 15, (Object)appointment.owner, (Object)user, 0);
    }

    private static final String pcGetpassword(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.password;
        }
        int n = pcInheritedFieldCount + 16;
        appointment.pcStateManager.accessingField(n);
        return appointment.password;
    }

    private static final void pcSetpassword(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.password = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 16, appointment.password, string, 0);
    }

    private static final boolean pcGetpasswordProtected(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.passwordProtected;
        }
        int n = pcInheritedFieldCount + 17;
        appointment.pcStateManager.accessingField(n);
        return appointment.passwordProtected;
    }

    private static final void pcSetpasswordProtected(Appointment appointment, boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.passwordProtected = bl;
            return;
        }
        appointment.pcStateManager.settingBooleanField((PersistenceCapable)appointment, pcInheritedFieldCount + 17, appointment.passwordProtected, bl, 0);
    }

    private static final Reminder pcGetreminder(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.reminder;
        }
        int n = pcInheritedFieldCount + 18;
        appointment.pcStateManager.accessingField(n);
        return appointment.reminder;
    }

    private static final void pcSetreminder(Appointment appointment, Reminder reminder) {
        if (appointment.pcStateManager == null) {
            appointment.reminder = reminder;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 18, (Object)appointment.reminder, (Object)reminder, 0);
    }

    private static final boolean pcGetreminderEmailSend(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.reminderEmailSend;
        }
        int n = pcInheritedFieldCount + 19;
        appointment.pcStateManager.accessingField(n);
        return appointment.reminderEmailSend;
    }

    private static final void pcSetreminderEmailSend(Appointment appointment, boolean bl) {
        if (appointment.pcStateManager == null) {
            appointment.reminderEmailSend = bl;
            return;
        }
        appointment.pcStateManager.settingBooleanField((PersistenceCapable)appointment, pcInheritedFieldCount + 19, appointment.reminderEmailSend, bl, 0);
    }

    private static final Room pcGetroom(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.room;
        }
        int n = pcInheritedFieldCount + 20;
        appointment.pcStateManager.accessingField(n);
        return appointment.room;
    }

    private static final void pcSetroom(Appointment appointment, Room room) {
        if (appointment.pcStateManager == null) {
            appointment.room = room;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 20, (Object)appointment.room, (Object)room, 0);
    }

    private static final Date pcGetstart(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.start;
        }
        int n = pcInheritedFieldCount + 21;
        appointment.pcStateManager.accessingField(n);
        return appointment.start;
    }

    private static final void pcSetstart(Appointment appointment, Date date) {
        if (appointment.pcStateManager == null) {
            appointment.start = date;
            return;
        }
        appointment.pcStateManager.settingObjectField((PersistenceCapable)appointment, pcInheritedFieldCount + 21, (Object)appointment.start, (Object)date, 0);
    }

    private static final String pcGettitle(Appointment appointment) {
        if (appointment.pcStateManager == null) {
            return appointment.title;
        }
        int n = pcInheritedFieldCount + 22;
        appointment.pcStateManager.accessingField(n);
        return appointment.title;
    }

    private static final void pcSettitle(Appointment appointment, String string) {
        if (appointment.pcStateManager == null) {
            appointment.title = string;
            return;
        }
        appointment.pcStateManager.settingStringField((PersistenceCapable)appointment, pcInheritedFieldCount + 22, appointment.title, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    public static enum Reminder {
        NONE(1),
        EMAIL(2),
        ICAL(3);

        private int id;

        private Reminder(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Reminder get(Long type) {
            return Reminder.get(type == null ? 1 : type.intValue());
        }

        public static Reminder get(Integer type) {
            return Reminder.get(type == null ? 1 : type);
        }

        public static Reminder get(int type) {
            Reminder r = NONE;
            switch (type) {
                case 2: {
                    r = EMAIL;
                    break;
                }
                case 3: {
                    r = ICAL;
                    break;
                }
            }
            return r;
        }
    }
}

