/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.util;

import org.checkerframework.checker.nullness.qual.Nullable;

public final class StringUtils {
    public static @Nullable String appendIfMissing(@Nullable String str, @Nullable String suffix) {
        if (str == null || StringUtils.isEmpty(suffix) || str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static boolean endsWithAny(@Nullable String str, String ... searchStrings) {
        if (StringUtils.isEmpty(str) || searchStrings == null || searchStrings.length == 0) {
            return false;
        }
        for (String searchString : searchStrings) {
            if (searchString == null || !str.endsWith(searchString)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(@Nullable String str) {
        if (str == null) {
            return true;
        }
        return str.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable String str) {
        if (str == null) {
            return false;
        }
        return !str.isEmpty();
    }

    public static boolean isBlank(@Nullable String str) {
        if (str == null) {
            return true;
        }
        if (str.isEmpty()) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(@Nullable String str) {
        if (str == null) {
            return false;
        }
        if (str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private StringUtils() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

