/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.service.calendar;

import jakarta.inject.Inject;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.openmeetings.core.notifier.NotifierService;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.dao.room.InvitationDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AppointmentLogic {
    private static final Logger log = LoggerFactory.getLogger(AppointmentLogic.class);
    @Inject
    private AppointmentDao appointmentDao;
    @Inject
    private InvitationDao invitationDao;
    @Inject
    private NotifierService notifierService;

    private void sendReminder(User u, Appointment a) {
        Invitation i = new Invitation();
        i.setInvitedBy(u);
        i.setInvitee(u);
        i.setAppointment(a);
        i.setRoom(a.getRoom());
        this.sendReminder(u, a, i);
    }

    private void sendReminder(User u, Appointment a, Invitation inv) {
        this.notifierService.notify(u, a, inv);
        if (inv.getHash() != null) {
            this.invitationDao.update(inv);
        }
    }

    public void doScheduledMeetingReminder() {
        String baseUrl = OpenmeetingsVariables.getBaseUrl();
        if (baseUrl == null || baseUrl.isEmpty()) {
            log.error("Error retrieving baseUrl for application");
            return;
        }
        int minutesReminderSend = OpenmeetingsVariables.getAppointmentReminderMinutes();
        if (minutesReminderSend == 0) {
            log.warn("minutesReminderSend is 0, disabling reminder scheduler");
            return;
        }
        long milliseconds = (long)(minutesReminderSend * 60) * 1000L;
        Calendar start = Calendar.getInstance();
        if (milliseconds < 0L) {
            start.setTimeInMillis(start.getTimeInMillis() + milliseconds);
        }
        Calendar end = Calendar.getInstance();
        if (milliseconds > 0L) {
            end.setTimeInMillis(end.getTimeInMillis() + milliseconds);
        }
        for (Appointment a : this.appointmentDao.getInRange(start, end)) {
            if (a.isReminderEmailSend()) continue;
            TimeZone ownerZone = TimezoneUtil.getTimeZone((User)a.getOwner());
            Calendar aNow = Calendar.getInstance(ownerZone);
            Calendar aStart = a.startCalendar(ownerZone);
            aStart.add(12, -minutesReminderSend);
            if (aStart.after(aNow)) continue;
            a.setReminderEmailSend(true);
            this.appointmentDao.update(a, null, false);
            List members = a.getMeetingMembers();
            this.sendReminder(a.getOwner(), a);
            if (members == null) {
                log.debug("doScheduledMeetingReminder : no members in meeting!");
                continue;
            }
            for (MeetingMember mm : members) {
                log.debug("doScheduledMeetingReminder : Member {}", (Object)mm.getUser().getAddress().getEmail());
                Invitation inv = mm.getInvitation();
                this.sendReminder(mm.getUser(), a, inv);
            }
        }
    }
}

