/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.webservice;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.apache.cxf.feature.Features;
import org.apache.openmeetings.db.dao.record.RecordingDao;
import org.apache.openmeetings.db.dto.basic.ServiceResult;
import org.apache.openmeetings.db.dto.record.RecordingDTO;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.webservice.BaseWebService;
import org.apache.openmeetings.webservice.error.ServiceException;
import org.apache.openmeetings.webservice.schema.RecordingDTOListWrapper;
import org.apache.openmeetings.webservice.schema.ServiceResultWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="recordWebService")
@WebService(serviceName="org.apache.openmeetings.webservice.RecordingWebService", targetNamespace="http://webservice.openmeetings.apache.org/")
@Features(features={"org.apache.cxf.ext.logging.LoggingFeature"})
@Produces(value={"application/json"})
@Tag(name="RecordingService")
@Path(value="/record")
public class RecordingWebService
extends BaseWebService {
    private static final Logger log = LoggerFactory.getLogger(RecordingWebService.class);
    @Inject
    private RecordingDao recordingDao;

    @DELETE
    @Path(value="/{id}")
    @Operation(description="Deletes a recording", responses={@ApiResponse(responseCode="200", description="serviceResult object with the result", content={@Content(schema=@Schema(implementation=ServiceResultWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public ServiceResult delete(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @QueryParam(value="sid") @WebParam(name="sid") String sid, @Parameter(required=true, description="the id of the recording") @PathParam(value="id") @WebParam(name="id") Long id) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> {
            this.recordingDao.delete((BaseFileItem)this.recordingDao.get(id));
            return new ServiceResult("Deleted", ServiceResult.Type.SUCCESS);
        });
    }

    @WebMethod
    @GET
    @Path(value="/{externaltype}/{externalid}")
    @Operation(description="Gets a list of recordings created by particular external USER", responses={@ApiResponse(responseCode="200", description="list of recordings", content={@Content(schema=@Schema(implementation=RecordingDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<RecordingDTO> getExternal(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the externalUserId") @PathParam(value="externaltype") @WebParam(name="externaltype") String externalType, @Parameter(required=true, description="the externalUserType") @PathParam(value="externalid") @WebParam(name="externalid") String externalId) throws ServiceException {
        log.trace("getExternal:: type {}, id {}", (Object)externalType, (Object)externalId);
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> RecordingDTO.list((List)this.recordingDao.getByExternalUser(externalId, externalType)));
    }

    @WebMethod
    @GET
    @Path(value="/{externaltype}")
    @Operation(description="Gets a list of recordings", responses={@ApiResponse(responseCode="200", description="list of recordings", content={@Content(schema=@Schema(implementation=RecordingDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<RecordingDTO> getExternalByType(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="externalType specified when creating the room") @PathParam(value="externaltype") @WebParam(name="externaltype") String externalType) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> RecordingDTO.list((List)this.recordingDao.getByExternalType(externalType)));
    }

    @WebMethod
    @GET
    @Path(value="/room/{roomid}")
    @Operation(description="Gets a list of recordings", responses={@ApiResponse(responseCode="200", description="list of recordings", content={@Content(schema=@Schema(implementation=RecordingDTOListWrapper.class))}), @ApiResponse(responseCode="500", description="Error in case of invalid credentials or server error")})
    public List<RecordingDTO> getExternalByRoom(@Parameter(required=true, description="The SID of the User. This SID must be marked as Loggedin") @WebParam(name="sid") @QueryParam(value="sid") String sid, @Parameter(required=true, description="the room id") @PathParam(value="roomid") @WebParam(name="roomid") Long roomId) throws ServiceException {
        return this.performCall(sid, User.Right.SOAP, (Sessiondata sd) -> RecordingDTO.list((List)this.recordingDao.getByRoomId(roomId)));
    }
}

