/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.dashboard.web;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.wicketstuff.dashboard.Dashboard;
import org.wicketstuff.dashboard.DashboardContextInitializer;
import org.wicketstuff.dashboard.Widget;
import org.wicketstuff.dashboard.web.DashboardPanel;
import org.wicketstuff.dashboard.web.WidgetActionsPanel;
import org.wicketstuff.dashboard.web.WidgetPanel;
import org.wicketstuff.dashboard.web.WidgetView;

public class WidgetHeaderPanel
extends GenericPanel<Widget> {
    private static final long serialVersionUID = 1L;

    public WidgetHeaderPanel(String id, IModel<Widget> model) {
        super(id, model);
        this.setMarkupId("header-" + ((Widget)this.getModelObject()).getId());
        final WebMarkupContainer toggle = new WebMarkupContainer("toggle");
        toggle.setOutputMarkupId(true).add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)this.getCssClass()))});
        toggle.add(new Behavior[]{new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                Widget widget;
                widget.setCollapsed(!(widget = WidgetHeaderPanel.this.getWidget()).isCollapsed());
                Dashboard dashboard = ((DashboardPanel)((Object)WidgetHeaderPanel.this.findParent(DashboardPanel.class))).getDashboard();
                DashboardContextInitializer.getDashboardContext().getDashboardPersister().save(dashboard);
                target.add(new Component[]{toggle.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)WidgetHeaderPanel.this.getCssClass()))})});
                WidgetView widgetView = ((WidgetPanel)((Object)WidgetHeaderPanel.this.findParent(WidgetPanel.class))).getWidgetView();
                target.add(new Component[]{widgetView});
            }
        }});
        toggle.add(new Behavior[]{new AttributeModifier("title", (IModel)new IModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return WidgetHeaderPanel.this.getWidget().isCollapsed() ? WidgetHeaderPanel.this.getString("expand") : WidgetHeaderPanel.this.getString("collapse");
            }
        })});
        this.add(new Component[]{toggle});
        this.add(new Component[]{new Label("title", (IModel)new PropertyModel(model, "title"))});
        WidgetActionsPanel actionsPanel = new WidgetActionsPanel("actions", model);
        this.add(new Component[]{actionsPanel});
    }

    private String getCssClass() {
        return "dragbox-toggle " + (this.getWidget().isCollapsed() ? "collapsed" : "expanded");
    }

    public Widget getWidget() {
        return (Widget)this.getModelObject();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        StringBuilder statement = new StringBuilder("$('#").append(this.getMarkupId()).append("').on('mouseover', function(ev) {");
        statement.append(" $(this).find('.dragbox-actions').show();").append("}).on('mouseout', function(ev) {").append(" $(this).find('.dragbox-actions').hide();").append("});");
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)statement.toString()));
    }
}

