/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.QueuedMessageDispatchBase;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;

public class NioPipelineParser {
    private static StackLogger logger = CommonLogger.getLogger(NioPipelineParser.class);
    private static final String CRLF = "\r\n";
    protected SIPMessageListener sipMessageListener;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private MessageParser smp = null;
    boolean isRunning = false;
    boolean currentStreamEnded = false;
    boolean readingMessageBodyContents = false;
    boolean readingHeaderLines = true;
    boolean partialLineRead = false;
    String partialLine = "";
    String callId;
    StringBuilder message = new StringBuilder();
    byte[] messageBody = null;
    int contentLength = 0;
    int contentReadSoFar = 0;

    public void close() {
    }

    public void readStream(InputStream inputStream) throws IOException {
        boolean isPreviousLineCRLF = false;
        while (!this.currentStreamEnded) {
            if (this.readingHeaderLines) {
                isPreviousLineCRLF = this.readMessageSipHeaderLines(inputStream, isPreviousLineCRLF);
            }
            if (!this.readingMessageBodyContents) continue;
            this.readMessageBody(inputStream);
        }
    }

    private boolean readMessageSipHeaderLines(InputStream inputStream, boolean isPreviousLineCRLF) throws IOException {
        boolean crlfReceived = false;
        String line = this.readLine(inputStream);
        if (this.partialLineRead) {
            this.partialLine = this.partialLine + line;
        } else {
            line = this.partialLine + line;
            this.partialLine = "";
            if (!line.equals(CRLF)) {
                this.message.append(line);
                String lineIgnoreCase = line.toLowerCase();
                if (lineIgnoreCase.startsWith(ContentLength.NAME_LOWER)) {
                    this.contentLength = Integer.parseInt(line.substring(ContentLength.NAME_LOWER.length() + 1).trim());
                } else if (lineIgnoreCase.startsWith(CallID.NAME_LOWER)) {
                    this.callId = line.substring(CallID.NAME_LOWER.length() + 1).trim();
                }
            } else {
                if (isPreviousLineCRLF) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("KeepAlive Double CRLF received, sending single CRLF as defined per RFC 5626 Section 4.4.1");
                        logger.logDebug("~~~ setting isPreviousLineCRLF=false");
                    }
                    crlfReceived = false;
                    try {
                        this.sipMessageListener.sendSingleCLRF();
                    }
                    catch (Exception e) {
                        logger.logError("A problem occured while trying to send a single CLRF in response to a double CLRF", e);
                    }
                } else {
                    crlfReceived = true;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Received CRLF");
                    }
                    if (this.sipMessageListener != null && this.sipMessageListener instanceof ConnectionOrientedMessageChannel) {
                        ((ConnectionOrientedMessageChannel)this.sipMessageListener).cancelPingKeepAliveTimeoutTaskIfStarted();
                    }
                }
                if (this.message.length() > 0) {
                    this.readingMessageBodyContents = true;
                    this.readingHeaderLines = false;
                    this.partialLineRead = false;
                    this.message.append(CRLF);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Content Length parsed is " + this.contentLength);
                    }
                    this.contentReadSoFar = 0;
                    this.messageBody = new byte[this.contentLength];
                }
            }
        }
        return crlfReceived;
    }

    private void readMessageBody(InputStream inputStream) throws IOException {
        int bytesRead = 0;
        if (this.contentLength > 0 && (bytesRead = this.readChunk(inputStream, this.messageBody, this.contentReadSoFar, this.contentLength - this.contentReadSoFar)) == -1) {
            this.currentStreamEnded = true;
            bytesRead = 0;
        }
        this.contentReadSoFar += bytesRead;
        if (this.contentReadSoFar == this.contentLength) {
            this.sizeCounter = this.maxMessageSize;
            this.readingHeaderLines = true;
            this.readingMessageBodyContents = false;
            String msgLines = this.message.toString();
            this.message = new StringBuilder();
            byte[] msgBodyBytes = this.messageBody;
            if (this.sipStack.getSelfRoutingThreadpoolExecutor() != null) {
                String callId = this.callId;
                if (callId == null || callId.trim().length() < 1) {
                    throw new IOException("received message with no Call-ID");
                }
                this.sipStack.getSelfRoutingThreadpoolExecutor().execute(new Dispatch(new UnparsedMessage(msgLines, msgBodyBytes), callId));
            } else {
                SIPMessage sipMessage;
                block7: {
                    sipMessage = null;
                    try {
                        byte[] msgBytes = msgLines.getBytes("UTF-8");
                        sipMessage = this.smp.parseSIPMessage(msgBytes, false, false, null);
                        sipMessage.setMessageContent(msgBodyBytes);
                    }
                    catch (ParseException e) {
                        if (!logger.isLoggingEnabled(32)) break block7;
                        logger.logDebug("Parsing problem", e);
                    }
                }
                this.contentLength = 0;
                this.processSIPMessage(sipMessage);
            }
        }
    }

    public void processSIPMessage(SIPMessage message) {
        try {
            this.sipMessageListener.processMessage(message);
        }
        catch (Exception e) {
            logger.logError("Can't process message", e);
        }
    }

    public synchronized void addBytes(byte[] bytes) throws Exception {
        this.currentStreamEnded = false;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        this.readStream(inputStream);
    }

    protected NioPipelineParser() {
    }

    public NioPipelineParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.smp = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        this.sipMessageListener = sipMessageListener;
        this.sizeCounter = this.maxMessageSize = maxMessageSize;
    }

    public NioPipelineParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, int maxMsgSize) {
        this(sipStack, mhandler, false, maxMsgSize);
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private int readChunk(InputStream inputStream, byte[] where, int offset, int length) throws IOException {
        int read = inputStream.read(where, offset, length);
        this.sizeCounter -= read;
        this.checkLimits();
        return read;
    }

    private int readSingleByte(InputStream inputStream) throws IOException {
        --this.sizeCounter;
        this.checkLimits();
        return inputStream.read();
    }

    private void checkLimits() {
        if (this.maxMessageSize > 0 && this.sizeCounter < 0) {
            throw new RuntimeException("Max Message Size Exceeded " + this.maxMessageSize);
        }
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        this.partialLineRead = false;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        byte[] crlfBuffer = new byte[2];
        int crlfCounter = 0;
        while (true) {
            int i;
            if ((i = this.readSingleByte(inputStream)) == -1) {
                this.partialLineRead = true;
                this.currentStreamEnded = true;
                break;
            }
            char ch = (char)(i & 0xFF);
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            } else if (counter == 0) {
                crlfBuffer[crlfCounter++] = 13;
            }
            if (ch == '\n') {
                if (counter != 1 || crlfCounter <= 0) break;
                crlfBuffer[crlfCounter++] = 10;
                break;
            }
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        if (counter == 1 && crlfCounter > 0) {
            return new String(crlfBuffer, 0, crlfCounter, "UTF-8");
        }
        String lineRead = new String(lineBuffer, 0, counter, "UTF-8");
        if (crlfCounter == 1) {
            lineRead = lineRead + "\r";
        }
        return lineRead;
    }

    public class Dispatch
    implements Runnable,
    QueuedMessageDispatchBase {
        String callId;
        UnparsedMessage unparsedMessage;
        long time;

        public Dispatch(UnparsedMessage unparsedMsg, String callId) {
            this.unparsedMessage = unparsedMsg;
            this.callId = callId;
            this.time = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            logger.logInfo("serving msg on call id " + this.callId);
            SIPMessage parsedSIPMessage = null;
            try {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("\nUnparsed message before parser is:\n" + this.unparsedMessage);
                }
                byte[] lineBytes = this.unparsedMessage.lines.getBytes("UTF-8");
                parsedSIPMessage = NioPipelineParser.this.smp.parseSIPMessage(lineBytes, false, false, null);
                if (parsedSIPMessage == null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("parsed message is null, probably because of end of stream, empty packets or socket closed and we got CRLF to terminate cleanly, not processing message");
                    }
                } else if (this.unparsedMessage.body.length > 0) {
                    parsedSIPMessage.setMessageContent(this.unparsedMessage.body);
                }
                if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                    ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.beforeMessage(parsedSIPMessage);
                }
                if (parsedSIPMessage != null) {
                    NioPipelineParser.this.sipMessageListener.processMessage(parsedSIPMessage);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releasing semaphore for message " + parsedSIPMessage);
                }
                if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                    ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.afterMessage(parsedSIPMessage);
                }
            }
            catch (ParseException e) {
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Problem parsing message " + this.unparsedMessage, e);
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releasing semaphore for message " + parsedSIPMessage);
                }
                if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                    ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.afterMessage(parsedSIPMessage);
                }
            }
            catch (Exception e2) {
                logger.logError("Error occured processing message " + NioPipelineParser.this.message, e2);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releasing semaphore for message " + parsedSIPMessage);
                }
                if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                    ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.afterMessage(parsedSIPMessage);
                }
                {
                    catch (Throwable throwable) {
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("releasing semaphore for message " + parsedSIPMessage);
                        }
                        if (((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor != null && parsedSIPMessage != null) {
                            ((NioPipelineParser)NioPipelineParser.this).sipStack.sipEventInterceptor.afterMessage(parsedSIPMessage);
                        }
                        throw throwable;
                    }
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("dispatch task done on " + parsedSIPMessage);
            }
        }

        @Override
        public long getReceptionTime() {
            return this.time;
        }
    }

    public static class UnparsedMessage {
        String lines;
        byte[] body;

        public UnparsedMessage(String messageLines, byte[] body) {
            this.lines = messageLines;
            this.body = body;
        }

        public String toString() {
            return super.toString() + "\n" + this.lines;
        }
    }
}

