/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../chat/chat":
/*!***********************!*\
  !*** external "Chat" ***!
  \***********************/
/***/ ((module) => {

"use strict";
module.exports = Chat;

/***/ }),

/***/ "../main/omutils":
/*!*************************!*\
  !*** external "OmUtil" ***!
  \*************************/
/***/ ((module) => {

"use strict";
module.exports = OmUtil;

/***/ }),

/***/ "../main/settings":
/*!***************************!*\
  !*** external "Settings" ***!
  \***************************/
/***/ ((module) => {

"use strict";
module.exports = Settings;

/***/ }),

/***/ "../settings/WebRtcPeer":
/*!*****************************!*\
  !*** external "WebRtcPeer" ***!
  \*****************************/
/***/ ((module) => {

"use strict";
module.exports = WebRtcPeer;

/***/ }),

/***/ "../settings/mic-level":
/*!***************************!*\
  !*** external "MicLevel" ***!
  \***************************/
/***/ ((module) => {

"use strict";
module.exports = MicLevel;

/***/ }),

/***/ "../settings/settings":
/*!********************************!*\
  !*** external "VideoSettings" ***!
  \********************************/
/***/ ((module) => {

"use strict";
module.exports = VideoSettings;

/***/ }),

/***/ "../settings/video-util":
/*!****************************!*\
  !*** external "VideoUtil" ***!
  \****************************/
/***/ ((module) => {

"use strict";
module.exports = VideoUtil;

/***/ }),

/***/ "../wb/interview-area":
/*!**********************************!*\
  !*** external "InterviewWbArea" ***!
  \**********************************/
/***/ ((module) => {

"use strict";
module.exports = InterviewWbArea;

/***/ }),

/***/ "../wb/wb-area":
/*!*****************************!*\
  !*** external "DrawWbArea" ***!
  \*****************************/
/***/ ((module) => {

"use strict";
module.exports = DrawWbArea;

/***/ }),

/***/ "./node_modules/nosleep.js/src/index.js":
/*!**********************************************!*\
  !*** ./node_modules/nosleep.js/src/index.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

const { webm, mp4 } = __webpack_require__(/*! ./media.js */ "./node_modules/nosleep.js/src/media.js");

// Detect iOS browsers < version 10
const oldIOS = () =>
  typeof navigator !== "undefined" &&
  parseFloat(
    (
      "" +
      (/CPU.*OS ([0-9_]{3,4})[0-9_]{0,1}|(CPU like).*AppleWebKit.*Mobile/i.exec(
        navigator.userAgent
      ) || [0, ""])[1]
    )
      .replace("undefined", "3_2")
      .replace("_", ".")
      .replace("_", "")
  ) < 10 &&
  !window.MSStream;

// Detect native Wake Lock API support
const nativeWakeLock = () => "wakeLock" in navigator;

class NoSleep {
  constructor() {
    this.enabled = false;
    if (nativeWakeLock()) {
      this._wakeLock = null;
      const handleVisibilityChange = () => {
        if (this._wakeLock !== null && document.visibilityState === "visible") {
          this.enable();
        }
      };
      document.addEventListener("visibilitychange", handleVisibilityChange);
      document.addEventListener("fullscreenchange", handleVisibilityChange);
    } else if (oldIOS()) {
      this.noSleepTimer = null;
    } else {
      // Set up no sleep video element
      this.noSleepVideo = document.createElement("video");

      this.noSleepVideo.setAttribute("title", "No Sleep");
      this.noSleepVideo.setAttribute("playsinline", "");

      this._addSourceToVideo(this.noSleepVideo, "webm", webm);
      this._addSourceToVideo(this.noSleepVideo, "mp4", mp4);

      this.noSleepVideo.addEventListener("loadedmetadata", () => {
        if (this.noSleepVideo.duration <= 1) {
          // webm source
          this.noSleepVideo.setAttribute("loop", "");
        } else {
          // mp4 source
          this.noSleepVideo.addEventListener("timeupdate", () => {
            if (this.noSleepVideo.currentTime > 0.5) {
              this.noSleepVideo.currentTime = Math.random();
            }
          });
        }
      });
    }
  }

  _addSourceToVideo(element, type, dataURI) {
    var source = document.createElement("source");
    source.src = dataURI;
    source.type = `video/${type}`;
    element.appendChild(source);
  }

  get isEnabled() {
    return this.enabled;
  }

  enable() {
    if (nativeWakeLock()) {
      return navigator.wakeLock
        .request("screen")
        .then((wakeLock) => {
          this._wakeLock = wakeLock;
          this.enabled = true;
          console.log("Wake Lock active.");
          this._wakeLock.addEventListener("release", () => {
            // ToDo: Potentially emit an event for the page to observe since
            // Wake Lock releases happen when page visibility changes.
            // (https://web.dev/wakelock/#wake-lock-lifecycle)
            console.log("Wake Lock released.");
          });
        })
        .catch((err) => {
          this.enabled = false;
          console.error(`${err.name}, ${err.message}`);
          throw err;
        });
    } else if (oldIOS()) {
      this.disable();
      console.warn(`
        NoSleep enabled for older iOS devices. This can interrupt
        active or long-running network requests from completing successfully.
        See https://github.com/richtr/NoSleep.js/issues/15 for more details.
      `);
      this.noSleepTimer = window.setInterval(() => {
        if (!document.hidden) {
          window.location.href = window.location.href.split("#")[0];
          window.setTimeout(window.stop, 0);
        }
      }, 15000);
      this.enabled = true;
      return Promise.resolve();
    } else {
      let playPromise = this.noSleepVideo.play();
      return playPromise
        .then((res) => {
          this.enabled = true;
          return res;
        })
        .catch((err) => {
          this.enabled = false;
          throw err;
        });
    }
  }

  disable() {
    if (nativeWakeLock()) {
      if (this._wakeLock) {
        this._wakeLock.release();
      }
      this._wakeLock = null;
    } else if (oldIOS()) {
      if (this.noSleepTimer) {
        console.warn(`
          NoSleep now disabled for older iOS devices.
        `);
        window.clearInterval(this.noSleepTimer);
        this.noSleepTimer = null;
      }
    } else {
      this.noSleepVideo.pause();
    }
    this.enabled = false;
  }
}

module.exports = NoSleep;


/***/ }),

/***/ "./node_modules/nosleep.js/src/media.js":
/*!**********************************************!*\
  !*** ./node_modules/nosleep.js/src/media.js ***!
  \**********************************************/
/***/ ((module) => {

module.exports = {
  webm:
    "data:video/webm;base64,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",
  mp4:
    "data:video/mp4;base64,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",
};


/***/ }),

/***/ "./src/room/activities.js":
/*!********************************!*\
  !*** ./src/room/activities.js ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");
const Settings = __webpack_require__(/*! ../main/settings */ "../main/settings");

const closedHeight = 20, timeout = 10000;
let activities, aclean, modArea, area, openedHeight = 345
	, openedHeightPx = openedHeight + 'px', inited = false
	, newActNotification;

function _load() {
	const s = Settings.load();
	if (typeof(s.activity) === 'undefined') {
		s.activity = {};
	}
	return s;
}
function _updateClean(s, a) {
	const clean = s.activity.clean === true;
	a.prop('checked', clean);
	if (clean) {
		activities.find('.auto-clean').each(function() {
			setTimeout(_clearItem.bind(null, $(this).data().id), timeout);
		});
	}
}
function isClosed() {
	return activities.height() < 24;
}
function _updateHeightVar(h) {
	Room.setCssVar('--activities-height', h);
}
function _open() {
	if (isClosed()) {
		$('.control.block i', activities).removeClass('fa-angle-up').addClass('fa-angle-down');
		$('.control.block', activities).removeClass('bg-warning');
		activities.animate(
			{
				height: openedHeightPx
				, top: '-' + openedHeightPx
			}
			, 1000
			, function() {
				activities.css({'top': ''});
				_updateHeightVar(openedHeightPx);
				activities.resizable('option', 'disabled', false);
			}
		);
	}
}
function _close() {
	if (!isClosed()) {
		$('.control.block i', activities).removeClass('fa-angle-down').addClass('fa-angle-up');
		activities.animate(
			{
				height: closedHeight
				, top: (openedHeight - closedHeight) + 'px'
			}
			, 1000
			, function() {
				activities.css({'top': ''});
				_updateHeightVar(closedHeight + 'px');
			}
		);
		activities.resizable('option', 'disabled', true);
	}
}
function _findUser(uid) {
	const m = '5px', t = 50, u = $('#user' + uid);
	if (u.length === 1) {
		u[0].scrollIntoView();
		u.addClass('bg-warning');
		for(let i = 0; i < 10; i++) {
			u.animate({marginTop: '-='+m}, t)
				.animate({marginTop: '+='+m}, t);
		}
		u.removeClass('bg-warning', 1500);
	}
}
function _hightlight(notify) {
	if (!inited) {
		return;
	}
	if (isClosed()) {
		$('.control.block', activities).addClass('bg-warning');
		if (notify) {
			OmUtil.notify(newActNotification, 'new_aa_item');
		}
	}
}
function _getId(id) {
	return 'activity-' + id;
}
function _action(name, val) {
	activityAction($('.room-block .room-container').data('room-id'), name, val);
}
function _remove(ids) {
	for (let i = 0; i < ids.length; ++i) {
		$('#' + _getId(ids[i])).remove();
	}
	_updateCount();
}
function _clearItem(id) {
	if (aclean.prop('checked')) {
		_remove([id]);
	}
}
function _updateCount() {
	if (!inited) {
		return;
	}
	$('.control.block .badge', activities).text(modArea.find('.activity').length);
}

module.exports = {
	init: function() {
		if ($('#activities').resizable("instance") !== undefined) {
			return;
		}
		activities = $('#activities');
		const ctrlBlk = activities.find('.control.block');
		ctrlBlk.off().click(Activities.toggle);
		newActNotification = ctrlBlk.data('new-aa');
		activities.resizable({
			handles: 'n'
			, disabled: isClosed()
			, minHeight: 195
			, stop: function(_, ui) {
				openedHeight = ui.size.height;
				openedHeightPx = openedHeight + 'px';
				_updateHeightVar(openedHeightPx);
				activities.css({'top': ''});
			}
		});
		modArea = activities.find('.area .actions');
		area = activities.find('.area .activities');
		aclean = $('#activity-auto-clean');
		aclean.change(function() {
			const s = _load();
			s.activity.clean = $(this).prop('checked');
			Settings.save(s);
			_updateClean(s, $(this));
		});
		_updateClean(_load(), aclean);
		inited = true;
		_updateCount();
	}
	, toggle: function() {
		if (!inited) {
			return;
		}
		if (isClosed()) {
			_open();
		} else {
			_close();
		}
	}
	, findUser: _findUser
	, add: function(obj) {
		if (!inited) {
			return;
		}
		const _id = _getId(obj.id);
		(obj.action ? modArea : area).append(OmUtil.tmpl('#activity-stub', _id).data(obj));
		const a = $('#' + _id).addClass(obj.cssClass);
		const acpt = a.find('.activity-accept');
		if (obj.accept) {
			acpt.click(function() { _action('accept', obj.id); });
		} else {
			acpt.remove();
		}
		const dcln = a.find('.activity-decline');
		if (obj.decline) {
			dcln.click(function() { _action('decline', obj.id); });
		} else {
			dcln.remove();
		}
		const fnd = a.find('.activity-find');
		if (obj.find) {
			fnd.click(function() { _findUser(obj.uid); });
		} else {
			fnd.remove();
		}
		a.find('.activity-close').click(function() {
			_action('close', obj.id);
		});
		a.find('.activity-text').text(obj.text);
		_hightlight(obj.action);
		if (aclean.prop('checked') && a.hasClass('auto-clean')) {
			setTimeout(_clearItem.bind(null, obj.id), timeout);
		}
		_updateCount();
	}
	, remove: _remove
};


/***/ }),

/***/ "./src/room/quick-poll.js":
/*!********************************!*\
  !*** ./src/room/quick-poll.js ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");
const UserListUtil = __webpack_require__(/*! ./user-list-util */ "./src/room/user-list-util.js");

function _setQuickPollRights() {
	const close = $('#quick-vote .close-btn');
	if (close.length === 1) {
		if (UserListUtil.hasRight(['PRESENTER'])) {
			close.show();
			if (typeof(close.data('bs.confirmation')) === 'object') {
				return;
			}
			close
				.confirmation({
					confirmationEvent: 'bla'
					, onConfirm: () => quickPollAction('close')
				});
		} else {
			close.hide();
		}
	}
}
function _update(obj) {
	if (obj.started) {
		let qv = $('#quick-vote');
		if (qv.length === 0) {
			const wbArea = $('.room-block .wb-block');
			qv = OmUtil.tmpl('#quick-vote-template', 'quick-vote');
			qv.attr('class', 'end-0');
			wbArea.append(qv);
		}
		const pro = qv.find('.control.pro')
			, con = qv.find('.control.con');
		if (obj.voted) {
			pro.removeClass('clickable').off();
			con.removeClass('clickable').off();
		} else {
			pro.addClass('clickable').off().click(function() {
				quickPollAction('vote', true);
			});
			con.addClass('clickable').off().click(function() {
				quickPollAction('vote', false);
			});
		}
		pro.find('.badge').text(obj.pros);
		con.find('.badge').text(obj.cons);
		_setQuickPollRights();
	} else {
		const qv = $('#quick-vote');
		if (qv.length === 1) {
			qv.remove();
		}
	}
	OmUtil.tmpl('#quick-vote-template', 'quick-vote');
}

module.exports = {
	update: _update
	, setRights: _setQuickPollRights
};

/***/ }),

/***/ "./src/room/room.js":
/*!**************************!*\
  !*** ./src/room/room.js ***!
  \**************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const Settings = __webpack_require__(/*! ../main/settings */ "../main/settings");
const VideoUtil = __webpack_require__(/*! ../settings/video-util */ "../settings/video-util");
const VideoSettings = __webpack_require__(/*! ../settings/settings */ "../settings/settings");
const InterviewWbArea = __webpack_require__(/*! ../wb/interview-area */ "../wb/interview-area");
const DrawWbArea = __webpack_require__(/*! ../wb/wb-area */ "../wb/wb-area")

const NoSleep = __webpack_require__(/*! nosleep.js */ "./node_modules/nosleep.js/src/index.js");
const VideoManager = __webpack_require__(/*! ./video-manager */ "./src/room/video-manager.js");
const Sharer = __webpack_require__(/*! ./sharer */ "./src/room/sharer.js");
const Activities = __webpack_require__(/*! ./activities */ "./src/room/activities.js");
const SipDialer = __webpack_require__(/*! ./sip-dialer */ "./src/room/sip-dialer.js");
const UserListUtil = __webpack_require__(/*! ./user-list-util */ "./src/room/user-list-util.js");
const UserList = __webpack_require__(/*! ./user-list */ "./src/room/user-list.js");
const QuickPoll = __webpack_require__(/*! ./quick-poll */ "./src/room/quick-poll.js");

const sbSide = Settings.isRtl ? 'right' : 'left';
let options, menuHeight, sb, dock, noSleep;

function _init(_options) {
	options = _options;
	window.WbArea = options.interview ? new InterviewWbArea() : new DrawWbArea();
	const menu = $('.room-block .room-container .menu');
	sb = $('.room-block .sidebar');
	sb.width(sb.width()); // this is required to 'fix' the width so it will not depend on CSS var
	dock = sb.find('.btn-dock').click(function() {
		const offset = parseInt(sb.css(sbSide));
		if (offset < 0) {
			sb.removeClass('closed');
		}
		dock.prop('disabled', true);
		const props = {};
		props[sbSide] = offset < 0 ? '0px' : (-sb.width() + 45) + 'px';
		sb.animate(props, 1500
			, function() {
				dock.prop('disabled', false);
				__dockSetMode(offset < 0);
				_setSize();
			});
	});
	__dockSetMode(true);
	menuHeight = menu.length === 0 ? 0 : menu.height();
	VideoManager.init();
	Activities.init();
	Sharer.init();
	UserList.init(options);
	_setSize();
	$(window).on('resize.omwb', window.WbArea.resize);
}
function __dockSetMode(mode) {
	const icon = dock.find('i').removeClass('icon-dock icon-undock');
	if (mode) {
		icon.addClass('icon-undock');
		dock.attr('title', dock.data('ttl-undock'))
			.find('.sr-only').text(dock.data('ttl-undock'));
		_sbAddResizable();
	} else {
		icon.addClass('icon-dock');
		dock.attr('title', dock.data('ttl-dock'))
			.find('.sr-only').text(dock.data('ttl-dock'));
		sb.addClass('closed').resizable('destroy');
	}
}
function _getSelfAudioClient() {
	const vw = $('.video-container[data-client-type=WEBCAM][data-client-uid=' + Room.getOptions().uid + ']');
	if (vw.length > 0) {
		const v = vw.first().data();
		if (VideoUtil.hasMic(v.stream())) {
			return v;
		}
	}
	return null;
}
function _preventKeydown(e) {
	const base = $(e.target);
	if (e.target.isContentEditable === true || base.is('textarea, input:not([readonly]):not([type=radio]):not([type=checkbox])')) {
		return;
	}
	if (e.which === 8) { // backspace
		e.preventDefault();
		e.stopImmediatePropagation();
		return false;
	}
}
function __keyPressed(hotkey, e) {
	const code = e.code;
	return hotkey.alt === e.altKey
		&& hotkey.ctrl === e.ctrlKey
		&& hotkey.shift === e.shiftKey
		&& hotkey.code.toUpperCase() === (code ? code.toUpperCase() : '');
}
function _keyHandler(e) {
	if (__keyPressed(options.keycode.arrange, e)) {
		VideoUtil.arrange();
	} else if (__keyPressed(options.keycode.arrangeresize, e)) {
		VideoUtil.arrangeResize(VideoSettings.load());
	} else if (__keyPressed(options.keycode.muteothers, e)) {
		const v = _getSelfAudioClient();
		if (v !== null) {
			VideoManager.clickMuteOthers(Room.getOptions().uid);
		}
	} else if (__keyPressed(options.keycode.mute, e)) {
		const v = _getSelfAudioClient();
		if (v !== null) {
			v.mute(!v.isMuted());
		}
	} else if (__keyPressed(options.keycode.quickpoll, e)) {
		quickPollAction('open');
	}
	if (e.which === 27) {
		$('#wb-rename-menu').hide();
	}
}
function _mouseHandler(e) {
	if (e.which === 1) {
		$('#wb-rename-menu').hide();
	}
}
function _sbWidth() {
	if (sb === undefined) {
		sb = $('.room-block .sidebar');
	}
	return sb === undefined ? 0 : sb.width() + parseInt(sb.css(sbSide));
}
function _setSize() {
	const sbW = _sbWidth()
		, holder = $('.room-block');
	($('.main.room')[0]).style.setProperty('--sidebar-width', sbW + 'px');
	if (sbW > 236) {
		holder.addClass('big').removeClass('narrow');
	} else {
		holder.removeClass('big').addClass('narrow');
	}
}
function _reload() {
	if (!!options && !!options.reloadUrl) {
		window.location.href = options.reloadUrl;
	} else {
		window.location.reload();
	}
}
function _close() {
	_unload();
	$(".room-block").remove();
	$("#chatPanel").remove();
	$('#disconnected-dlg')
		.modal('show')
		.off('hide.bs.modal')
		.on('hide.bs.modal', _reload);
}
function _sbAddResizable() {
	sb.resizable({
		handles: Settings.isRtl ? 'w' : 'e'
		, stop: function() {
			_setSize();
		}
	});
}
function _load() {
	$('body').addClass('no-header');
	Wicket.Event.subscribe("/websocket/closed", _close);
	Wicket.Event.subscribe("/websocket/error", _close);
	$(window).on('keydown.openmeetings', _preventKeydown);
	$(window).on('keyup.openmeetings', _keyHandler);
	$(window).on('keydown.om-sip', SipDialer.keyDown);
	$(window).on('keyup.om-sip', SipDialer.keyUp);
	$(document).click(_mouseHandler);
	document.addEventListener('click', _addNoSleep, false);
	SipDialer.init();
}
function _addNoSleep() {
	_removeNoSleep();
	noSleep = new NoSleep();
	noSleep.enable();
}
function _removeNoSleep() {
	document.removeEventListener('click', _addNoSleep, false);
	if (noSleep) {
		noSleep.disable();
		noSleep = null;
	}
}
function _unload() {
	$('body').removeClass('no-header');
	Wicket.Event.unsubscribe("/websocket/closed", _close);
	Wicket.Event.unsubscribe("/websocket/error", _close);
	if (typeof(WbArea) === 'object') {
		WbArea.destroy();
		window.WbArea = undefined;
	}
	if (typeof(VideoSettings) === 'object') {
		VideoSettings.close();
	}
	if (typeof(VideoManager) === 'object') {
		VideoManager.destroy();
	}
	$('.ui-dialog.user-video').remove();
	$(window).off('keyup.openmeetings');
	$(window).off('keydown.openmeetings');
	$(window).off('resize.omwb');
	$(window).off('keydown.om-sip');
	$(window).off('keyup.om-sip');
	$(document).off('click', _mouseHandler);
	sb = undefined;
	Sharer.close();
	_removeNoSleep();
}
function _showClipboard(txt) {
	const dlg = $('#clipboard-dialog');
	dlg.find('p .text').text(txt);
	dlg.dialog({
		resizable: false
		, height: "auto"
		, width: 400
		, modal: true
		, buttons: [
			{
				text: dlg.data('btn-ok')
				, click: function() {
					$(this).dialog('close');
				}
			}
		]
	});
}

module.exports = {
	init: _init
	, getMenuHeight: function() {
		return menuHeight;
	}
	, getOptions: function() {
		return typeof(options) === 'object' ? JSON.parse(JSON.stringify(options)) : {};
	}
	, load: _load
	, unload: _unload
	, showClipboard: _showClipboard
	, quickPoll: QuickPoll.update
	, hasRight: UserListUtil.hasRight
	, setCssVar: function(key, val) {
		($('.main.room')[0]).style.setProperty(key, val);
	}
	, addClient: UserList.addClient
	, updateClient: UserList.updateClient
	, removeClient: UserList.removeClient
	, removeOthers: UserList.removeOthers
	, getClient: UserList.getClient
};


/***/ }),

/***/ "./src/room/sharer.js":
/*!****************************!*\
  !*** ./src/room/sharer.js ***!
  \****************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const VideoUtil = __webpack_require__(/*! ../settings/video-util */ "../settings/video-util");
const VideoMgrUtil = __webpack_require__(/*! ./video-manager-util */ "./src/room/video-manager-util.js");

const SHARE_STARTING = 'starting'
	, SHARE_STARTED = 'started'
	, SHARE_STOPPED = 'stopped';

let sharer, type, fps, sbtn, rbtn
	, shareState = SHARE_STOPPED, recState = SHARE_STOPPED;

/**
 * Re-entering the room should reset settings.
 */
function reset() {
	shareState = SHARE_STOPPED;
	recState = SHARE_STOPPED;
}

function _init() {
	reset();
	sharer = $('#sharer').dialog({
		appendTo: '.room-block .room-container'
		, classes: {
			'ui-dialog': 'sharer'
			, 'ui-dialog-titlebar': ''
		}
		, width: 450
		, autoOpen: false
		, resizable: false
	});
	const ui = sharer.closest('.ui-dialog');
	const parent = $('.room-block .room-container .sb-wb');
	ui.draggable('option', 'containment', parent);
	fixJQueryUIDialogTouch(sharer);

	if (!VideoUtil.sharingSupported()) {
		sharer.find('.container').remove();
		sharer.find('.alert').show();
	} else {
		type = sharer.find('select.type');
		fps = sharer.find('select.fps');
		_disable(fps, VideoUtil.isEdge());
		sbtn = sharer.find('.share-start-stop').off().click(function() {
			if (shareState === SHARE_STOPPED) {
				_setShareState(SHARE_STARTING);
				VideoMgrUtil.sendMessage({
					id: 'wannaShare'
					, shareType: type.val()
					, fps: fps.val()
				});
			} else {
				VideoMgrUtil.sendMessage({
					id: 'pauseSharing'
					, uid: _getShareUid()
				});
			}
		});
		rbtn = sharer.find('.record-start-stop').off();
		if (Room.getOptions().allowRecording) {
			rbtn.show().click(function() {
				if (recState === SHARE_STOPPED) {
					_setRecState(SHARE_STARTING);
					VideoMgrUtil.sendMessage({
						id: 'wannaRecord'
						, shareType: type.val()
						, fps: fps.val()
					});
				} else {
					VideoMgrUtil.sendMessage({
						id: 'stopRecord'
						, uid: _getShareUid()
					});
				}
			});
		} else {
			rbtn.hide();
		}
	}
}
function _disable(e, state) {
	e.prop('disabled', state);
	if (state) {
		e.addClass('disabled');
	} else {
		e.removeClass('disabled');
	}
}
function _typeDisabled() {
	return VideoUtil.isEdge() || VideoUtil.isChrome() || VideoUtil.isEdgeChromium();
}
function _setBtnState(btn, state) {
	const dis = SHARE_STOPPED !== state
		, typeDis = _typeDisabled();
	_disable(type, dis);
	_disable(fps, dis || typeDis);
	btn.find('span').text(btn.data(dis ? 'stop' : 'start'));
	if (dis) {
		btn.addClass('stop');
	} else {
		btn.removeClass('stop');
	}
	_disable(btn, state === SHARE_STARTING);
	_disable(btn, state === SHARE_STARTING);
}
function _setShareState(state) {
	shareState = state;
	_setBtnState(sbtn, state);
}
function _setRecState(state) {
	recState = state;
	_setBtnState(rbtn, state);
}
function _getShareUid() {
	const v = $('div[data-client-uid="' + Room.getOptions().uid + '"][data-client-type="SCREEN"]');
	return v && v.data() && v.data().stream() ? v.data().stream().uid : '';
}

module.exports = {
	SHARE_STARTING: SHARE_STARTING
	, SHARE_STARTED: SHARE_STARTED
	, SHARE_STOPPED: SHARE_STOPPED

	, init: _init
	, open: function() {
		if (sharer && sharer.dialog('instance')) {
			sharer.dialog('open');
		}
	}
	, close: function() {
		if (sharer && sharer.dialog('instance')) {
			sharer.dialog('close');
		}
	}
	, setShareState: _setShareState
	, setRecState: _setRecState
	, baseConstraints: function(sd) {
		return {
			video: {
				frameRate: {
					ideal: sd.fps
				}
			}
			, audio: false
		};
	}
};


/***/ }),

/***/ "./src/room/sip-dialer.js":
/*!********************************!*\
  !*** ./src/room/sip-dialer.js ***!
  \********************************/
/***/ ((module) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
function __addSipText(v) {
	const txt = $('.sip-number');
	txt.val(txt.val() + v);
}
function __eraseSipText() {
	const txt = $('.sip-number')
		, t = txt.val();
	if (!!t) {
		txt.val(t.substring(0, t.length - 1));
	}
}
function _sipGetKey(evt) {
	let k = -1;
	if (evt.keyCode > 47 && evt.keyCode < 58) {
		k = evt.keyCode - 48;
	}
	if (evt.keyCode > 95 && evt.keyCode < 106) {
		k = evt.keyCode - 96;
	}
	return k;
}

module.exports = {
	init: function() {
		$('.sip .button-row button').off().click(function() {
			__addSipText($(this).data('value'));
		});
		$('#sip-dialer-btn-erase').off().click(__eraseSipText);
	}
	, keyDown: function(evt) {
		const k = _sipGetKey(evt);
		if (k > 0) {
			$('#sip-dialer-btn-' + k).addClass('bg-warning');
		}
	}
	, keyUp: function(evt) {
		if (evt.key === 'Backspace') {
			__eraseSipText();
		} else {
			const k = _sipGetKey(evt);
			if (k > 0) {
				$('#sip-dialer-btn-' + k).removeClass('bg-warning');
				__addSipText(k);
			}
		}
	}
};

/***/ }),

/***/ "./src/room/user-list-util.js":
/*!************************************!*\
  !*** ./src/room/user-list-util.js ***!
  \************************************/
/***/ ((module) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
let options;

function _hasRight(_inRights, _ref) {
	const ref = _ref || options.rights;
	let _rights;
	if (Array.isArray(_inRights)) {
		_rights = _inRights;
	} else {
		if ('SUPER_MODERATOR' === _inRights) {
			return ref.includes(_inRights);
		}
		_rights = [_inRights];
	}
	const rights = ['SUPER_MODERATOR', 'MODERATOR', ..._rights];
	for (let i = 0; i < rights.length; ++i) {
		if (ref.includes(rights[i])) {
			return true;
		}
	}
	return false;
}

module.exports = {
	init: function(opts) {
		options = opts;
	}
	, hasRight: _hasRight
};


/***/ }),

/***/ "./src/room/user-list.js":
/*!*******************************!*\
  !*** ./src/room/user-list.js ***!
  \*******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const Settings = __webpack_require__(/*! ../main/settings */ "../main/settings");
const Chat = __webpack_require__(/*! ../chat/chat */ "../chat/chat");
const VideoUtil = __webpack_require__(/*! ../settings/video-util */ "../settings/video-util");
const VideoSettings = __webpack_require__(/*! ../settings/settings */ "../settings/settings");

const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");
const VideoManager = __webpack_require__(/*! ./video-manager */ "./src/room/video-manager.js");
const UserListUtil = __webpack_require__(/*! ./user-list-util */ "./src/room/user-list-util.js");
const QuickPoll = __webpack_require__(/*! ./quick-poll */ "./src/room/quick-poll.js");

let options;

function __activityAVIcon(elem, selector, predicate, onfunc, disabledfunc) {
	const icon = elem.find(selector);
	if (predicate()) {
		icon.show();
		const on = onfunc()
			, disabled = disabledfunc();
		if (disabled) {
			icon.addClass('disabled');
		} else {
			icon.removeClass('disabled');
			if (on) {
				icon.addClass('enabled');
			} else {
				icon.removeClass('enabled');
			}
		}
		icon.attr('title', icon.data(on ? 'on' :'off'));
	} else {
		icon.hide();
	}
	return icon;
}
function __activityIcon(elem, selector, predicate, action, confirm) {
	let icon = elem.find(selector);
	if (predicate()) {
		if (icon.length === 0) {
			icon = OmUtil.tmpl('#user-actions-stub ' + selector);
			elem.append(icon);
		}
		icon.off();
		if (confirm) {
			icon.confirmation(confirm);
		} else {
			icon.click(action);
		}
	} else {
		icon.hide();
	}
}
function __rightIcon(c, elem, rights, selector, predicate) {
	const self = c.uid === options.uid
		, hasRight = UserListUtil.hasRight(rights, c.rights);
	let icon = elem.find(selector);
	if (predicate() && !UserListUtil.hasRight('SUPER_MODERATOR', c.rights) && (
		(self && options.questions && !hasRight)
		|| (!self && UserListUtil.hasRight('MODERATOR'))
	)) {
		if (icon.length === 0) {
			icon = OmUtil.tmpl('#user-actions-stub ' + selector);
			elem.append(icon);
		}
		if (hasRight) {
			icon.addClass('granted');
		} else {
			icon.removeClass('granted')
		}
		icon.attr('title', icon.data(self ? 'request' : (hasRight ? 'revoke' : 'grant')));
		icon.off().click(function() {
			OmUtil.roomAction({action: 'toggleRight', right: rights[0], uid: c.uid});
		});
	} else {
		icon.remove();
	}
}
function __rightAudioIcon(c, elem) {
	__rightIcon(c, elem, ['AUDIO'], '.right.audio', () => true);
}
function __rightVideoIcon(c, elem) {
	__rightIcon(c, elem, ['VIDEO'], '.right.camera', () => !options.audioOnly);
}
function __rightOtherIcons(c, elem) {
	__rightIcon(c, elem, ['PRESENTER'], '.right.presenter', () => !options.interview && $('.wb-area').is(':visible'));
	__rightIcon(c, elem, ['WHITEBOARD', 'PRESENTER'], '.right.wb', () => !options.interview && $('.wb-area').is(':visible'));
	__rightIcon(c, elem, ['SHARE'], '.right.screen-share', () => true);
	__rightIcon(c, elem, ['REMOTE_CONTROL'], '.right.remote-control', () => true);
	__rightIcon(c, elem, ['MODERATOR'], '.right.moderator', () => true);
}
function __setStatus(c, le) {
	const status = le.find('.user-status')
		, mode = c.level == 5 ? 'mod' : (c.level == 3 ? 'wb' : 'user');
	status.removeClass('mod wb user');
	status.attr('title', status.data(mode)).addClass(mode);
	le.data('level', c.level);
}
function __updateCount() {
	$('#room-sidebar-users-tab .user-count').text($('#room-sidebar-tab-users .user-list .users .user.entry').length);
}
function __sortUserList() {
	const container = $('#room-sidebar-tab-users .user-list .users');
	container.find('.user.entry').sort((_u1, _u2) => {
		const u1 = $(_u1)
			, u2 = $(_u2);
		return u2.data('level') - u1.data('level') || u1.attr('title').localeCompare(u2.attr('title'));
	}).appendTo(container);
}


function _getClient(uid) {
	return $('#user' + uid);
}
function _addClient(_clients) {
	if (!options) {
		return; //too early
	}
	const clients = Array.isArray(_clients) ? _clients : [_clients];
	clients.forEach(c => {
		const self = c.uid === options.uid;
		let le = _getClient(c.uid);
		if (le.length === 0) {
			le = OmUtil.tmpl('#user-entry-stub', 'user' + c.uid);
			le.attr('id', 'user' + c.uid)
				.attr('data-userid', c.user.id)
				.attr('data-uid', c.uid);
			if (self) {
				le.addClass('current');
			}
			$('#room-sidebar-tab-users .user-list .users').append(le);
		}
		_updateClient(c);
	});
	__updateCount();
	__sortUserList();
}
function _updateClient(c) {
	if (!options) {
		return; //too early
	}
	const self = c.uid === options.uid
		, le = _getClient(c.uid)
		, selfCamStream = c.streams.find(s => s.type === 'WEBCAM')
		, hasAudio = VideoUtil.hasMic(self && selfCamStream ? selfCamStream : c)
		, hasVideo = VideoUtil.hasCam(self && selfCamStream ? selfCamStream : c)
		, speaks = le.find('.audio-activity');
	if (le.length === 0) {
		return;
	}
	__setStatus(c, le);
	if (hasVideo || hasAudio) {
		if (le.find('.restart').length === 0) {
			le.prepend(OmUtil.tmpl('#user-av-restart').click(function () {
				VideoManager.refresh(c.uid);
			}));
		}
	} else {
		le.find('.restart').remove();
	}
	speaks.hide().removeClass('clickable').attr('title', speaks.data('speaks')).off();
	if (hasAudio) {
		speaks.show();
		if(UserListUtil.hasRight('MUTE_OTHERS')) {
			speaks.addClass('clickable').click(function () {
				VideoManager.clickMuteOthers(c.uid);
			}).attr('title', speaks.attr('title') + speaks.data('mute'));
		}
	}
	le.attr('title', c.user.displayName)
		.css('background-image', 'url(' + c.user.pictureUri + ')')
		.find('.user.name').text(c.user.displayName);

	if (c.user.id !== -1) {
		const actions = le.find('.user.actions');
		__rightVideoIcon(c, actions);
		__rightAudioIcon(c, actions);
		__rightOtherIcons(c, actions);
		__activityIcon(actions, '.kick'
			, () => !self && UserListUtil.hasRight('MODERATOR') && !UserListUtil.hasRight('SUPER_MODERATOR', c.rights)
			, null
			, {
				confirmationEvent: 'om-kick'
				, placement: Settings.isRtl ? 'left' : 'right'
				, onConfirm: () => OmUtil.roomAction({action: 'kick', uid: c.uid})
			});
		__activityIcon(actions, '.private-chat'
			, () => options.userId !== c.user.id && $('#chatPanel').is(':visible')
			, function() {
				Chat.addTab('chatTab-u' + c.user.id, c.user.displayName);
				Chat.open();
				$('#chatMessage .wysiwyg-editor').click();
			});
	}
	if (self) {
		options.rights = c.rights;
		QuickPoll.setRights();
		options.activities = c.activities;
		const header = $('#room-sidebar-tab-users .header');
		header.find('.om-icon.settings').off().click(VideoSettings.open);
		__rightVideoIcon(c, header);
		__activityAVIcon(
				header
				, '.activity.cam'
				, () => !options.audioOnly && UserListUtil.hasRight(VideoUtil.CAM_ACTIVITY)
				, () => hasVideo
				, () => Settings.load().video.cam < 0)
			.off().click(function() {
				VideoManager.toggleActivity(VideoUtil.CAM_ACTIVITY);
			});;
		__rightAudioIcon(c, header);
		__activityAVIcon(
				header
				, '.activity.mic', () => UserListUtil.hasRight(VideoUtil.MIC_ACTIVITY)
				, () => hasAudio
				, () => Settings.load().video.mic < 0)
			.off().click(function() {
				VideoManager.toggleActivity(VideoUtil.MIC_ACTIVITY);
			});
		__rightOtherIcons(c, header);
	}
	VideoManager.update(c)
}

module.exports = {
	init: function(opts) {
		options = opts;
		UserListUtil.init(opts);
	}
	, addClient: _addClient
	, updateClient: function(c) {
		_updateClient(c);
		__sortUserList();
	}
	, removeClient: function(uid) {
		_getClient(uid).remove();
		__updateCount();
	}
	, removeOthers: function() {
		const selfUid = options.uid;
		$('.user-list .user.entry').each(function() {
			const c = $(this);
			if (c.data('uid') !== selfUid) {
				c.remove();
			}
		});
		__updateCount();
	}
	, getClient: _getClient
};


/***/ }),

/***/ "./src/room/user-settings.js":
/*!***********************************!*\
  !*** ./src/room/user-settings.js ***!
  \***********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const Settings = __webpack_require__(/*! ../main/settings */ "../main/settings");
const Chat = __webpack_require__(/*! ../chat/chat */ "../chat/chat");
const VideoSettings = __webpack_require__(/*! ../settings/settings */ "../settings/settings");

function __initMuteOthers() {
	let s = VideoSettings.load();
	$('#muteOthersAsk')
		.prop('checked', s.video.confirmMuteOthers)
		.off().click(function() {
			s = VideoSettings.load();
			s.video.confirmMuteOthers = !$('#muteOthersAsk').prop('checked');
			VideoSettings.save();
		});
}
function __initChat() {
	let s = Settings.load();
	$('#chatNotify')
		.prop('checked', s.chat.muted)
		.off().click(function() {
			s = Settings.load();
			s.chat.muted = !$('#chatNotify').prop('checked');
			Settings.save(s);
			Chat.reload();
		});
	$('#sendOnCtrlEnter')
		.prop('checked', s.chat.sendOn === Chat.SEND_CTRL)
		.off().click(function() {
			s = Settings.load();
			s.chat.sendOn = $('#sendOnCtrlEnter').prop('checked') ? Chat.SEND_CTRL : Chat.SEND_ENTER;
			Settings.save(s);
			Chat.reload();
		});
}
function __initVideo() {
	const resolutions = $('#video-settings .cam-resolution').clone();
	let s = VideoSettings.load();
	resolutions
		.change(function() {
			const o = resolutions.find('option:selected').data();
			s.fixed.width = o.width;
			s.fixed.height = o.height;
			VideoSettings.save();
		})
		.find('option').each(function() {
			const o = $(this).data();
			if (o.width === s.fixed.width && o.height === s.fixed.height) {
				$(this).prop('selected', true);
				return false;
			}
		});
	$('#video-sizes-container')
		.html('')
		.append(resolutions.prop('disabled', !s.fixed.enabled));
	$('#fixedVideoPod')
		.prop('checked', s.fixed.enabled)
		.off().click(function() {
			s = VideoSettings.load();
			s.fixed.enabled = $('#fixedVideoPod').prop('checked');
			resolutions.prop('disabled', !s.fixed.enabled)
			VideoSettings.save();
		});
}
function _open() {
	__initMuteOthers();
	__initChat();
	__initVideo();
	$('#room-local-settings').modal('show');
}

module.exports = {
	open: _open
};


/***/ }),

/***/ "./src/room/video-manager-util.js":
/*!****************************************!*\
  !*** ./src/room/video-manager-util.js ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");
const VideoUtil = __webpack_require__(/*! ../settings/video-util */ "../settings/video-util");
const VideoSettings = __webpack_require__(/*! ../settings/settings */ "../settings/settings");

let share;

function __savePod(v) {
	const opts = Room.getOptions();
	if (!opts.interview && v && v.find('video').length > 0 && v.data('clientType') === 'WEBCAM' && v.dialog('instance')) {
		const userUI = $(`#user${v.data('clientUid')}`)
			, widget = v.dialog('widget');
		userUI.data('video-pod', {
			x: widget.css('left')
			, y: widget.css('top')
			, w: widget.css('width')
			, h: widget.css('height')
		});
	}
}
function _closeV(v) {
	if (!v || v.length < 1) {
		return;
	}
	__savePod(v);
	if (v.dialog('instance') !== undefined) {
		v.dialog('destroy');
	}
	v.parents('.pod').remove();
	v.remove();
	WbArea.updateAreaClass();
}
function _clickMuteOthers(uid) {
	const s = VideoSettings.load();
	if (false !== s.video.confirmMuteOthers) {
		const dlg = $('#muteothers-confirm');
		dlg.dialog({
			appendTo: ".room-container"
			, buttons: [
				{
					text: dlg.data('btn-ok')
					, click: function() {
						s.video.confirmMuteOthers = !$('#muteothers-confirm-dont-show').prop('checked');
						VideoSettings.save();
						OmUtil.roomAction({action: 'muteOthers', uid: uid});
						$(this).dialog('close');
					}
				}
				, {
					text: dlg.data('btn-cancel')
					, click: function() {
						$(this).dialog('close');
					}
				}
			]
		})
	} else {
		OmUtil.roomAction({action: 'muteOthers', uid: uid});
	}
}

module.exports = {
	init: (_share) => {
		share = _share;
	}
	, sendMessage: (_m) => {
		OmUtil.sendMessage(_m, {type: 'kurento'});
	}
	, savePod: __savePod
	, closeV: _closeV
	, close: (uid, showShareBtn) => {
		const v = $('#' + VideoUtil.getVid(uid));
		if (v.length === 1) {
			_closeV(v);
		}
		if (!showShareBtn && uid === share.data('uid')) {
			share.off().hide();
		}
	}
	, clickMuteOthers: _clickMuteOthers
};


/***/ }),

/***/ "./src/room/video-manager.js":
/*!***********************************!*\
  !*** ./src/room/video-manager.js ***!
  \***********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");
const VideoUtil = __webpack_require__(/*! ../settings/video-util */ "../settings/video-util");
const VideoSettings = __webpack_require__(/*! ../settings/settings */ "../settings/settings");

let share, inited = false;
const VideoMgrUtil = __webpack_require__(/*! ./video-manager-util */ "./src/room/video-manager-util.js");
const Video = __webpack_require__(/*! ./video */ "./src/room/video.js");
const Sharer = __webpack_require__(/*! ./sharer */ "./src/room/sharer.js");

function _onVideoResponse(m) {
	const w = $('#' + VideoUtil.getVid(m.uid))
		, v = w.data();
	if (v) {
		v.processSdpAnswer(m.sdpAnswer);
	}
}
function _onBroadcast(msg) {
	const sd = msg.stream
		, uid = sd.uid;
	if (Array.isArray(msg.cleanup)) {
		msg.cleanup.forEach(function(_cuid) {
			VideoMgrUtil.close(_cuid);
		});
	}
	$('#' + VideoUtil.getVid(uid)).remove();
	new Video(msg);
	OmUtil.log(uid + ' registered in room');
}
function _onShareUpdated(msg) {
	const sd = msg.stream
		, uid = sd.uid
		, w = $('#' + VideoUtil.getVid(uid))
		, v = w.data();
	if (v && (VideoUtil.isSharing(sd) || VideoUtil.isRecording(sd))) {
		// Update activities in the current data object
		v.stream().activities = sd.activities;
	}
	Sharer.setShareState(VideoUtil.isSharing(sd) ? Sharer.SHARE_STARTED : Sharer.SHARE_STOPPED);
	Sharer.setRecState(VideoUtil.isRecording(sd) ? Sharer.SHARE_STARTED : Sharer.SHARE_STOPPED);
}
function _onReceive(msg) {
	const uid = msg.stream.uid;
	VideoMgrUtil.closeV($('#' + VideoUtil.getVid(uid)));
	new Video(msg);
	OmUtil.log(uid + ' receiving video');
}
function _onKMessage(m) {
	switch (m.id) {
		case 'clientLeave':
			$(`${VideoUtil.VID_SEL}[data-client-uid="${m.uid}"]`).each(function() {
				VideoMgrUtil.closeV($(this));
			});
			if (share.data('cuid') === m.uid) {
				share.off().hide();
			}
			break;
		case 'broadcastStopped':
			VideoMgrUtil.close(m.uid, false);
			break;
		case 'broadcast':
			_onBroadcast(m);
			break;
		case 'videoResponse':
			_onVideoResponse(m);
			break;
		case 'iceCandidate':
			{
				const w = $('#' + VideoUtil.getVid(m.uid))
					, v = w.data();
				if (v) {
					v.processIceCandidate(m.candidate);
				}
			}
			break;
		case 'newStream':
			_play([m.stream], m.iceServers);
			break;
		case 'shareUpdated':
			_onShareUpdated(m);
			break;
		case 'error':
			OmUtil.error(m.message);
			break;
		default:
			//no-op
	}
}
function _onWsMessage(_, msg) {
	try {
		if (msg instanceof Blob) {
			return; //ping
		}
		const m = JSON.parse(msg);
		if (!m) {
			return;
		}
		if ('kurento' === m.type && 'test' !== m.mode) {
			OmUtil.info('Received message: ' + msg);
			_onKMessage(m);
		} else if ('mic' === m.type) {
			switch (m.id) {
				case 'activity':
					_userSpeaks(m.uid, m.active);
					break;
				default:
					//no-op
			}
		}
	} catch (err) {
		OmUtil.error(err);
	}
}
function _init() {
	Wicket.Event.subscribe('/websocket/message', _onWsMessage);
	VideoSettings.init(Room.getOptions());
	share = $('.room-block .room-container').find('.btn.shared');
	VideoMgrUtil.init(share);
	inited = true;
	$(window).on('keydown.push-to-talk', {enable: true}, _onPtt);
	$(window).on('keyup.push-to-talk', {enable: false}, _onPtt);
}
function _update(c) {
	if (!inited) {
		return;
	}
	const streamMap = {};
	c.streams.forEach(function(sd) {
		streamMap[sd.uid] = sd.uid;
		sd.self = c.self;
		sd.cam = c.cam;
		sd.mic = c.mic;
		if (VideoUtil.isSharing(sd) || VideoUtil.isRecording(sd)) {
			return;
		}
		const _id = VideoUtil.getVid(sd.uid)
			, av = VideoUtil.hasMic(sd) || VideoUtil.hasCam(sd)
			, v = $('#' + _id);
		if (av && v.length === 1) {
			v.data().update(sd);
		} else if (!av && v.length === 1) {
			VideoMgrUtil.closeV(v);
		}
	});
	if (c.uid === Room.getOptions().uid) {
		$(VideoUtil.VID_SEL).each(function() {
			$(this).data().setRights(c.rights);
		});
	}
	$(`[data-client-uid="${c.cuid}"]`).each(function() {
		const sd = $(this).data().stream();
		if (!streamMap[sd.uid]) {
			//not-inited/invalid video window
			VideoMgrUtil.closeV($(this));
		}
	});
}
function _playSharing(sd, iceServers) {
	const m = {stream: sd, iceServers: iceServers}
		, v = $('#' + VideoUtil.getVid(sd.uid))
	if (v.length === 1) {
		v.remove();
	}
	new Video(m);
	VideoUtil.setPos(v, {left: 0, top: 35});
}
function _play(streams, iceServers) {
	if (!inited) {
		return;
	}
	streams.forEach(function(sd) {
		const m = {stream: sd, iceServers: iceServers};
		if (VideoUtil.isSharing(sd)) {
			VideoUtil.highlight(share
					.attr('title', share.data('user') + ' ' + sd.user.firstName + ' ' + sd.user.lastName + ' ' + share.data('text'))
					.data('uid', sd.uid)
					.data('cuid', sd.cuid)
					.show()
				, 'btn-outline-warning', 10);
			share.tooltip().off().click(function() {
				_playSharing(sd, iceServers);
			});
			if (Room.getOptions().autoOpenSharing === true) {
				_playSharing(sd, iceServers);
			}
		} else if (VideoUtil.isRecording(sd)) {
			return;
		} else {
			_onReceive(m);
		}
	});
}
function _find(uid) {
	return $(`${VideoUtil.VID_SEL}[data-client-uid="${uid}"][data-client-type="WEBCAM"]`);
}
function _userSpeaks(uid, active) {
	const u = $(`#user${uid} .audio-activity`)
		, v = _find(uid).parent();
	if (active) {
		u.addClass('speaking');
		v.addClass('user-speaks')
	} else {
		u.removeClass('speaking');
		v.removeClass('user-speaks')
	}
}
function _refresh(uid, opts) {
	const v = _find(uid);
	if (v.length > 0) {
		v.data().refresh(opts);
	}
}
function _mute(uid, mute) {
	const v = _find(uid);
	if (v.length > 0) {
		v.data().mute(mute);
	}
}
function _muteOthers(uid) {
	$(VideoUtil.VID_SEL).each(function() {
		const w = $(this), v = w.data(), v2 = w.data('client-uid');
		if (v && v2) {
			v.mute(uid !== v2);
		}
	});
}
function _toggleActivity(activity) {
	VideoMgrUtil.sendMessage({
		id: 'toggleActivity'
		, activity: activity
	});
}
function _onPtt(e) {
	if ((e.ctrlKey || e.metaKey) && 'Space' === e.code) {
		const v = _find(Room.getOptions().uid);
		if (v.length > 0 && v.data()) {
			v.data().pushToTalk(e.data.enable);
		}
	}
}

module.exports = {
	init: _init
	, update: _update
	, play: _play
	, refresh: _refresh
	, mute: _mute
	, muteOthers: _muteOthers
	, toggleActivity: _toggleActivity
	, destroy: function() {
		$(window).off('keydown.push-to-talk');
		$(window).off('keyup.push-to-talk');
		Wicket.Event.unsubscribe('/websocket/message', _onWsMessage);
	}
};


/***/ }),

/***/ "./src/room/video.js":
/*!***************************!*\
  !*** ./src/room/video.js ***!
  \***************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");
const VideoUtil = __webpack_require__(/*! ../settings/video-util */ "../settings/video-util");
const MicLevel = __webpack_require__(/*! ../settings/mic-level */ "../settings/mic-level");
const WebRtcPeer = __webpack_require__(/*! ../settings/WebRtcPeer */ "../settings/WebRtcPeer");
const VideoSettings = __webpack_require__(/*! ../settings/settings */ "../settings/settings");

const AudioCtx = window.AudioContext || window.webkitAudioContext;
const VideoMgrUtil = __webpack_require__(/*! ./video-manager-util */ "./src/room/video-manager-util.js");
const Sharer = __webpack_require__(/*! ./sharer */ "./src/room/sharer.js");
const Volume = __webpack_require__(/*! ./volume */ "./src/room/volume.js");

module.exports = class Video {
	constructor(msg) {
		const states = [], self = this, vidSize = {};
		let sd, v, vc, t, footer, size, vol, iceServers
			, lm, level, userSpeaks = false, muteOthers
			, hasVideo, isSharing, isRecording;

		function __getState() {
			const state = states.length > 0 ? states[0] : null;
			if (!state || state.disposed) {
				return null;
			}
			return state;
		}
		function __getVideo(_state) {
			const vid = self.video(_state);
			return vid && vid.length > 0 ? vid[0] : null;
		}
		function _resizeDlgArea(_w, _h) {
			if (Room.getOptions().interview) {
				VideoUtil.setPos(v, VideoUtil.getPos());
			} else if (v.dialog('instance')) {
				v.dialog('option', 'width', _w).dialog('option', 'height', _h);
			}
		}
		function _micActivity(speaks) {
			if (speaks !== userSpeaks) {
				userSpeaks = speaks;
				OmUtil.sendMessage({type: 'mic', id: 'activity', active: speaks});
			}
		}
		function _getScreenStream(msg, state, callback) {
			function __handleScreenError(err) {
				VideoMgrUtil.sendMessage({id: 'errorSharing'});
				Sharer.setShareState(Sharer.SHARE_STOPPED);
				Sharer.setRecState(Sharer.SHARE_STOPPED);
				OmUtil.error(err);
			}
			const b = VideoUtil.browser;
			let promise, cnts;
			if (VideoUtil.isEdge() && b.major > 16) {
				cnts = {
					video: true
				};
				promise = navigator.getDisplayMedia(cnts);
			} else if (VideoUtil.sharingSupported()) {
				cnts = {
					video: true
				};
				if (VideoUtil.isSafari()) {
					promise = new Promise((resolve) => {
						VideoUtil.askPermission(resolve);
					}).then(() => navigator.mediaDevices.getDisplayMedia(cnts));
				} else {
					promise = navigator.mediaDevices.getDisplayMedia(cnts);
				}
			} else {
				promise = new Promise(() => {
					Sharer.close();
					throw 'Screen-sharing is not supported in ' + b.name + '[' + b.major + ']';
				});
			}
			promise.then(stream => {
				if (!state.disposed) {
					__createVideo(state);
					state.stream = stream;
					callback(msg, state, cnts);
				}
			}).catch(__handleScreenError);
		}
		function _getVideoStream(msg, state, callback) {
			VideoSettings.constraints(sd, function(cnts) {
				if (VideoUtil.hasCam(sd) !== cnts.videoEnabled || VideoUtil.hasMic(sd) !== cnts.audioEnabled) {
					VideoMgrUtil.sendMessage({
						id : 'devicesAltered'
						, uid: sd.uid
						, audio: cnts.audioEnabled
						, video: cnts.videoEnabled
					});
				}
				if (!cnts.audio && !cnts.video) {
					OmUtil.error('Requested devices are not available');
					VideoMgrUtil.close(sd.uid)
					return;
				}
				navigator.mediaDevices.getUserMedia(cnts)
					.then(stream => {
						if (state.disposed || msg.instanceUid !== v.data('instance-uid')) {
							return;
						}
						stream.getVideoTracks().forEach(track => track.enabled = cnts.videoEnabled);
						stream.getAudioTracks().forEach(track => track.enabled = cnts.audioEnabled);
						state.localStream = stream;
						if (__pttEnabled(state)) {
							OmUtil.alert('warning', $('#user-video').data('ptt-info'), 10000);
						}
						let _stream = stream;
						const data = {};
						if (stream.getAudioTracks().length !== 0) {
							lm = vc.find('.level-meter');
							lm.show();
							data.aCtx = new AudioCtx();
							data.gainNode = data.aCtx.createGain();
							data.analyser = data.aCtx.createAnalyser();
							data.aSrc = data.aCtx.createMediaStreamSource(stream);
							data.aSrc.connect(data.gainNode);
							data.gainNode.connect(data.analyser);
							if (VideoUtil.isEdge()) {
								data.analyser.connect(data.aCtx.destination);
							} else {
								data.aDest = data.aCtx.createMediaStreamDestination();
								data.analyser.connect(data.aDest);
								_stream = data.aDest.stream;
								stream.getVideoTracks().forEach(track => _stream.addTrack(track));
							}
						}
						state.data = data;
						__createVideo(state);
						state.stream = _stream;
						callback(msg, state, cnts);
					})
					.catch(function(err) {
						VideoMgrUtil.sendMessage({
							id : 'devicesAltered'
							, uid: sd.uid
							, audio: false
							, video: false
						});
						VideoMgrUtil.close(sd.uid);
						if ('NotReadableError' === err.name) {
							OmUtil.error('Camera/Microphone is busy and can\'t be used');
						} else {
							OmUtil.error(err);
						}
					});
			});
		}
		function __connectionStateChangeListener(state) {
			const pc = state.data.rtcPeer.pc;
			console.warn(`!!RTCPeerConnection state changed: ${pc.connectionState}, user: ${sd.user.displayName}, uid: ${sd.uid}`);
			switch(pc.connectionState) {
				case "connected":
					if (sd.self) {
						// The connection has become fully connected
						OmUtil.alert('info', `Connection to Media server has been established`, 3000);//notify user
					}
					break;
				case "disconnected":
				case "failed":
					//connection has been dropped
					OmUtil.alert('warning', `Media server connection for user ${sd.user.displayName} is ${pc.connectionState}, will try to re-connect`, 3000);//notify user
					_refresh();
					break;
				case "closed":
					// The connection has been closed
					break;
			}
		}
		function __createSendPeer(msg, state, cnts) {
			state.options = {
				mediaStream: state.stream
				, mediaConstraints: cnts
				, onIceCandidate: self.onIceCandidate
				, onConnectionStateChange: () => __connectionStateChangeListener(state)
			};
			const vid = __getVideo(state);
			VideoUtil.playSrc(vid, state.stream, true);

			const data = state.data;
			data.rtcPeer = new WebRtcPeer.Sendonly(VideoUtil.addIceServers(state.options, msg));
			if (data.analyser) {
				level = new MicLevel();
				level.meter(data.analyser, lm, _micActivity, OmUtil.error);
			}
			data.rtcPeer.createOffer()
				.then(sdpOffer => {
					data.rtcPeer.processLocalOffer(sdpOffer);
					OmUtil.log('Invoking Sender SDP offer callback function');
					const bmsg = {
							id : 'broadcastStarted'
							, uid: sd.uid
							, sdpOffer: sdpOffer.sdp
						}, vtracks = state.stream.getVideoTracks();
					if (vtracks && vtracks.length > 0) {
						const vts = vtracks[0].getSettings();
						vidSize.width = vts.width;
						vidSize.height = vts.height;
						bmsg.width = vts.width;
						bmsg.height = vts.height;
						bmsg.fps = vts.frameRate;
					}
					VideoMgrUtil.sendMessage(bmsg);
					if (isSharing) {
						Sharer.setShareState(Sharer.SHARE_STARTED);
					}
					if (isRecording) {
						Sharer.setRecState(Sharer.SHARE_STARTED);
					}
				})
				.catch(error => OmUtil.error(error));
		}
		function _createSendPeer(msg, state) {
			if (isSharing || isRecording) {
				_getScreenStream(msg, state, __createSendPeer);
			} else {
				_getVideoStream(msg, state, __createSendPeer);
			}
		}
		function _createResvPeer(msg, state) {
			__createVideo(state);
			const options = VideoUtil.addIceServers({
				mediaConstraints: {audio: true, video: true}
				, onIceCandidate : self.onIceCandidate
				, onConnectionStateChange: () => __connectionStateChangeListener(state)
			}, msg);
			const data = state.data;
			data.rtcPeer = new WebRtcPeer.Recvonly(options);
			data.rtcPeer.createOffer()
				.then(sdpOffer => {
					data.rtcPeer.processLocalOffer(sdpOffer);
					OmUtil.log('Invoking Receiver SDP offer callback function');
					VideoMgrUtil.sendMessage({
						id : 'addListener'
						, sender: sd.uid
						, sdpOffer: sdpOffer.sdp
					});
				})
				.catch(genErr => OmUtil.error('Receiver sdp offer error ' + genErr));
		}
		function _handleMicStatus(state) {
			if (!footer || !footer.is(':visible')) {
				return;
			}
			if (state) {
				footer.text(footer.data('on'));
				footer.addClass('mic-on');
				t.addClass('mic-on');
			} else {
				footer.text(footer.data('off'));
				footer.removeClass('mic-on');
				t.removeClass('mic-on');
			}
		}
		function _initContainer(_id, name, opts, instanceUid) {
			let contSel = '#user' + sd.cuid;
			const _hasVideo = VideoUtil.hasVideo(sd)
			if (_hasVideo) {
				const s = VideoSettings.load();
				if (s.fixed.enabled && !opts.interview && !isSharing) {
					size = {
						width: s.fixed.width
						, height: s.fixed.height
					};
				} else {
					size = {
						width: sd.width
						, height: sd.height
					};
				}
			} else {
				size = {
					width: 120
					, height: 90
				};
			}
			hasVideo = _hasVideo || $(contSel).length < 1;
			if (hasVideo) {
				if (opts.interview) {
					const area = $('.pod-area');
					const contId = crypto.randomUUID();
					contSel = '#' + contId;
					area.append($('<div class="pod"></div>').attr('id', contId));
					WbArea.updateAreaClass();
				} else {
					contSel = '.room-block .room-container';
				}
			}
			$(contSel).append(OmUtil.tmpl('#user-video', _id)
					.attr('title', name)
					.attr('data-client-uid', sd.cuid)
					.attr('data-client-type', sd.type)
					.attr('data-instance-uid', instanceUid)
					.data(self));
			v = $('#' + _id);
			vc = v.find('.video');
			muteOthers = vc.find('.mute-others');
			_setRights();
			return contSel;
		}
		function _initDialog(v, opts) {
			if (opts.interview) {
				v.dialog('option', 'draggable', false);
				v.dialog('option', 'resizable', false);
				$('.pod-area').sortable('refresh');
			} else {
				v.dialog('option', 'draggable', true);
				v.dialog('option', 'resizable', true);
				if (isSharing) {
					v.on('dialogclose', function() {
						VideoMgrUtil.close(sd.uid, true);
					});
				}
				const ui = v.closest('.ui-dialog');
				const parent = $('.room-block .room-container .sb-wb');
				ui.draggable('option', 'containment', parent);
				ui.resizable('option', 'containment', parent);
			}
			_initDialogBtns(opts);
		}
		function _initDialogBtns(opts) {
			function noDblClick(elem) {
				elem.dblclick(function(e) {
					e.stopImmediatePropagation();
					return false;
				});
			}
			v.parent().find('.ui-dialog-titlebar-close').remove();
			v.parent().append(OmUtil.tmpl('#video-button-bar'));
			const refresh = v.parent().find('.btn-refresh')
				, tgl = v.parent().find('.btn-toggle')
				, cls = v.parent().find('.btn-wclose');
			if (isSharing) {
				cls.click(function (_) {
					v.dialog('close');
					return false;
				});
				noDblClick(cls);
				refresh.remove();
			} else {
				cls.remove();
				refresh.click(function(e) {
					e.stopImmediatePropagation();
					_refresh();
					return false;
				});
			}
			if (opts.interview) {
				tgl.remove();
			} else {
				tgl.click(function (e) {
					e.stopImmediatePropagation();
					$(this).toggleClass('minimized');
					v.toggle();
					return false;
				});
				noDblClick(tgl);
			}
		}
		function _update(_c) {
			const prevA = sd.activities
				, prevW = vidSize.width || sd.width // try to check actual size of video first
				, prevH = vidSize.height || sd.height // try to check actual size of video first
				, prevCam = sd.cam
				, prevMic = sd.mic;
			sd.activities = _c.activities.sort();
			sd.level = _c.level;
			sd.user.firstName = _c.user.firstName;
			sd.user.lastName = _c.user.lastName;
			sd.user.displayName = _c.user.displayName;
			sd.width = _c.width;
			sd.height = _c.height;
			sd.cam = _c.cam;
			sd.mic = _c.mic;
			const name = sd.user.displayName;
			if (hasVideo) {
				v.dialog('option', 'title', name).parent().find('.ui-dialog-titlebar').attr('title', name);
			}
			const same = prevA.length === sd.activities.length
				&& prevA.every(function(value, index) { return value === sd.activities[index]})
				&& prevW === sd.width && prevH === sd.height
				&& prevCam == sd.cam && prevMic === sd.mic;
			const camChanged = sd.camEnabled !== _c.camEnabled
				, micChanged = sd.micEnabled !== _c.micEnabled
			if (sd.self && !same) {
				_cleanup();
				v.remove();
				_init({stream: sd, iceServers: iceServers});
			} else if (camChanged || micChanged) {
				sd.micEnabled = _c.micEnabled;
				sd.camEnabled = _c.camEnabled;
				const state = __getState();
				if (camChanged) {
					VideoMgrUtil.savePod(v);
					v.off();
					if (v.dialog('instance')) {
						v.dialog('destroy');
					}
					v.remove();
					__initUI(v.data('instance-uid'));
					__createVideo(state);
					VideoUtil.playSrc(state.video[0], state.stream || state.rStream, sd.self);
					if (state.data.analyser) {
						lm = vc.find('.level-meter');
						level.setCanvas(lm);
					}
				}
				if (micChanged) {
					__updateVideo(state);
				}
				if (sd.self) {
					state.localStream.getVideoTracks().forEach(track => track.enabled = sd.camEnabled);
					state.localStream.getAudioTracks().forEach(track => track.enabled = sd.micEnabled);
				}
			}
		}
		function __createVideo(state) {
			const _id = VideoUtil.getVid(sd.uid);
			_resizeDlgArea(size.width, size.height);
			if (hasVideo && !isSharing && !isRecording) {
				// let's try to restore size+position
				const opts = Room.getOptions()
					, stored = $(`#user${sd.cuid}`).data('video-pod');
				if (!opts.interview && stored) {
					const widget = v.dialog('widget');
					widget.css('left', stored.x);
					widget.css('top', stored.y)
					widget.css('width', stored.w);
					widget.css('height', stored.h)
				} else {
					VideoUtil.setPos(v, VideoUtil.getPos(VideoUtil.getRects(VideoUtil.VIDWIN_SEL, _id), sd.width, sd.height + 25));
				}
			}
			state.video = $(hasVideo ? '<video>' : '<audio>').attr('id', 'vid' + _id)
				.attr('playsinline', 'playsinline')
				//.attr('autoplay', 'autoplay')
				.prop('controls', false)
				.width(vc.width()).height(vc.height());
			if (state.data) {
				state.video.data(state.data);
			}
			if (hasVideo) {
				vc.removeClass('audio-only').css('background-image', '');
				vc.parents('.ui-dialog').removeClass('audio-only');
				state.video.attr('poster', sd.user.pictureUri);
			} else {
				state.video.attr('poster', null);
				vc.addClass('audio-only');
			}
			vc.append(state.video);
			__updateVideo(state);
		}
		function __updateVideo(state) {
			if (VideoUtil.hasMic(sd)) {
				const volIco = vol.create(self)
				if (hasVideo) {
					v.parent().find('.buttonpane').append(volIco);
				} else {
					volIco.addClass('ulist-small');
					volIco.insertAfter('#user' + sd.cuid + ' .typing-activity');
				}
			} else {
				vol.destroy();
			}
		}
		function _refresh(_msg) {
			const msg = _msg || {
				iceServers: iceServers
				, instanceUid: v.length > 0 ? v.data('instance-uid') : undefined
			};
			if (sd.self) {
				VideoMgrUtil.sendMessage({
					id : 'broadcastRestarted'
					, uid: sd.uid
				});
			}
			_cleanup();
			const hasAudio = VideoUtil.hasMic(sd)
				, state = {
					disposed: false
					, data: {}
				};
			states.push(state);
			if (sd.self) {
				_createSendPeer(msg, state);
			} else {
				_createResvPeer(msg, state);
			}
			_handleMicStatus(hasAudio);
		}
		function _setRights() {
			if (Room.hasRight(['MUTE_OTHERS']) && VideoUtil.hasMic(sd)) {
				muteOthers.addClass('enabled').off().click(function() {
					VideoMgrUtil.clickMuteOthers(sd.cuid);
				});
			} else {
				muteOthers.removeClass('enabled').off();
			}
		}
		function _cleanData(data) {
			if (!data) {
				return;
			}
			if (data.analyser) {
				VideoUtil.disconnect(data.analyser);
				data.analyser = null;
			}
			if (data.gainNode) {
				VideoUtil.disconnect(data.gainNode);
				data.gainNode = null;
			}
			if (data.aSrc) {
				VideoUtil.cleanStream(data.aSrc.mediaStream);
				VideoUtil.disconnect(data.aSrc);
				data.aSrc = null;
			}
			if (data.aDest) {
				VideoUtil.disconnect(data.aDest);
				data.aDest = null;
			}
			if (data.aCtx) {
				if (data.aCtx.destination) {
					VideoUtil.disconnect(data.aCtx.destination);
				}
				if ('closed' !== data.aCtx.state) {
					try {
						data.aCtx.close();
					} catch(e) {
						console.error(e);
					}
				}
				data.aCtx = null;
			}
			VideoUtil.cleanPeer(data.rtcPeer);
			data.rtcPeer = null;
		}
		function _cleanup(evt) {
			VideoMgrUtil.savePod(v);
			delete vidSize.width;
			delete vidSize.height;
			OmUtil.log('!!Disposing participant ' + sd.uid);
			let state;
			while(state = states.pop()) {
				state.disposed = true;
				if (state.options) {
					delete state.options.mediaConstraints;
					delete state.options.onIceCandidate;
					state.options = null;
				}
				_cleanData(state.data);
				VideoUtil.cleanStream(state.localStream);
				VideoUtil.cleanStream(state.stream);
				VideoUtil.cleanStream(state.rStream);
				state.data = null;
				state.localStream = null;
				state.stream = null;
				const video = state.video;
				if (video && video.length > 0) {
					video.attr('id', 'dummy');
					const vidNode = video[0];
					VideoUtil.cleanStream(vidNode.srcObject);
					vidNode.srcObject = null;
					vidNode.load();
					vidNode.removeAttribute("src");
					vidNode.removeAttribute("srcObject");
					vidNode.parentNode.removeChild(vidNode);
					state.video.data({});
					state.video = null;
				}
			}
			if (lm && lm.length > 0) {
				_micActivity(false);
				lm.hide();
				muteOthers.removeClass('enabled').off();
			}
			if (level) {
				level.dispose();
				level = null;
			}
			vc.find('audio,video').remove();
			vol.destroy();
			if (evt && evt.target) {
				$(evt).off();
			}
		}
		function _reattachStream() {
			states.forEach(state => {
				if (state.video && state.video.length > 0) {
					const data = state.data
						, videoEl = state.video[0];
					if (data.rtcPeer && (!videoEl.srcObject || !videoEl.srcObject.active)) {
						videoEl.srcObject = data.rtcPeer.stream;
					}
				}
			});
		}
		function _processSdpAnswer(answer) {
			const state = __getState();
			if (!state || !state.data.rtcPeer) {
				return;
			}
			state.data.rtcPeer.processRemoteAnswer(answer)
				.then(() => {
					const video = __getVideo(state);
					state.rStream = state.data.rtcPeer.pc.getRemoteStreams()[0];
					VideoUtil.playSrc(video, state.rStream, false);
				})
				.catch(error => OmUtil.error(error, true));
		}
		function _processIceCandidate(candidate) {
			const state = __getState();
			if (!state || !state.data.rtcPeer) {
				return;
			}
			state.data.rtcPeer.addIceCandidate(candidate)
				.catch(error => OmUtil.error('Error adding candidate: ' + error, true));
		}
		function __initUI(instanceUid) {
			if (!vol) {
				vol = new Volume();
			}
			isSharing = VideoUtil.isSharing(sd);
			isRecording = VideoUtil.isRecording(sd);
			const _id = VideoUtil.getVid(sd.uid)
				, name = sd.user.displayName
				, _w = sd.width
				, _h = sd.height
				, opts = Room.getOptions();
			sd.self = sd.cuid === opts.uid;
			const contSel = _initContainer(_id, name, opts, instanceUid);
			footer = v.find('.footer');
			if (!opts.showMicStatus) {
				footer.hide();
			}
			if (!sd.self && isSharing) {
				Sharer.close();
			}
			if (sd.self && (isSharing || isRecording)) {
				v.hide();
			} else if (hasVideo) {
				v.dialog({
					classes: {
						'ui-dialog': 'video user-video' + (opts.showMicStatus ? ' mic-status' : '')
						, 'ui-dialog-titlebar': '' + (opts.showMicStatus ? ' ui-state-highlight' : '')
					}
					, width: _w
					, minWidth: 40
					, minHeight: 50
					, autoOpen: true
					, modal: false
					, appendTo: contSel
				});
				_initDialog(v, opts);
			}
			t = v.parent().find('.ui-dialog-titlebar').attr('title', name);
			v.on('remove', _cleanup);
			if (hasVideo) {
				vc.width(_w).height(_h);
			}
		}
		function _init(_msg) {
			sd = _msg.stream;
			sd.activities = sd.activities.sort();
			_msg.instanceUid = crypto.randomUUID();
			iceServers = _msg.iceServers;
			__initUI(_msg.instanceUid);
			_refresh(_msg);
		}
		function __pttEnabled(state) {
			return sd && sd.self && state && state.localStream
					&& VideoUtil.hasActivity(sd, VideoUtil.MIC_ACTIVITY) && !sd.micEnabled;
		}

		this.update = _update;
		this.refresh = _refresh;
		this.pushToTalk = (enable) => {
			const state = __getState();
			if (__pttEnabled(state)) {
				state.localStream.getAudioTracks().forEach(track => track.enabled = enable);
				const classes = document.querySelector('#room-sidebar-tab-users .header .om-icon.activity.mic.clickable').classList;
				if (enable) {
					classes.add('push-to-talk');
				} else {
					classes.remove('push-to-talk');
				}
			}
		};
		this.mute = function(_mute) {
			vol.mute(_mute);
		};
		this.isMuted = function() {
			return vol.muted();
		};
		this.stream = function() { return sd; };
		this.setRights = _setRights;
		this.processSdpAnswer = _processSdpAnswer;
		this.processIceCandidate = _processIceCandidate;
		this.onIceCandidate = function(candidate) {
			const opts = Room.getOptions();
			OmUtil.log('Local candidate ' + JSON.stringify(candidate));
			VideoMgrUtil.sendMessage({
				id: 'onIceCandidate'
				, candidate: candidate
				, uid: sd.uid
				, luid: sd.self ? sd.uid : opts.uid
			});
		};
		this.reattachStream = _reattachStream;
		this.video = function(_state) {
			const state = _state || __getState();
			if (!state || state.disposed) {
				return null;
			}
			return state.video;
		};
		this.handleMicStatus = _handleMicStatus;

		_init(msg);
	}
};


/***/ }),

/***/ "./src/room/volume.js":
/*!****************************!*\
  !*** ./src/room/volume.js ***!
  \****************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */
const OmUtil = __webpack_require__(/*! ../main/omutils */ "../main/omutils");

module.exports = class Volume {
	constructor() {
		const self = this;
		let video, vol, drop, slider, handleEl, hideTimer = null
			, lastVolume = 50, muted = false;

		function __cancelHide() {
			if (hideTimer) {
				clearTimeout(hideTimer);
				hideTimer = null;
			}
		}
		function __hideDrop() {
			__cancelHide();
			hideTimer = setTimeout(() => {
				drop.hide();
				hideTimer = null;
			}, 3000);
		}

		this.create = (_video) => {
			video = _video;
			this.destroy();
			const uid = video.stream().uid
				, cuid = video.stream().cuid
				, volId = 'volume-' + uid;
			vol = OmUtil.tmpl('#volume-control-stub', volId)
			slider = vol.find('.slider');
			drop = vol.find('.dropdown-menu');
			vol.on('mouseenter', function(e) {
					e.stopImmediatePropagation();
					drop.show();
					__hideDrop()
				})
				.click(function(e) {
					e.stopImmediatePropagation();
					OmUtil.roomAction({action: 'mute', uid: cuid, mute: !muted});
					self.mute(!muted);
					drop.hide();
					return false;
				}).dblclick(function(e) {
					e.stopImmediatePropagation();
					return false;
				});
			drop.on('mouseenter', function() {
				__cancelHide();
			});
			drop.on('mouseleave', function() {
				__hideDrop();
			});
			handleEl = vol.find('.handle');
			slider.slider({
				orientation: 'vertical'
				, range: 'min'
				, min: 0
				, max: 100
				, value: lastVolume
				, create: function() {
					handleEl.text($(this).slider('value'));
				}
				, slide: function(event, ui) {
					self.handle(ui.value);
				}
			});
			this.handle(lastVolume);
			this.mute(muted);
			return vol;
		};
		this.handle = (val) => {
			handleEl.text(val);
			const vidEl = video.video()
				, data = vidEl.data();
			if (video.stream().self) {
				if (data.gainNode) {
					data.gainNode.gain.value = val / 100;
				}
			} else {
				vidEl[0].volume = val / 100;
			}
			const ico = vol.find('a');
			if (val > 0 && ico.hasClass('volume-off')) {
				ico.toggleClass('volume-off volume-on');
				video.handleMicStatus(true);
			} else if (val === 0 && ico.hasClass('volume-on')) {
				ico.toggleClass('volume-on volume-off');
				video.handleMicStatus(false);
			}
		};
		this.mute = (mute) => {
			if (!slider) {
				return;
			}
			muted = mute;
			if (mute) {
				const val = slider.slider('option', 'value');
				if (val > 0) {
					lastVolume = val;
				}
				slider.slider('option', 'value', 0);
				this.handle(0);
			} else {
				slider.slider('option', 'value', lastVolume);
				this.handle(lastVolume);
			}
		};
		this.destroy = () => {
			if (vol) {
				vol.remove();
				vol = null;
			}
		};
		this.muted = () => {
			return muted;
		};
	}
};


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!***************************!*\
  !*** ./src/room/index.js ***!
  \***************************/
/* Licensed under the Apache License, Version 2.0 (the "License") http://www.apache.org/licenses/LICENSE-2.0 */

// Let's re-style jquery-ui dialogs and buttons
$.extend($.ui.dialog.prototype.options.classes, {
	'ui-dialog': 'modal-content'
	, 'ui-dialog-titlebar': 'modal-header'
	, 'ui-dialog-title': 'modal-title'
	, 'ui-dialog-titlebar-close': 'close'
	, 'ui-dialog-content': 'modal-body'
	, 'ui-dialog-buttonpane': 'modal-footer'
});
$.extend($.ui.button.prototype.options.classes, {
	'ui-button': 'btn btn-outline-secondary'
});

Object.assign(window, {
	VideoManager: __webpack_require__(/*! ./video-manager */ "./src/room/video-manager.js")
	, Sharer: __webpack_require__(/*! ./sharer */ "./src/room/sharer.js")
	, Room: __webpack_require__(/*! ./room */ "./src/room/room.js")
	, Activities: __webpack_require__(/*! ./activities */ "./src/room/activities.js")
	, UserSettings: __webpack_require__(/*! ./user-settings */ "./src/room/user-settings.js")
});

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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