/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <stdio.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/evaluation_helper.h>
#include <plc4c/driver_s7_static.h>

#include "sub_item.h"

// Code generated by code-generation. DO NOT EDIT.


// Parse function.
plc4c_return_code plc4c_s7_read_write_sub_item_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_sub_item** _message) {
  uint16_t startPos = plc4c_spi_read_get_pos(readBuffer);
  plc4c_return_code _res = OK;

  // Allocate enough memory to contain this data structure.
  (*_message) = malloc(sizeof(plc4c_s7_read_write_sub_item));
  if(*_message == NULL) {
    return NO_MEMORY;
  }

  // Simple Field (bytesToRead)
  uint8_t bytesToRead = 0;
  _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &bytesToRead);
  if(_res != OK) {
    return _res;
  }
  (*_message)->bytes_to_read = bytesToRead;

  // Simple Field (dbNumber)
  uint16_t dbNumber = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &dbNumber);
  if(_res != OK) {
    return _res;
  }
  (*_message)->db_number = dbNumber;

  // Simple Field (startAddress)
  uint16_t startAddress = 0;
  _res = plc4c_spi_read_unsigned_short(readBuffer, 16, (uint16_t*) &startAddress);
  if(_res != OK) {
    return _res;
  }
  (*_message)->start_address = startAddress;

  return OK;
}

plc4c_return_code plc4c_s7_read_write_sub_item_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_sub_item* _message) {
  plc4c_return_code _res = OK;

  // Simple Field (bytesToRead)
  _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, _message->bytes_to_read);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (dbNumber)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->db_number);
  if(_res != OK) {
    return _res;
  }

  // Simple Field (startAddress)
  _res = plc4c_spi_write_unsigned_short(writeBuffer, 16, _message->start_address);
  if(_res != OK) {
    return _res;
  }

  return OK;
}

uint16_t plc4c_s7_read_write_sub_item_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_sub_item* _message) {
  return plc4c_s7_read_write_sub_item_length_in_bits(ctx, _message) / 8;
}

uint16_t plc4c_s7_read_write_sub_item_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_sub_item* _message) {
  uint16_t lengthInBits = 0;

  // Simple field (bytesToRead)
  lengthInBits += 8;

  // Simple field (dbNumber)
  lengthInBits += 16;

  // Simple field (startAddress)
  lengthInBits += 16;

  return lengthInBits;
}

