/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"context"

	"github.com/pkg/errors"

	api "github.com/apache/plc4x/plc4go/pkg/api/values"
	. "github.com/apache/plc4x/plc4go/protocols/ads/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

type AdsParserHelper struct {
}

func (m AdsParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (any, error) {
	switch typeName {
	case "AmsSerialFrame":
		return AmsSerialFrameParseWithBuffer(context.Background(), io)
	case "DataItem":
		plcValueType, _ := api.PlcValueTypeByName(arguments[0])
		stringLength, err := utils.StrToInt32(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return DataItemParseWithBuffer(context.Background(), io, plcValueType, stringLength)
	case "AdsTableSizes":
		return AdsTableSizesParseWithBuffer(context.Background(), io)
	case "AdsMultiRequestItem":
		indexGroup, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return AdsMultiRequestItemParseWithBuffer[AdsMultiRequestItem](context.Background(), io, indexGroup)
	case "AmsSerialAcknowledgeFrame":
		return AmsSerialAcknowledgeFrameParseWithBuffer(context.Background(), io)
	case "AdsDataTypeArrayInfo":
		return AdsDataTypeArrayInfoParseWithBuffer(context.Background(), io)
	case "AdsDataTypeTableEntry":
		return AdsDataTypeTableEntryParseWithBuffer(context.Background(), io)
	case "AmsNetId":
		return AmsNetIdParseWithBuffer(context.Background(), io)
	case "AdsStampHeader":
		return AdsStampHeaderParseWithBuffer(context.Background(), io)
	case "AmsSerialResetFrame":
		return AmsSerialResetFrameParseWithBuffer(context.Background(), io)
	case "AdsDataTypeTableChildEntry":
		return AdsDataTypeTableChildEntryParseWithBuffer(context.Background(), io)
	case "AdsConstants":
		return AdsConstantsParseWithBuffer(context.Background(), io)
	case "AdsNotificationSample":
		return AdsNotificationSampleParseWithBuffer(context.Background(), io)
	case "AdsSymbolTableEntry":
		return AdsSymbolTableEntryParseWithBuffer(context.Background(), io)
	case "AmsTCPPacket":
		return AmsTCPPacketParseWithBuffer(context.Background(), io)
	case "AmsPacket":
		return AmsPacketParseWithBuffer[AmsPacket](context.Background(), io)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
