/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataModificationDate is the corresponding interface of BACnetConstructedDataModificationDate
type BACnetConstructedDataModificationDate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetModificationDate returns ModificationDate (property field)
	GetModificationDate() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataModificationDate is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataModificationDate()
	// CreateBuilder creates a BACnetConstructedDataModificationDateBuilder
	CreateBACnetConstructedDataModificationDateBuilder() BACnetConstructedDataModificationDateBuilder
}

// _BACnetConstructedDataModificationDate is the data-structure of this message
type _BACnetConstructedDataModificationDate struct {
	BACnetConstructedDataContract
	ModificationDate BACnetDateTime
}

var _ BACnetConstructedDataModificationDate = (*_BACnetConstructedDataModificationDate)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataModificationDate)(nil)

// NewBACnetConstructedDataModificationDate factory function for _BACnetConstructedDataModificationDate
func NewBACnetConstructedDataModificationDate(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, modificationDate BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataModificationDate {
	if modificationDate == nil {
		panic("modificationDate of type BACnetDateTime for BACnetConstructedDataModificationDate must not be nil")
	}
	_result := &_BACnetConstructedDataModificationDate{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ModificationDate:              modificationDate,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataModificationDateBuilder is a builder for BACnetConstructedDataModificationDate
type BACnetConstructedDataModificationDateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(modificationDate BACnetDateTime) BACnetConstructedDataModificationDateBuilder
	// WithModificationDate adds ModificationDate (property field)
	WithModificationDate(BACnetDateTime) BACnetConstructedDataModificationDateBuilder
	// WithModificationDateBuilder adds ModificationDate (property field) which is build by the builder
	WithModificationDateBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataModificationDateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataModificationDate or returns an error if something is wrong
	Build() (BACnetConstructedDataModificationDate, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataModificationDate
}

// NewBACnetConstructedDataModificationDateBuilder() creates a BACnetConstructedDataModificationDateBuilder
func NewBACnetConstructedDataModificationDateBuilder() BACnetConstructedDataModificationDateBuilder {
	return &_BACnetConstructedDataModificationDateBuilder{_BACnetConstructedDataModificationDate: new(_BACnetConstructedDataModificationDate)}
}

type _BACnetConstructedDataModificationDateBuilder struct {
	*_BACnetConstructedDataModificationDate

	parentBuilder *_BACnetConstructedDataBuilder

	collectedErr []error
}

var _ (BACnetConstructedDataModificationDateBuilder) = (*_BACnetConstructedDataModificationDateBuilder)(nil)

func (b *_BACnetConstructedDataModificationDateBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataModificationDate
}

func (b *_BACnetConstructedDataModificationDateBuilder) WithMandatoryFields(modificationDate BACnetDateTime) BACnetConstructedDataModificationDateBuilder {
	return b.WithModificationDate(modificationDate)
}

func (b *_BACnetConstructedDataModificationDateBuilder) WithModificationDate(modificationDate BACnetDateTime) BACnetConstructedDataModificationDateBuilder {
	b.ModificationDate = modificationDate
	return b
}

func (b *_BACnetConstructedDataModificationDateBuilder) WithModificationDateBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataModificationDateBuilder {
	builder := builderSupplier(b.ModificationDate.CreateBACnetDateTimeBuilder())
	var err error
	b.ModificationDate, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataModificationDateBuilder) Build() (BACnetConstructedDataModificationDate, error) {
	if b.ModificationDate == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'modificationDate' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetConstructedDataModificationDate.deepCopy(), nil
}

func (b *_BACnetConstructedDataModificationDateBuilder) MustBuild() BACnetConstructedDataModificationDate {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataModificationDateBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataModificationDateBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataModificationDateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataModificationDateBuilder().(*_BACnetConstructedDataModificationDateBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetConstructedDataModificationDateBuilder creates a BACnetConstructedDataModificationDateBuilder
func (b *_BACnetConstructedDataModificationDate) CreateBACnetConstructedDataModificationDateBuilder() BACnetConstructedDataModificationDateBuilder {
	if b == nil {
		return NewBACnetConstructedDataModificationDateBuilder()
	}
	return &_BACnetConstructedDataModificationDateBuilder{_BACnetConstructedDataModificationDate: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataModificationDate) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataModificationDate) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MODIFICATION_DATE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataModificationDate) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataModificationDate) GetModificationDate() BACnetDateTime {
	return m.ModificationDate
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataModificationDate) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetModificationDate())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataModificationDate(structType any) BACnetConstructedDataModificationDate {
	if casted, ok := structType.(BACnetConstructedDataModificationDate); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataModificationDate); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataModificationDate) GetTypeName() string {
	return "BACnetConstructedDataModificationDate"
}

func (m *_BACnetConstructedDataModificationDate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (modificationDate)
	lengthInBits += m.ModificationDate.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataModificationDate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataModificationDate) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataModificationDate BACnetConstructedDataModificationDate, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataModificationDate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataModificationDate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	modificationDate, err := ReadSimpleField[BACnetDateTime](ctx, "modificationDate", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'modificationDate' field"))
	}
	m.ModificationDate = modificationDate

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), modificationDate)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataModificationDate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataModificationDate")
	}

	return m, nil
}

func (m *_BACnetConstructedDataModificationDate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataModificationDate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataModificationDate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataModificationDate")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "modificationDate", m.GetModificationDate(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'modificationDate' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataModificationDate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataModificationDate")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataModificationDate) IsBACnetConstructedDataModificationDate() {}

func (m *_BACnetConstructedDataModificationDate) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataModificationDate) deepCopy() *_BACnetConstructedDataModificationDate {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataModificationDateCopy := &_BACnetConstructedDataModificationDate{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.ModificationDate),
	}
	_BACnetConstructedDataModificationDateCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataModificationDateCopy
}

func (m *_BACnetConstructedDataModificationDate) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
