/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// MeteringDataOtherWaterConsumption is the corresponding interface of MeteringDataOtherWaterConsumption
type MeteringDataOtherWaterConsumption interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	MeteringData
	// GetKL returns KL (property field)
	GetKL() uint32
	// IsMeteringDataOtherWaterConsumption is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsMeteringDataOtherWaterConsumption()
	// CreateBuilder creates a MeteringDataOtherWaterConsumptionBuilder
	CreateMeteringDataOtherWaterConsumptionBuilder() MeteringDataOtherWaterConsumptionBuilder
}

// _MeteringDataOtherWaterConsumption is the data-structure of this message
type _MeteringDataOtherWaterConsumption struct {
	MeteringDataContract
	KL uint32
}

var _ MeteringDataOtherWaterConsumption = (*_MeteringDataOtherWaterConsumption)(nil)
var _ MeteringDataRequirements = (*_MeteringDataOtherWaterConsumption)(nil)

// NewMeteringDataOtherWaterConsumption factory function for _MeteringDataOtherWaterConsumption
func NewMeteringDataOtherWaterConsumption(commandTypeContainer MeteringCommandTypeContainer, argument byte, kL uint32) *_MeteringDataOtherWaterConsumption {
	_result := &_MeteringDataOtherWaterConsumption{
		MeteringDataContract: NewMeteringData(commandTypeContainer, argument),
		KL:                   kL,
	}
	_result.MeteringDataContract.(*_MeteringData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// MeteringDataOtherWaterConsumptionBuilder is a builder for MeteringDataOtherWaterConsumption
type MeteringDataOtherWaterConsumptionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(kL uint32) MeteringDataOtherWaterConsumptionBuilder
	// WithKL adds KL (property field)
	WithKL(uint32) MeteringDataOtherWaterConsumptionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() MeteringDataBuilder
	// Build builds the MeteringDataOtherWaterConsumption or returns an error if something is wrong
	Build() (MeteringDataOtherWaterConsumption, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() MeteringDataOtherWaterConsumption
}

// NewMeteringDataOtherWaterConsumptionBuilder() creates a MeteringDataOtherWaterConsumptionBuilder
func NewMeteringDataOtherWaterConsumptionBuilder() MeteringDataOtherWaterConsumptionBuilder {
	return &_MeteringDataOtherWaterConsumptionBuilder{_MeteringDataOtherWaterConsumption: new(_MeteringDataOtherWaterConsumption)}
}

type _MeteringDataOtherWaterConsumptionBuilder struct {
	*_MeteringDataOtherWaterConsumption

	parentBuilder *_MeteringDataBuilder

	collectedErr []error
}

var _ (MeteringDataOtherWaterConsumptionBuilder) = (*_MeteringDataOtherWaterConsumptionBuilder)(nil)

func (b *_MeteringDataOtherWaterConsumptionBuilder) setParent(contract MeteringDataContract) {
	b.MeteringDataContract = contract
	contract.(*_MeteringData)._SubType = b._MeteringDataOtherWaterConsumption
}

func (b *_MeteringDataOtherWaterConsumptionBuilder) WithMandatoryFields(kL uint32) MeteringDataOtherWaterConsumptionBuilder {
	return b.WithKL(kL)
}

func (b *_MeteringDataOtherWaterConsumptionBuilder) WithKL(kL uint32) MeteringDataOtherWaterConsumptionBuilder {
	b.KL = kL
	return b
}

func (b *_MeteringDataOtherWaterConsumptionBuilder) Build() (MeteringDataOtherWaterConsumption, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._MeteringDataOtherWaterConsumption.deepCopy(), nil
}

func (b *_MeteringDataOtherWaterConsumptionBuilder) MustBuild() MeteringDataOtherWaterConsumption {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_MeteringDataOtherWaterConsumptionBuilder) Done() MeteringDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewMeteringDataBuilder().(*_MeteringDataBuilder)
	}
	return b.parentBuilder
}

func (b *_MeteringDataOtherWaterConsumptionBuilder) buildForMeteringData() (MeteringData, error) {
	return b.Build()
}

func (b *_MeteringDataOtherWaterConsumptionBuilder) DeepCopy() any {
	_copy := b.CreateMeteringDataOtherWaterConsumptionBuilder().(*_MeteringDataOtherWaterConsumptionBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateMeteringDataOtherWaterConsumptionBuilder creates a MeteringDataOtherWaterConsumptionBuilder
func (b *_MeteringDataOtherWaterConsumption) CreateMeteringDataOtherWaterConsumptionBuilder() MeteringDataOtherWaterConsumptionBuilder {
	if b == nil {
		return NewMeteringDataOtherWaterConsumptionBuilder()
	}
	return &_MeteringDataOtherWaterConsumptionBuilder{_MeteringDataOtherWaterConsumption: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_MeteringDataOtherWaterConsumption) GetParent() MeteringDataContract {
	return m.MeteringDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_MeteringDataOtherWaterConsumption) GetKL() uint32 {
	return m.KL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastMeteringDataOtherWaterConsumption(structType any) MeteringDataOtherWaterConsumption {
	if casted, ok := structType.(MeteringDataOtherWaterConsumption); ok {
		return casted
	}
	if casted, ok := structType.(*MeteringDataOtherWaterConsumption); ok {
		return *casted
	}
	return nil
}

func (m *_MeteringDataOtherWaterConsumption) GetTypeName() string {
	return "MeteringDataOtherWaterConsumption"
}

func (m *_MeteringDataOtherWaterConsumption) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.MeteringDataContract.(*_MeteringData).getLengthInBits(ctx))

	// Simple field (kL)
	lengthInBits += 32

	return lengthInBits
}

func (m *_MeteringDataOtherWaterConsumption) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_MeteringDataOtherWaterConsumption) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_MeteringData) (__meteringDataOtherWaterConsumption MeteringDataOtherWaterConsumption, err error) {
	m.MeteringDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("MeteringDataOtherWaterConsumption"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for MeteringDataOtherWaterConsumption")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	kL, err := ReadSimpleField(ctx, "kL", ReadUnsignedInt(readBuffer, uint8(32)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'kL' field"))
	}
	m.KL = kL

	if closeErr := readBuffer.CloseContext("MeteringDataOtherWaterConsumption"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for MeteringDataOtherWaterConsumption")
	}

	return m, nil
}

func (m *_MeteringDataOtherWaterConsumption) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_MeteringDataOtherWaterConsumption) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("MeteringDataOtherWaterConsumption"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for MeteringDataOtherWaterConsumption")
		}

		if err := WriteSimpleField[uint32](ctx, "kL", m.GetKL(), WriteUnsignedInt(writeBuffer, 32)); err != nil {
			return errors.Wrap(err, "Error serializing 'kL' field")
		}

		if popErr := writeBuffer.PopContext("MeteringDataOtherWaterConsumption"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for MeteringDataOtherWaterConsumption")
		}
		return nil
	}
	return m.MeteringDataContract.(*_MeteringData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_MeteringDataOtherWaterConsumption) IsMeteringDataOtherWaterConsumption() {}

func (m *_MeteringDataOtherWaterConsumption) DeepCopy() any {
	return m.deepCopy()
}

func (m *_MeteringDataOtherWaterConsumption) deepCopy() *_MeteringDataOtherWaterConsumption {
	if m == nil {
		return nil
	}
	_MeteringDataOtherWaterConsumptionCopy := &_MeteringDataOtherWaterConsumption{
		m.MeteringDataContract.(*_MeteringData).deepCopy(),
		m.KL,
	}
	_MeteringDataOtherWaterConsumptionCopy.MeteringDataContract.(*_MeteringData)._SubType = m
	return _MeteringDataOtherWaterConsumptionCopy
}

func (m *_MeteringDataOtherWaterConsumption) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
