/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataOtherAlarmCleared is the corresponding interface of SecurityDataOtherAlarmCleared
type SecurityDataOtherAlarmCleared interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// IsSecurityDataOtherAlarmCleared is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataOtherAlarmCleared()
	// CreateBuilder creates a SecurityDataOtherAlarmClearedBuilder
	CreateSecurityDataOtherAlarmClearedBuilder() SecurityDataOtherAlarmClearedBuilder
}

// _SecurityDataOtherAlarmCleared is the data-structure of this message
type _SecurityDataOtherAlarmCleared struct {
	SecurityDataContract
}

var _ SecurityDataOtherAlarmCleared = (*_SecurityDataOtherAlarmCleared)(nil)
var _ SecurityDataRequirements = (*_SecurityDataOtherAlarmCleared)(nil)

// NewSecurityDataOtherAlarmCleared factory function for _SecurityDataOtherAlarmCleared
func NewSecurityDataOtherAlarmCleared(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataOtherAlarmCleared {
	_result := &_SecurityDataOtherAlarmCleared{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataOtherAlarmClearedBuilder is a builder for SecurityDataOtherAlarmCleared
type SecurityDataOtherAlarmClearedBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() SecurityDataOtherAlarmClearedBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataOtherAlarmCleared or returns an error if something is wrong
	Build() (SecurityDataOtherAlarmCleared, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataOtherAlarmCleared
}

// NewSecurityDataOtherAlarmClearedBuilder() creates a SecurityDataOtherAlarmClearedBuilder
func NewSecurityDataOtherAlarmClearedBuilder() SecurityDataOtherAlarmClearedBuilder {
	return &_SecurityDataOtherAlarmClearedBuilder{_SecurityDataOtherAlarmCleared: new(_SecurityDataOtherAlarmCleared)}
}

type _SecurityDataOtherAlarmClearedBuilder struct {
	*_SecurityDataOtherAlarmCleared

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataOtherAlarmClearedBuilder) = (*_SecurityDataOtherAlarmClearedBuilder)(nil)

func (b *_SecurityDataOtherAlarmClearedBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataOtherAlarmCleared
}

func (b *_SecurityDataOtherAlarmClearedBuilder) WithMandatoryFields() SecurityDataOtherAlarmClearedBuilder {
	return b
}

func (b *_SecurityDataOtherAlarmClearedBuilder) Build() (SecurityDataOtherAlarmCleared, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataOtherAlarmCleared.deepCopy(), nil
}

func (b *_SecurityDataOtherAlarmClearedBuilder) MustBuild() SecurityDataOtherAlarmCleared {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataOtherAlarmClearedBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataOtherAlarmClearedBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataOtherAlarmClearedBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataOtherAlarmClearedBuilder().(*_SecurityDataOtherAlarmClearedBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataOtherAlarmClearedBuilder creates a SecurityDataOtherAlarmClearedBuilder
func (b *_SecurityDataOtherAlarmCleared) CreateSecurityDataOtherAlarmClearedBuilder() SecurityDataOtherAlarmClearedBuilder {
	if b == nil {
		return NewSecurityDataOtherAlarmClearedBuilder()
	}
	return &_SecurityDataOtherAlarmClearedBuilder{_SecurityDataOtherAlarmCleared: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataOtherAlarmCleared) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

// Deprecated: use the interface for direct cast
func CastSecurityDataOtherAlarmCleared(structType any) SecurityDataOtherAlarmCleared {
	if casted, ok := structType.(SecurityDataOtherAlarmCleared); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataOtherAlarmCleared); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataOtherAlarmCleared) GetTypeName() string {
	return "SecurityDataOtherAlarmCleared"
}

func (m *_SecurityDataOtherAlarmCleared) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_SecurityDataOtherAlarmCleared) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataOtherAlarmCleared) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataOtherAlarmCleared SecurityDataOtherAlarmCleared, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataOtherAlarmCleared"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataOtherAlarmCleared")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataOtherAlarmCleared"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataOtherAlarmCleared")
	}

	return m, nil
}

func (m *_SecurityDataOtherAlarmCleared) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataOtherAlarmCleared) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataOtherAlarmCleared"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataOtherAlarmCleared")
		}

		if popErr := writeBuffer.PopContext("SecurityDataOtherAlarmCleared"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataOtherAlarmCleared")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataOtherAlarmCleared) IsSecurityDataOtherAlarmCleared() {}

func (m *_SecurityDataOtherAlarmCleared) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataOtherAlarmCleared) deepCopy() *_SecurityDataOtherAlarmCleared {
	if m == nil {
		return nil
	}
	_SecurityDataOtherAlarmClearedCopy := &_SecurityDataOtherAlarmCleared{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
	}
	_SecurityDataOtherAlarmClearedCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataOtherAlarmClearedCopy
}

func (m *_SecurityDataOtherAlarmCleared) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
