/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataRequestZoneName is the corresponding interface of SecurityDataRequestZoneName
type SecurityDataRequestZoneName interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	SecurityData
	// GetZoneNumber returns ZoneNumber (property field)
	GetZoneNumber() uint8
	// IsSecurityDataRequestZoneName is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsSecurityDataRequestZoneName()
	// CreateBuilder creates a SecurityDataRequestZoneNameBuilder
	CreateSecurityDataRequestZoneNameBuilder() SecurityDataRequestZoneNameBuilder
}

// _SecurityDataRequestZoneName is the data-structure of this message
type _SecurityDataRequestZoneName struct {
	SecurityDataContract
	ZoneNumber uint8
}

var _ SecurityDataRequestZoneName = (*_SecurityDataRequestZoneName)(nil)
var _ SecurityDataRequirements = (*_SecurityDataRequestZoneName)(nil)

// NewSecurityDataRequestZoneName factory function for _SecurityDataRequestZoneName
func NewSecurityDataRequestZoneName(commandTypeContainer SecurityCommandTypeContainer, argument byte, zoneNumber uint8) *_SecurityDataRequestZoneName {
	_result := &_SecurityDataRequestZoneName{
		SecurityDataContract: NewSecurityData(commandTypeContainer, argument),
		ZoneNumber:           zoneNumber,
	}
	_result.SecurityDataContract.(*_SecurityData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// SecurityDataRequestZoneNameBuilder is a builder for SecurityDataRequestZoneName
type SecurityDataRequestZoneNameBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(zoneNumber uint8) SecurityDataRequestZoneNameBuilder
	// WithZoneNumber adds ZoneNumber (property field)
	WithZoneNumber(uint8) SecurityDataRequestZoneNameBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() SecurityDataBuilder
	// Build builds the SecurityDataRequestZoneName or returns an error if something is wrong
	Build() (SecurityDataRequestZoneName, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() SecurityDataRequestZoneName
}

// NewSecurityDataRequestZoneNameBuilder() creates a SecurityDataRequestZoneNameBuilder
func NewSecurityDataRequestZoneNameBuilder() SecurityDataRequestZoneNameBuilder {
	return &_SecurityDataRequestZoneNameBuilder{_SecurityDataRequestZoneName: new(_SecurityDataRequestZoneName)}
}

type _SecurityDataRequestZoneNameBuilder struct {
	*_SecurityDataRequestZoneName

	parentBuilder *_SecurityDataBuilder

	collectedErr []error
}

var _ (SecurityDataRequestZoneNameBuilder) = (*_SecurityDataRequestZoneNameBuilder)(nil)

func (b *_SecurityDataRequestZoneNameBuilder) setParent(contract SecurityDataContract) {
	b.SecurityDataContract = contract
	contract.(*_SecurityData)._SubType = b._SecurityDataRequestZoneName
}

func (b *_SecurityDataRequestZoneNameBuilder) WithMandatoryFields(zoneNumber uint8) SecurityDataRequestZoneNameBuilder {
	return b.WithZoneNumber(zoneNumber)
}

func (b *_SecurityDataRequestZoneNameBuilder) WithZoneNumber(zoneNumber uint8) SecurityDataRequestZoneNameBuilder {
	b.ZoneNumber = zoneNumber
	return b
}

func (b *_SecurityDataRequestZoneNameBuilder) Build() (SecurityDataRequestZoneName, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._SecurityDataRequestZoneName.deepCopy(), nil
}

func (b *_SecurityDataRequestZoneNameBuilder) MustBuild() SecurityDataRequestZoneName {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_SecurityDataRequestZoneNameBuilder) Done() SecurityDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewSecurityDataBuilder().(*_SecurityDataBuilder)
	}
	return b.parentBuilder
}

func (b *_SecurityDataRequestZoneNameBuilder) buildForSecurityData() (SecurityData, error) {
	return b.Build()
}

func (b *_SecurityDataRequestZoneNameBuilder) DeepCopy() any {
	_copy := b.CreateSecurityDataRequestZoneNameBuilder().(*_SecurityDataRequestZoneNameBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateSecurityDataRequestZoneNameBuilder creates a SecurityDataRequestZoneNameBuilder
func (b *_SecurityDataRequestZoneName) CreateSecurityDataRequestZoneNameBuilder() SecurityDataRequestZoneNameBuilder {
	if b == nil {
		return NewSecurityDataRequestZoneNameBuilder()
	}
	return &_SecurityDataRequestZoneNameBuilder{_SecurityDataRequestZoneName: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataRequestZoneName) GetParent() SecurityDataContract {
	return m.SecurityDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_SecurityDataRequestZoneName) GetZoneNumber() uint8 {
	return m.ZoneNumber
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastSecurityDataRequestZoneName(structType any) SecurityDataRequestZoneName {
	if casted, ok := structType.(SecurityDataRequestZoneName); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataRequestZoneName); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataRequestZoneName) GetTypeName() string {
	return "SecurityDataRequestZoneName"
}

func (m *_SecurityDataRequestZoneName) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.SecurityDataContract.(*_SecurityData).getLengthInBits(ctx))

	// Simple field (zoneNumber)
	lengthInBits += 8

	return lengthInBits
}

func (m *_SecurityDataRequestZoneName) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_SecurityDataRequestZoneName) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_SecurityData) (__securityDataRequestZoneName SecurityDataRequestZoneName, err error) {
	m.SecurityDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataRequestZoneName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataRequestZoneName")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	zoneNumber, err := ReadSimpleField(ctx, "zoneNumber", ReadUnsignedByte(readBuffer, uint8(8)))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'zoneNumber' field"))
	}
	m.ZoneNumber = zoneNumber

	if closeErr := readBuffer.CloseContext("SecurityDataRequestZoneName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataRequestZoneName")
	}

	return m, nil
}

func (m *_SecurityDataRequestZoneName) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_SecurityDataRequestZoneName) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataRequestZoneName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataRequestZoneName")
		}

		if err := WriteSimpleField[uint8](ctx, "zoneNumber", m.GetZoneNumber(), WriteUnsignedByte(writeBuffer, 8)); err != nil {
			return errors.Wrap(err, "Error serializing 'zoneNumber' field")
		}

		if popErr := writeBuffer.PopContext("SecurityDataRequestZoneName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataRequestZoneName")
		}
		return nil
	}
	return m.SecurityDataContract.(*_SecurityData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_SecurityDataRequestZoneName) IsSecurityDataRequestZoneName() {}

func (m *_SecurityDataRequestZoneName) DeepCopy() any {
	return m.deepCopy()
}

func (m *_SecurityDataRequestZoneName) deepCopy() *_SecurityDataRequestZoneName {
	if m == nil {
		return nil
	}
	_SecurityDataRequestZoneNameCopy := &_SecurityDataRequestZoneName{
		m.SecurityDataContract.(*_SecurityData).deepCopy(),
		m.ZoneNumber,
	}
	_SecurityDataRequestZoneNameCopy.SecurityDataContract.(*_SecurityData)._SubType = m
	return _SecurityDataRequestZoneNameCopy
}

func (m *_SecurityDataRequestZoneName) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
