/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	api "github.com/apache/plc4x/plc4go/pkg/api/values"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/apache/plc4x/plc4go/spi/values"
)

// Code generated by code-generation. DO NOT EDIT.

func KnxDatapointParse(ctx context.Context, theBytes []byte, datapointType KnxDatapointType) (api.PlcValue, error) {
	return KnxDatapointParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), datapointType)
}

func KnxDatapointParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, datapointType KnxDatapointType) (api.PlcValue, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	readBuffer.PullContext("KnxDatapoint")
	switch {
	case datapointType == KnxDatapointType_BOOL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_BYTE: // BYTE
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBYTE(value), nil
	case datapointType == KnxDatapointType_WORD: // WORD
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcWORD(value), nil
	case datapointType == KnxDatapointType_DWORD: // DWORD
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDWORD(value), nil
	case datapointType == KnxDatapointType_LWORD: // LWORD
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLWORD(value), nil
	case datapointType == KnxDatapointType_USINT: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_SINT: // SINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSINT(value), nil
	case datapointType == KnxDatapointType_UINT: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_INT: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_UDINT: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DINT: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_ULINT: // ULINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcULINT(value), nil
	case datapointType == KnxDatapointType_LINT: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_REAL: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_LREAL: // LREAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLREAL(value), nil
	case datapointType == KnxDatapointType_CHAR: // CHAR
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(8), utils.WithEncoding("UTF-8"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcCHAR(value), nil
	case datapointType == KnxDatapointType_WCHAR: // WCHAR
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(16), utils.WithEncoding("UTF-16"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcWCHAR(value), nil
	case datapointType == KnxDatapointType_TIME: // TIME
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (milliseconds)
		milliseconds, _millisecondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("milliseconds", 32)
		if _millisecondsErr != nil {
			return nil, errors.Wrap(_millisecondsErr, "Error parsing 'milliseconds' field")
		}
		_ = milliseconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcTIMEFromMilliseconds(int64(milliseconds)), nil
	case datapointType == KnxDatapointType_LTIME: // LTIME
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (nanoseconds)
		nanoseconds, _nanosecondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint64("nanoseconds", 64)
		if _nanosecondsErr != nil {
			return nil, errors.Wrap(_nanosecondsErr, "Error parsing 'nanoseconds' field")
		}
		_ = nanoseconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLTIMEFromNanoseconds(nanoseconds), nil
	case datapointType == KnxDatapointType_DATE: // DATE
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (secondsSinceEpoch)
		secondsSinceEpoch, _secondsSinceEpochErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("secondsSinceEpoch", 32)
		if _secondsSinceEpochErr != nil {
			return nil, errors.Wrap(_secondsSinceEpochErr, "Error parsing 'secondsSinceEpoch' field")
		}
		_ = secondsSinceEpoch // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDATEFromSecondsSinceEpoch(uint32(secondsSinceEpoch)), nil
	case datapointType == KnxDatapointType_TIME_OF_DAY: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (millisecondsSinceMidnight)
		millisecondsSinceMidnight, _millisecondsSinceMidnightErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("millisecondsSinceMidnight", 32)
		if _millisecondsSinceMidnightErr != nil {
			return nil, errors.Wrap(_millisecondsSinceMidnightErr, "Error parsing 'millisecondsSinceMidnight' field")
		}
		_ = millisecondsSinceMidnight // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcTIME_OF_DAYFromMillisecondsSinceMidnight(millisecondsSinceMidnight), nil
	case datapointType == KnxDatapointType_TOD: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (millisecondsSinceMidnight)
		millisecondsSinceMidnight, _millisecondsSinceMidnightErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("millisecondsSinceMidnight", 32)
		if _millisecondsSinceMidnightErr != nil {
			return nil, errors.Wrap(_millisecondsSinceMidnightErr, "Error parsing 'millisecondsSinceMidnight' field")
		}
		_ = millisecondsSinceMidnight // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcTIME_OF_DAYFromMillisecondsSinceMidnight(millisecondsSinceMidnight), nil
	case datapointType == KnxDatapointType_DATE_AND_TIME: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("year", 16)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_ = year // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (month)
		month, _monthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("month", 8)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_ = month // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (day)
		day, _dayErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("day", 8)
		if _dayErr != nil {
			return nil, errors.Wrap(_dayErr, "Error parsing 'day' field")
		}
		_ = day // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dayOfWeek)
		dayOfWeek, _dayOfWeekErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayOfWeek", 8)
		if _dayOfWeekErr != nil {
			return nil, errors.Wrap(_dayOfWeekErr, "Error parsing 'dayOfWeek' field")
		}
		_ = dayOfWeek // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hour)
		hour, _hourErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hour", 8)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}
		_ = hour // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (minutes)
		minutes, _minutesErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("minutes", 8)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_ = minutes // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (seconds)
		seconds, _secondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("seconds", 8)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_ = seconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (nanoseconds)
		nanoseconds, _nanosecondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("nanoseconds", 32)
		if _nanosecondsErr != nil {
			return nil, errors.Wrap(_nanosecondsErr, "Error parsing 'nanoseconds' field")
		}
		_ = nanoseconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDATA_AND_TIMEFromSegments(uint32(year), uint32(month), uint32(day), uint32(hour), uint32(minutes), uint32(seconds), uint32(nanoseconds)), nil
	case datapointType == KnxDatapointType_DT: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("year", 16)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_ = year // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (month)
		month, _monthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("month", 8)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_ = month // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (day)
		day, _dayErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("day", 8)
		if _dayErr != nil {
			return nil, errors.Wrap(_dayErr, "Error parsing 'day' field")
		}
		_ = day // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dayOfWeek)
		dayOfWeek, _dayOfWeekErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayOfWeek", 8)
		if _dayOfWeekErr != nil {
			return nil, errors.Wrap(_dayOfWeekErr, "Error parsing 'dayOfWeek' field")
		}
		_ = dayOfWeek // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hour)
		hour, _hourErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hour", 8)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}
		_ = hour // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (minutes)
		minutes, _minutesErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("minutes", 8)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_ = minutes // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (seconds)
		seconds, _secondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("seconds", 8)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_ = seconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (nanoseconds)
		nanoseconds, _nanosecondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("nanoseconds", 32)
		if _nanosecondsErr != nil {
			return nil, errors.Wrap(_nanosecondsErr, "Error parsing 'nanoseconds' field")
		}
		_ = nanoseconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDATA_AND_TIMEFromSegments(uint32(year), uint32(month), uint32(day), uint32(hour), uint32(minutes), uint32(seconds), uint32(nanoseconds)), nil
	case datapointType == KnxDatapointType_DPT_Switch: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Bool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Enable: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Ramp: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Alarm: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_BinaryValue: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Step: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_UpDown: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_OpenClose: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Start: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_State: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Invert: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_DimSendStyle: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_InputSource: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Reset: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Ack: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Trigger: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Occupancy: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Window_Door: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_LogicalFunction: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Scene_AB: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_ShutterBlinds_Mode: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_DayNight: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Heat_Cool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Switch_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (on)
		on, _onErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("on")
		if _onErr != nil {
			return nil, errors.Wrap(_onErr, "Error parsing 'on' field")
		}
		_map["Struct"] = values.NewPlcBOOL(on)
		_ = on // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Bool_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (valueTrue)
		valueTrue, _valueTrueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("valueTrue")
		if _valueTrueErr != nil {
			return nil, errors.Wrap(_valueTrueErr, "Error parsing 'valueTrue' field")
		}
		_map["Struct"] = values.NewPlcBOOL(valueTrue)
		_ = valueTrue // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Enable_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (enable)
		enable, _enableErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("enable")
		if _enableErr != nil {
			return nil, errors.Wrap(_enableErr, "Error parsing 'enable' field")
		}
		_map["Struct"] = values.NewPlcBOOL(enable)
		_ = enable // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Ramp_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (ramp)
		ramp, _rampErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("ramp")
		if _rampErr != nil {
			return nil, errors.Wrap(_rampErr, "Error parsing 'ramp' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ramp)
		_ = ramp // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Alarm_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (alarm)
		alarm, _alarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("alarm")
		if _alarmErr != nil {
			return nil, errors.Wrap(_alarmErr, "Error parsing 'alarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarm)
		_ = alarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_BinaryValue_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (high)
		high, _highErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("high")
		if _highErr != nil {
			return nil, errors.Wrap(_highErr, "Error parsing 'high' field")
		}
		_map["Struct"] = values.NewPlcBOOL(high)
		_ = high // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Step_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (increase)
		increase, _increaseErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("increase")
		if _increaseErr != nil {
			return nil, errors.Wrap(_increaseErr, "Error parsing 'increase' field")
		}
		_map["Struct"] = values.NewPlcBOOL(increase)
		_ = increase // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Direction1_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (down)
		down, _downErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("down")
		if _downErr != nil {
			return nil, errors.Wrap(_downErr, "Error parsing 'down' field")
		}
		_map["Struct"] = values.NewPlcBOOL(down)
		_ = down // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Direction2_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (close)
		close, _closeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("close")
		if _closeErr != nil {
			return nil, errors.Wrap(_closeErr, "Error parsing 'close' field")
		}
		_map["Struct"] = values.NewPlcBOOL(close)
		_ = close // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Start_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (start)
		start, _startErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("start")
		if _startErr != nil {
			return nil, errors.Wrap(_startErr, "Error parsing 'start' field")
		}
		_map["Struct"] = values.NewPlcBOOL(start)
		_ = start // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_State_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (active)
		active, _activeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("active")
		if _activeErr != nil {
			return nil, errors.Wrap(_activeErr, "Error parsing 'active' field")
		}
		_map["Struct"] = values.NewPlcBOOL(active)
		_ = active // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Invert_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)
		_ = control // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (inverted)
		inverted, _invertedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("inverted")
		if _invertedErr != nil {
			return nil, errors.Wrap(_invertedErr, "Error parsing 'inverted' field")
		}
		_map["Struct"] = values.NewPlcBOOL(inverted)
		_ = inverted // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Control_Dimming: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (increase)
		increase, _increaseErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("increase")
		if _increaseErr != nil {
			return nil, errors.Wrap(_increaseErr, "Error parsing 'increase' field")
		}
		_map["Struct"] = values.NewPlcBOOL(increase)
		_ = increase // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepcode)
		stepcode, _stepcodeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepcode", 3)
		if _stepcodeErr != nil {
			return nil, errors.Wrap(_stepcodeErr, "Error parsing 'stepcode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepcode)
		_ = stepcode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Control_Blinds: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (down)
		down, _downErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("down")
		if _downErr != nil {
			return nil, errors.Wrap(_downErr, "Error parsing 'down' field")
		}
		_map["Struct"] = values.NewPlcBOOL(down)
		_ = down // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepcode)
		stepcode, _stepcodeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepcode", 3)
		if _stepcodeErr != nil {
			return nil, errors.Wrap(_stepcodeErr, "Error parsing 'stepcode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepcode)
		_ = stepcode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Char_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(8), utils.WithEncoding("ASCII"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_Char_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(8), utils.WithEncoding("ISO-8859-1"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_Scaling: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Angle: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Percent_U8: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DecimalFactor: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Tariff: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_1_Ucount: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_FanStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Percent_V8: // SINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_1_Count: // SINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Status_Mode3: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (statusA)
		statusA, _statusAErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusA")
		if _statusAErr != nil {
			return nil, errors.Wrap(_statusAErr, "Error parsing 'statusA' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusA)
		_ = statusA // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusB)
		statusB, _statusBErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusB")
		if _statusBErr != nil {
			return nil, errors.Wrap(_statusBErr, "Error parsing 'statusB' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusB)
		_ = statusB // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusC)
		statusC, _statusCErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusC")
		if _statusCErr != nil {
			return nil, errors.Wrap(_statusCErr, "Error parsing 'statusC' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusC)
		_ = statusC // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusD)
		statusD, _statusDErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusD")
		if _statusDErr != nil {
			return nil, errors.Wrap(_statusDErr, "Error parsing 'statusD' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusD)
		_ = statusD // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusE)
		statusE, _statusEErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusE")
		if _statusEErr != nil {
			return nil, errors.Wrap(_statusEErr, "Error parsing 'statusE' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusE)
		_ = statusE // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (mode)
		mode, _modeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("mode", 3)
		if _modeErr != nil {
			return nil, errors.Wrap(_modeErr, "Error parsing 'mode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(mode)
		_ = mode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Value_2_Ucount: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodMsec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriod10Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriod100Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodSec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodMin: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodHrs: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_PropDataType: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Length_mm: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_UElCurrentmA: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Brightness: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Absolute_Colour_Temperature: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_2_Count: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeMsec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTime10Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTime100Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeSec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeMin: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeHrs: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Percent_V16: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Rotation_Angle: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Length_m: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Temp: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Tempd: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Tempa: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Lux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Wsp: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Pres: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AirQuality: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AirFlow: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Time1: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Time2: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volt: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Curr: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_PowerDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_KelvinPerPercent: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flow: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Rain_Amount: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Temp_F: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Wsp_kmh: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Concentration_ygm3: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Coefficient: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_TimeOfDay: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (day)
		day, _dayErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("day", 3)
		if _dayErr != nil {
			return nil, errors.Wrap(_dayErr, "Error parsing 'day' field")
		}
		_map["Struct"] = values.NewPlcUSINT(day)
		_ = day // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hour)
		hour, _hourErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hour", 5)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hour)
		_ = hour // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("minutes", 6)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_map["Struct"] = values.NewPlcUSINT(minutes)
		_ = minutes // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("seconds", 6)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_map["Struct"] = values.NewPlcUSINT(seconds)
		_ = seconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Date: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (dayOfMonth)
		dayOfMonth, _dayOfMonthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayOfMonth", 5)
		if _dayOfMonthErr != nil {
			return nil, errors.Wrap(_dayOfMonthErr, "Error parsing 'dayOfMonth' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayOfMonth)
		_ = dayOfMonth // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (month)
		month, _monthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("month", 4)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_map["Struct"] = values.NewPlcUSINT(month)
		_ = month // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("year", 7)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_map["Struct"] = values.NewPlcUSINT(year)
		_ = year // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Value_4_Ucount: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Sec: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Min: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Hrs: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_VolumeLiquid_Litre: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_Volume_m_3: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_4_Count: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_FlowRate_m3h: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApparentEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_kWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApparentEnergy_kVAh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_kVARh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_MWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongDeltaTimeSec: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaVolumeLiquid_Litre: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaVolume_m_3: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Acceleration: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Acceleration_Angular: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Activation_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Activity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Mol: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Amplitude: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Angular_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Angular_Velocity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Area: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Capacitance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensitySurface: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensityVolume: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Compressibility: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Conductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electrical_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Density: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Charge: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Current: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_CurrentDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_DipoleMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Displacement: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Potential: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_PotentialDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_ElectromagneticMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electromotive_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Angular_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Heat_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Heat_FlowRate: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Heat_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Impedance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Length: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Light_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Luminance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Moment: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetization: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_MagnetomotiveForce: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Mass: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_MassFlux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Power_Factor: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Pressure: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Reactance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Resistance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Resistivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_SelfInductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_SolidAngle: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Sound_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Speed: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Stress: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Surface_Tension: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Common_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_TemperatureDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_ThermoelectricPower: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Time: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Torque: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volume: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Weight: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Work: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_ApparentPower: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Volume_Flux_Meter: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Volume_Flux_ls: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Access_Data: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (hurz)
		hurz, _hurzErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hurz", 4)
		if _hurzErr != nil {
			return nil, errors.Wrap(_hurzErr, "Error parsing 'hurz' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hurz)
		_ = hurz // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (value1)
		value1, _value1Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value1", 4)
		if _value1Err != nil {
			return nil, errors.Wrap(_value1Err, "Error parsing 'value1' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value1)
		_ = value1 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (value2)
		value2, _value2Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value2", 4)
		if _value2Err != nil {
			return nil, errors.Wrap(_value2Err, "Error parsing 'value2' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value2)
		_ = value2 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (value3)
		value3, _value3Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value3", 4)
		if _value3Err != nil {
			return nil, errors.Wrap(_value3Err, "Error parsing 'value3' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value3)
		_ = value3 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (value4)
		value4, _value4Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value4", 4)
		if _value4Err != nil {
			return nil, errors.Wrap(_value4Err, "Error parsing 'value4' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value4)
		_ = value4 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (value5)
		value5, _value5Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value5", 4)
		if _value5Err != nil {
			return nil, errors.Wrap(_value5Err, "Error parsing 'value5' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value5)
		_ = value5 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (detectionError)
		detectionError, _detectionErrorErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("detectionError")
		if _detectionErrorErr != nil {
			return nil, errors.Wrap(_detectionErrorErr, "Error parsing 'detectionError' field")
		}
		_map["Struct"] = values.NewPlcBOOL(detectionError)
		_ = detectionError // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (permission)
		permission, _permissionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("permission")
		if _permissionErr != nil {
			return nil, errors.Wrap(_permissionErr, "Error parsing 'permission' field")
		}
		_map["Struct"] = values.NewPlcBOOL(permission)
		_ = permission // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (readDirection)
		readDirection, _readDirectionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("readDirection")
		if _readDirectionErr != nil {
			return nil, errors.Wrap(_readDirectionErr, "Error parsing 'readDirection' field")
		}
		_map["Struct"] = values.NewPlcBOOL(readDirection)
		_ = readDirection // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (encryptionOfAccessInformation)
		encryptionOfAccessInformation, _encryptionOfAccessInformationErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("encryptionOfAccessInformation")
		if _encryptionOfAccessInformationErr != nil {
			return nil, errors.Wrap(_encryptionOfAccessInformationErr, "Error parsing 'encryptionOfAccessInformation' field")
		}
		_map["Struct"] = values.NewPlcBOOL(encryptionOfAccessInformation)
		_ = encryptionOfAccessInformation // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (indexOfAccessIdentificationCode)
		indexOfAccessIdentificationCode, _indexOfAccessIdentificationCodeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("indexOfAccessIdentificationCode", 4)
		if _indexOfAccessIdentificationCodeErr != nil {
			return nil, errors.Wrap(_indexOfAccessIdentificationCodeErr, "Error parsing 'indexOfAccessIdentificationCode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(indexOfAccessIdentificationCode)
		_ = indexOfAccessIdentificationCode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_String_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(112), utils.WithEncoding("ASCII"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_String_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(112), utils.WithEncoding("ISO-8859-1"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_SceneNumber: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 6)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SceneControl: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
		learnTheSceneCorrespondingToTheFieldSceneNumber, _learnTheSceneCorrespondingToTheFieldSceneNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("learnTheSceneCorrespondingToTheFieldSceneNumber")
		if _learnTheSceneCorrespondingToTheFieldSceneNumberErr != nil {
			return nil, errors.Wrap(_learnTheSceneCorrespondingToTheFieldSceneNumberErr, "Error parsing 'learnTheSceneCorrespondingToTheFieldSceneNumber' field")
		}
		_map["Struct"] = values.NewPlcBOOL(learnTheSceneCorrespondingToTheFieldSceneNumber)
		_ = learnTheSceneCorrespondingToTheFieldSceneNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (sceneNumber)
		sceneNumber, _sceneNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("sceneNumber", 6)
		if _sceneNumberErr != nil {
			return nil, errors.Wrap(_sceneNumberErr, "Error parsing 'sceneNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sceneNumber)
		_ = sceneNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DateTime: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("year", 8)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_map["Struct"] = values.NewPlcUSINT(year)
		_ = year // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (month)
		month, _monthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("month", 4)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_map["Struct"] = values.NewPlcUSINT(month)
		_ = month // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (dayofmonth)
		dayofmonth, _dayofmonthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayofmonth", 5)
		if _dayofmonthErr != nil {
			return nil, errors.Wrap(_dayofmonthErr, "Error parsing 'dayofmonth' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayofmonth)
		_ = dayofmonth // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dayofweek)
		dayofweek, _dayofweekErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dayofweek", 3)
		if _dayofweekErr != nil {
			return nil, errors.Wrap(_dayofweekErr, "Error parsing 'dayofweek' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayofweek)
		_ = dayofweek // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hourofday)
		hourofday, _hourofdayErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hourofday", 5)
		if _hourofdayErr != nil {
			return nil, errors.Wrap(_hourofdayErr, "Error parsing 'hourofday' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hourofday)
		_ = hourofday // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("minutes", 6)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_map["Struct"] = values.NewPlcUSINT(minutes)
		_ = minutes // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("seconds", 6)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_map["Struct"] = values.NewPlcUSINT(seconds)
		_ = seconds // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (workingDay)
		workingDay, _workingDayErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("workingDay")
		if _workingDayErr != nil {
			return nil, errors.Wrap(_workingDayErr, "Error parsing 'workingDay' field")
		}
		_map["Struct"] = values.NewPlcBOOL(workingDay)
		_ = workingDay // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noWd)
		noWd, _noWdErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noWd")
		if _noWdErr != nil {
			return nil, errors.Wrap(_noWdErr, "Error parsing 'noWd' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noWd)
		_ = noWd // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noYear)
		noYear, _noYearErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noYear")
		if _noYearErr != nil {
			return nil, errors.Wrap(_noYearErr, "Error parsing 'noYear' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noYear)
		_ = noYear // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noDate)
		noDate, _noDateErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noDate")
		if _noDateErr != nil {
			return nil, errors.Wrap(_noDateErr, "Error parsing 'noDate' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noDate)
		_ = noDate // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noDayOfWeek)
		noDayOfWeek, _noDayOfWeekErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noDayOfWeek")
		if _noDayOfWeekErr != nil {
			return nil, errors.Wrap(_noDayOfWeekErr, "Error parsing 'noDayOfWeek' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noDayOfWeek)
		_ = noDayOfWeek // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (noTime)
		noTime, _noTimeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("noTime")
		if _noTimeErr != nil {
			return nil, errors.Wrap(_noTimeErr, "Error parsing 'noTime' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noTime)
		_ = noTime // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (standardSummerTime)
		standardSummerTime, _standardSummerTimeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("standardSummerTime")
		if _standardSummerTimeErr != nil {
			return nil, errors.Wrap(_standardSummerTimeErr, "Error parsing 'standardSummerTime' field")
		}
		_map["Struct"] = values.NewPlcBOOL(standardSummerTime)
		_ = standardSummerTime // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (qualityOfClock)
		qualityOfClock, _qualityOfClockErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("qualityOfClock")
		if _qualityOfClockErr != nil {
			return nil, errors.Wrap(_qualityOfClockErr, "Error parsing 'qualityOfClock' field")
		}
		_map["Struct"] = values.NewPlcBOOL(qualityOfClock)
		_ = qualityOfClock // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_SCLOMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BuildingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_OccMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Priority: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LightApplicationMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApplicationArea: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_AlarmClassType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_PSUMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ErrorClass_System: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ErrorClass_HVAC: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Time_Delay: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Beaufort_Wind_Force_Scale: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SensorSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActuatorConnectType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Cloud_Cover: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_PowerReturnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_FuelType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BurnerType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVACMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DHWMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LoadPriority: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVACContrMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVACEmergMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ChangeoverMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ValveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DamperMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HeaterMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_FanMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_MasterSlaveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_StatusRoomSetp: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Metering_DeviceType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HumDehumMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_EnableHCStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ADAType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BackupMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_StartSynchronization: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Behaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Behaviour_Bus_Power_Up_Down: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DALI_Fade_Time: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BlinkingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LightControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SwitchPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_PBAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DimmPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SwitchOnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LoadTypeSet: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LoadTypeDetected: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Converter_Test_Control: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Converter_Control: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SABExcept_Behaviour: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SABBehaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SSSBMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BlindsControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_CommMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_AddInfoTypes: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_RF_ModeSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_RF_FilterSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_StatusGen: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
		alarmStatusOfCorrespondingDatapointIsNotAcknowledged, _alarmStatusOfCorrespondingDatapointIsNotAcknowledgedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("alarmStatusOfCorrespondingDatapointIsNotAcknowledged")
		if _alarmStatusOfCorrespondingDatapointIsNotAcknowledgedErr != nil {
			return nil, errors.Wrap(_alarmStatusOfCorrespondingDatapointIsNotAcknowledgedErr, "Error parsing 'alarmStatusOfCorrespondingDatapointIsNotAcknowledged' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
		_ = alarmStatusOfCorrespondingDatapointIsNotAcknowledged // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (correspondingDatapointIsInAlarm)
		correspondingDatapointIsInAlarm, _correspondingDatapointIsInAlarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("correspondingDatapointIsInAlarm")
		if _correspondingDatapointIsInAlarmErr != nil {
			return nil, errors.Wrap(_correspondingDatapointIsInAlarmErr, "Error parsing 'correspondingDatapointIsInAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointIsInAlarm)
		_ = correspondingDatapointIsInAlarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (correspondingDatapointMainValueIsOverridden)
		correspondingDatapointMainValueIsOverridden, _correspondingDatapointMainValueIsOverriddenErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("correspondingDatapointMainValueIsOverridden")
		if _correspondingDatapointMainValueIsOverriddenErr != nil {
			return nil, errors.Wrap(_correspondingDatapointMainValueIsOverriddenErr, "Error parsing 'correspondingDatapointMainValueIsOverridden' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointMainValueIsOverridden)
		_ = correspondingDatapointMainValueIsOverridden // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
		correspondingDatapointMainValueIsCorruptedDueToFailure, _correspondingDatapointMainValueIsCorruptedDueToFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("correspondingDatapointMainValueIsCorruptedDueToFailure")
		if _correspondingDatapointMainValueIsCorruptedDueToFailureErr != nil {
			return nil, errors.Wrap(_correspondingDatapointMainValueIsCorruptedDueToFailureErr, "Error parsing 'correspondingDatapointMainValueIsCorruptedDueToFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointMainValueIsCorruptedDueToFailure)
		_ = correspondingDatapointMainValueIsCorruptedDueToFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (correspondingDatapointValueIsOutOfService)
		correspondingDatapointValueIsOutOfService, _correspondingDatapointValueIsOutOfServiceErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("correspondingDatapointValueIsOutOfService")
		if _correspondingDatapointValueIsOutOfServiceErr != nil {
			return nil, errors.Wrap(_correspondingDatapointValueIsOutOfServiceErr, "Error parsing 'correspondingDatapointValueIsOutOfService' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointValueIsOutOfService)
		_ = correspondingDatapointValueIsOutOfService // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Device_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (verifyModeIsOn)
		verifyModeIsOn, _verifyModeIsOnErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("verifyModeIsOn")
		if _verifyModeIsOnErr != nil {
			return nil, errors.Wrap(_verifyModeIsOnErr, "Error parsing 'verifyModeIsOn' field")
		}
		_map["Struct"] = values.NewPlcBOOL(verifyModeIsOn)
		_ = verifyModeIsOn // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
		aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived, _aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceivedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived")
		if _aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceivedErr != nil {
			return nil, errors.Wrap(_aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceivedErr, "Error parsing 'aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived' field")
		}
		_map["Struct"] = values.NewPlcBOOL(aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
		_ = aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (theUserApplicationIsStopped)
		theUserApplicationIsStopped, _theUserApplicationIsStoppedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("theUserApplicationIsStopped")
		if _theUserApplicationIsStoppedErr != nil {
			return nil, errors.Wrap(_theUserApplicationIsStoppedErr, "Error parsing 'theUserApplicationIsStopped' field")
		}
		_map["Struct"] = values.NewPlcBOOL(theUserApplicationIsStopped)
		_ = theUserApplicationIsStopped // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_ForceSign: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (roomhmax)
		roomhmax, _roomhmaxErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("roomhmax")
		if _roomhmaxErr != nil {
			return nil, errors.Wrap(_roomhmaxErr, "Error parsing 'roomhmax' field")
		}
		_map["Struct"] = values.NewPlcBOOL(roomhmax)
		_ = roomhmax // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (roomhconf)
		roomhconf, _roomhconfErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("roomhconf")
		if _roomhconfErr != nil {
			return nil, errors.Wrap(_roomhconfErr, "Error parsing 'roomhconf' field")
		}
		_map["Struct"] = values.NewPlcBOOL(roomhconf)
		_ = roomhconf // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dhwlegio)
		dhwlegio, _dhwlegioErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("dhwlegio")
		if _dhwlegioErr != nil {
			return nil, errors.Wrap(_dhwlegioErr, "Error parsing 'dhwlegio' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwlegio)
		_ = dhwlegio // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dhwnorm)
		dhwnorm, _dhwnormErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("dhwnorm")
		if _dhwnormErr != nil {
			return nil, errors.Wrap(_dhwnormErr, "Error parsing 'dhwnorm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwnorm)
		_ = dhwnorm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (overrun)
		overrun, _overrunErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("overrun")
		if _overrunErr != nil {
			return nil, errors.Wrap(_overrunErr, "Error parsing 'overrun' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overrun)
		_ = overrun // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (oversupply)
		oversupply, _oversupplyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("oversupply")
		if _oversupplyErr != nil {
			return nil, errors.Wrap(_oversupplyErr, "Error parsing 'oversupply' field")
		}
		_map["Struct"] = values.NewPlcBOOL(oversupply)
		_ = oversupply // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (protection)
		protection, _protectionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("protection")
		if _protectionErr != nil {
			return nil, errors.Wrap(_protectionErr, "Error parsing 'protection' field")
		}
		_map["Struct"] = values.NewPlcBOOL(protection)
		_ = protection // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (forcerequest)
		forcerequest, _forcerequestErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("forcerequest")
		if _forcerequestErr != nil {
			return nil, errors.Wrap(_forcerequestErr, "Error parsing 'forcerequest' field")
		}
		_map["Struct"] = values.NewPlcBOOL(forcerequest)
		_ = forcerequest // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_ForceSignCool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_StatusRHC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (summermode)
		summermode, _summermodeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("summermode")
		if _summermodeErr != nil {
			return nil, errors.Wrap(_summermodeErr, "Error parsing 'summermode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(summermode)
		_ = summermode // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusstopoptim)
		statusstopoptim, _statusstopoptimErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusstopoptim")
		if _statusstopoptimErr != nil {
			return nil, errors.Wrap(_statusstopoptimErr, "Error parsing 'statusstopoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstopoptim)
		_ = statusstopoptim // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusstartoptim)
		statusstartoptim, _statusstartoptimErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusstartoptim")
		if _statusstartoptimErr != nil {
			return nil, errors.Wrap(_statusstartoptimErr, "Error parsing 'statusstartoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstartoptim)
		_ = statusstartoptim // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusmorningboost)
		statusmorningboost, _statusmorningboostErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusmorningboost")
		if _statusmorningboostErr != nil {
			return nil, errors.Wrap(_statusmorningboostErr, "Error parsing 'statusmorningboost' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusmorningboost)
		_ = statusmorningboost // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempreturnlimit)
		tempreturnlimit, _tempreturnlimitErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("tempreturnlimit")
		if _tempreturnlimitErr != nil {
			return nil, errors.Wrap(_tempreturnlimitErr, "Error parsing 'tempreturnlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempreturnlimit)
		_ = tempreturnlimit // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempflowlimit)
		tempflowlimit, _tempflowlimitErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("tempflowlimit")
		if _tempflowlimitErr != nil {
			return nil, errors.Wrap(_tempflowlimitErr, "Error parsing 'tempflowlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempflowlimit)
		_ = tempflowlimit // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (satuseco)
		satuseco, _satusecoErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("satuseco")
		if _satusecoErr != nil {
			return nil, errors.Wrap(_satusecoErr, "Error parsing 'satuseco' field")
		}
		_map["Struct"] = values.NewPlcBOOL(satuseco)
		_ = satuseco // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusSDHWC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (solarloadsufficient)
		solarloadsufficient, _solarloadsufficientErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("solarloadsufficient")
		if _solarloadsufficientErr != nil {
			return nil, errors.Wrap(_solarloadsufficientErr, "Error parsing 'solarloadsufficient' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solarloadsufficient)
		_ = solarloadsufficient // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (sdhwloadactive)
		sdhwloadactive, _sdhwloadactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("sdhwloadactive")
		if _sdhwloadactiveErr != nil {
			return nil, errors.Wrap(_sdhwloadactiveErr, "Error parsing 'sdhwloadactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(sdhwloadactive)
		_ = sdhwloadactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_FuelTypeSet: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (solidstate)
		solidstate, _solidstateErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("solidstate")
		if _solidstateErr != nil {
			return nil, errors.Wrap(_solidstateErr, "Error parsing 'solidstate' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solidstate)
		_ = solidstate // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (gas)
		gas, _gasErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("gas")
		if _gasErr != nil {
			return nil, errors.Wrap(_gasErr, "Error parsing 'gas' field")
		}
		_map["Struct"] = values.NewPlcBOOL(gas)
		_ = gas // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (oil)
		oil, _oilErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("oil")
		if _oilErr != nil {
			return nil, errors.Wrap(_oilErr, "Error parsing 'oil' field")
		}
		_map["Struct"] = values.NewPlcBOOL(oil)
		_ = oil // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusRCC: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_StatusAHU: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cool)
		cool, _coolErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cool")
		if _coolErr != nil {
			return nil, errors.Wrap(_coolErr, "Error parsing 'cool' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cool)
		_ = cool // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (heat)
		heat, _heatErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("heat")
		if _heatErr != nil {
			return nil, errors.Wrap(_heatErr, "Error parsing 'heat' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heat)
		_ = heat // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fanactive)
		fanactive, _fanactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fanactive")
		if _fanactiveErr != nil {
			return nil, errors.Wrap(_fanactiveErr, "Error parsing 'fanactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fanactive)
		_ = fanactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTSM: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (statusOfHvacModeUser)
		statusOfHvacModeUser, _statusOfHvacModeUserErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusOfHvacModeUser")
		if _statusOfHvacModeUserErr != nil {
			return nil, errors.Wrap(_statusOfHvacModeUserErr, "Error parsing 'statusOfHvacModeUser' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusOfHvacModeUser)
		_ = statusOfHvacModeUser // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusOfComfortProlongationUser)
		statusOfComfortProlongationUser, _statusOfComfortProlongationUserErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusOfComfortProlongationUser")
		if _statusOfComfortProlongationUserErr != nil {
			return nil, errors.Wrap(_statusOfComfortProlongationUserErr, "Error parsing 'statusOfComfortProlongationUser' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusOfComfortProlongationUser)
		_ = statusOfComfortProlongationUser // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (effectiveValueOfTheComfortPushButton)
		effectiveValueOfTheComfortPushButton, _effectiveValueOfTheComfortPushButtonErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("effectiveValueOfTheComfortPushButton")
		if _effectiveValueOfTheComfortPushButtonErr != nil {
			return nil, errors.Wrap(_effectiveValueOfTheComfortPushButtonErr, "Error parsing 'effectiveValueOfTheComfortPushButton' field")
		}
		_map["Struct"] = values.NewPlcBOOL(effectiveValueOfTheComfortPushButton)
		_ = effectiveValueOfTheComfortPushButton // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (effectiveValueOfThePresenceStatus)
		effectiveValueOfThePresenceStatus, _effectiveValueOfThePresenceStatusErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("effectiveValueOfThePresenceStatus")
		if _effectiveValueOfThePresenceStatusErr != nil {
			return nil, errors.Wrap(_effectiveValueOfThePresenceStatusErr, "Error parsing 'effectiveValueOfThePresenceStatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(effectiveValueOfThePresenceStatus)
		_ = effectiveValueOfThePresenceStatus // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (effectiveValueOfTheWindowStatus)
		effectiveValueOfTheWindowStatus, _effectiveValueOfTheWindowStatusErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("effectiveValueOfTheWindowStatus")
		if _effectiveValueOfTheWindowStatusErr != nil {
			return nil, errors.Wrap(_effectiveValueOfTheWindowStatusErr, "Error parsing 'effectiveValueOfTheWindowStatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(effectiveValueOfTheWindowStatus)
		_ = effectiveValueOfTheWindowStatus // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_LightActuatorErrorInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (overheat)
		overheat, _overheatErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("overheat")
		if _overheatErr != nil {
			return nil, errors.Wrap(_overheatErr, "Error parsing 'overheat' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overheat)
		_ = overheat // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (lampfailure)
		lampfailure, _lampfailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("lampfailure")
		if _lampfailureErr != nil {
			return nil, errors.Wrap(_lampfailureErr, "Error parsing 'lampfailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lampfailure)
		_ = lampfailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (defectiveload)
		defectiveload, _defectiveloadErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("defectiveload")
		if _defectiveloadErr != nil {
			return nil, errors.Wrap(_defectiveloadErr, "Error parsing 'defectiveload' field")
		}
		_map["Struct"] = values.NewPlcBOOL(defectiveload)
		_ = defectiveload // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (underload)
		underload, _underloadErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("underload")
		if _underloadErr != nil {
			return nil, errors.Wrap(_underloadErr, "Error parsing 'underload' field")
		}
		_map["Struct"] = values.NewPlcBOOL(underload)
		_ = underload // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (overcurrent)
		overcurrent, _overcurrentErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("overcurrent")
		if _overcurrentErr != nil {
			return nil, errors.Wrap(_overcurrentErr, "Error parsing 'overcurrent' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overcurrent)
		_ = overcurrent // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (undervoltage)
		undervoltage, _undervoltageErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("undervoltage")
		if _undervoltageErr != nil {
			return nil, errors.Wrap(_undervoltageErr, "Error parsing 'undervoltage' field")
		}
		_map["Struct"] = values.NewPlcBOOL(undervoltage)
		_ = undervoltage // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (loaddetectionerror)
		loaddetectionerror, _loaddetectionerrorErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("loaddetectionerror")
		if _loaddetectionerrorErr != nil {
			return nil, errors.Wrap(_loaddetectionerrorErr, "Error parsing 'loaddetectionerror' field")
		}
		_map["Struct"] = values.NewPlcBOOL(loaddetectionerror)
		_ = loaddetectionerror // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_RF_ModeInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (bibatSlave)
		bibatSlave, _bibatSlaveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("bibatSlave")
		if _bibatSlaveErr != nil {
			return nil, errors.Wrap(_bibatSlaveErr, "Error parsing 'bibatSlave' field")
		}
		_map["Struct"] = values.NewPlcBOOL(bibatSlave)
		_ = bibatSlave // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (bibatMaster)
		bibatMaster, _bibatMasterErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("bibatMaster")
		if _bibatMasterErr != nil {
			return nil, errors.Wrap(_bibatMasterErr, "Error parsing 'bibatMaster' field")
		}
		_map["Struct"] = values.NewPlcBOOL(bibatMaster)
		_ = bibatMaster // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (asynchronous)
		asynchronous, _asynchronousErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("asynchronous")
		if _asynchronousErr != nil {
			return nil, errors.Wrap(_asynchronousErr, "Error parsing 'asynchronous' field")
		}
		_map["Struct"] = values.NewPlcBOOL(asynchronous)
		_ = asynchronous // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_RF_FilterInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (doa)
		doa, _doaErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("doa")
		if _doaErr != nil {
			return nil, errors.Wrap(_doaErr, "Error parsing 'doa' field")
		}
		_map["Struct"] = values.NewPlcBOOL(doa)
		_ = doa // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (knxSn)
		knxSn, _knxSnErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("knxSn")
		if _knxSnErr != nil {
			return nil, errors.Wrap(_knxSnErr, "Error parsing 'knxSn' field")
		}
		_map["Struct"] = values.NewPlcBOOL(knxSn)
		_ = knxSn // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (doaAndKnxSn)
		doaAndKnxSn, _doaAndKnxSnErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("doaAndKnxSn")
		if _doaAndKnxSnErr != nil {
			return nil, errors.Wrap(_doaAndKnxSnErr, "Error parsing 'doaAndKnxSn' field")
		}
		_map["Struct"] = values.NewPlcBOOL(doaAndKnxSn)
		_ = doaAndKnxSn // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Channel_Activation_8: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		activationStateOfChannel1, _activationStateOfChannel1Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel1")
		if _activationStateOfChannel1Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel1Err, "Error parsing 'activationStateOfChannel1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel1)
		_ = activationStateOfChannel1 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel2)
		activationStateOfChannel2, _activationStateOfChannel2Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel2")
		if _activationStateOfChannel2Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel2Err, "Error parsing 'activationStateOfChannel2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel2)
		_ = activationStateOfChannel2 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel3)
		activationStateOfChannel3, _activationStateOfChannel3Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel3")
		if _activationStateOfChannel3Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel3Err, "Error parsing 'activationStateOfChannel3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel3)
		_ = activationStateOfChannel3 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel4)
		activationStateOfChannel4, _activationStateOfChannel4Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel4")
		if _activationStateOfChannel4Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel4Err, "Error parsing 'activationStateOfChannel4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel4)
		_ = activationStateOfChannel4 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel5)
		activationStateOfChannel5, _activationStateOfChannel5Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel5")
		if _activationStateOfChannel5Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel5Err, "Error parsing 'activationStateOfChannel5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel5)
		_ = activationStateOfChannel5 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel6)
		activationStateOfChannel6, _activationStateOfChannel6Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel6")
		if _activationStateOfChannel6Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel6Err, "Error parsing 'activationStateOfChannel6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel6)
		_ = activationStateOfChannel6 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel7)
		activationStateOfChannel7, _activationStateOfChannel7Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel7")
		if _activationStateOfChannel7Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel7Err, "Error parsing 'activationStateOfChannel7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel7)
		_ = activationStateOfChannel7 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel8)
		activationStateOfChannel8, _activationStateOfChannel8Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel8")
		if _activationStateOfChannel8Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel8Err, "Error parsing 'activationStateOfChannel8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel8)
		_ = activationStateOfChannel8 // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusDHWC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (tempoptimshiftactive)
		tempoptimshiftactive, _tempoptimshiftactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("tempoptimshiftactive")
		if _tempoptimshiftactiveErr != nil {
			return nil, errors.Wrap(_tempoptimshiftactiveErr, "Error parsing 'tempoptimshiftactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempoptimshiftactive)
		_ = tempoptimshiftactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (solarenergysupport)
		solarenergysupport, _solarenergysupportErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("solarenergysupport")
		if _solarenergysupportErr != nil {
			return nil, errors.Wrap(_solarenergysupportErr, "Error parsing 'solarenergysupport' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solarenergysupport)
		_ = solarenergysupport // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (solarenergyonly)
		solarenergyonly, _solarenergyonlyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("solarenergyonly")
		if _solarenergyonlyErr != nil {
			return nil, errors.Wrap(_solarenergyonlyErr, "Error parsing 'solarenergyonly' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solarenergyonly)
		_ = solarenergyonly // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (otherenergysourceactive)
		otherenergysourceactive, _otherenergysourceactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("otherenergysourceactive")
		if _otherenergysourceactiveErr != nil {
			return nil, errors.Wrap(_otherenergysourceactiveErr, "Error parsing 'otherenergysourceactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(otherenergysourceactive)
		_ = otherenergysourceactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dhwpushactive)
		dhwpushactive, _dhwpushactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("dhwpushactive")
		if _dhwpushactiveErr != nil {
			return nil, errors.Wrap(_dhwpushactiveErr, "Error parsing 'dhwpushactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwpushactive)
		_ = dhwpushactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (legioprotactive)
		legioprotactive, _legioprotactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("legioprotactive")
		if _legioprotactiveErr != nil {
			return nil, errors.Wrap(_legioprotactiveErr, "Error parsing 'legioprotactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(legioprotactive)
		_ = legioprotactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dhwloadactive)
		dhwloadactive, _dhwloadactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("dhwloadactive")
		if _dhwloadactiveErr != nil {
			return nil, errors.Wrap(_dhwloadactiveErr, "Error parsing 'dhwloadactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwloadactive)
		_ = dhwloadactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusRHCC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (overheatalarm)
		overheatalarm, _overheatalarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("overheatalarm")
		if _overheatalarmErr != nil {
			return nil, errors.Wrap(_overheatalarmErr, "Error parsing 'overheatalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overheatalarm)
		_ = overheatalarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (frostalarm)
		frostalarm, _frostalarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("frostalarm")
		if _frostalarmErr != nil {
			return nil, errors.Wrap(_frostalarmErr, "Error parsing 'frostalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(frostalarm)
		_ = frostalarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dewpointstatus)
		dewpointstatus, _dewpointstatusErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("dewpointstatus")
		if _dewpointstatusErr != nil {
			return nil, errors.Wrap(_dewpointstatusErr, "Error parsing 'dewpointstatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dewpointstatus)
		_ = dewpointstatus // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (coolingdisabled)
		coolingdisabled, _coolingdisabledErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("coolingdisabled")
		if _coolingdisabledErr != nil {
			return nil, errors.Wrap(_coolingdisabledErr, "Error parsing 'coolingdisabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(coolingdisabled)
		_ = coolingdisabled // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusprecool)
		statusprecool, _statusprecoolErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusprecool")
		if _statusprecoolErr != nil {
			return nil, errors.Wrap(_statusprecoolErr, "Error parsing 'statusprecool' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusprecool)
		_ = statusprecool // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusecoc)
		statusecoc, _statusecocErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusecoc")
		if _statusecocErr != nil {
			return nil, errors.Wrap(_statusecocErr, "Error parsing 'statusecoc' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusecoc)
		_ = statusecoc // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (heatcoolmode)
		heatcoolmode, _heatcoolmodeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("heatcoolmode")
		if _heatcoolmodeErr != nil {
			return nil, errors.Wrap(_heatcoolmodeErr, "Error parsing 'heatcoolmode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heatcoolmode)
		_ = heatcoolmode // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (heatingdiabled)
		heatingdiabled, _heatingdiabledErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("heatingdiabled")
		if _heatingdiabledErr != nil {
			return nil, errors.Wrap(_heatingdiabledErr, "Error parsing 'heatingdiabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heatingdiabled)
		_ = heatingdiabled // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusstopoptim)
		statusstopoptim, _statusstopoptimErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusstopoptim")
		if _statusstopoptimErr != nil {
			return nil, errors.Wrap(_statusstopoptimErr, "Error parsing 'statusstopoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstopoptim)
		_ = statusstopoptim // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusstartoptim)
		statusstartoptim, _statusstartoptimErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusstartoptim")
		if _statusstartoptimErr != nil {
			return nil, errors.Wrap(_statusstartoptimErr, "Error parsing 'statusstartoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstartoptim)
		_ = statusstartoptim // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusmorningboosth)
		statusmorningboosth, _statusmorningboosthErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusmorningboosth")
		if _statusmorningboosthErr != nil {
			return nil, errors.Wrap(_statusmorningboosthErr, "Error parsing 'statusmorningboosth' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusmorningboosth)
		_ = statusmorningboosth // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempflowreturnlimit)
		tempflowreturnlimit, _tempflowreturnlimitErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("tempflowreturnlimit")
		if _tempflowreturnlimitErr != nil {
			return nil, errors.Wrap(_tempflowreturnlimitErr, "Error parsing 'tempflowreturnlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempflowreturnlimit)
		_ = tempflowreturnlimit // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempflowlimit)
		tempflowlimit, _tempflowlimitErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("tempflowlimit")
		if _tempflowlimitErr != nil {
			return nil, errors.Wrap(_tempflowlimitErr, "Error parsing 'tempflowlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempflowlimit)
		_ = tempflowlimit // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (statusecoh)
		statusecoh, _statusecohErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("statusecoh")
		if _statusecohErr != nil {
			return nil, errors.Wrap(_statusecohErr, "Error parsing 'statusecoh' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusecoh)
		_ = statusecoh // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedStatus_HVA: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (calibrationMode)
		calibrationMode, _calibrationModeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("calibrationMode")
		if _calibrationModeErr != nil {
			return nil, errors.Wrap(_calibrationModeErr, "Error parsing 'calibrationMode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(calibrationMode)
		_ = calibrationMode // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (lockedPosition)
		lockedPosition, _lockedPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("lockedPosition")
		if _lockedPositionErr != nil {
			return nil, errors.Wrap(_lockedPositionErr, "Error parsing 'lockedPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lockedPosition)
		_ = lockedPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (forcedPosition)
		forcedPosition, _forcedPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("forcedPosition")
		if _forcedPositionErr != nil {
			return nil, errors.Wrap(_forcedPositionErr, "Error parsing 'forcedPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(forcedPosition)
		_ = forcedPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (manuaOperationOverridden)
		manuaOperationOverridden, _manuaOperationOverriddenErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("manuaOperationOverridden")
		if _manuaOperationOverriddenErr != nil {
			return nil, errors.Wrap(_manuaOperationOverriddenErr, "Error parsing 'manuaOperationOverridden' field")
		}
		_map["Struct"] = values.NewPlcBOOL(manuaOperationOverridden)
		_ = manuaOperationOverridden // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (serviceMode)
		serviceMode, _serviceModeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("serviceMode")
		if _serviceModeErr != nil {
			return nil, errors.Wrap(_serviceModeErr, "Error parsing 'serviceMode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(serviceMode)
		_ = serviceMode // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (valveKick)
		valveKick, _valveKickErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("valveKick")
		if _valveKickErr != nil {
			return nil, errors.Wrap(_valveKickErr, "Error parsing 'valveKick' field")
		}
		_map["Struct"] = values.NewPlcBOOL(valveKick)
		_ = valveKick // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (overload)
		overload, _overloadErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("overload")
		if _overloadErr != nil {
			return nil, errors.Wrap(_overloadErr, "Error parsing 'overload' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overload)
		_ = overload // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (shortCircuit)
		shortCircuit, _shortCircuitErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("shortCircuit")
		if _shortCircuitErr != nil {
			return nil, errors.Wrap(_shortCircuitErr, "Error parsing 'shortCircuit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(shortCircuit)
		_ = shortCircuit // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (currentValvePosition)
		currentValvePosition, _currentValvePositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("currentValvePosition")
		if _currentValvePositionErr != nil {
			return nil, errors.Wrap(_currentValvePositionErr, "Error parsing 'currentValvePosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(currentValvePosition)
		_ = currentValvePosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (coolingModeEnabled)
		coolingModeEnabled, _coolingModeEnabledErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("coolingModeEnabled")
		if _coolingModeEnabledErr != nil {
			return nil, errors.Wrap(_coolingModeEnabledErr, "Error parsing 'coolingModeEnabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(coolingModeEnabled)
		_ = coolingModeEnabled // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (heatingModeEnabled)
		heatingModeEnabled, _heatingModeEnabledErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("heatingModeEnabled")
		if _heatingModeEnabledErr != nil {
			return nil, errors.Wrap(_heatingModeEnabledErr, "Error parsing 'heatingModeEnabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heatingModeEnabled)
		_ = heatingModeEnabled // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (additionalHeatingCoolingStage2Stage)
		additionalHeatingCoolingStage2Stage, _additionalHeatingCoolingStage2StageErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("additionalHeatingCoolingStage2Stage")
		if _additionalHeatingCoolingStage2StageErr != nil {
			return nil, errors.Wrap(_additionalHeatingCoolingStage2StageErr, "Error parsing 'additionalHeatingCoolingStage2Stage' field")
		}
		_map["Struct"] = values.NewPlcBOOL(additionalHeatingCoolingStage2Stage)
		_ = additionalHeatingCoolingStage2Stage // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (controllerInactive)
		controllerInactive, _controllerInactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("controllerInactive")
		if _controllerInactiveErr != nil {
			return nil, errors.Wrap(_controllerInactiveErr, "Error parsing 'controllerInactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(controllerInactive)
		_ = controllerInactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (overheatAlarm)
		overheatAlarm, _overheatAlarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("overheatAlarm")
		if _overheatAlarmErr != nil {
			return nil, errors.Wrap(_overheatAlarmErr, "Error parsing 'overheatAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overheatAlarm)
		_ = overheatAlarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (frostAlarm)
		frostAlarm, _frostAlarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("frostAlarm")
		if _frostAlarmErr != nil {
			return nil, errors.Wrap(_frostAlarmErr, "Error parsing 'frostAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(frostAlarm)
		_ = frostAlarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dewPointStatus)
		dewPointStatus, _dewPointStatusErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("dewPointStatus")
		if _dewPointStatusErr != nil {
			return nil, errors.Wrap(_dewPointStatusErr, "Error parsing 'dewPointStatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dewPointStatus)
		_ = dewPointStatus // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activeMode)
		activeMode, _activeModeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activeMode")
		if _activeModeErr != nil {
			return nil, errors.Wrap(_activeModeErr, "Error parsing 'activeMode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activeMode)
		_ = activeMode // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (generalFailureInformation)
		generalFailureInformation, _generalFailureInformationErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("generalFailureInformation")
		if _generalFailureInformationErr != nil {
			return nil, errors.Wrap(_generalFailureInformationErr, "Error parsing 'generalFailureInformation' field")
		}
		_map["Struct"] = values.NewPlcBOOL(generalFailureInformation)
		_ = generalFailureInformation // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Media: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("reserved", 10); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (knxIp)
		knxIp, _knxIpErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("knxIp")
		if _knxIpErr != nil {
			return nil, errors.Wrap(_knxIpErr, "Error parsing 'knxIp' field")
		}
		_map["Struct"] = values.NewPlcBOOL(knxIp)
		_ = knxIp // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (rf)
		rf, _rfErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("rf")
		if _rfErr != nil {
			return nil, errors.Wrap(_rfErr, "Error parsing 'rf' field")
		}
		_map["Struct"] = values.NewPlcBOOL(rf)
		_ = rf // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (pl110)
		pl110, _pl110Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("pl110")
		if _pl110Err != nil {
			return nil, errors.Wrap(_pl110Err, "Error parsing 'pl110' field")
		}
		_map["Struct"] = values.NewPlcBOOL(pl110)
		_ = pl110 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tp1)
		tp1, _tp1Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("tp1")
		if _tp1Err != nil {
			return nil, errors.Wrap(_tp1Err, "Error parsing 'tp1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tp1)
		_ = tp1 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Channel_Activation_16: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		activationStateOfChannel1, _activationStateOfChannel1Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel1")
		if _activationStateOfChannel1Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel1Err, "Error parsing 'activationStateOfChannel1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel1)
		_ = activationStateOfChannel1 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel2)
		activationStateOfChannel2, _activationStateOfChannel2Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel2")
		if _activationStateOfChannel2Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel2Err, "Error parsing 'activationStateOfChannel2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel2)
		_ = activationStateOfChannel2 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel3)
		activationStateOfChannel3, _activationStateOfChannel3Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel3")
		if _activationStateOfChannel3Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel3Err, "Error parsing 'activationStateOfChannel3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel3)
		_ = activationStateOfChannel3 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel4)
		activationStateOfChannel4, _activationStateOfChannel4Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel4")
		if _activationStateOfChannel4Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel4Err, "Error parsing 'activationStateOfChannel4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel4)
		_ = activationStateOfChannel4 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel5)
		activationStateOfChannel5, _activationStateOfChannel5Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel5")
		if _activationStateOfChannel5Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel5Err, "Error parsing 'activationStateOfChannel5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel5)
		_ = activationStateOfChannel5 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel6)
		activationStateOfChannel6, _activationStateOfChannel6Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel6")
		if _activationStateOfChannel6Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel6Err, "Error parsing 'activationStateOfChannel6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel6)
		_ = activationStateOfChannel6 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel7)
		activationStateOfChannel7, _activationStateOfChannel7Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel7")
		if _activationStateOfChannel7Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel7Err, "Error parsing 'activationStateOfChannel7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel7)
		_ = activationStateOfChannel7 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel8)
		activationStateOfChannel8, _activationStateOfChannel8Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel8")
		if _activationStateOfChannel8Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel8Err, "Error parsing 'activationStateOfChannel8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel8)
		_ = activationStateOfChannel8 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel9)
		activationStateOfChannel9, _activationStateOfChannel9Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel9")
		if _activationStateOfChannel9Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel9Err, "Error parsing 'activationStateOfChannel9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel9)
		_ = activationStateOfChannel9 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel10)
		activationStateOfChannel10, _activationStateOfChannel10Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel10")
		if _activationStateOfChannel10Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel10Err, "Error parsing 'activationStateOfChannel10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel10)
		_ = activationStateOfChannel10 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel11)
		activationStateOfChannel11, _activationStateOfChannel11Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel11")
		if _activationStateOfChannel11Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel11Err, "Error parsing 'activationStateOfChannel11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel11)
		_ = activationStateOfChannel11 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel12)
		activationStateOfChannel12, _activationStateOfChannel12Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel12")
		if _activationStateOfChannel12Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel12Err, "Error parsing 'activationStateOfChannel12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel12)
		_ = activationStateOfChannel12 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel13)
		activationStateOfChannel13, _activationStateOfChannel13Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel13")
		if _activationStateOfChannel13Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel13Err, "Error parsing 'activationStateOfChannel13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel13)
		_ = activationStateOfChannel13 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel14)
		activationStateOfChannel14, _activationStateOfChannel14Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel14")
		if _activationStateOfChannel14Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel14Err, "Error parsing 'activationStateOfChannel14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel14)
		_ = activationStateOfChannel14 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel15)
		activationStateOfChannel15, _activationStateOfChannel15Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel15")
		if _activationStateOfChannel15Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel15Err, "Error parsing 'activationStateOfChannel15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel15)
		_ = activationStateOfChannel15 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel16)
		activationStateOfChannel16, _activationStateOfChannel16Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel16")
		if _activationStateOfChannel16Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel16Err, "Error parsing 'activationStateOfChannel16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel16)
		_ = activationStateOfChannel16 // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_OnOffAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Alarm_Reaction: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_UpDown_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVAC_PB_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DoubleNibble: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (busy)
		busy, _busyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("busy", 4)
		if _busyErr != nil {
			return nil, errors.Wrap(_busyErr, "Error parsing 'busy' field")
		}
		_map["Struct"] = values.NewPlcUSINT(busy)
		_ = busy // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (nak)
		nak, _nakErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("nak", 4)
		if _nakErr != nil {
			return nil, errors.Wrap(_nakErr, "Error parsing 'nak' field")
		}
		_map["Struct"] = values.NewPlcUSINT(nak)
		_ = nak // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_SceneInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (sceneIsInactive)
		sceneIsInactive, _sceneIsInactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("sceneIsInactive")
		if _sceneIsInactiveErr != nil {
			return nil, errors.Wrap(_sceneIsInactiveErr, "Error parsing 'sceneIsInactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(sceneIsInactive)
		_ = sceneIsInactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (scenenumber)
		scenenumber, _scenenumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("scenenumber", 6)
		if _scenenumberErr != nil {
			return nil, errors.Wrap(_scenenumberErr, "Error parsing 'scenenumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(scenenumber)
		_ = scenenumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedInfoOnOff: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (maskBitInfoOnOffOutput16)
		maskBitInfoOnOffOutput16, _maskBitInfoOnOffOutput16Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput16")
		if _maskBitInfoOnOffOutput16Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput16Err, "Error parsing 'maskBitInfoOnOffOutput16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput16)
		_ = maskBitInfoOnOffOutput16 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput15)
		maskBitInfoOnOffOutput15, _maskBitInfoOnOffOutput15Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput15")
		if _maskBitInfoOnOffOutput15Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput15Err, "Error parsing 'maskBitInfoOnOffOutput15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput15)
		_ = maskBitInfoOnOffOutput15 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput14)
		maskBitInfoOnOffOutput14, _maskBitInfoOnOffOutput14Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput14")
		if _maskBitInfoOnOffOutput14Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput14Err, "Error parsing 'maskBitInfoOnOffOutput14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput14)
		_ = maskBitInfoOnOffOutput14 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput13)
		maskBitInfoOnOffOutput13, _maskBitInfoOnOffOutput13Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput13")
		if _maskBitInfoOnOffOutput13Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput13Err, "Error parsing 'maskBitInfoOnOffOutput13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput13)
		_ = maskBitInfoOnOffOutput13 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput12)
		maskBitInfoOnOffOutput12, _maskBitInfoOnOffOutput12Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput12")
		if _maskBitInfoOnOffOutput12Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput12Err, "Error parsing 'maskBitInfoOnOffOutput12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput12)
		_ = maskBitInfoOnOffOutput12 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput11)
		maskBitInfoOnOffOutput11, _maskBitInfoOnOffOutput11Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput11")
		if _maskBitInfoOnOffOutput11Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput11Err, "Error parsing 'maskBitInfoOnOffOutput11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput11)
		_ = maskBitInfoOnOffOutput11 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput10)
		maskBitInfoOnOffOutput10, _maskBitInfoOnOffOutput10Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput10")
		if _maskBitInfoOnOffOutput10Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput10Err, "Error parsing 'maskBitInfoOnOffOutput10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput10)
		_ = maskBitInfoOnOffOutput10 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput9)
		maskBitInfoOnOffOutput9, _maskBitInfoOnOffOutput9Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput9")
		if _maskBitInfoOnOffOutput9Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput9Err, "Error parsing 'maskBitInfoOnOffOutput9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput9)
		_ = maskBitInfoOnOffOutput9 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput8)
		maskBitInfoOnOffOutput8, _maskBitInfoOnOffOutput8Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput8")
		if _maskBitInfoOnOffOutput8Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput8Err, "Error parsing 'maskBitInfoOnOffOutput8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput8)
		_ = maskBitInfoOnOffOutput8 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput7)
		maskBitInfoOnOffOutput7, _maskBitInfoOnOffOutput7Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput7")
		if _maskBitInfoOnOffOutput7Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput7Err, "Error parsing 'maskBitInfoOnOffOutput7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput7)
		_ = maskBitInfoOnOffOutput7 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput6)
		maskBitInfoOnOffOutput6, _maskBitInfoOnOffOutput6Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput6")
		if _maskBitInfoOnOffOutput6Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput6Err, "Error parsing 'maskBitInfoOnOffOutput6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput6)
		_ = maskBitInfoOnOffOutput6 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput5)
		maskBitInfoOnOffOutput5, _maskBitInfoOnOffOutput5Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput5")
		if _maskBitInfoOnOffOutput5Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput5Err, "Error parsing 'maskBitInfoOnOffOutput5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput5)
		_ = maskBitInfoOnOffOutput5 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput4)
		maskBitInfoOnOffOutput4, _maskBitInfoOnOffOutput4Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput4")
		if _maskBitInfoOnOffOutput4Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput4Err, "Error parsing 'maskBitInfoOnOffOutput4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput4)
		_ = maskBitInfoOnOffOutput4 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput3)
		maskBitInfoOnOffOutput3, _maskBitInfoOnOffOutput3Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput3")
		if _maskBitInfoOnOffOutput3Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput3Err, "Error parsing 'maskBitInfoOnOffOutput3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput3)
		_ = maskBitInfoOnOffOutput3 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput2)
		maskBitInfoOnOffOutput2, _maskBitInfoOnOffOutput2Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput2")
		if _maskBitInfoOnOffOutput2Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput2Err, "Error parsing 'maskBitInfoOnOffOutput2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput2)
		_ = maskBitInfoOnOffOutput2 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskBitInfoOnOffOutput1)
		maskBitInfoOnOffOutput1, _maskBitInfoOnOffOutput1Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskBitInfoOnOffOutput1")
		if _maskBitInfoOnOffOutput1Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput1Err, "Error parsing 'maskBitInfoOnOffOutput1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput1)
		_ = maskBitInfoOnOffOutput1 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput16)
		infoOnOffOutput16, _infoOnOffOutput16Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput16")
		if _infoOnOffOutput16Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput16Err, "Error parsing 'infoOnOffOutput16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput16)
		_ = infoOnOffOutput16 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput15)
		infoOnOffOutput15, _infoOnOffOutput15Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput15")
		if _infoOnOffOutput15Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput15Err, "Error parsing 'infoOnOffOutput15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput15)
		_ = infoOnOffOutput15 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput14)
		infoOnOffOutput14, _infoOnOffOutput14Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput14")
		if _infoOnOffOutput14Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput14Err, "Error parsing 'infoOnOffOutput14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput14)
		_ = infoOnOffOutput14 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput13)
		infoOnOffOutput13, _infoOnOffOutput13Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput13")
		if _infoOnOffOutput13Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput13Err, "Error parsing 'infoOnOffOutput13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput13)
		_ = infoOnOffOutput13 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput12)
		infoOnOffOutput12, _infoOnOffOutput12Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput12")
		if _infoOnOffOutput12Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput12Err, "Error parsing 'infoOnOffOutput12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput12)
		_ = infoOnOffOutput12 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput11)
		infoOnOffOutput11, _infoOnOffOutput11Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput11")
		if _infoOnOffOutput11Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput11Err, "Error parsing 'infoOnOffOutput11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput11)
		_ = infoOnOffOutput11 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput10)
		infoOnOffOutput10, _infoOnOffOutput10Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput10")
		if _infoOnOffOutput10Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput10Err, "Error parsing 'infoOnOffOutput10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput10)
		_ = infoOnOffOutput10 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput9)
		infoOnOffOutput9, _infoOnOffOutput9Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput9")
		if _infoOnOffOutput9Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput9Err, "Error parsing 'infoOnOffOutput9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput9)
		_ = infoOnOffOutput9 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput8)
		infoOnOffOutput8, _infoOnOffOutput8Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput8")
		if _infoOnOffOutput8Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput8Err, "Error parsing 'infoOnOffOutput8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput8)
		_ = infoOnOffOutput8 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput7)
		infoOnOffOutput7, _infoOnOffOutput7Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput7")
		if _infoOnOffOutput7Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput7Err, "Error parsing 'infoOnOffOutput7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput7)
		_ = infoOnOffOutput7 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput6)
		infoOnOffOutput6, _infoOnOffOutput6Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput6")
		if _infoOnOffOutput6Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput6Err, "Error parsing 'infoOnOffOutput6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput6)
		_ = infoOnOffOutput6 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput5)
		infoOnOffOutput5, _infoOnOffOutput5Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput5")
		if _infoOnOffOutput5Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput5Err, "Error parsing 'infoOnOffOutput5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput5)
		_ = infoOnOffOutput5 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput4)
		infoOnOffOutput4, _infoOnOffOutput4Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput4")
		if _infoOnOffOutput4Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput4Err, "Error parsing 'infoOnOffOutput4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput4)
		_ = infoOnOffOutput4 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput3)
		infoOnOffOutput3, _infoOnOffOutput3Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput3")
		if _infoOnOffOutput3Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput3Err, "Error parsing 'infoOnOffOutput3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput3)
		_ = infoOnOffOutput3 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput2)
		infoOnOffOutput2, _infoOnOffOutput2Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput2")
		if _infoOnOffOutput2Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput2Err, "Error parsing 'infoOnOffOutput2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput2)
		_ = infoOnOffOutput2 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (infoOnOffOutput1)
		infoOnOffOutput1, _infoOnOffOutput1Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("infoOnOffOutput1")
		if _infoOnOffOutput1Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput1Err, "Error parsing 'infoOnOffOutput1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput1)
		_ = infoOnOffOutput1 // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApparentEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_DPT_Channel_Activation_24: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		activationStateOfChannel1, _activationStateOfChannel1Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel1")
		if _activationStateOfChannel1Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel1Err, "Error parsing 'activationStateOfChannel1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel1)
		_ = activationStateOfChannel1 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel2)
		activationStateOfChannel2, _activationStateOfChannel2Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel2")
		if _activationStateOfChannel2Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel2Err, "Error parsing 'activationStateOfChannel2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel2)
		_ = activationStateOfChannel2 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel3)
		activationStateOfChannel3, _activationStateOfChannel3Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel3")
		if _activationStateOfChannel3Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel3Err, "Error parsing 'activationStateOfChannel3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel3)
		_ = activationStateOfChannel3 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel4)
		activationStateOfChannel4, _activationStateOfChannel4Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel4")
		if _activationStateOfChannel4Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel4Err, "Error parsing 'activationStateOfChannel4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel4)
		_ = activationStateOfChannel4 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel5)
		activationStateOfChannel5, _activationStateOfChannel5Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel5")
		if _activationStateOfChannel5Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel5Err, "Error parsing 'activationStateOfChannel5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel5)
		_ = activationStateOfChannel5 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel6)
		activationStateOfChannel6, _activationStateOfChannel6Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel6")
		if _activationStateOfChannel6Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel6Err, "Error parsing 'activationStateOfChannel6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel6)
		_ = activationStateOfChannel6 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel7)
		activationStateOfChannel7, _activationStateOfChannel7Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel7")
		if _activationStateOfChannel7Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel7Err, "Error parsing 'activationStateOfChannel7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel7)
		_ = activationStateOfChannel7 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel8)
		activationStateOfChannel8, _activationStateOfChannel8Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel8")
		if _activationStateOfChannel8Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel8Err, "Error parsing 'activationStateOfChannel8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel8)
		_ = activationStateOfChannel8 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel9)
		activationStateOfChannel9, _activationStateOfChannel9Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel9")
		if _activationStateOfChannel9Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel9Err, "Error parsing 'activationStateOfChannel9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel9)
		_ = activationStateOfChannel9 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel10)
		activationStateOfChannel10, _activationStateOfChannel10Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel10")
		if _activationStateOfChannel10Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel10Err, "Error parsing 'activationStateOfChannel10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel10)
		_ = activationStateOfChannel10 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel11)
		activationStateOfChannel11, _activationStateOfChannel11Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel11")
		if _activationStateOfChannel11Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel11Err, "Error parsing 'activationStateOfChannel11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel11)
		_ = activationStateOfChannel11 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel12)
		activationStateOfChannel12, _activationStateOfChannel12Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel12")
		if _activationStateOfChannel12Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel12Err, "Error parsing 'activationStateOfChannel12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel12)
		_ = activationStateOfChannel12 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel13)
		activationStateOfChannel13, _activationStateOfChannel13Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel13")
		if _activationStateOfChannel13Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel13Err, "Error parsing 'activationStateOfChannel13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel13)
		_ = activationStateOfChannel13 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel14)
		activationStateOfChannel14, _activationStateOfChannel14Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel14")
		if _activationStateOfChannel14Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel14Err, "Error parsing 'activationStateOfChannel14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel14)
		_ = activationStateOfChannel14 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel15)
		activationStateOfChannel15, _activationStateOfChannel15Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel15")
		if _activationStateOfChannel15Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel15Err, "Error parsing 'activationStateOfChannel15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel15)
		_ = activationStateOfChannel15 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel16)
		activationStateOfChannel16, _activationStateOfChannel16Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel16")
		if _activationStateOfChannel16Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel16Err, "Error parsing 'activationStateOfChannel16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel16)
		_ = activationStateOfChannel16 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel17)
		activationStateOfChannel17, _activationStateOfChannel17Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel17")
		if _activationStateOfChannel17Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel17Err, "Error parsing 'activationStateOfChannel17' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel17)
		_ = activationStateOfChannel17 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel18)
		activationStateOfChannel18, _activationStateOfChannel18Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel18")
		if _activationStateOfChannel18Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel18Err, "Error parsing 'activationStateOfChannel18' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel18)
		_ = activationStateOfChannel18 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel19)
		activationStateOfChannel19, _activationStateOfChannel19Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel19")
		if _activationStateOfChannel19Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel19Err, "Error parsing 'activationStateOfChannel19' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel19)
		_ = activationStateOfChannel19 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel20)
		activationStateOfChannel20, _activationStateOfChannel20Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel20")
		if _activationStateOfChannel20Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel20Err, "Error parsing 'activationStateOfChannel20' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel20)
		_ = activationStateOfChannel20 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel21)
		activationStateOfChannel21, _activationStateOfChannel21Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel21")
		if _activationStateOfChannel21Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel21Err, "Error parsing 'activationStateOfChannel21' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel21)
		_ = activationStateOfChannel21 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel22)
		activationStateOfChannel22, _activationStateOfChannel22Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel22")
		if _activationStateOfChannel22Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel22Err, "Error parsing 'activationStateOfChannel22' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel22)
		_ = activationStateOfChannel22 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel23)
		activationStateOfChannel23, _activationStateOfChannel23Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel23")
		if _activationStateOfChannel23Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel23Err, "Error parsing 'activationStateOfChannel23' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel23)
		_ = activationStateOfChannel23 // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (activationStateOfChannel24)
		activationStateOfChannel24, _activationStateOfChannel24Err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("activationStateOfChannel24")
		if _activationStateOfChannel24Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel24Err, "Error parsing 'activationStateOfChannel24' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel24)
		_ = activationStateOfChannel24 // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_HVACModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)
		_ = delayTimeMin // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hvacMode)
		hvacMode, _hvacModeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("hvacMode", 8)
		if _hvacModeErr != nil {
			return nil, errors.Wrap(_hvacModeErr, "Error parsing 'hvacMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hvacMode)
		_ = hvacMode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DHWModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)
		_ = delayTimeMin // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dhwMode)
		dhwMode, _dhwModeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("dhwMode", 8)
		if _dhwModeErr != nil {
			return nil, errors.Wrap(_dhwModeErr, "Error parsing 'dhwMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dhwMode)
		_ = dhwMode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_OccModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)
		_ = delayTimeMin // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (occupancyMode)
		occupancyMode, _occupancyModeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("occupancyMode", 8)
		if _occupancyModeErr != nil {
			return nil, errors.Wrap(_occupancyModeErr, "Error parsing 'occupancyMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(occupancyMode)
		_ = occupancyMode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_BuildingModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)
		_ = delayTimeMin // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (buildingMode)
		buildingMode, _buildingModeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("buildingMode", 8)
		if _buildingModeErr != nil {
			return nil, errors.Wrap(_buildingModeErr, "Error parsing 'buildingMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(buildingMode)
		_ = buildingMode // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusLightingActuator: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validactualvalue)
		validactualvalue, _validactualvalueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validactualvalue")
		if _validactualvalueErr != nil {
			return nil, errors.Wrap(_validactualvalueErr, "Error parsing 'validactualvalue' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validactualvalue)
		_ = validactualvalue // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (locked)
		locked, _lockedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("locked")
		if _lockedErr != nil {
			return nil, errors.Wrap(_lockedErr, "Error parsing 'locked' field")
		}
		_map["Struct"] = values.NewPlcBOOL(locked)
		_ = locked // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (forced)
		forced, _forcedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("forced")
		if _forcedErr != nil {
			return nil, errors.Wrap(_forcedErr, "Error parsing 'forced' field")
		}
		_map["Struct"] = values.NewPlcBOOL(forced)
		_ = forced // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (nightmodeactive)
		nightmodeactive, _nightmodeactiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("nightmodeactive")
		if _nightmodeactiveErr != nil {
			return nil, errors.Wrap(_nightmodeactiveErr, "Error parsing 'nightmodeactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(nightmodeactive)
		_ = nightmodeactive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (staircaselightingFunction)
		staircaselightingFunction, _staircaselightingFunctionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("staircaselightingFunction")
		if _staircaselightingFunctionErr != nil {
			return nil, errors.Wrap(_staircaselightingFunctionErr, "Error parsing 'staircaselightingFunction' field")
		}
		_map["Struct"] = values.NewPlcBOOL(staircaselightingFunction)
		_ = staircaselightingFunction // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (dimming)
		dimming, _dimmingErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("dimming")
		if _dimmingErr != nil {
			return nil, errors.Wrap(_dimmingErr, "Error parsing 'dimming' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dimming)
		_ = dimming // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (localoverride)
		localoverride, _localoverrideErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("localoverride")
		if _localoverrideErr != nil {
			return nil, errors.Wrap(_localoverrideErr, "Error parsing 'localoverride' field")
		}
		_map["Struct"] = values.NewPlcBOOL(localoverride)
		_ = localoverride // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (failure)
		failure, _failureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("failure")
		if _failureErr != nil {
			return nil, errors.Wrap(_failureErr, "Error parsing 'failure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(failure)
		_ = failure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (actualvalue)
		actualvalue, _actualvalueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("actualvalue", 8)
		if _actualvalueErr != nil {
			return nil, errors.Wrap(_actualvalueErr, "Error parsing 'actualvalue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(actualvalue)
		_ = actualvalue // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Version: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (magicNumber)
		magicNumber, _magicNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("magicNumber", 5)
		if _magicNumberErr != nil {
			return nil, errors.Wrap(_magicNumberErr, "Error parsing 'magicNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(magicNumber)
		_ = magicNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (versionNumber)
		versionNumber, _versionNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("versionNumber", 5)
		if _versionNumberErr != nil {
			return nil, errors.Wrap(_versionNumberErr, "Error parsing 'versionNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(versionNumber)
		_ = versionNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (revisionNumber)
		revisionNumber, _revisionNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("revisionNumber", 6)
		if _revisionNumberErr != nil {
			return nil, errors.Wrap(_revisionNumberErr, "Error parsing 'revisionNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(revisionNumber)
		_ = revisionNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_AlarmInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (logNumber)
		logNumber, _logNumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("logNumber", 8)
		if _logNumberErr != nil {
			return nil, errors.Wrap(_logNumberErr, "Error parsing 'logNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(logNumber)
		_ = logNumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (alarmPriority)
		alarmPriority, _alarmPriorityErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("alarmPriority", 8)
		if _alarmPriorityErr != nil {
			return nil, errors.Wrap(_alarmPriorityErr, "Error parsing 'alarmPriority' field")
		}
		_map["Struct"] = values.NewPlcUSINT(alarmPriority)
		_ = alarmPriority // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (applicationArea)
		applicationArea, _applicationAreaErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("applicationArea", 8)
		if _applicationAreaErr != nil {
			return nil, errors.Wrap(_applicationAreaErr, "Error parsing 'applicationArea' field")
		}
		_map["Struct"] = values.NewPlcUSINT(applicationArea)
		_ = applicationArea // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (errorClass)
		errorClass, _errorClassErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("errorClass", 8)
		if _errorClassErr != nil {
			return nil, errors.Wrap(_errorClassErr, "Error parsing 'errorClass' field")
		}
		_map["Struct"] = values.NewPlcUSINT(errorClass)
		_ = errorClass // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (errorcodeSup)
		errorcodeSup, _errorcodeSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("errorcodeSup")
		if _errorcodeSupErr != nil {
			return nil, errors.Wrap(_errorcodeSupErr, "Error parsing 'errorcodeSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(errorcodeSup)
		_ = errorcodeSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (alarmtextSup)
		alarmtextSup, _alarmtextSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("alarmtextSup")
		if _alarmtextSupErr != nil {
			return nil, errors.Wrap(_alarmtextSupErr, "Error parsing 'alarmtextSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmtextSup)
		_ = alarmtextSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (timestampSup)
		timestampSup, _timestampSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("timestampSup")
		if _timestampSupErr != nil {
			return nil, errors.Wrap(_timestampSupErr, "Error parsing 'timestampSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(timestampSup)
		_ = timestampSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (ackSup)
		ackSup, _ackSupErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("ackSup")
		if _ackSupErr != nil {
			return nil, errors.Wrap(_ackSupErr, "Error parsing 'ackSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ackSup)
		_ = ackSup // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (locked)
		locked, _lockedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("locked")
		if _lockedErr != nil {
			return nil, errors.Wrap(_lockedErr, "Error parsing 'locked' field")
		}
		_map["Struct"] = values.NewPlcBOOL(locked)
		_ = locked // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (alarmunack)
		alarmunack, _alarmunackErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("alarmunack")
		if _alarmunackErr != nil {
			return nil, errors.Wrap(_alarmunackErr, "Error parsing 'alarmunack' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmunack)
		_ = alarmunack // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (inalarm)
		inalarm, _inalarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("inalarm")
		if _inalarmErr != nil {
			return nil, errors.Wrap(_inalarmErr, "Error parsing 'inalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(inalarm)
		_ = inalarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_3: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (tempsetpcomf)
		tempsetpcomf, _tempsetpcomfErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("tempsetpcomf", 16)
		if _tempsetpcomfErr != nil {
			return nil, errors.Wrap(_tempsetpcomfErr, "Error parsing 'tempsetpcomf' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpcomf)
		_ = tempsetpcomf // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempsetpstdby)
		tempsetpstdby, _tempsetpstdbyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("tempsetpstdby", 16)
		if _tempsetpstdbyErr != nil {
			return nil, errors.Wrap(_tempsetpstdbyErr, "Error parsing 'tempsetpstdby' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpstdby)
		_ = tempsetpstdby // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempsetpeco)
		tempsetpeco, _tempsetpecoErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("tempsetpeco", 16)
		if _tempsetpecoErr != nil {
			return nil, errors.Wrap(_tempsetpecoErr, "Error parsing 'tempsetpeco' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpeco)
		_ = tempsetpeco // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_3: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (tempsetpshiftcomf)
		tempsetpshiftcomf, _tempsetpshiftcomfErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("tempsetpshiftcomf", 16)
		if _tempsetpshiftcomfErr != nil {
			return nil, errors.Wrap(_tempsetpshiftcomfErr, "Error parsing 'tempsetpshiftcomf' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpshiftcomf)
		_ = tempsetpshiftcomf // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempsetpshiftstdby)
		tempsetpshiftstdby, _tempsetpshiftstdbyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("tempsetpshiftstdby", 16)
		if _tempsetpshiftstdbyErr != nil {
			return nil, errors.Wrap(_tempsetpshiftstdbyErr, "Error parsing 'tempsetpshiftstdby' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpshiftstdby)
		_ = tempsetpshiftstdby // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tempsetpshifteco)
		tempsetpshifteco, _tempsetpshiftecoErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("tempsetpshifteco", 16)
		if _tempsetpshiftecoErr != nil {
			return nil, errors.Wrap(_tempsetpshiftecoErr, "Error parsing 'tempsetpshifteco' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpshifteco)
		_ = tempsetpshifteco // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Scaling_Speed: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (timePeriod)
		timePeriod, _timePeriodErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("timePeriod", 16)
		if _timePeriodErr != nil {
			return nil, errors.Wrap(_timePeriodErr, "Error parsing 'timePeriod' field")
		}
		_map["Struct"] = values.NewPlcUINT(timePeriod)
		_ = timePeriod // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (percent)
		percent, _percentErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("percent", 8)
		if _percentErr != nil {
			return nil, errors.Wrap(_percentErr, "Error parsing 'percent' field")
		}
		_map["Struct"] = values.NewPlcUSINT(percent)
		_ = percent // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Scaling_Step_Time: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (timePeriod)
		timePeriod, _timePeriodErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("timePeriod", 16)
		if _timePeriodErr != nil {
			return nil, errors.Wrap(_timePeriodErr, "Error parsing 'timePeriod' field")
		}
		_map["Struct"] = values.NewPlcUINT(timePeriod)
		_ = timePeriod // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (percent)
		percent, _percentErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("percent", 8)
		if _percentErr != nil {
			return nil, errors.Wrap(_percentErr, "Error parsing 'percent' field")
		}
		_map["Struct"] = values.NewPlcUSINT(percent)
		_ = percent // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_MeteringValue: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (countval)
		countval, _countvalErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("countval", 32)
		if _countvalErr != nil {
			return nil, errors.Wrap(_countvalErr, "Error parsing 'countval' field")
		}
		_map["Struct"] = values.NewPlcDINT(countval)
		_ = countval // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (valinffield)
		valinffield, _valinffieldErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("valinffield", 8)
		if _valinffieldErr != nil {
			return nil, errors.Wrap(_valinffieldErr, "Error parsing 'valinffield' field")
		}
		_map["Struct"] = values.NewPlcUSINT(valinffield)
		_ = valinffield // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (alarmunack)
		alarmunack, _alarmunackErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("alarmunack")
		if _alarmunackErr != nil {
			return nil, errors.Wrap(_alarmunackErr, "Error parsing 'alarmunack' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmunack)
		_ = alarmunack // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (inalarm)
		inalarm, _inalarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("inalarm")
		if _inalarmErr != nil {
			return nil, errors.Wrap(_inalarmErr, "Error parsing 'inalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(inalarm)
		_ = inalarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (overridden)
		overridden, _overriddenErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("overridden")
		if _overriddenErr != nil {
			return nil, errors.Wrap(_overriddenErr, "Error parsing 'overridden' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overridden)
		_ = overridden // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (fault)
		fault, _faultErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		_ = fault // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (outofservice)
		outofservice, _outofserviceErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("outofservice")
		if _outofserviceErr != nil {
			return nil, errors.Wrap(_outofserviceErr, "Error parsing 'outofservice' field")
		}
		_map["Struct"] = values.NewPlcBOOL(outofservice)
		_ = outofservice // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_MBus_Address: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (manufactid)
		manufactid, _manufactidErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("manufactid", 16)
		if _manufactidErr != nil {
			return nil, errors.Wrap(_manufactidErr, "Error parsing 'manufactid' field")
		}
		_map["Struct"] = values.NewPlcUINT(manufactid)
		_ = manufactid // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (identnumber)
		identnumber, _identnumberErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("identnumber", 32)
		if _identnumberErr != nil {
			return nil, errors.Wrap(_identnumberErr, "Error parsing 'identnumber' field")
		}
		_map["Struct"] = values.NewPlcUDINT(identnumber)
		_ = identnumber // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (version)
		version, _versionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("version", 8)
		if _versionErr != nil {
			return nil, errors.Wrap(_versionErr, "Error parsing 'version' field")
		}
		_map["Struct"] = values.NewPlcUSINT(version)
		_ = version // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (medium)
		medium, _mediumErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("medium", 8)
		if _mediumErr != nil {
			return nil, errors.Wrap(_mediumErr, "Error parsing 'medium' field")
		}
		_map["Struct"] = values.NewPlcUSINT(medium)
		_ = medium // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Colour_RGB: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (r)
		r, _rErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("r", 8)
		if _rErr != nil {
			return nil, errors.Wrap(_rErr, "Error parsing 'r' field")
		}
		_map["Struct"] = values.NewPlcUSINT(r)
		_ = r // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (g)
		g, _gErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("g", 8)
		if _gErr != nil {
			return nil, errors.Wrap(_gErr, "Error parsing 'g' field")
		}
		_map["Struct"] = values.NewPlcUSINT(g)
		_ = g // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (b)
		b, _bErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("b", 8)
		if _bErr != nil {
			return nil, errors.Wrap(_bErr, "Error parsing 'b' field")
		}
		_map["Struct"] = values.NewPlcUSINT(b)
		_ = b // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_LanguageCodeAlpha2_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadString("value", uint32(16), utils.WithEncoding("ASCII"))
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		_ = value // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_Tariff_ActiveEnergy: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activeelectricalenergy)
		activeelectricalenergy, _activeelectricalenergyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("activeelectricalenergy", 32)
		if _activeelectricalenergyErr != nil {
			return nil, errors.Wrap(_activeelectricalenergyErr, "Error parsing 'activeelectricalenergy' field")
		}
		_map["Struct"] = values.NewPlcDINT(activeelectricalenergy)
		_ = activeelectricalenergy // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tariff)
		tariff, _tariffErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("tariff", 8)
		if _tariffErr != nil {
			return nil, errors.Wrap(_tariffErr, "Error parsing 'tariff' field")
		}
		_map["Struct"] = values.NewPlcUSINT(tariff)
		_ = tariff // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (electricalengergyvalidity)
		electricalengergyvalidity, _electricalengergyvalidityErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("electricalengergyvalidity")
		if _electricalengergyvalidityErr != nil {
			return nil, errors.Wrap(_electricalengergyvalidityErr, "Error parsing 'electricalengergyvalidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(electricalengergyvalidity)
		_ = electricalengergyvalidity // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (tariffvalidity)
		tariffvalidity, _tariffvalidityErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("tariffvalidity")
		if _tariffvalidityErr != nil {
			return nil, errors.Wrap(_tariffvalidityErr, "Error parsing 'tariffvalidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tariffvalidity)
		_ = tariffvalidity // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Prioritised_Mode_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (deactivationOfPriority)
		deactivationOfPriority, _deactivationOfPriorityErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("deactivationOfPriority")
		if _deactivationOfPriorityErr != nil {
			return nil, errors.Wrap(_deactivationOfPriorityErr, "Error parsing 'deactivationOfPriority' field")
		}
		_map["Struct"] = values.NewPlcBOOL(deactivationOfPriority)
		_ = deactivationOfPriority // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (priorityLevel)
		priorityLevel, _priorityLevelErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("priorityLevel", 3)
		if _priorityLevelErr != nil {
			return nil, errors.Wrap(_priorityLevelErr, "Error parsing 'priorityLevel' field")
		}
		_map["Struct"] = values.NewPlcUSINT(priorityLevel)
		_ = priorityLevel // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (modeLevel)
		modeLevel, _modeLevelErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("modeLevel", 4)
		if _modeLevelErr != nil {
			return nil, errors.Wrap(_modeLevelErr, "Error parsing 'modeLevel' field")
		}
		_map["Struct"] = values.NewPlcUSINT(modeLevel)
		_ = modeLevel // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DALI_Control_Gear_Diagnostic: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (convertorError)
		convertorError, _convertorErrorErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("convertorError")
		if _convertorErrorErr != nil {
			return nil, errors.Wrap(_convertorErrorErr, "Error parsing 'convertorError' field")
		}
		_map["Struct"] = values.NewPlcBOOL(convertorError)
		_ = convertorError // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (ballastFailure)
		ballastFailure, _ballastFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("ballastFailure")
		if _ballastFailureErr != nil {
			return nil, errors.Wrap(_ballastFailureErr, "Error parsing 'ballastFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ballastFailure)
		_ = ballastFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (lampFailure)
		lampFailure, _lampFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("lampFailure")
		if _lampFailureErr != nil {
			return nil, errors.Wrap(_lampFailureErr, "Error parsing 'lampFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lampFailure)
		_ = lampFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (readOrResponse)
		readOrResponse, _readOrResponseErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("readOrResponse")
		if _readOrResponseErr != nil {
			return nil, errors.Wrap(_readOrResponseErr, "Error parsing 'readOrResponse' field")
		}
		_map["Struct"] = values.NewPlcBOOL(readOrResponse)
		_ = readOrResponse // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (addressIndicator)
		addressIndicator, _addressIndicatorErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("addressIndicator")
		if _addressIndicatorErr != nil {
			return nil, errors.Wrap(_addressIndicatorErr, "Error parsing 'addressIndicator' field")
		}
		_map["Struct"] = values.NewPlcBOOL(addressIndicator)
		_ = addressIndicator // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (daliDeviceAddressOrDaliGroupAddress)
		daliDeviceAddressOrDaliGroupAddress, _daliDeviceAddressOrDaliGroupAddressErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("daliDeviceAddressOrDaliGroupAddress", 6)
		if _daliDeviceAddressOrDaliGroupAddressErr != nil {
			return nil, errors.Wrap(_daliDeviceAddressOrDaliGroupAddressErr, "Error parsing 'daliDeviceAddressOrDaliGroupAddress' field")
		}
		_map["Struct"] = values.NewPlcUSINT(daliDeviceAddressOrDaliGroupAddress)
		_ = daliDeviceAddressOrDaliGroupAddress // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DALI_Diagnostics: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ballastFailure)
		ballastFailure, _ballastFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("ballastFailure")
		if _ballastFailureErr != nil {
			return nil, errors.Wrap(_ballastFailureErr, "Error parsing 'ballastFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ballastFailure)
		_ = ballastFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (lampFailure)
		lampFailure, _lampFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("lampFailure")
		if _lampFailureErr != nil {
			return nil, errors.Wrap(_lampFailureErr, "Error parsing 'lampFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lampFailure)
		_ = lampFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (deviceAddress)
		deviceAddress, _deviceAddressErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("deviceAddress", 6)
		if _deviceAddressErr != nil {
			return nil, errors.Wrap(_deviceAddressErr, "Error parsing 'deviceAddress' field")
		}
		_map["Struct"] = values.NewPlcUSINT(deviceAddress)
		_ = deviceAddress // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedPosition: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (heightPosition)
		heightPosition, _heightPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("heightPosition", 8)
		if _heightPositionErr != nil {
			return nil, errors.Wrap(_heightPositionErr, "Error parsing 'heightPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(heightPosition)
		_ = heightPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (slatsPosition)
		slatsPosition, _slatsPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("slatsPosition", 8)
		if _slatsPositionErr != nil {
			return nil, errors.Wrap(_slatsPositionErr, "Error parsing 'slatsPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(slatsPosition)
		_ = slatsPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validitySlatsPosition)
		validitySlatsPosition, _validitySlatsPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validitySlatsPosition")
		if _validitySlatsPositionErr != nil {
			return nil, errors.Wrap(_validitySlatsPositionErr, "Error parsing 'validitySlatsPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validitySlatsPosition)
		_ = validitySlatsPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (validityHeightPosition)
		validityHeightPosition, _validityHeightPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validityHeightPosition")
		if _validityHeightPositionErr != nil {
			return nil, errors.Wrap(_validityHeightPositionErr, "Error parsing 'validityHeightPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityHeightPosition)
		_ = validityHeightPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusSAB: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (heightPosition)
		heightPosition, _heightPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("heightPosition", 8)
		if _heightPositionErr != nil {
			return nil, errors.Wrap(_heightPositionErr, "Error parsing 'heightPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(heightPosition)
		_ = heightPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (slatsPosition)
		slatsPosition, _slatsPositionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("slatsPosition", 8)
		if _slatsPositionErr != nil {
			return nil, errors.Wrap(_slatsPositionErr, "Error parsing 'slatsPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(slatsPosition)
		_ = slatsPosition // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (upperEndPosReached)
		upperEndPosReached, _upperEndPosReachedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("upperEndPosReached")
		if _upperEndPosReachedErr != nil {
			return nil, errors.Wrap(_upperEndPosReachedErr, "Error parsing 'upperEndPosReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(upperEndPosReached)
		_ = upperEndPosReached // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (lowerEndPosReached)
		lowerEndPosReached, _lowerEndPosReachedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("lowerEndPosReached")
		if _lowerEndPosReachedErr != nil {
			return nil, errors.Wrap(_lowerEndPosReachedErr, "Error parsing 'lowerEndPosReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lowerEndPosReached)
		_ = lowerEndPosReached // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
		lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent, _lowerPredefPosReachedTypHeight100PercentSlatsAngle100PercentErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent")
		if _lowerPredefPosReachedTypHeight100PercentSlatsAngle100PercentErr != nil {
			return nil, errors.Wrap(_lowerPredefPosReachedTypHeight100PercentSlatsAngle100PercentErr, "Error parsing 'lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
		_ = lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (targetPosDrive)
		targetPosDrive, _targetPosDriveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("targetPosDrive")
		if _targetPosDriveErr != nil {
			return nil, errors.Wrap(_targetPosDriveErr, "Error parsing 'targetPosDrive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(targetPosDrive)
		_ = targetPosDrive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
		restrictionOfTargetHeightPosPosCanNotBeReached, _restrictionOfTargetHeightPosPosCanNotBeReachedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("restrictionOfTargetHeightPosPosCanNotBeReached")
		if _restrictionOfTargetHeightPosPosCanNotBeReachedErr != nil {
			return nil, errors.Wrap(_restrictionOfTargetHeightPosPosCanNotBeReachedErr, "Error parsing 'restrictionOfTargetHeightPosPosCanNotBeReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(restrictionOfTargetHeightPosPosCanNotBeReached)
		_ = restrictionOfTargetHeightPosPosCanNotBeReached // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
		restrictionOfSlatsHeightPosPosCanNotBeReached, _restrictionOfSlatsHeightPosPosCanNotBeReachedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("restrictionOfSlatsHeightPosPosCanNotBeReached")
		if _restrictionOfSlatsHeightPosPosCanNotBeReachedErr != nil {
			return nil, errors.Wrap(_restrictionOfSlatsHeightPosPosCanNotBeReachedErr, "Error parsing 'restrictionOfSlatsHeightPosPosCanNotBeReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(restrictionOfSlatsHeightPosPosCanNotBeReached)
		_ = restrictionOfSlatsHeightPosPosCanNotBeReached // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
		atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm, _atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarmErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm")
		if _atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarmErr != nil {
			return nil, errors.Wrap(_atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarmErr, "Error parsing 'atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
		_ = atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
		upDownPositionIsForcedByMoveupdownforcedInput, _upDownPositionIsForcedByMoveupdownforcedInputErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("upDownPositionIsForcedByMoveupdownforcedInput")
		if _upDownPositionIsForcedByMoveupdownforcedInputErr != nil {
			return nil, errors.Wrap(_upDownPositionIsForcedByMoveupdownforcedInputErr, "Error parsing 'upDownPositionIsForcedByMoveupdownforcedInput' field")
		}
		_map["Struct"] = values.NewPlcBOOL(upDownPositionIsForcedByMoveupdownforcedInput)
		_ = upDownPositionIsForcedByMoveupdownforcedInput // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (movementIsLockedEGByDevicelockedInput)
		movementIsLockedEGByDevicelockedInput, _movementIsLockedEGByDevicelockedInputErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("movementIsLockedEGByDevicelockedInput")
		if _movementIsLockedEGByDevicelockedInputErr != nil {
			return nil, errors.Wrap(_movementIsLockedEGByDevicelockedInputErr, "Error parsing 'movementIsLockedEGByDevicelockedInput' field")
		}
		_map["Struct"] = values.NewPlcBOOL(movementIsLockedEGByDevicelockedInput)
		_ = movementIsLockedEGByDevicelockedInput // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
		actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface, _actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterfaceErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface")
		if _actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterfaceErr != nil {
			return nil, errors.Wrap(_actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterfaceErr, "Error parsing 'actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface' field")
		}
		_map["Struct"] = values.NewPlcBOOL(actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
		_ = actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (generalFailureOfTheActuatorOrTheDrive)
		generalFailureOfTheActuatorOrTheDrive, _generalFailureOfTheActuatorOrTheDriveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("generalFailureOfTheActuatorOrTheDrive")
		if _generalFailureOfTheActuatorOrTheDriveErr != nil {
			return nil, errors.Wrap(_generalFailureOfTheActuatorOrTheDriveErr, "Error parsing 'generalFailureOfTheActuatorOrTheDrive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(generalFailureOfTheActuatorOrTheDrive)
		_ = generalFailureOfTheActuatorOrTheDrive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validityHeightPos)
		validityHeightPos, _validityHeightPosErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validityHeightPos")
		if _validityHeightPosErr != nil {
			return nil, errors.Wrap(_validityHeightPosErr, "Error parsing 'validityHeightPos' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityHeightPos)
		_ = validityHeightPos // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (validitySlatsPos)
		validitySlatsPos, _validitySlatsPosErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validitySlatsPos")
		if _validitySlatsPosErr != nil {
			return nil, errors.Wrap(_validitySlatsPosErr, "Error parsing 'validitySlatsPos' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validitySlatsPos)
		_ = validitySlatsPos // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Colour_xyY: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (xAxis)
		xAxis, _xAxisErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("xAxis", 16)
		if _xAxisErr != nil {
			return nil, errors.Wrap(_xAxisErr, "Error parsing 'xAxis' field")
		}
		_map["Struct"] = values.NewPlcUINT(xAxis)
		_ = xAxis // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (yAxis)
		yAxis, _yAxisErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("yAxis", 16)
		if _yAxisErr != nil {
			return nil, errors.Wrap(_yAxisErr, "Error parsing 'yAxis' field")
		}
		_map["Struct"] = values.NewPlcUINT(yAxis)
		_ = yAxis // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (brightness)
		brightness, _brightnessErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("brightness", 8)
		if _brightnessErr != nil {
			return nil, errors.Wrap(_brightnessErr, "Error parsing 'brightness' field")
		}
		_map["Struct"] = values.NewPlcUSINT(brightness)
		_ = brightness // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validityXy)
		validityXy, _validityXyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validityXy")
		if _validityXyErr != nil {
			return nil, errors.Wrap(_validityXyErr, "Error parsing 'validityXy' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityXy)
		_ = validityXy // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (validityBrightness)
		validityBrightness, _validityBrightnessErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validityBrightness")
		if _validityBrightnessErr != nil {
			return nil, errors.Wrap(_validityBrightnessErr, "Error parsing 'validityBrightness' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityBrightness)
		_ = validityBrightness // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Converter_Status: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
		converterModeAccordingToTheDaliConverterStateMachine, _converterModeAccordingToTheDaliConverterStateMachineErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("converterModeAccordingToTheDaliConverterStateMachine", 4)
		if _converterModeAccordingToTheDaliConverterStateMachineErr != nil {
			return nil, errors.Wrap(_converterModeAccordingToTheDaliConverterStateMachineErr, "Error parsing 'converterModeAccordingToTheDaliConverterStateMachine' field")
		}
		_map["Struct"] = values.NewPlcUSINT(converterModeAccordingToTheDaliConverterStateMachine)
		_ = converterModeAccordingToTheDaliConverterStateMachine // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (hardwiredSwitchIsActive)
		hardwiredSwitchIsActive, _hardwiredSwitchIsActiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("hardwiredSwitchIsActive")
		if _hardwiredSwitchIsActiveErr != nil {
			return nil, errors.Wrap(_hardwiredSwitchIsActiveErr, "Error parsing 'hardwiredSwitchIsActive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(hardwiredSwitchIsActive)
		_ = hardwiredSwitchIsActive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (hardwiredInhibitIsActive)
		hardwiredInhibitIsActive, _hardwiredInhibitIsActiveErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("hardwiredInhibitIsActive")
		if _hardwiredInhibitIsActiveErr != nil {
			return nil, errors.Wrap(_hardwiredInhibitIsActiveErr, "Error parsing 'hardwiredInhibitIsActive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(hardwiredInhibitIsActive)
		_ = hardwiredInhibitIsActive // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (functionTestPending)
		functionTestPending, _functionTestPendingErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("functionTestPending", 2)
		if _functionTestPendingErr != nil {
			return nil, errors.Wrap(_functionTestPendingErr, "Error parsing 'functionTestPending' field")
		}
		_map["Struct"] = values.NewPlcUSINT(functionTestPending)
		_ = functionTestPending // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (durationTestPending)
		durationTestPending, _durationTestPendingErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("durationTestPending", 2)
		if _durationTestPendingErr != nil {
			return nil, errors.Wrap(_durationTestPendingErr, "Error parsing 'durationTestPending' field")
		}
		_map["Struct"] = values.NewPlcUSINT(durationTestPending)
		_ = durationTestPending // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (partialDurationTestPending)
		partialDurationTestPending, _partialDurationTestPendingErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("partialDurationTestPending", 2)
		if _partialDurationTestPendingErr != nil {
			return nil, errors.Wrap(_partialDurationTestPendingErr, "Error parsing 'partialDurationTestPending' field")
		}
		_map["Struct"] = values.NewPlcUSINT(partialDurationTestPending)
		_ = partialDurationTestPending // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (converterFailure)
		converterFailure, _converterFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("converterFailure", 2)
		if _converterFailureErr != nil {
			return nil, errors.Wrap(_converterFailureErr, "Error parsing 'converterFailure' field")
		}
		_map["Struct"] = values.NewPlcUSINT(converterFailure)
		_ = converterFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Converter_Test_Result: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ltrf)
		ltrf, _ltrfErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("ltrf", 4)
		if _ltrfErr != nil {
			return nil, errors.Wrap(_ltrfErr, "Error parsing 'ltrf' field")
		}
		_map["Struct"] = values.NewPlcUSINT(ltrf)
		_ = ltrf // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (ltrd)
		ltrd, _ltrdErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("ltrd", 4)
		if _ltrdErr != nil {
			return nil, errors.Wrap(_ltrdErr, "Error parsing 'ltrd' field")
		}
		_map["Struct"] = values.NewPlcUSINT(ltrd)
		_ = ltrd // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (ltrp)
		ltrp, _ltrpErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("ltrp", 4)
		if _ltrpErr != nil {
			return nil, errors.Wrap(_ltrpErr, "Error parsing 'ltrp' field")
		}
		_map["Struct"] = values.NewPlcUSINT(ltrp)
		_ = ltrp // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (sf)
		sf, _sfErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("sf", 2)
		if _sfErr != nil {
			return nil, errors.Wrap(_sfErr, "Error parsing 'sf' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sf)
		_ = sf // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (sd)
		sd, _sdErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("sd", 2)
		if _sdErr != nil {
			return nil, errors.Wrap(_sdErr, "Error parsing 'sd' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sd)
		_ = sd // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (sp)
		sp, _spErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("sp", 2)
		if _spErr != nil {
			return nil, errors.Wrap(_spErr, "Error parsing 'sp' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sp)
		_ = sp // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ldtr)
		ldtr, _ldtrErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("ldtr", 16)
		if _ldtrErr != nil {
			return nil, errors.Wrap(_ldtrErr, "Error parsing 'ldtr' field")
		}
		_map["Struct"] = values.NewPlcUINT(ldtr)
		_ = ldtr // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (lpdtr)
		lpdtr, _lpdtrErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("lpdtr", 8)
		if _lpdtrErr != nil {
			return nil, errors.Wrap(_lpdtrErr, "Error parsing 'lpdtr' field")
		}
		_map["Struct"] = values.NewPlcUSINT(lpdtr)
		_ = lpdtr // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Battery_Info: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (batteryFailure)
		batteryFailure, _batteryFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("batteryFailure")
		if _batteryFailureErr != nil {
			return nil, errors.Wrap(_batteryFailureErr, "Error parsing 'batteryFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(batteryFailure)
		_ = batteryFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (batteryDurationFailure)
		batteryDurationFailure, _batteryDurationFailureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("batteryDurationFailure")
		if _batteryDurationFailureErr != nil {
			return nil, errors.Wrap(_batteryDurationFailureErr, "Error parsing 'batteryDurationFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(batteryDurationFailure)
		_ = batteryDurationFailure // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (batteryFullyCharged)
		batteryFullyCharged, _batteryFullyChargedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("batteryFullyCharged")
		if _batteryFullyChargedErr != nil {
			return nil, errors.Wrap(_batteryFullyChargedErr, "Error parsing 'batteryFullyCharged' field")
		}
		_map["Struct"] = values.NewPlcBOOL(batteryFullyCharged)
		_ = batteryFullyCharged // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (batteryChargeLevel)
		batteryChargeLevel, _batteryChargeLevelErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("batteryChargeLevel", 8)
		if _batteryChargeLevelErr != nil {
			return nil, errors.Wrap(_batteryChargeLevelErr, "Error parsing 'batteryChargeLevel' field")
		}
		_map["Struct"] = values.NewPlcUSINT(batteryChargeLevel)
		_ = batteryChargeLevel // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Transition: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ms)
		ms, _msErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("ms", 16)
		if _msErr != nil {
			return nil, errors.Wrap(_msErr, "Error parsing 'ms' field")
		}
		_map["Struct"] = values.NewPlcUINT(ms)
		_ = ms // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (temperatureK)
		temperatureK, _temperatureKErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint16("temperatureK", 16)
		if _temperatureKErr != nil {
			return nil, errors.Wrap(_temperatureKErr, "Error parsing 'temperatureK' field")
		}
		_map["Struct"] = values.NewPlcUINT(temperatureK)
		_ = temperatureK // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (percent)
		percent, _percentErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("percent", 8)
		if _percentErr != nil {
			return nil, errors.Wrap(_percentErr, "Error parsing 'percent' field")
		}
		_map["Struct"] = values.NewPlcUSINT(percent)
		_ = percent // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validityOfTheTimePeriod)
		validityOfTheTimePeriod, _validityOfTheTimePeriodErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validityOfTheTimePeriod")
		if _validityOfTheTimePeriodErr != nil {
			return nil, errors.Wrap(_validityOfTheTimePeriodErr, "Error parsing 'validityOfTheTimePeriod' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityOfTheTimePeriod)
		_ = validityOfTheTimePeriod // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (validityOfTheAbsoluteColourTemperature)
		validityOfTheAbsoluteColourTemperature, _validityOfTheAbsoluteColourTemperatureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validityOfTheAbsoluteColourTemperature")
		if _validityOfTheAbsoluteColourTemperatureErr != nil {
			return nil, errors.Wrap(_validityOfTheAbsoluteColourTemperatureErr, "Error parsing 'validityOfTheAbsoluteColourTemperature' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityOfTheAbsoluteColourTemperature)
		_ = validityOfTheAbsoluteColourTemperature // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (validityOfTheAbsoluteBrightness)
		validityOfTheAbsoluteBrightness, _validityOfTheAbsoluteBrightnessErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("validityOfTheAbsoluteBrightness")
		if _validityOfTheAbsoluteBrightnessErr != nil {
			return nil, errors.Wrap(_validityOfTheAbsoluteBrightnessErr, "Error parsing 'validityOfTheAbsoluteBrightness' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityOfTheAbsoluteBrightness)
		_ = validityOfTheAbsoluteBrightness // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cct)
		cct, _cctErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cct")
		if _cctErr != nil {
			return nil, errors.Wrap(_cctErr, "Error parsing 'cct' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cct)
		_ = cct // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourTemperature)
		stepCodeColourTemperature, _stepCodeColourTemperatureErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourTemperature", 3)
		if _stepCodeColourTemperatureErr != nil {
			return nil, errors.Wrap(_stepCodeColourTemperatureErr, "Error parsing 'stepCodeColourTemperature' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourTemperature)
		_ = stepCodeColourTemperature // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cb)
		cb, _cbErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cb")
		if _cbErr != nil {
			return nil, errors.Wrap(_cbErr, "Error parsing 'cb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cb)
		_ = cb // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeBrightness)
		stepCodeBrightness, _stepCodeBrightnessErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeBrightness", 3)
		if _stepCodeBrightnessErr != nil {
			return nil, errors.Wrap(_stepCodeBrightnessErr, "Error parsing 'stepCodeBrightness' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeBrightness)
		_ = stepCodeBrightness // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cctAndStepCodeColourValidity)
		cctAndStepCodeColourValidity, _cctAndStepCodeColourValidityErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cctAndStepCodeColourValidity")
		if _cctAndStepCodeColourValidityErr != nil {
			return nil, errors.Wrap(_cctAndStepCodeColourValidityErr, "Error parsing 'cctAndStepCodeColourValidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cctAndStepCodeColourValidity)
		_ = cctAndStepCodeColourValidity // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (cbAndStepCodeBrightnessValidity)
		cbAndStepCodeBrightnessValidity, _cbAndStepCodeBrightnessValidityErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cbAndStepCodeBrightnessValidity")
		if _cbAndStepCodeBrightnessValidityErr != nil {
			return nil, errors.Wrap(_cbAndStepCodeBrightnessValidityErr, "Error parsing 'cbAndStepCodeBrightnessValidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cbAndStepCodeBrightnessValidity)
		_ = cbAndStepCodeBrightnessValidity // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Colour_RGBW: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (colourLevelRed)
		colourLevelRed, _colourLevelRedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("colourLevelRed", 8)
		if _colourLevelRedErr != nil {
			return nil, errors.Wrap(_colourLevelRedErr, "Error parsing 'colourLevelRed' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelRed)
		_ = colourLevelRed // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (colourLevelGreen)
		colourLevelGreen, _colourLevelGreenErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("colourLevelGreen", 8)
		if _colourLevelGreenErr != nil {
			return nil, errors.Wrap(_colourLevelGreenErr, "Error parsing 'colourLevelGreen' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelGreen)
		_ = colourLevelGreen // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (colourLevelBlue)
		colourLevelBlue, _colourLevelBlueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("colourLevelBlue", 8)
		if _colourLevelBlueErr != nil {
			return nil, errors.Wrap(_colourLevelBlueErr, "Error parsing 'colourLevelBlue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelBlue)
		_ = colourLevelBlue // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (colourLevelWhite)
		colourLevelWhite, _colourLevelWhiteErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("colourLevelWhite", 8)
		if _colourLevelWhiteErr != nil {
			return nil, errors.Wrap(_colourLevelWhiteErr, "Error parsing 'colourLevelWhite' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelWhite)
		_ = colourLevelWhite // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (mr)
		mr, _mrErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("mr")
		if _mrErr != nil {
			return nil, errors.Wrap(_mrErr, "Error parsing 'mr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mr)
		_ = mr // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (mg)
		mg, _mgErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("mg")
		if _mgErr != nil {
			return nil, errors.Wrap(_mgErr, "Error parsing 'mg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mg)
		_ = mg // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (mb)
		mb, _mbErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("mb")
		if _mbErr != nil {
			return nil, errors.Wrap(_mbErr, "Error parsing 'mb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mb)
		_ = mb // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (mw)
		mw, _mwErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("mw")
		if _mwErr != nil {
			return nil, errors.Wrap(_mwErr, "Error parsing 'mw' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mw)
		_ = mw // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGBW: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (maskcw)
		maskcw, _maskcwErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskcw")
		if _maskcwErr != nil {
			return nil, errors.Wrap(_maskcwErr, "Error parsing 'maskcw' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcw)
		_ = maskcw // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskcb)
		maskcb, _maskcbErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskcb")
		if _maskcbErr != nil {
			return nil, errors.Wrap(_maskcbErr, "Error parsing 'maskcb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcb)
		_ = maskcb // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskcg)
		maskcg, _maskcgErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskcg")
		if _maskcgErr != nil {
			return nil, errors.Wrap(_maskcgErr, "Error parsing 'maskcg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcg)
		_ = maskcg // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (maskcr)
		maskcr, _maskcrErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("maskcr")
		if _maskcrErr != nil {
			return nil, errors.Wrap(_maskcrErr, "Error parsing 'maskcr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcr)
		_ = maskcr // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cw)
		cw, _cwErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cw")
		if _cwErr != nil {
			return nil, errors.Wrap(_cwErr, "Error parsing 'cw' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cw)
		_ = cw // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourWhite)
		stepCodeColourWhite, _stepCodeColourWhiteErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourWhite", 3)
		if _stepCodeColourWhiteErr != nil {
			return nil, errors.Wrap(_stepCodeColourWhiteErr, "Error parsing 'stepCodeColourWhite' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourWhite)
		_ = stepCodeColourWhite // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cb)
		cb, _cbErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cb")
		if _cbErr != nil {
			return nil, errors.Wrap(_cbErr, "Error parsing 'cb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cb)
		_ = cb // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourBlue)
		stepCodeColourBlue, _stepCodeColourBlueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourBlue", 3)
		if _stepCodeColourBlueErr != nil {
			return nil, errors.Wrap(_stepCodeColourBlueErr, "Error parsing 'stepCodeColourBlue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourBlue)
		_ = stepCodeColourBlue // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cg)
		cg, _cgErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cg")
		if _cgErr != nil {
			return nil, errors.Wrap(_cgErr, "Error parsing 'cg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cg)
		_ = cg // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourGreen)
		stepCodeColourGreen, _stepCodeColourGreenErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourGreen", 3)
		if _stepCodeColourGreenErr != nil {
			return nil, errors.Wrap(_stepCodeColourGreenErr, "Error parsing 'stepCodeColourGreen' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourGreen)
		_ = stepCodeColourGreen // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cr)
		cr, _crErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cr")
		if _crErr != nil {
			return nil, errors.Wrap(_crErr, "Error parsing 'cr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cr)
		_ = cr // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourRed)
		stepCodeColourRed, _stepCodeColourRedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourRed", 3)
		if _stepCodeColourRedErr != nil {
			return nil, errors.Wrap(_stepCodeColourRedErr, "Error parsing 'stepCodeColourRed' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourRed)
		_ = stepCodeColourRed // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGB: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cb)
		cb, _cbErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cb")
		if _cbErr != nil {
			return nil, errors.Wrap(_cbErr, "Error parsing 'cb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cb)
		_ = cb // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourBlue)
		stepCodeColourBlue, _stepCodeColourBlueErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourBlue", 3)
		if _stepCodeColourBlueErr != nil {
			return nil, errors.Wrap(_stepCodeColourBlueErr, "Error parsing 'stepCodeColourBlue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourBlue)
		_ = stepCodeColourBlue // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cg)
		cg, _cgErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cg")
		if _cgErr != nil {
			return nil, errors.Wrap(_cgErr, "Error parsing 'cg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cg)
		_ = cg // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourGreen)
		stepCodeColourGreen, _stepCodeColourGreenErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourGreen", 3)
		if _stepCodeColourGreenErr != nil {
			return nil, errors.Wrap(_stepCodeColourGreenErr, "Error parsing 'stepCodeColourGreen' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourGreen)
		_ = stepCodeColourGreen // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cr)
		cr, _crErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadBit("cr")
		if _crErr != nil {
			return nil, errors.Wrap(_crErr, "Error parsing 'cr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cr)
		_ = cr // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (stepCodeColourRed)
		stepCodeColourRed, _stepCodeColourRedErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("stepCodeColourRed", 3)
		if _stepCodeColourRedErr != nil {
			return nil, errors.Wrap(_stepCodeColourRedErr, "Error parsing 'stepCodeColourRed' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourRed)
		_ = stepCodeColourRed // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_GeographicalLocation: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (longitude)
		longitude, _longitudeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("longitude", 32)
		if _longitudeErr != nil {
			return nil, errors.Wrap(_longitudeErr, "Error parsing 'longitude' field")
		}
		_map["Struct"] = values.NewPlcREAL(longitude)
		_ = longitude // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (latitude)
		latitude, _latitudeErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("latitude", 32)
		if _latitudeErr != nil {
			return nil, errors.Wrap(_latitudeErr, "Error parsing 'latitude' field")
		}
		_map["Struct"] = values.NewPlcREAL(latitude)
		_ = latitude // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_4: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (roomTemperatureSetpointComfort)
		roomTemperatureSetpointComfort, _roomTemperatureSetpointComfortErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointComfort", 16)
		if _roomTemperatureSetpointComfortErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointComfortErr, "Error parsing 'roomTemperatureSetpointComfort' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointComfort)
		_ = roomTemperatureSetpointComfort // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (roomTemperatureSetpointStandby)
		roomTemperatureSetpointStandby, _roomTemperatureSetpointStandbyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointStandby", 16)
		if _roomTemperatureSetpointStandbyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointStandbyErr, "Error parsing 'roomTemperatureSetpointStandby' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointStandby)
		_ = roomTemperatureSetpointStandby // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (roomTemperatureSetpointEconomy)
		roomTemperatureSetpointEconomy, _roomTemperatureSetpointEconomyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointEconomy", 16)
		if _roomTemperatureSetpointEconomyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointEconomyErr, "Error parsing 'roomTemperatureSetpointEconomy' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointEconomy)
		_ = roomTemperatureSetpointEconomy // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (roomTemperatureSetpointBuildingProtection)
		roomTemperatureSetpointBuildingProtection, _roomTemperatureSetpointBuildingProtectionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointBuildingProtection", 16)
		if _roomTemperatureSetpointBuildingProtectionErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointBuildingProtectionErr, "Error parsing 'roomTemperatureSetpointBuildingProtection' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointBuildingProtection)
		_ = roomTemperatureSetpointBuildingProtection // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_4: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (roomTemperatureSetpointShiftComfort)
		roomTemperatureSetpointShiftComfort, _roomTemperatureSetpointShiftComfortErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointShiftComfort", 16)
		if _roomTemperatureSetpointShiftComfortErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftComfortErr, "Error parsing 'roomTemperatureSetpointShiftComfort' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftComfort)
		_ = roomTemperatureSetpointShiftComfort // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (roomTemperatureSetpointShiftStandby)
		roomTemperatureSetpointShiftStandby, _roomTemperatureSetpointShiftStandbyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointShiftStandby", 16)
		if _roomTemperatureSetpointShiftStandbyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftStandbyErr, "Error parsing 'roomTemperatureSetpointShiftStandby' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftStandby)
		_ = roomTemperatureSetpointShiftStandby // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (roomTemperatureSetpointShiftEconomy)
		roomTemperatureSetpointShiftEconomy, _roomTemperatureSetpointShiftEconomyErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointShiftEconomy", 16)
		if _roomTemperatureSetpointShiftEconomyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftEconomyErr, "Error parsing 'roomTemperatureSetpointShiftEconomy' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftEconomy)
		_ = roomTemperatureSetpointShiftEconomy // TODO: temporary till we fix TIME stuff in golang (see above in the template)

		// Simple Field (roomTemperatureSetpointShiftBuildingProtection)
		roomTemperatureSetpointShiftBuildingProtection, _roomTemperatureSetpointShiftBuildingProtectionErr := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadFloat32("roomTemperatureSetpointShiftBuildingProtection", 16)
		if _roomTemperatureSetpointShiftBuildingProtectionErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftBuildingProtectionErr, "Error parsing 'roomTemperatureSetpointShiftBuildingProtection' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftBuildingProtection)
		_ = roomTemperatureSetpointShiftBuildingProtection // TODO: temporary till we fix TIME stuff in golang (see above in the template)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	}
	// TODO: add more info which type it is actually
	return nil, errors.New("unsupported type")
}

func KnxDatapointSerialize(value api.PlcValue, datapointType KnxDatapointType) ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := KnxDatapointSerializeWithWriteBuffer(context.Background(), wb, value, datapointType); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

type _KnxDatapoint struct {
	DatapointType KnxDatapointType
}

func (m _KnxDatapoint) GetDatapointType() KnxDatapointType {
	return m.DatapointType
}

func KnxDatapointSerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer, value api.PlcValue, datapointType KnxDatapointType) error {
	log := zerolog.Ctx(ctx)
	_ = log
	m := _KnxDatapoint{
		DatapointType: datapointType,
	}
	_ = m
	writeBuffer.PushContext("KnxDatapoint")
	switch {
	case datapointType == KnxDatapointType_BOOL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_BYTE: // BYTE
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_WORD: // WORD
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DWORD: // DWORD
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_LWORD: // LWORD
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("value", 64, uint64(value.GetUint64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_USINT: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_SINT: // SINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt8("value", 8, int8(value.GetInt8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_UINT: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_INT: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_UDINT: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DINT: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_ULINT: // ULINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("value", 64, uint64(value.GetUint64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_LINT: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt64("value", 64, int64(value.GetInt64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_REAL: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_LREAL: // LREAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat64("value", 64, value.GetFloat64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_CHAR: // CHAR
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(8), value.GetString(), utils.WithEncoding("UTF-8)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_WCHAR: // WCHAR
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(16), value.GetString(), utils.WithEncoding("UTF-16)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_TIME: // TIME
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (milliseconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("milliseconds", 32, uint32(value.(values.PlcTIME).GetMilliseconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'milliseconds' field")
		}
	case datapointType == KnxDatapointType_LTIME: // LTIME
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (nanoseconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint64("nanoseconds", 64, uint64(value.(values.PlcLTIME).GetNanoseconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanoseconds' field")
		}
	case datapointType == KnxDatapointType_DATE: // DATE
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (secondsSinceEpoch)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("secondsSinceEpoch", 32, uint32(value.(values.PlcDATE).GetSecondsSinceEpoch())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'secondsSinceEpoch' field")
		}
	case datapointType == KnxDatapointType_TIME_OF_DAY: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (millisecondsSinceMidnight)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("millisecondsSinceMidnight", 32, uint32(value.(values.PlcTIME_OF_DAY).GetMillisecondsSinceMidnight())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'millisecondsSinceMidnight' field")
		}
	case datapointType == KnxDatapointType_TOD: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (millisecondsSinceMidnight)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("millisecondsSinceMidnight", 32, uint32(value.(values.PlcTIME_OF_DAY).GetMillisecondsSinceMidnight())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'millisecondsSinceMidnight' field")
		}
	case datapointType == KnxDatapointType_DATE_AND_TIME: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("year", 16, uint16(value.(values.PlcDATE_AND_TIME).GetYear())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}

		// Simple Field (month)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("month", 8, uint8(value.(values.PlcDATE_AND_TIME).GetMonth())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Simple Field (day)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("day", 8, uint8(value.(values.PlcDATE_AND_TIME).GetDay())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'day' field")
		}

		// Simple Field (dayOfWeek)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayOfWeek", 8, uint8(value.(values.PlcDATE_AND_TIME).GetDayOfWeek())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfWeek' field")
		}

		// Simple Field (hour)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hour", 8, uint8(value.(values.PlcDATE_AND_TIME).GetHour())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Simple Field (minutes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("minutes", 8, uint8(value.(values.PlcDATE_AND_TIME).GetMinutes())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Simple Field (seconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("seconds", 8, uint8(value.(values.PlcDATE_AND_TIME).GetSeconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}

		// Simple Field (nanoseconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("nanoseconds", 32, uint32(value.(values.PlcDATE_AND_TIME).GetNanoseconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanoseconds' field")
		}
	case datapointType == KnxDatapointType_DT: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("year", 16, uint16(value.(values.PlcDATE_AND_TIME).GetYear())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}

		// Simple Field (month)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("month", 8, uint8(value.(values.PlcDATE_AND_TIME).GetMonth())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Simple Field (day)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("day", 8, uint8(value.(values.PlcDATE_AND_TIME).GetDay())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'day' field")
		}

		// Simple Field (dayOfWeek)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayOfWeek", 8, uint8(value.(values.PlcDATE_AND_TIME).GetDayOfWeek())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfWeek' field")
		}

		// Simple Field (hour)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hour", 8, uint8(value.(values.PlcDATE_AND_TIME).GetHour())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Simple Field (minutes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("minutes", 8, uint8(value.(values.PlcDATE_AND_TIME).GetMinutes())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Simple Field (seconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("seconds", 8, uint8(value.(values.PlcDATE_AND_TIME).GetSeconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}

		// Simple Field (nanoseconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("nanoseconds", 32, uint32(value.(values.PlcDATE_AND_TIME).GetNanoseconds())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanoseconds' field")
		}
	case datapointType == KnxDatapointType_DPT_Switch: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Bool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Enable: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Ramp: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Alarm: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BinaryValue: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Step: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_UpDown: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_OpenClose: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Start: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_State: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Invert: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DimSendStyle: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_InputSource: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Reset: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Ack: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Trigger: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Occupancy: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Window_Door: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LogicalFunction: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Scene_AB: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ShutterBlinds_Mode: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DayNight: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Heat_Cool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Switch_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (on)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("on", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'on' field")
		}
	case datapointType == KnxDatapointType_DPT_Bool_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (valueTrue)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("valueTrue", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'valueTrue' field")
		}
	case datapointType == KnxDatapointType_DPT_Enable_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (enable)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("enable", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'enable' field")
		}
	case datapointType == KnxDatapointType_DPT_Ramp_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (ramp)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("ramp", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ramp' field")
		}
	case datapointType == KnxDatapointType_DPT_Alarm_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (alarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("alarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarm' field")
		}
	case datapointType == KnxDatapointType_DPT_BinaryValue_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (high)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("high", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'high' field")
		}
	case datapointType == KnxDatapointType_DPT_Step_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (increase)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("increase", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'increase' field")
		}
	case datapointType == KnxDatapointType_DPT_Direction1_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (down)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("down", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'down' field")
		}
	case datapointType == KnxDatapointType_DPT_Direction2_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (close)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("close", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'close' field")
		}
	case datapointType == KnxDatapointType_DPT_Start_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (start)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("start", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'start' field")
		}
	case datapointType == KnxDatapointType_DPT_State_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (active)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("active", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'active' field")
		}
	case datapointType == KnxDatapointType_DPT_Invert_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (inverted)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("inverted", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'inverted' field")
		}
	case datapointType == KnxDatapointType_DPT_Control_Dimming: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (increase)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("increase", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'increase' field")
		}

		// Simple Field (stepcode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepcode", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepcode' field")
		}
	case datapointType == KnxDatapointType_DPT_Control_Blinds: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (down)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("down", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'down' field")
		}

		// Simple Field (stepcode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepcode", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepcode' field")
		}
	case datapointType == KnxDatapointType_DPT_Char_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(8), value.GetString(), utils.WithEncoding("ASCII)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Char_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(8), value.GetString(), utils.WithEncoding("ISO-8859-1)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Scaling: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Angle: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Percent_U8: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DecimalFactor: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Tariff: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_1_Ucount: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FanStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Percent_V8: // SINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt8("value", 8, int8(value.GetInt8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_1_Count: // SINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt8("value", 8, int8(value.GetInt8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Status_Mode3: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (statusA)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusA", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusA' field")
		}

		// Simple Field (statusB)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusB", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusB' field")
		}

		// Simple Field (statusC)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusC", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusC' field")
		}

		// Simple Field (statusD)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusD", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusD' field")
		}

		// Simple Field (statusE)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusE", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusE' field")
		}

		// Simple Field (mode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("mode", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mode' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_2_Ucount: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodMsec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriod10Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriod100Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodSec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodMin: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodHrs: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PropDataType: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Length_mm: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_UElCurrentmA: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Brightness: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Absolute_Colour_Temperature: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("value", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_2_Count: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeMsec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTime10Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTime100Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeSec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeMin: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeHrs: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Percent_V16: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Rotation_Angle: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Length_m: // INT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt16("value", 16, int16(value.GetInt16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Temp: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Tempd: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Tempa: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Lux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Wsp: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Pres: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AirQuality: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AirFlow: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Time1: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Time2: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volt: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Curr: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PowerDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_KelvinPerPercent: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flow: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Rain_Amount: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Temp_F: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Wsp_kmh: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Concentration_ygm3: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Coefficient: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimeOfDay: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (day)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("day", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'day' field")
		}

		// Simple Field (hour)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hour", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (minutes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("minutes", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (seconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("seconds", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}
	case datapointType == KnxDatapointType_DPT_Date: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (dayOfMonth)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayOfMonth", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfMonth' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (month)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("month", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("year", 7, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_4_Ucount: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Sec: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Min: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Hrs: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_VolumeLiquid_Litre: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Volume_m_3: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("value", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_4_Count: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FlowRate_m3h: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApparentEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_kWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApparentEnergy_kVAh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_kVARh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_MWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongDeltaTimeSec: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaVolumeLiquid_Litre: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaVolume_m_3: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("value", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Acceleration: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Acceleration_Angular: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Activation_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Activity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Mol: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Amplitude: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Angular_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Angular_Velocity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Area: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Capacitance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensitySurface: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensityVolume: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Compressibility: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Conductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electrical_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Density: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Charge: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Current: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_CurrentDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_DipoleMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Displacement: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Potential: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_PotentialDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_ElectromagneticMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electromotive_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Angular_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Heat_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Heat_FlowRate: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Heat_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Impedance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Length: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Light_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Luminance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Moment: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetization: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_MagnetomotiveForce: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Mass: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_MassFlux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Power_Factor: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Pressure: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Reactance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Resistance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Resistivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_SelfInductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_SolidAngle: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Sound_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Speed: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Stress: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Surface_Tension: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Common_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_TemperatureDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_ThermoelectricPower: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Time: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Torque: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volume: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Weight: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Work: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_ApparentPower: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Volume_Flux_Meter: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Volume_Flux_ls: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Access_Data: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (hurz)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hurz", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hurz' field")
		}

		// Simple Field (value1)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value1", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value1' field")
		}

		// Simple Field (value2)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value2", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value2' field")
		}

		// Simple Field (value3)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value3", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value3' field")
		}

		// Simple Field (value4)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value4", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value4' field")
		}

		// Simple Field (value5)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value5", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value5' field")
		}

		// Simple Field (detectionError)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("detectionError", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'detectionError' field")
		}

		// Simple Field (permission)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("permission", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'permission' field")
		}

		// Simple Field (readDirection)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("readDirection", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'readDirection' field")
		}

		// Simple Field (encryptionOfAccessInformation)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("encryptionOfAccessInformation", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'encryptionOfAccessInformation' field")
		}

		// Simple Field (indexOfAccessIdentificationCode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("indexOfAccessIdentificationCode", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'indexOfAccessIdentificationCode' field")
		}
	case datapointType == KnxDatapointType_DPT_String_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(112), value.GetString(), utils.WithEncoding("ASCII)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_String_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(112), value.GetString(), utils.WithEncoding("ISO-8859-1)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SceneNumber: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SceneControl: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("learnTheSceneCorrespondingToTheFieldSceneNumber", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'learnTheSceneCorrespondingToTheFieldSceneNumber' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (sceneNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("sceneNumber", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sceneNumber' field")
		}
	case datapointType == KnxDatapointType_DPT_DateTime: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("year", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (month)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("month", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (dayofmonth)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayofmonth", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayofmonth' field")
		}

		// Simple Field (dayofweek)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dayofweek", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayofweek' field")
		}

		// Simple Field (hourofday)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hourofday", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hourofday' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (minutes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("minutes", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (seconds)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("seconds", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}

		// Simple Field (workingDay)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("workingDay", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'workingDay' field")
		}

		// Simple Field (noWd)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noWd", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noWd' field")
		}

		// Simple Field (noYear)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noYear", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noYear' field")
		}

		// Simple Field (noDate)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noDate", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noDate' field")
		}

		// Simple Field (noDayOfWeek)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noDayOfWeek", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noDayOfWeek' field")
		}

		// Simple Field (noTime)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("noTime", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noTime' field")
		}

		// Simple Field (standardSummerTime)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("standardSummerTime", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'standardSummerTime' field")
		}

		// Simple Field (qualityOfClock)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("qualityOfClock", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'qualityOfClock' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case datapointType == KnxDatapointType_DPT_SCLOMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BuildingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_OccMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Priority: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LightApplicationMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApplicationArea: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_AlarmClassType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PSUMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ErrorClass_System: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ErrorClass_HVAC: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Time_Delay: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Beaufort_Wind_Force_Scale: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SensorSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActuatorConnectType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Cloud_Cover: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PowerReturnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FuelType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BurnerType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DHWMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LoadPriority: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACContrMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACEmergMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ChangeoverMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ValveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DamperMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HeaterMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FanMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_MasterSlaveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRoomSetp: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Metering_DeviceType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HumDehumMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_EnableHCStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ADAType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BackupMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StartSynchronization: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Behaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Behaviour_Bus_Power_Up_Down: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DALI_Fade_Time: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BlinkingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LightControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SwitchPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PBAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DimmPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SwitchOnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LoadTypeSet: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LoadTypeDetected: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Converter_Test_Control: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Converter_Control: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SABExcept_Behaviour: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SABBehaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SSSBMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BlindsControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_CommMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_AddInfoTypes: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_ModeSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_FilterSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusGen: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("alarmStatusOfCorrespondingDatapointIsNotAcknowledged", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmStatusOfCorrespondingDatapointIsNotAcknowledged' field")
		}

		// Simple Field (correspondingDatapointIsInAlarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("correspondingDatapointIsInAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointIsInAlarm' field")
		}

		// Simple Field (correspondingDatapointMainValueIsOverridden)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("correspondingDatapointMainValueIsOverridden", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointMainValueIsOverridden' field")
		}

		// Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("correspondingDatapointMainValueIsCorruptedDueToFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointMainValueIsCorruptedDueToFailure' field")
		}

		// Simple Field (correspondingDatapointValueIsOutOfService)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("correspondingDatapointValueIsOutOfService", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointValueIsOutOfService' field")
		}
	case datapointType == KnxDatapointType_DPT_Device_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (verifyModeIsOn)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("verifyModeIsOn", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'verifyModeIsOn' field")
		}

		// Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived' field")
		}

		// Simple Field (theUserApplicationIsStopped)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("theUserApplicationIsStopped", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'theUserApplicationIsStopped' field")
		}
	case datapointType == KnxDatapointType_DPT_ForceSign: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (roomhmax)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("roomhmax", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomhmax' field")
		}

		// Simple Field (roomhconf)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("roomhconf", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomhconf' field")
		}

		// Simple Field (dhwlegio)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("dhwlegio", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwlegio' field")
		}

		// Simple Field (dhwnorm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("dhwnorm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwnorm' field")
		}

		// Simple Field (overrun)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("overrun", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overrun' field")
		}

		// Simple Field (oversupply)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("oversupply", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'oversupply' field")
		}

		// Simple Field (protection)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("protection", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'protection' field")
		}

		// Simple Field (forcerequest)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("forcerequest", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'forcerequest' field")
		}
	case datapointType == KnxDatapointType_DPT_ForceSignCool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRHC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (summermode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("summermode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'summermode' field")
		}

		// Simple Field (statusstopoptim)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusstopoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstopoptim' field")
		}

		// Simple Field (statusstartoptim)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusstartoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstartoptim' field")
		}

		// Simple Field (statusmorningboost)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusmorningboost", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusmorningboost' field")
		}

		// Simple Field (tempreturnlimit)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("tempreturnlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempreturnlimit' field")
		}

		// Simple Field (tempflowlimit)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("tempflowlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempflowlimit' field")
		}

		// Simple Field (satuseco)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("satuseco", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'satuseco' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusSDHWC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (solarloadsufficient)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("solarloadsufficient", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solarloadsufficient' field")
		}

		// Simple Field (sdhwloadactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("sdhwloadactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sdhwloadactive' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_FuelTypeSet: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (solidstate)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("solidstate", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solidstate' field")
		}

		// Simple Field (gas)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("gas", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'gas' field")
		}

		// Simple Field (oil)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("oil", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'oil' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRCC: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusAHU: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cool)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cool", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cool' field")
		}

		// Simple Field (heat)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("heat", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heat' field")
		}

		// Simple Field (fanactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fanactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fanactive' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTSM: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (statusOfHvacModeUser)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusOfHvacModeUser", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusOfHvacModeUser' field")
		}

		// Simple Field (statusOfComfortProlongationUser)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusOfComfortProlongationUser", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusOfComfortProlongationUser' field")
		}

		// Simple Field (effectiveValueOfTheComfortPushButton)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("effectiveValueOfTheComfortPushButton", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'effectiveValueOfTheComfortPushButton' field")
		}

		// Simple Field (effectiveValueOfThePresenceStatus)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("effectiveValueOfThePresenceStatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'effectiveValueOfThePresenceStatus' field")
		}

		// Simple Field (effectiveValueOfTheWindowStatus)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("effectiveValueOfTheWindowStatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'effectiveValueOfTheWindowStatus' field")
		}
	case datapointType == KnxDatapointType_DPT_LightActuatorErrorInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (overheat)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("overheat", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overheat' field")
		}

		// Simple Field (lampfailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("lampfailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lampfailure' field")
		}

		// Simple Field (defectiveload)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("defectiveload", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'defectiveload' field")
		}

		// Simple Field (underload)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("underload", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'underload' field")
		}

		// Simple Field (overcurrent)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("overcurrent", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overcurrent' field")
		}

		// Simple Field (undervoltage)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("undervoltage", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'undervoltage' field")
		}

		// Simple Field (loaddetectionerror)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("loaddetectionerror", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'loaddetectionerror' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_ModeInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (bibatSlave)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("bibatSlave", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'bibatSlave' field")
		}

		// Simple Field (bibatMaster)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("bibatMaster", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'bibatMaster' field")
		}

		// Simple Field (asynchronous)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("asynchronous", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'asynchronous' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_FilterInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (doa)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("doa", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'doa' field")
		}

		// Simple Field (knxSn)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("knxSn", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'knxSn' field")
		}

		// Simple Field (doaAndKnxSn)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("doaAndKnxSn", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'doaAndKnxSn' field")
		}
	case datapointType == KnxDatapointType_DPT_Channel_Activation_8: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel1' field")
		}

		// Simple Field (activationStateOfChannel2)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel2' field")
		}

		// Simple Field (activationStateOfChannel3)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel3' field")
		}

		// Simple Field (activationStateOfChannel4)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel4' field")
		}

		// Simple Field (activationStateOfChannel5)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel5' field")
		}

		// Simple Field (activationStateOfChannel6)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel6' field")
		}

		// Simple Field (activationStateOfChannel7)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel7' field")
		}

		// Simple Field (activationStateOfChannel8)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel8' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusDHWC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (tempoptimshiftactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("tempoptimshiftactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempoptimshiftactive' field")
		}

		// Simple Field (solarenergysupport)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("solarenergysupport", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solarenergysupport' field")
		}

		// Simple Field (solarenergyonly)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("solarenergyonly", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solarenergyonly' field")
		}

		// Simple Field (otherenergysourceactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("otherenergysourceactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'otherenergysourceactive' field")
		}

		// Simple Field (dhwpushactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("dhwpushactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwpushactive' field")
		}

		// Simple Field (legioprotactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("legioprotactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'legioprotactive' field")
		}

		// Simple Field (dhwloadactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("dhwloadactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwloadactive' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRHCC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (overheatalarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("overheatalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overheatalarm' field")
		}

		// Simple Field (frostalarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("frostalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'frostalarm' field")
		}

		// Simple Field (dewpointstatus)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("dewpointstatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dewpointstatus' field")
		}

		// Simple Field (coolingdisabled)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("coolingdisabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'coolingdisabled' field")
		}

		// Simple Field (statusprecool)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusprecool", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusprecool' field")
		}

		// Simple Field (statusecoc)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusecoc", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusecoc' field")
		}

		// Simple Field (heatcoolmode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("heatcoolmode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heatcoolmode' field")
		}

		// Simple Field (heatingdiabled)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("heatingdiabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heatingdiabled' field")
		}

		// Simple Field (statusstopoptim)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusstopoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstopoptim' field")
		}

		// Simple Field (statusstartoptim)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusstartoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstartoptim' field")
		}

		// Simple Field (statusmorningboosth)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusmorningboosth", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusmorningboosth' field")
		}

		// Simple Field (tempflowreturnlimit)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("tempflowreturnlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempflowreturnlimit' field")
		}

		// Simple Field (tempflowlimit)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("tempflowlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempflowlimit' field")
		}

		// Simple Field (statusecoh)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("statusecoh", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusecoh' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedStatus_HVA: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (calibrationMode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("calibrationMode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'calibrationMode' field")
		}

		// Simple Field (lockedPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("lockedPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lockedPosition' field")
		}

		// Simple Field (forcedPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("forcedPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'forcedPosition' field")
		}

		// Simple Field (manuaOperationOverridden)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("manuaOperationOverridden", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'manuaOperationOverridden' field")
		}

		// Simple Field (serviceMode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("serviceMode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'serviceMode' field")
		}

		// Simple Field (valveKick)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("valveKick", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'valveKick' field")
		}

		// Simple Field (overload)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("overload", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overload' field")
		}

		// Simple Field (shortCircuit)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("shortCircuit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'shortCircuit' field")
		}

		// Simple Field (currentValvePosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("currentValvePosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'currentValvePosition' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 7, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (coolingModeEnabled)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("coolingModeEnabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'coolingModeEnabled' field")
		}

		// Simple Field (heatingModeEnabled)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("heatingModeEnabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heatingModeEnabled' field")
		}

		// Simple Field (additionalHeatingCoolingStage2Stage)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("additionalHeatingCoolingStage2Stage", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'additionalHeatingCoolingStage2Stage' field")
		}

		// Simple Field (controllerInactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("controllerInactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'controllerInactive' field")
		}

		// Simple Field (overheatAlarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("overheatAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overheatAlarm' field")
		}

		// Simple Field (frostAlarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("frostAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'frostAlarm' field")
		}

		// Simple Field (dewPointStatus)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("dewPointStatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dewPointStatus' field")
		}

		// Simple Field (activeMode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activeMode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activeMode' field")
		}

		// Simple Field (generalFailureInformation)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("generalFailureInformation", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'generalFailureInformation' field")
		}
	case datapointType == KnxDatapointType_DPT_Media: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("reserved", 10, uint16(uint16(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (knxIp)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("knxIp", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'knxIp' field")
		}

		// Simple Field (rf)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("rf", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'rf' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (pl110)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("pl110", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'pl110' field")
		}

		// Simple Field (tp1)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("tp1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tp1' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case datapointType == KnxDatapointType_DPT_Channel_Activation_16: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel1' field")
		}

		// Simple Field (activationStateOfChannel2)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel2' field")
		}

		// Simple Field (activationStateOfChannel3)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel3' field")
		}

		// Simple Field (activationStateOfChannel4)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel4' field")
		}

		// Simple Field (activationStateOfChannel5)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel5' field")
		}

		// Simple Field (activationStateOfChannel6)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel6' field")
		}

		// Simple Field (activationStateOfChannel7)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel7' field")
		}

		// Simple Field (activationStateOfChannel8)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel8' field")
		}

		// Simple Field (activationStateOfChannel9)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel9' field")
		}

		// Simple Field (activationStateOfChannel10)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel10' field")
		}

		// Simple Field (activationStateOfChannel11)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel11' field")
		}

		// Simple Field (activationStateOfChannel12)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel12' field")
		}

		// Simple Field (activationStateOfChannel13)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel13' field")
		}

		// Simple Field (activationStateOfChannel14)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel14' field")
		}

		// Simple Field (activationStateOfChannel15)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel15' field")
		}

		// Simple Field (activationStateOfChannel16)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel16' field")
		}
	case datapointType == KnxDatapointType_DPT_OnOffAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Alarm_Reaction: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_UpDown_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVAC_PB_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("value", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DoubleNibble: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (busy)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("busy", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'busy' field")
		}

		// Simple Field (nak)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("nak", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nak' field")
		}
	case datapointType == KnxDatapointType_DPT_SceneInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 1, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (sceneIsInactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("sceneIsInactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sceneIsInactive' field")
		}

		// Simple Field (scenenumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("scenenumber", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'scenenumber' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedInfoOnOff: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (maskBitInfoOnOffOutput16)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput16' field")
		}

		// Simple Field (maskBitInfoOnOffOutput15)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput15' field")
		}

		// Simple Field (maskBitInfoOnOffOutput14)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput14' field")
		}

		// Simple Field (maskBitInfoOnOffOutput13)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput13' field")
		}

		// Simple Field (maskBitInfoOnOffOutput12)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput12' field")
		}

		// Simple Field (maskBitInfoOnOffOutput11)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput11' field")
		}

		// Simple Field (maskBitInfoOnOffOutput10)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput10' field")
		}

		// Simple Field (maskBitInfoOnOffOutput9)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput9' field")
		}

		// Simple Field (maskBitInfoOnOffOutput8)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput8' field")
		}

		// Simple Field (maskBitInfoOnOffOutput7)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput7' field")
		}

		// Simple Field (maskBitInfoOnOffOutput6)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput6' field")
		}

		// Simple Field (maskBitInfoOnOffOutput5)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput5' field")
		}

		// Simple Field (maskBitInfoOnOffOutput4)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput4' field")
		}

		// Simple Field (maskBitInfoOnOffOutput3)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput3' field")
		}

		// Simple Field (maskBitInfoOnOffOutput2)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput2' field")
		}

		// Simple Field (maskBitInfoOnOffOutput1)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskBitInfoOnOffOutput1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput1' field")
		}

		// Simple Field (infoOnOffOutput16)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput16' field")
		}

		// Simple Field (infoOnOffOutput15)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput15' field")
		}

		// Simple Field (infoOnOffOutput14)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput14' field")
		}

		// Simple Field (infoOnOffOutput13)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput13' field")
		}

		// Simple Field (infoOnOffOutput12)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput12' field")
		}

		// Simple Field (infoOnOffOutput11)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput11' field")
		}

		// Simple Field (infoOnOffOutput10)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput10' field")
		}

		// Simple Field (infoOnOffOutput9)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput9' field")
		}

		// Simple Field (infoOnOffOutput8)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput8' field")
		}

		// Simple Field (infoOnOffOutput7)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput7' field")
		}

		// Simple Field (infoOnOffOutput6)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput6' field")
		}

		// Simple Field (infoOnOffOutput5)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput5' field")
		}

		// Simple Field (infoOnOffOutput4)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput4' field")
		}

		// Simple Field (infoOnOffOutput3)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput3' field")
		}

		// Simple Field (infoOnOffOutput2)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput2' field")
		}

		// Simple Field (infoOnOffOutput1)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("infoOnOffOutput1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput1' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt64("value", 64, int64(value.GetInt64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApparentEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt64("value", 64, int64(value.GetInt64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt64("value", 64, int64(value.GetInt64())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Channel_Activation_24: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel1' field")
		}

		// Simple Field (activationStateOfChannel2)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel2' field")
		}

		// Simple Field (activationStateOfChannel3)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel3' field")
		}

		// Simple Field (activationStateOfChannel4)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel4' field")
		}

		// Simple Field (activationStateOfChannel5)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel5' field")
		}

		// Simple Field (activationStateOfChannel6)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel6' field")
		}

		// Simple Field (activationStateOfChannel7)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel7' field")
		}

		// Simple Field (activationStateOfChannel8)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel8' field")
		}

		// Simple Field (activationStateOfChannel9)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel9' field")
		}

		// Simple Field (activationStateOfChannel10)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel10' field")
		}

		// Simple Field (activationStateOfChannel11)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel11' field")
		}

		// Simple Field (activationStateOfChannel12)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel12' field")
		}

		// Simple Field (activationStateOfChannel13)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel13' field")
		}

		// Simple Field (activationStateOfChannel14)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel14' field")
		}

		// Simple Field (activationStateOfChannel15)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel15' field")
		}

		// Simple Field (activationStateOfChannel16)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel16' field")
		}

		// Simple Field (activationStateOfChannel17)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel17", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel17' field")
		}

		// Simple Field (activationStateOfChannel18)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel18", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel18' field")
		}

		// Simple Field (activationStateOfChannel19)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel19", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel19' field")
		}

		// Simple Field (activationStateOfChannel20)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel20", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel20' field")
		}

		// Simple Field (activationStateOfChannel21)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel21", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel21' field")
		}

		// Simple Field (activationStateOfChannel22)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel22", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel22' field")
		}

		// Simple Field (activationStateOfChannel23)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel23", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel23' field")
		}

		// Simple Field (activationStateOfChannel24)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("activationStateOfChannel24", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel24' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("delayTimeMin", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (hvacMode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("hvacMode", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hvacMode' field")
		}
	case datapointType == KnxDatapointType_DPT_DHWModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("delayTimeMin", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (dhwMode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("dhwMode", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwMode' field")
		}
	case datapointType == KnxDatapointType_DPT_OccModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("delayTimeMin", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (occupancyMode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("occupancyMode", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'occupancyMode' field")
		}
	case datapointType == KnxDatapointType_DPT_BuildingModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("delayTimeMin", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (buildingMode)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("buildingMode", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'buildingMode' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusLightingActuator: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validactualvalue)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validactualvalue", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validactualvalue' field")
		}

		// Simple Field (locked)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("locked", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'locked' field")
		}

		// Simple Field (forced)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("forced", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'forced' field")
		}

		// Simple Field (nightmodeactive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("nightmodeactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nightmodeactive' field")
		}

		// Simple Field (staircaselightingFunction)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("staircaselightingFunction", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'staircaselightingFunction' field")
		}

		// Simple Field (dimming)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("dimming", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dimming' field")
		}

		// Simple Field (localoverride)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("localoverride", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'localoverride' field")
		}

		// Simple Field (failure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("failure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'failure' field")
		}

		// Simple Field (actualvalue)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("actualvalue", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'actualvalue' field")
		}
	case datapointType == KnxDatapointType_DPT_Version: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (magicNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("magicNumber", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'magicNumber' field")
		}

		// Simple Field (versionNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("versionNumber", 5, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'versionNumber' field")
		}

		// Simple Field (revisionNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("revisionNumber", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'revisionNumber' field")
		}
	case datapointType == KnxDatapointType_DPT_AlarmInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (logNumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("logNumber", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'logNumber' field")
		}

		// Simple Field (alarmPriority)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("alarmPriority", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmPriority' field")
		}

		// Simple Field (applicationArea)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("applicationArea", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'applicationArea' field")
		}

		// Simple Field (errorClass)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("errorClass", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'errorClass' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (errorcodeSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("errorcodeSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'errorcodeSup' field")
		}

		// Simple Field (alarmtextSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("alarmtextSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmtextSup' field")
		}

		// Simple Field (timestampSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("timestampSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'timestampSup' field")
		}

		// Simple Field (ackSup)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("ackSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ackSup' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (locked)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("locked", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'locked' field")
		}

		// Simple Field (alarmunack)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("alarmunack", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmunack' field")
		}

		// Simple Field (inalarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("inalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'inalarm' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_3: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (tempsetpcomf)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("tempsetpcomf", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpcomf' field")
		}

		// Simple Field (tempsetpstdby)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("tempsetpstdby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpstdby' field")
		}

		// Simple Field (tempsetpeco)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("tempsetpeco", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpeco' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_3: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (tempsetpshiftcomf)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("tempsetpshiftcomf", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpshiftcomf' field")
		}

		// Simple Field (tempsetpshiftstdby)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("tempsetpshiftstdby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpshiftstdby' field")
		}

		// Simple Field (tempsetpshifteco)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("tempsetpshifteco", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpshifteco' field")
		}
	case datapointType == KnxDatapointType_DPT_Scaling_Speed: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (timePeriod)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("timePeriod", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'timePeriod' field")
		}

		// Simple Field (percent)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("percent", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'percent' field")
		}
	case datapointType == KnxDatapointType_DPT_Scaling_Step_Time: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (timePeriod)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("timePeriod", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'timePeriod' field")
		}

		// Simple Field (percent)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("percent", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'percent' field")
		}
	case datapointType == KnxDatapointType_DPT_MeteringValue: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (countval)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("countval", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'countval' field")
		}

		// Simple Field (valinffield)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("valinffield", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'valinffield' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (alarmunack)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("alarmunack", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmunack' field")
		}

		// Simple Field (inalarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("inalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'inalarm' field")
		}

		// Simple Field (overridden)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("overridden", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overridden' field")
		}

		// Simple Field (fault)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}

		// Simple Field (outofservice)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("outofservice", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'outofservice' field")
		}
	case datapointType == KnxDatapointType_DPT_MBus_Address: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (manufactid)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("manufactid", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'manufactid' field")
		}

		// Simple Field (identnumber)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint32("identnumber", 32, uint32(value.GetUint32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'identnumber' field")
		}

		// Simple Field (version)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("version", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'version' field")
		}

		// Simple Field (medium)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("medium", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'medium' field")
		}
	case datapointType == KnxDatapointType_DPT_Colour_RGB: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (r)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("r", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'r' field")
		}

		// Simple Field (g)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("g", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'g' field")
		}

		// Simple Field (b)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("b", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'b' field")
		}
	case datapointType == KnxDatapointType_DPT_LanguageCodeAlpha2_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteString("value", uint32(16), value.GetString(), utils.WithEncoding("ASCII)")); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Tariff_ActiveEnergy: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activeelectricalenergy)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteInt32("activeelectricalenergy", 32, int32(value.GetInt32())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activeelectricalenergy' field")
		}

		// Simple Field (tariff)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("tariff", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tariff' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (electricalengergyvalidity)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("electricalengergyvalidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'electricalengergyvalidity' field")
		}

		// Simple Field (tariffvalidity)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("tariffvalidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tariffvalidity' field")
		}
	case datapointType == KnxDatapointType_DPT_Prioritised_Mode_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (deactivationOfPriority)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("deactivationOfPriority", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'deactivationOfPriority' field")
		}

		// Simple Field (priorityLevel)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("priorityLevel", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'priorityLevel' field")
		}

		// Simple Field (modeLevel)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("modeLevel", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'modeLevel' field")
		}
	case datapointType == KnxDatapointType_DPT_DALI_Control_Gear_Diagnostic: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (convertorError)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("convertorError", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'convertorError' field")
		}

		// Simple Field (ballastFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("ballastFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ballastFailure' field")
		}

		// Simple Field (lampFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("lampFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lampFailure' field")
		}

		// Simple Field (readOrResponse)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("readOrResponse", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'readOrResponse' field")
		}

		// Simple Field (addressIndicator)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("addressIndicator", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'addressIndicator' field")
		}

		// Simple Field (daliDeviceAddressOrDaliGroupAddress)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("daliDeviceAddressOrDaliGroupAddress", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'daliDeviceAddressOrDaliGroupAddress' field")
		}
	case datapointType == KnxDatapointType_DPT_DALI_Diagnostics: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ballastFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("ballastFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ballastFailure' field")
		}

		// Simple Field (lampFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("lampFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lampFailure' field")
		}

		// Simple Field (deviceAddress)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("deviceAddress", 6, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'deviceAddress' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedPosition: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (heightPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("heightPosition", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heightPosition' field")
		}

		// Simple Field (slatsPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("slatsPosition", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'slatsPosition' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validitySlatsPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validitySlatsPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validitySlatsPosition' field")
		}

		// Simple Field (validityHeightPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validityHeightPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityHeightPosition' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusSAB: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (heightPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("heightPosition", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heightPosition' field")
		}

		// Simple Field (slatsPosition)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("slatsPosition", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'slatsPosition' field")
		}

		// Simple Field (upperEndPosReached)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("upperEndPosReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'upperEndPosReached' field")
		}

		// Simple Field (lowerEndPosReached)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("lowerEndPosReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lowerEndPosReached' field")
		}

		// Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent' field")
		}

		// Simple Field (targetPosDrive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("targetPosDrive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'targetPosDrive' field")
		}

		// Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("restrictionOfTargetHeightPosPosCanNotBeReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'restrictionOfTargetHeightPosPosCanNotBeReached' field")
		}

		// Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("restrictionOfSlatsHeightPosPosCanNotBeReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'restrictionOfSlatsHeightPosPosCanNotBeReached' field")
		}

		// Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm' field")
		}

		// Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("upDownPositionIsForcedByMoveupdownforcedInput", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'upDownPositionIsForcedByMoveupdownforcedInput' field")
		}

		// Simple Field (movementIsLockedEGByDevicelockedInput)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("movementIsLockedEGByDevicelockedInput", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'movementIsLockedEGByDevicelockedInput' field")
		}

		// Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface' field")
		}

		// Simple Field (generalFailureOfTheActuatorOrTheDrive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("generalFailureOfTheActuatorOrTheDrive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'generalFailureOfTheActuatorOrTheDrive' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 3, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validityHeightPos)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validityHeightPos", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityHeightPos' field")
		}

		// Simple Field (validitySlatsPos)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validitySlatsPos", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validitySlatsPos' field")
		}
	case datapointType == KnxDatapointType_DPT_Colour_xyY: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (xAxis)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("xAxis", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'xAxis' field")
		}

		// Simple Field (yAxis)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("yAxis", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'yAxis' field")
		}

		// Simple Field (brightness)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("brightness", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'brightness' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validityXy)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validityXy", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityXy' field")
		}

		// Simple Field (validityBrightness)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validityBrightness", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityBrightness' field")
		}
	case datapointType == KnxDatapointType_DPT_Converter_Status: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("converterModeAccordingToTheDaliConverterStateMachine", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'converterModeAccordingToTheDaliConverterStateMachine' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (hardwiredSwitchIsActive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("hardwiredSwitchIsActive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hardwiredSwitchIsActive' field")
		}

		// Simple Field (hardwiredInhibitIsActive)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("hardwiredInhibitIsActive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hardwiredInhibitIsActive' field")
		}

		// Simple Field (functionTestPending)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("functionTestPending", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'functionTestPending' field")
		}

		// Simple Field (durationTestPending)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("durationTestPending", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'durationTestPending' field")
		}

		// Simple Field (partialDurationTestPending)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("partialDurationTestPending", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'partialDurationTestPending' field")
		}

		// Simple Field (converterFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("converterFailure", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'converterFailure' field")
		}
	case datapointType == KnxDatapointType_DPT_Converter_Test_Result: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ltrf)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("ltrf", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ltrf' field")
		}

		// Simple Field (ltrd)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("ltrd", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ltrd' field")
		}

		// Simple Field (ltrp)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("ltrp", 4, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ltrp' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (sf)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("sf", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sf' field")
		}

		// Simple Field (sd)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("sd", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sd' field")
		}

		// Simple Field (sp)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("sp", 2, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sp' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 2, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ldtr)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("ldtr", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ldtr' field")
		}

		// Simple Field (lpdtr)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("lpdtr", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lpdtr' field")
		}
	case datapointType == KnxDatapointType_DPT_Battery_Info: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (batteryFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("batteryFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryFailure' field")
		}

		// Simple Field (batteryDurationFailure)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("batteryDurationFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryDurationFailure' field")
		}

		// Simple Field (batteryFullyCharged)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("batteryFullyCharged", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryFullyCharged' field")
		}

		// Simple Field (batteryChargeLevel)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("batteryChargeLevel", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryChargeLevel' field")
		}
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Transition: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ms)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("ms", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ms' field")
		}

		// Simple Field (temperatureK)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint16("temperatureK", 16, uint16(value.GetUint16())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'temperatureK' field")
		}

		// Simple Field (percent)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("percent", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'percent' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 5, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validityOfTheTimePeriod)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validityOfTheTimePeriod", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityOfTheTimePeriod' field")
		}

		// Simple Field (validityOfTheAbsoluteColourTemperature)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validityOfTheAbsoluteColourTemperature", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityOfTheAbsoluteColourTemperature' field")
		}

		// Simple Field (validityOfTheAbsoluteBrightness)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("validityOfTheAbsoluteBrightness", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityOfTheAbsoluteBrightness' field")
		}
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cct)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cct", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cct' field")
		}

		// Simple Field (stepCodeColourTemperature)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourTemperature", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourTemperature' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cb)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cb' field")
		}

		// Simple Field (stepCodeBrightness)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeBrightness", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeBrightness' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 6, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cctAndStepCodeColourValidity)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cctAndStepCodeColourValidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cctAndStepCodeColourValidity' field")
		}

		// Simple Field (cbAndStepCodeBrightnessValidity)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cbAndStepCodeBrightnessValidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cbAndStepCodeBrightnessValidity' field")
		}
	case datapointType == KnxDatapointType_DPT_Colour_RGBW: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (colourLevelRed)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("colourLevelRed", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelRed' field")
		}

		// Simple Field (colourLevelGreen)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("colourLevelGreen", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelGreen' field")
		}

		// Simple Field (colourLevelBlue)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("colourLevelBlue", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelBlue' field")
		}

		// Simple Field (colourLevelWhite)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("colourLevelWhite", 8, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelWhite' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (mr)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("mr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mr' field")
		}

		// Simple Field (mg)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("mg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mg' field")
		}

		// Simple Field (mb)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("mb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mb' field")
		}

		// Simple Field (mw)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("mw", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mw' field")
		}
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGBW: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (maskcw)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskcw", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcw' field")
		}

		// Simple Field (maskcb)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskcb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcb' field")
		}

		// Simple Field (maskcg)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskcg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcg' field")
		}

		// Simple Field (maskcr)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("maskcr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcr' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cw)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cw", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cw' field")
		}

		// Simple Field (stepCodeColourWhite)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourWhite", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourWhite' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cb)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cb' field")
		}

		// Simple Field (stepCodeColourBlue)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourBlue", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourBlue' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cg)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cg' field")
		}

		// Simple Field (stepCodeColourGreen)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourGreen", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourGreen' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cr)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cr' field")
		}

		// Simple Field (stepCodeColourRed)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourRed", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourRed' field")
		}
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGB: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cb)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cb' field")
		}

		// Simple Field (stepCodeColourBlue)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourBlue", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourBlue' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cg)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cg' field")
		}

		// Simple Field (stepCodeColourGreen)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourGreen", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourGreen' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 4, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cr)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteBit("cr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cr' field")
		}

		// Simple Field (stepCodeColourRed)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("stepCodeColourRed", 3, uint8(value.GetUint8())); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourRed' field")
		}
	case datapointType == KnxDatapointType_DPT_GeographicalLocation: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (longitude)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("longitude", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'longitude' field")
		}

		// Simple Field (latitude)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("latitude", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'latitude' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_4: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (roomTemperatureSetpointComfort)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointComfort", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointComfort' field")
		}

		// Simple Field (roomTemperatureSetpointStandby)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointStandby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointStandby' field")
		}

		// Simple Field (roomTemperatureSetpointEconomy)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointEconomy", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointEconomy' field")
		}

		// Simple Field (roomTemperatureSetpointBuildingProtection)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointBuildingProtection", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointBuildingProtection' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_4: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteUint8("reserved", 8, uint8(uint8(0x00))); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (roomTemperatureSetpointShiftComfort)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointShiftComfort", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftComfort' field")
		}

		// Simple Field (roomTemperatureSetpointShiftStandby)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointShiftStandby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftStandby' field")
		}

		// Simple Field (roomTemperatureSetpointShiftEconomy)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointShiftEconomy", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftEconomy' field")
		}

		// Simple Field (roomTemperatureSetpointShiftBuildingProtection)
		if _err := /*TODO: migrate me*/ writeBuffer.WriteFloat32("roomTemperatureSetpointShiftBuildingProtection", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftBuildingProtection' field")
		}
	default:
		// TODO: add more info which type it is actually
		return errors.New("unsupported type")
	}
	writeBuffer.PopContext("KnxDatapoint")
	return nil
}
