/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableLldp is an enum
type OpcuaNodeIdServicesVariableLldp int32

type IOpcuaNodeIdServicesVariableLldp interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableLldp_LldpSystemCapabilitiesMap_OptionSetValues                                                          OpcuaNodeIdServicesVariableLldp = 18957
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_LastChangeTime                                                OpcuaNodeIdServicesVariableLldp = 18975
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteInserts                                                 OpcuaNodeIdServicesVariableLldp = 18976
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDeletes                                                 OpcuaNodeIdServicesVariableLldp = 18977
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDrops                                                   OpcuaNodeIdServicesVariableLldp = 18978
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteAgeouts                                                 OpcuaNodeIdServicesVariableLldp = 18979
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisIdSubtype                                               OpcuaNodeIdServicesVariableLldp = 18981
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisId                                                      OpcuaNodeIdServicesVariableLldp = 18982
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemName                                                     OpcuaNodeIdServicesVariableLldp = 18983
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemDescription                                              OpcuaNodeIdServicesVariableLldp = 18984
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesSupported                                    OpcuaNodeIdServicesVariableLldp = 18985
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesEnabled                                      OpcuaNodeIdServicesVariableLldp = 18986
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_IetfBaseNetworkInterfaceName             OpcuaNodeIdServicesVariableLldp = 18989
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_DestMacAddress                           OpcuaNodeIdServicesVariableLldp = 18990
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortIdSubtype                            OpcuaNodeIdServicesVariableLldp = 18991
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortId                                   OpcuaNodeIdServicesVariableLldp = 18992
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortDescription                          OpcuaNodeIdServicesVariableLldp = 18993
	OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_ManagementAddressTxPort                  OpcuaNodeIdServicesVariableLldp = 18994
	OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_LastChangeTime                                                            OpcuaNodeIdServicesVariableLldp = 18997
	OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteInserts                                                             OpcuaNodeIdServicesVariableLldp = 18998
	OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDeletes                                                             OpcuaNodeIdServicesVariableLldp = 18999
	OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDrops                                                               OpcuaNodeIdServicesVariableLldp = 19000
	OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteAgeouts                                                             OpcuaNodeIdServicesVariableLldp = 19001
	OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisIdSubtype                                                               OpcuaNodeIdServicesVariableLldp = 19003
	OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisId                                                                      OpcuaNodeIdServicesVariableLldp = 19004
	OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemName                                                                     OpcuaNodeIdServicesVariableLldp = 19005
	OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemDescription                                                              OpcuaNodeIdServicesVariableLldp = 19006
	OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesSupported                                                    OpcuaNodeIdServicesVariableLldp = 19007
	OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesEnabled                                                      OpcuaNodeIdServicesVariableLldp = 19008
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_IetfBaseNetworkInterfaceName                                               OpcuaNodeIdServicesVariableLldp = 19010
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_DestMacAddress                                                             OpcuaNodeIdServicesVariableLldp = 19011
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortIdSubtype                                                              OpcuaNodeIdServicesVariableLldp = 19012
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortId                                                                     OpcuaNodeIdServicesVariableLldp = 19013
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortDescription                                                            OpcuaNodeIdServicesVariableLldp = 19014
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_ManagementAddressTxPort                                                    OpcuaNodeIdServicesVariableLldp = 19015
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_TimeMark                    OpcuaNodeIdServicesVariableLldp = 19018
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteIndex                 OpcuaNodeIdServicesVariableLldp = 19019
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisIdSubtype            OpcuaNodeIdServicesVariableLldp = 19020
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisId                   OpcuaNodeIdServicesVariableLldp = 19021
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortIdSubtype               OpcuaNodeIdServicesVariableLldp = 19022
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortId                      OpcuaNodeIdServicesVariableLldp = 19023
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortDescription             OpcuaNodeIdServicesVariableLldp = 19024
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemName                  OpcuaNodeIdServicesVariableLldp = 19025
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemDescription           OpcuaNodeIdServicesVariableLldp = 19026
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesSupported OpcuaNodeIdServicesVariableLldp = 19027
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesEnabled   OpcuaNodeIdServicesVariableLldp = 19028
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteChanges               OpcuaNodeIdServicesVariableLldp = 19029
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteTooManyNeighbors      OpcuaNodeIdServicesVariableLldp = 19030
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ManagementAddress           OpcuaNodeIdServicesVariableLldp = 19031
	OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteUnknownTlv            OpcuaNodeIdServicesVariableLldp = 19032
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_TimeMark                                                                      OpcuaNodeIdServicesVariableLldp = 19034
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteIndex                                                                   OpcuaNodeIdServicesVariableLldp = 19035
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisIdSubtype                                                              OpcuaNodeIdServicesVariableLldp = 19036
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisId                                                                     OpcuaNodeIdServicesVariableLldp = 19037
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortIdSubtype                                                                 OpcuaNodeIdServicesVariableLldp = 19038
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortId                                                                        OpcuaNodeIdServicesVariableLldp = 19039
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortDescription                                                               OpcuaNodeIdServicesVariableLldp = 19040
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemName                                                                    OpcuaNodeIdServicesVariableLldp = 19041
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemDescription                                                             OpcuaNodeIdServicesVariableLldp = 19042
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesSupported                                                   OpcuaNodeIdServicesVariableLldp = 19043
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesEnabled                                                     OpcuaNodeIdServicesVariableLldp = 19044
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteChanges                                                                 OpcuaNodeIdServicesVariableLldp = 19045
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteTooManyNeighbors                                                        OpcuaNodeIdServicesVariableLldp = 19046
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ManagementAddress                                                             OpcuaNodeIdServicesVariableLldp = 19047
	OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteUnknownTlv                                                              OpcuaNodeIdServicesVariableLldp = 19078
)

var OpcuaNodeIdServicesVariableLldpValues []OpcuaNodeIdServicesVariableLldp

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableLldpValues = []OpcuaNodeIdServicesVariableLldp{
		OpcuaNodeIdServicesVariableLldp_LldpSystemCapabilitiesMap_OptionSetValues,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_LastChangeTime,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteInserts,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDeletes,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDrops,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteAgeouts,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisId,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemName,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemDescription,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesSupported,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesEnabled,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_IetfBaseNetworkInterfaceName,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_DestMacAddress,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortId,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortDescription,
		OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_ManagementAddressTxPort,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_LastChangeTime,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteInserts,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDeletes,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDrops,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteAgeouts,
		OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisId,
		OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemName,
		OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemDescription,
		OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesSupported,
		OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesEnabled,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_IetfBaseNetworkInterfaceName,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_DestMacAddress,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortId,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortDescription,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_ManagementAddressTxPort,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_TimeMark,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteIndex,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisId,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortId,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortDescription,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemName,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemDescription,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesSupported,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesEnabled,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteChanges,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteTooManyNeighbors,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ManagementAddress,
		OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteUnknownTlv,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_TimeMark,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteIndex,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisId,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortIdSubtype,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortId,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortDescription,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemName,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemDescription,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesSupported,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesEnabled,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteChanges,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteTooManyNeighbors,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ManagementAddress,
		OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteUnknownTlv,
	}
}

func OpcuaNodeIdServicesVariableLldpByValue(value int32) (enum OpcuaNodeIdServicesVariableLldp, ok bool) {
	switch value {
	case 18957:
		return OpcuaNodeIdServicesVariableLldp_LldpSystemCapabilitiesMap_OptionSetValues, true
	case 18975:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_LastChangeTime, true
	case 18976:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteInserts, true
	case 18977:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDeletes, true
	case 18978:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDrops, true
	case 18979:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteAgeouts, true
	case 18981:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisIdSubtype, true
	case 18982:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisId, true
	case 18983:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemName, true
	case 18984:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemDescription, true
	case 18985:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesSupported, true
	case 18986:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesEnabled, true
	case 18989:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_IetfBaseNetworkInterfaceName, true
	case 18990:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_DestMacAddress, true
	case 18991:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortIdSubtype, true
	case 18992:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortId, true
	case 18993:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortDescription, true
	case 18994:
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_ManagementAddressTxPort, true
	case 18997:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_LastChangeTime, true
	case 18998:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteInserts, true
	case 18999:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDeletes, true
	case 19000:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDrops, true
	case 19001:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteAgeouts, true
	case 19003:
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisIdSubtype, true
	case 19004:
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisId, true
	case 19005:
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemName, true
	case 19006:
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemDescription, true
	case 19007:
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesSupported, true
	case 19008:
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesEnabled, true
	case 19010:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_IetfBaseNetworkInterfaceName, true
	case 19011:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_DestMacAddress, true
	case 19012:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortIdSubtype, true
	case 19013:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortId, true
	case 19014:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortDescription, true
	case 19015:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_ManagementAddressTxPort, true
	case 19018:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_TimeMark, true
	case 19019:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteIndex, true
	case 19020:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisIdSubtype, true
	case 19021:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisId, true
	case 19022:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortIdSubtype, true
	case 19023:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortId, true
	case 19024:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortDescription, true
	case 19025:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemName, true
	case 19026:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemDescription, true
	case 19027:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesSupported, true
	case 19028:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesEnabled, true
	case 19029:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteChanges, true
	case 19030:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteTooManyNeighbors, true
	case 19031:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ManagementAddress, true
	case 19032:
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteUnknownTlv, true
	case 19034:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_TimeMark, true
	case 19035:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteIndex, true
	case 19036:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisIdSubtype, true
	case 19037:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisId, true
	case 19038:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortIdSubtype, true
	case 19039:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortId, true
	case 19040:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortDescription, true
	case 19041:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemName, true
	case 19042:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemDescription, true
	case 19043:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesSupported, true
	case 19044:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesEnabled, true
	case 19045:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteChanges, true
	case 19046:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteTooManyNeighbors, true
	case 19047:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ManagementAddress, true
	case 19078:
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteUnknownTlv, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableLldpByName(value string) (enum OpcuaNodeIdServicesVariableLldp, ok bool) {
	switch value {
	case "LldpSystemCapabilitiesMap_OptionSetValues":
		return OpcuaNodeIdServicesVariableLldp_LldpSystemCapabilitiesMap_OptionSetValues, true
	case "LldpInformationType_RemoteStatistics_LastChangeTime":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_LastChangeTime, true
	case "LldpInformationType_RemoteStatistics_RemoteInserts":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteInserts, true
	case "LldpInformationType_RemoteStatistics_RemoteDeletes":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDeletes, true
	case "LldpInformationType_RemoteStatistics_RemoteDrops":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDrops, true
	case "LldpInformationType_RemoteStatistics_RemoteAgeouts":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteAgeouts, true
	case "LldpInformationType_LocalSystemData_ChassisIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisIdSubtype, true
	case "LldpInformationType_LocalSystemData_ChassisId":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisId, true
	case "LldpInformationType_LocalSystemData_SystemName":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemName, true
	case "LldpInformationType_LocalSystemData_SystemDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemDescription, true
	case "LldpInformationType_LocalSystemData_SystemCapabilitiesSupported":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesSupported, true
	case "LldpInformationType_LocalSystemData_SystemCapabilitiesEnabled":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesEnabled, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder_IetfBaseNetworkInterfaceName":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_IetfBaseNetworkInterfaceName, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder_DestMacAddress":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_DestMacAddress, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder_PortIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortIdSubtype, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder_PortId":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortId, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder_PortDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortDescription, true
	case "LldpInformationType_Ports_LldpPortInformation_Placeholder_ManagementAddressTxPort":
		return OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_ManagementAddressTxPort, true
	case "LldpRemoteStatisticsType_LastChangeTime":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_LastChangeTime, true
	case "LldpRemoteStatisticsType_RemoteInserts":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteInserts, true
	case "LldpRemoteStatisticsType_RemoteDeletes":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDeletes, true
	case "LldpRemoteStatisticsType_RemoteDrops":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDrops, true
	case "LldpRemoteStatisticsType_RemoteAgeouts":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteAgeouts, true
	case "LldpLocalSystemType_ChassisIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisIdSubtype, true
	case "LldpLocalSystemType_ChassisId":
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisId, true
	case "LldpLocalSystemType_SystemName":
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemName, true
	case "LldpLocalSystemType_SystemDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemDescription, true
	case "LldpLocalSystemType_SystemCapabilitiesSupported":
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesSupported, true
	case "LldpLocalSystemType_SystemCapabilitiesEnabled":
		return OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesEnabled, true
	case "LldpPortInformationType_IetfBaseNetworkInterfaceName":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_IetfBaseNetworkInterfaceName, true
	case "LldpPortInformationType_DestMacAddress":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_DestMacAddress, true
	case "LldpPortInformationType_PortIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortIdSubtype, true
	case "LldpPortInformationType_PortId":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortId, true
	case "LldpPortInformationType_PortDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortDescription, true
	case "LldpPortInformationType_ManagementAddressTxPort":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_ManagementAddressTxPort, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_TimeMark":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_TimeMark, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteIndex":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteIndex, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisIdSubtype, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisId":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisId, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortIdSubtype, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortId":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortId, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortDescription, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemName":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemName, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemDescription, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesSupported":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesSupported, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesEnabled":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesEnabled, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteChanges":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteChanges, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteTooManyNeighbors":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteTooManyNeighbors, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ManagementAddress":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ManagementAddress, true
	case "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteUnknownTlv":
		return OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteUnknownTlv, true
	case "LldpRemoteSystemType_TimeMark":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_TimeMark, true
	case "LldpRemoteSystemType_RemoteIndex":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteIndex, true
	case "LldpRemoteSystemType_ChassisIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisIdSubtype, true
	case "LldpRemoteSystemType_ChassisId":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisId, true
	case "LldpRemoteSystemType_PortIdSubtype":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortIdSubtype, true
	case "LldpRemoteSystemType_PortId":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortId, true
	case "LldpRemoteSystemType_PortDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortDescription, true
	case "LldpRemoteSystemType_SystemName":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemName, true
	case "LldpRemoteSystemType_SystemDescription":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemDescription, true
	case "LldpRemoteSystemType_SystemCapabilitiesSupported":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesSupported, true
	case "LldpRemoteSystemType_SystemCapabilitiesEnabled":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesEnabled, true
	case "LldpRemoteSystemType_RemoteChanges":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteChanges, true
	case "LldpRemoteSystemType_RemoteTooManyNeighbors":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteTooManyNeighbors, true
	case "LldpRemoteSystemType_ManagementAddress":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ManagementAddress, true
	case "LldpRemoteSystemType_RemoteUnknownTlv":
		return OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteUnknownTlv, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableLldpKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableLldpValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableLldp(structType any) OpcuaNodeIdServicesVariableLldp {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableLldp {
		if sOpcuaNodeIdServicesVariableLldp, ok := typ.(OpcuaNodeIdServicesVariableLldp); ok {
			return sOpcuaNodeIdServicesVariableLldp
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableLldp) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableLldp) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableLldpParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableLldp, error) {
	return OpcuaNodeIdServicesVariableLldpParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableLldpParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableLldp, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableLldp", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableLldp")
	}
	if enum, ok := OpcuaNodeIdServicesVariableLldpByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableLldp")
		return OpcuaNodeIdServicesVariableLldp(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableLldp) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableLldp) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableLldp", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableLldp) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableLldp) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableLldp_LldpSystemCapabilitiesMap_OptionSetValues:
		return "LldpSystemCapabilitiesMap_OptionSetValues"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_LastChangeTime:
		return "LldpInformationType_RemoteStatistics_LastChangeTime"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteInserts:
		return "LldpInformationType_RemoteStatistics_RemoteInserts"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDeletes:
		return "LldpInformationType_RemoteStatistics_RemoteDeletes"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteDrops:
		return "LldpInformationType_RemoteStatistics_RemoteDrops"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_RemoteStatistics_RemoteAgeouts:
		return "LldpInformationType_RemoteStatistics_RemoteAgeouts"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisIdSubtype:
		return "LldpInformationType_LocalSystemData_ChassisIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_ChassisId:
		return "LldpInformationType_LocalSystemData_ChassisId"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemName:
		return "LldpInformationType_LocalSystemData_SystemName"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemDescription:
		return "LldpInformationType_LocalSystemData_SystemDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesSupported:
		return "LldpInformationType_LocalSystemData_SystemCapabilitiesSupported"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_LocalSystemData_SystemCapabilitiesEnabled:
		return "LldpInformationType_LocalSystemData_SystemCapabilitiesEnabled"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_IetfBaseNetworkInterfaceName:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder_IetfBaseNetworkInterfaceName"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_DestMacAddress:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder_DestMacAddress"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortIdSubtype:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder_PortIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortId:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder_PortId"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_PortDescription:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder_PortDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpInformationType_Ports_LldpPortInformation_Placeholder_ManagementAddressTxPort:
		return "LldpInformationType_Ports_LldpPortInformation_Placeholder_ManagementAddressTxPort"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_LastChangeTime:
		return "LldpRemoteStatisticsType_LastChangeTime"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteInserts:
		return "LldpRemoteStatisticsType_RemoteInserts"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDeletes:
		return "LldpRemoteStatisticsType_RemoteDeletes"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteDrops:
		return "LldpRemoteStatisticsType_RemoteDrops"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteStatisticsType_RemoteAgeouts:
		return "LldpRemoteStatisticsType_RemoteAgeouts"
	case OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisIdSubtype:
		return "LldpLocalSystemType_ChassisIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_ChassisId:
		return "LldpLocalSystemType_ChassisId"
	case OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemName:
		return "LldpLocalSystemType_SystemName"
	case OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemDescription:
		return "LldpLocalSystemType_SystemDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesSupported:
		return "LldpLocalSystemType_SystemCapabilitiesSupported"
	case OpcuaNodeIdServicesVariableLldp_LldpLocalSystemType_SystemCapabilitiesEnabled:
		return "LldpLocalSystemType_SystemCapabilitiesEnabled"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_IetfBaseNetworkInterfaceName:
		return "LldpPortInformationType_IetfBaseNetworkInterfaceName"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_DestMacAddress:
		return "LldpPortInformationType_DestMacAddress"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortIdSubtype:
		return "LldpPortInformationType_PortIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortId:
		return "LldpPortInformationType_PortId"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_PortDescription:
		return "LldpPortInformationType_PortDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_ManagementAddressTxPort:
		return "LldpPortInformationType_ManagementAddressTxPort"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_TimeMark:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_TimeMark"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteIndex:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteIndex"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisIdSubtype:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisId:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ChassisId"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortIdSubtype:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortId:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortId"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortDescription:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_PortDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemName:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemName"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemDescription:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesSupported:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesSupported"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesEnabled:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_SystemCapabilitiesEnabled"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteChanges:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteChanges"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteTooManyNeighbors:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteTooManyNeighbors"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ManagementAddress:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_ManagementAddress"
	case OpcuaNodeIdServicesVariableLldp_LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteUnknownTlv:
		return "LldpPortInformationType_RemoteSystemsData_LldpRemoteSystem_Placeholder_RemoteUnknownTlv"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_TimeMark:
		return "LldpRemoteSystemType_TimeMark"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteIndex:
		return "LldpRemoteSystemType_RemoteIndex"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisIdSubtype:
		return "LldpRemoteSystemType_ChassisIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ChassisId:
		return "LldpRemoteSystemType_ChassisId"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortIdSubtype:
		return "LldpRemoteSystemType_PortIdSubtype"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortId:
		return "LldpRemoteSystemType_PortId"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_PortDescription:
		return "LldpRemoteSystemType_PortDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemName:
		return "LldpRemoteSystemType_SystemName"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemDescription:
		return "LldpRemoteSystemType_SystemDescription"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesSupported:
		return "LldpRemoteSystemType_SystemCapabilitiesSupported"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_SystemCapabilitiesEnabled:
		return "LldpRemoteSystemType_SystemCapabilitiesEnabled"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteChanges:
		return "LldpRemoteSystemType_RemoteChanges"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteTooManyNeighbors:
		return "LldpRemoteSystemType_RemoteTooManyNeighbors"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_ManagementAddress:
		return "LldpRemoteSystemType_ManagementAddress"
	case OpcuaNodeIdServicesVariableLldp_LldpRemoteSystemType_RemoteUnknownTlv:
		return "LldpRemoteSystemType_RemoteUnknownTlv"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableLldp) String() string {
	return e.PLC4XEnumName()
}
