/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// OpcuaNodeIdServicesVariableTest is an enum
type OpcuaNodeIdServicesVariableTest int32

type IOpcuaNodeIdServicesVariableTest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	OpcuaNodeIdServicesVariableTest_TestEnumeration_EnumValues    OpcuaNodeIdServicesVariableTest = 15433
	OpcuaNodeIdServicesVariableTest_TestOptionSet_OptionSetValues OpcuaNodeIdServicesVariableTest = 19441
)

var OpcuaNodeIdServicesVariableTestValues []OpcuaNodeIdServicesVariableTest

func init() {
	_ = errors.New
	OpcuaNodeIdServicesVariableTestValues = []OpcuaNodeIdServicesVariableTest{
		OpcuaNodeIdServicesVariableTest_TestEnumeration_EnumValues,
		OpcuaNodeIdServicesVariableTest_TestOptionSet_OptionSetValues,
	}
}

func OpcuaNodeIdServicesVariableTestByValue(value int32) (enum OpcuaNodeIdServicesVariableTest, ok bool) {
	switch value {
	case 15433:
		return OpcuaNodeIdServicesVariableTest_TestEnumeration_EnumValues, true
	case 19441:
		return OpcuaNodeIdServicesVariableTest_TestOptionSet_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTestByName(value string) (enum OpcuaNodeIdServicesVariableTest, ok bool) {
	switch value {
	case "TestEnumeration_EnumValues":
		return OpcuaNodeIdServicesVariableTest_TestEnumeration_EnumValues, true
	case "TestOptionSet_OptionSetValues":
		return OpcuaNodeIdServicesVariableTest_TestOptionSet_OptionSetValues, true
	}
	return 0, false
}

func OpcuaNodeIdServicesVariableTestKnows(value int32) bool {
	for _, typeValue := range OpcuaNodeIdServicesVariableTestValues {
		if int32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastOpcuaNodeIdServicesVariableTest(structType any) OpcuaNodeIdServicesVariableTest {
	castFunc := func(typ any) OpcuaNodeIdServicesVariableTest {
		if sOpcuaNodeIdServicesVariableTest, ok := typ.(OpcuaNodeIdServicesVariableTest); ok {
			return sOpcuaNodeIdServicesVariableTest
		}
		return 0
	}
	return castFunc(structType)
}

func (m OpcuaNodeIdServicesVariableTest) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m OpcuaNodeIdServicesVariableTest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func OpcuaNodeIdServicesVariableTestParse(ctx context.Context, theBytes []byte) (OpcuaNodeIdServicesVariableTest, error) {
	return OpcuaNodeIdServicesVariableTestParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func OpcuaNodeIdServicesVariableTestParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (OpcuaNodeIdServicesVariableTest, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadInt32("OpcuaNodeIdServicesVariableTest", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading OpcuaNodeIdServicesVariableTest")
	}
	if enum, ok := OpcuaNodeIdServicesVariableTestByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for OpcuaNodeIdServicesVariableTest")
		return OpcuaNodeIdServicesVariableTest(val), nil
	} else {
		return enum, nil
	}
}

func (e OpcuaNodeIdServicesVariableTest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e OpcuaNodeIdServicesVariableTest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteInt32("OpcuaNodeIdServicesVariableTest", 32, int32(int32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e OpcuaNodeIdServicesVariableTest) GetValue() int32 {
	return int32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e OpcuaNodeIdServicesVariableTest) PLC4XEnumName() string {
	switch e {
	case OpcuaNodeIdServicesVariableTest_TestEnumeration_EnumValues:
		return "TestEnumeration_EnumValues"
	case OpcuaNodeIdServicesVariableTest_TestOptionSet_OptionSetValues:
		return "TestOptionSet_OptionSetValues"
	}
	return fmt.Sprintf("Unknown(%v)", int32(e))
}

func (e OpcuaNodeIdServicesVariableTest) String() string {
	return e.PLC4XEnumName()
}
