/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// ControllerType is an enum
type ControllerType uint32

type IControllerType interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

const (
	ControllerType_ANY     ControllerType = 0
	ControllerType_S7_200  ControllerType = 1
	ControllerType_S7_300  ControllerType = 2
	ControllerType_S7_400  ControllerType = 3
	ControllerType_S7_1200 ControllerType = 4
	ControllerType_S7_1500 ControllerType = 5
	ControllerType_LOGO    ControllerType = 6
)

var ControllerTypeValues []ControllerType

func init() {
	_ = errors.New
	ControllerTypeValues = []ControllerType{
		ControllerType_ANY,
		ControllerType_S7_200,
		ControllerType_S7_300,
		ControllerType_S7_400,
		ControllerType_S7_1200,
		ControllerType_S7_1500,
		ControllerType_LOGO,
	}
}

func ControllerTypeByValue(value uint32) (enum ControllerType, ok bool) {
	switch value {
	case 0:
		return ControllerType_ANY, true
	case 1:
		return ControllerType_S7_200, true
	case 2:
		return ControllerType_S7_300, true
	case 3:
		return ControllerType_S7_400, true
	case 4:
		return ControllerType_S7_1200, true
	case 5:
		return ControllerType_S7_1500, true
	case 6:
		return ControllerType_LOGO, true
	}
	return 0, false
}

func ControllerTypeByName(value string) (enum ControllerType, ok bool) {
	switch value {
	case "ANY":
		return ControllerType_ANY, true
	case "S7_200":
		return ControllerType_S7_200, true
	case "S7_300":
		return ControllerType_S7_300, true
	case "S7_400":
		return ControllerType_S7_400, true
	case "S7_1200":
		return ControllerType_S7_1200, true
	case "S7_1500":
		return ControllerType_S7_1500, true
	case "LOGO":
		return ControllerType_LOGO, true
	}
	return 0, false
}

func ControllerTypeKnows(value uint32) bool {
	for _, typeValue := range ControllerTypeValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastControllerType(structType any) ControllerType {
	castFunc := func(typ any) ControllerType {
		if sControllerType, ok := typ.(ControllerType); ok {
			return sControllerType
		}
		return 0
	}
	return castFunc(structType)
}

func (m ControllerType) GetLengthInBits(ctx context.Context) uint16 {
	return 32
}

func (m ControllerType) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ControllerTypeParse(ctx context.Context, theBytes []byte) (ControllerType, error) {
	return ControllerTypeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ControllerTypeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ControllerType, error) {
	log := zerolog.Ctx(ctx)
	_ = log
	val, err := /*TODO: migrate me*/ /*TODO: migrate me*/ readBuffer.ReadUint32("ControllerType", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading ControllerType")
	}
	if enum, ok := ControllerTypeByValue(val); !ok {
		log.Debug().Interface("val", val).Msg("no value val found for ControllerType")
		return ControllerType(val), nil
	} else {
		return enum, nil
	}
}

func (e ControllerType) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased()
	if err := e.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (e ControllerType) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	log := zerolog.Ctx(ctx)
	_ = log
	return /*TODO: migrate me*/ writeBuffer.WriteUint32("ControllerType", 32, uint32(uint32(e)), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

func (e ControllerType) GetValue() uint32 {
	return uint32(e)
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e ControllerType) PLC4XEnumName() string {
	switch e {
	case ControllerType_ANY:
		return "ANY"
	case ControllerType_S7_200:
		return "S7_200"
	case ControllerType_S7_300:
		return "S7_300"
	case ControllerType_S7_400:
		return "S7_400"
	case ControllerType_S7_1200:
		return "S7_1200"
	case ControllerType_S7_1500:
		return "S7_1500"
	case ControllerType_LOGO:
		return "LOGO"
	}
	return fmt.Sprintf("Unknown(%v)", uint32(e))
}

func (e ControllerType) String() string {
	return e.PLC4XEnumName()
}
