/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SecurityDataPasswordEntryStatus extends SecurityData implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final byte code;

  public SecurityDataPasswordEntryStatus(
      SecurityCommandTypeContainer commandTypeContainer, byte argument, byte code) {
    super(commandTypeContainer, argument);
    this.code = code;
  }

  public byte getCode() {
    return code;
  }

  public boolean getIsPasswordEntrySucceeded() {
    return (boolean) ((getCode()) == (0x01));
  }

  public boolean getIsPasswordEntryFailed() {
    return (boolean) ((getCode()) == (0x02));
  }

  public boolean getIsPasswordEntryDisabled() {
    return (boolean) ((getCode()) == (0x03));
  }

  public boolean getIsPasswordEntryEnabledAgain() {
    return (boolean) ((getCode()) == (0x04));
  }

  public boolean getIsReserved() {
    return (boolean) ((getCode()) >= (0x05));
  }

  @Override
  protected void serializeSecurityDataChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SecurityDataPasswordEntryStatus");

    // Simple Field (code)
    writeSimpleField("code", code, writeByte(writeBuffer, 8));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isPasswordEntrySucceeded = getIsPasswordEntrySucceeded();
    writeBuffer.writeVirtual("isPasswordEntrySucceeded", isPasswordEntrySucceeded);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isPasswordEntryFailed = getIsPasswordEntryFailed();
    writeBuffer.writeVirtual("isPasswordEntryFailed", isPasswordEntryFailed);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isPasswordEntryDisabled = getIsPasswordEntryDisabled();
    writeBuffer.writeVirtual("isPasswordEntryDisabled", isPasswordEntryDisabled);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isPasswordEntryEnabledAgain = getIsPasswordEntryEnabledAgain();
    writeBuffer.writeVirtual("isPasswordEntryEnabledAgain", isPasswordEntryEnabledAgain);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isReserved = getIsReserved();
    writeBuffer.writeVirtual("isReserved", isReserved);

    writeBuffer.popContext("SecurityDataPasswordEntryStatus");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SecurityDataPasswordEntryStatus _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (code)
    lengthInBits += 8;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static SecurityDataBuilder staticParseSecurityDataBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("SecurityDataPasswordEntryStatus");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte code = readSimpleField("code", readByte(readBuffer, 8));
    boolean isPasswordEntrySucceeded =
        readVirtualField("isPasswordEntrySucceeded", boolean.class, (code) == (0x01));
    boolean isPasswordEntryFailed =
        readVirtualField("isPasswordEntryFailed", boolean.class, (code) == (0x02));
    boolean isPasswordEntryDisabled =
        readVirtualField("isPasswordEntryDisabled", boolean.class, (code) == (0x03));
    boolean isPasswordEntryEnabledAgain =
        readVirtualField("isPasswordEntryEnabledAgain", boolean.class, (code) == (0x04));
    boolean isReserved = readVirtualField("isReserved", boolean.class, (code) >= (0x05));

    readBuffer.closeContext("SecurityDataPasswordEntryStatus");
    // Create the instance
    return new SecurityDataPasswordEntryStatusBuilderImpl(code);
  }

  public static class SecurityDataPasswordEntryStatusBuilderImpl
      implements SecurityData.SecurityDataBuilder {
    private final byte code;

    public SecurityDataPasswordEntryStatusBuilderImpl(byte code) {
      this.code = code;
    }

    public SecurityDataPasswordEntryStatus build(
        SecurityCommandTypeContainer commandTypeContainer, byte argument) {
      SecurityDataPasswordEntryStatus securityDataPasswordEntryStatus =
          new SecurityDataPasswordEntryStatus(commandTypeContainer, argument, code);
      return securityDataPasswordEntryStatus;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SecurityDataPasswordEntryStatus)) {
      return false;
    }
    SecurityDataPasswordEntryStatus that = (SecurityDataPasswordEntryStatus) o;
    return (getCode() == that.getCode()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getCode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
