/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum TemperatureBroadcastCommandTypeContainer {
  TemperatureBroadcastCommandSetBroadcastEvent0_2Bytes(
      (short) 0x02, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent1_2Bytes(
      (short) 0x0A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent2_2Bytes(
      (short) 0x12, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent3_2Bytes(
      (short) 0x1A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent4_2Bytes(
      (short) 0x22, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent5_2Bytes(
      (short) 0x2A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent6_2Bytes(
      (short) 0x32, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent7_2Bytes(
      (short) 0x3A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent8_2Bytes(
      (short) 0x42, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent9_2Bytes(
      (short) 0x4A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent10_2Bytes(
      (short) 0x52, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent11_2Bytes(
      (short) 0x5A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent12_2Bytes(
      (short) 0x62, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent13_2Bytes(
      (short) 0x6A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent14_2Bytes(
      (short) 0x72, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT),
  TemperatureBroadcastCommandSetBroadcastEvent15_2Bytes(
      (short) 0x7A, (byte) 2, TemperatureBroadcastCommandType.BROADCAST_EVENT);
  private static final Map<Short, TemperatureBroadcastCommandTypeContainer> map;

  static {
    map = new HashMap<>();
    for (TemperatureBroadcastCommandTypeContainer value :
        TemperatureBroadcastCommandTypeContainer.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final byte numBytes;
  private final TemperatureBroadcastCommandType commandType;

  TemperatureBroadcastCommandTypeContainer(
      short value, byte numBytes, TemperatureBroadcastCommandType commandType) {
    this.value = value;
    this.numBytes = numBytes;
    this.commandType = commandType;
  }

  public short getValue() {
    return value;
  }

  public byte getNumBytes() {
    return numBytes;
  }

  public static TemperatureBroadcastCommandTypeContainer firstEnumForFieldNumBytes(
      byte fieldValue) {
    for (TemperatureBroadcastCommandTypeContainer _val :
        TemperatureBroadcastCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<TemperatureBroadcastCommandTypeContainer> enumsForFieldNumBytes(
      byte fieldValue) {
    List<TemperatureBroadcastCommandTypeContainer> _values = new ArrayList<>();
    for (TemperatureBroadcastCommandTypeContainer _val :
        TemperatureBroadcastCommandTypeContainer.values()) {
      if (_val.getNumBytes() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public TemperatureBroadcastCommandType getCommandType() {
    return commandType;
  }

  public static TemperatureBroadcastCommandTypeContainer firstEnumForFieldCommandType(
      TemperatureBroadcastCommandType fieldValue) {
    for (TemperatureBroadcastCommandTypeContainer _val :
        TemperatureBroadcastCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<TemperatureBroadcastCommandTypeContainer> enumsForFieldCommandType(
      TemperatureBroadcastCommandType fieldValue) {
    List<TemperatureBroadcastCommandTypeContainer> _values = new ArrayList<>();
    for (TemperatureBroadcastCommandTypeContainer _val :
        TemperatureBroadcastCommandTypeContainer.values()) {
      if (_val.getCommandType() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static TemperatureBroadcastCommandTypeContainer enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
