/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum KnxPropertyDataType {
  PDT_UNKNOWN((short) 0, (short) 0, (short) 0, (String) "Unknown Property Data Type"),
  PDT_CONTROL((short) 1, (short) 0, (short) 10, (String) "PDT_CONTROL"),
  PDT_CHAR((short) 2, (short) 1, (short) 1, (String) "PDT_CHAR"),
  PDT_UNSIGNED_CHAR((short) 3, (short) 2, (short) 1, (String) "PDT_UNSIGNED_CHAR"),
  PDT_INT((short) 4, (short) 3, (short) 2, (String) "PDT_INT"),
  PDT_UNSIGNED_INT((short) 5, (short) 4, (short) 2, (String) "PDT_UNSIGNED_INT"),
  PDT_KNX_FLOAT((short) 6, (short) 5, (short) 2, (String) "PDT_KNX_FLOAT"),
  PDT_DATE((short) 7, (short) 6, (short) 3, (String) "PDT_DATE"),
  PDT_TIME((short) 8, (short) 7, (short) 3, (String) "PDT_TIME"),
  PDT_LONG((short) 9, (short) 8, (short) 4, (String) "PDT_LONG"),
  PDT_UNSIGNED_LONG((short) 10, (short) 9, (short) 4, (String) "PDT_UNSIGNED_LONG"),
  PDT_FLOAT((short) 11, (short) 10, (short) 4, (String) "PDT_FLOAT"),
  PDT_DOUBLE((short) 12, (short) 11, (short) 8, (String) "PDT_DOUBLE"),
  PDT_CHAR_BLOCK((short) 13, (short) 12, (short) 10, (String) "PDT_CHAR_BLOCK"),
  PDT_POLL_GROUP_SETTINGS((short) 14, (short) 13, (short) 3, (String) "PDT_POLL_GROUP_SETTINGS"),
  PDT_SHORT_CHAR_BLOCK((short) 15, (short) 14, (short) 5, (String) "PDT_SHORT_CHAR_BLOCK"),
  PDT_DATE_TIME((short) 16, (short) 15, (short) 8, (String) "PDT_DATE_TIME"),
  PDT_VARIABLE_LENGTH((short) 17, (short) 16, (short) 0, (String) "PDT_VARIABLE_LENGTH"),
  PDT_GENERIC_01((short) 18, (short) 17, (short) 1, (String) "PDT_GENERIC_01"),
  PDT_GENERIC_02((short) 19, (short) 18, (short) 2, (String) "PDT_GENERIC_02"),
  PDT_GENERIC_03((short) 20, (short) 19, (short) 3, (String) "PDT_GENERIC_03"),
  PDT_GENERIC_04((short) 21, (short) 20, (short) 4, (String) "PDT_GENERIC_04"),
  PDT_GENERIC_05((short) 22, (short) 21, (short) 5, (String) "PDT_GENERIC_05"),
  PDT_GENERIC_06((short) 23, (short) 22, (short) 6, (String) "PDT_GENERIC_06"),
  PDT_GENERIC_07((short) 24, (short) 23, (short) 7, (String) "PDT_GENERIC_07"),
  PDT_GENERIC_08((short) 25, (short) 24, (short) 8, (String) "PDT_GENERIC_08"),
  PDT_GENERIC_09((short) 26, (short) 25, (short) 9, (String) "PDT_GENERIC_09"),
  PDT_GENERIC_10((short) 27, (short) 26, (short) 10, (String) "PDT_GENERIC_10"),
  PDT_GENERIC_11((short) 28, (short) 27, (short) 11, (String) "PDT_GENERIC_11"),
  PDT_GENERIC_12((short) 29, (short) 28, (short) 12, (String) "PDT_GENERIC_12"),
  PDT_GENERIC_13((short) 30, (short) 29, (short) 13, (String) "PDT_GENERIC_13"),
  PDT_GENERIC_14((short) 31, (short) 30, (short) 14, (String) "PDT_GENERIC_14"),
  PDT_GENERIC_15((short) 32, (short) 31, (short) 15, (String) "PDT_GENERIC_15"),
  PDT_GENERIC_16((short) 33, (short) 32, (short) 16, (String) "PDT_GENERIC_16"),
  PDT_GENERIC_17((short) 34, (short) 33, (short) 17, (String) "PDT_GENERIC_17"),
  PDT_GENERIC_18((short) 35, (short) 34, (short) 18, (String) "PDT_GENERIC_18"),
  PDT_GENERIC_19((short) 36, (short) 35, (short) 19, (String) "PDT_GENERIC_19"),
  PDT_GENERIC_20((short) 37, (short) 36, (short) 20, (String) "PDT_GENERIC_20"),
  PDT_UTF_8((short) 38, (short) 47, (short) 0, (String) "PDT_UTF-8"),
  PDT_VERSION((short) 39, (short) 48, (short) 2, (String) "PDT_VERSION"),
  PDT_ALARM_INFO((short) 40, (short) 49, (short) 6, (String) "PDT_ALARM_INFO"),
  PDT_BINARY_INFORMATION((short) 41, (short) 50, (short) 1, (String) "PDT_BINARY_INFORMATION"),
  PDT_BITSET8((short) 42, (short) 51, (short) 1, (String) "PDT_BITSET8"),
  PDT_BITSET16((short) 43, (short) 52, (short) 2, (String) "PDT_BITSET16"),
  PDT_ENUM8((short) 44, (short) 53, (short) 1, (String) "PDT_ENUM8"),
  PDT_SCALING((short) 45, (short) 54, (short) 1, (String) "PDT_SCALING"),
  PDT_NE_VL((short) 46, (short) 60, (short) 0, (String) "PDT_NE_VL"),
  PDT_NE_FL((short) 47, (short) 61, (short) 0, (String) "PDT_NE_FL"),
  PDT_FUNCTION((short) 48, (short) 62, (short) 0, (String) "PDT_FUNCTION"),
  PDT_ESCAPE((short) 49, (short) 63, (short) 0, (String) "PDT_ESCAPE");
  private static final Map<Short, KnxPropertyDataType> map;

  static {
    map = new HashMap<>();
    for (KnxPropertyDataType value : KnxPropertyDataType.values()) {
      map.put((short) value.getValue(), value);
    }
  }

  private final short value;
  private final short number;
  private final short sizeInBytes;
  private final String name;

  KnxPropertyDataType(short value, short number, short sizeInBytes, String name) {
    this.value = value;
    this.number = number;
    this.sizeInBytes = sizeInBytes;
    this.name = name;
  }

  public short getValue() {
    return value;
  }

  public short getNumber() {
    return number;
  }

  public static KnxPropertyDataType firstEnumForFieldNumber(short fieldValue) {
    for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
      if (_val.getNumber() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxPropertyDataType> enumsForFieldNumber(short fieldValue) {
    List<KnxPropertyDataType> _values = new ArrayList<>();
    for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
      if (_val.getNumber() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public short getSizeInBytes() {
    return sizeInBytes;
  }

  public static KnxPropertyDataType firstEnumForFieldSizeInBytes(short fieldValue) {
    for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
      if (_val.getSizeInBytes() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxPropertyDataType> enumsForFieldSizeInBytes(short fieldValue) {
    List<KnxPropertyDataType> _values = new ArrayList<>();
    for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
      if (_val.getSizeInBytes() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public String getName() {
    return name;
  }

  public static KnxPropertyDataType firstEnumForFieldName(String fieldValue) {
    for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
      if (_val.getName().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<KnxPropertyDataType> enumsForFieldName(String fieldValue) {
    List<KnxPropertyDataType> _values = new ArrayList<>();
    for (KnxPropertyDataType _val : KnxPropertyDataType.values()) {
      if (_val.getName().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static KnxPropertyDataType enumForValue(short value) {
    return map.get(value);
  }

  public static Boolean isDefined(short value) {
    return map.containsKey(value);
  }
}
