/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.controller.impl.manager;

import java.util.HashSet;
import java.util.Set;

public class SyncStateInfo {
    private final String clusterName;
    private final String brokerName;
    private Set<String> syncStateSet;
    private int syncStateSetEpoch;
    private String masterAddress;
    private int masterEpoch;

    public SyncStateInfo(String clusterName, String brokerName, String masterAddress) {
        this.clusterName = clusterName;
        this.brokerName = brokerName;
        this.masterAddress = masterAddress;
        this.masterEpoch = 1;
        this.syncStateSet = new HashSet<String>();
        this.syncStateSet.add(masterAddress);
        this.syncStateSetEpoch = 1;
    }

    public void updateMasterInfo(String masterAddress) {
        this.masterAddress = masterAddress;
        ++this.masterEpoch;
    }

    public void updateSyncStateSetInfo(Set<String> newSyncStateSet) {
        this.syncStateSet = new HashSet<String>(newSyncStateSet);
        ++this.syncStateSetEpoch;
    }

    public boolean isMasterExist() {
        return !this.masterAddress.isEmpty();
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public Set<String> getSyncStateSet() {
        return new HashSet<String>(this.syncStateSet);
    }

    public int getSyncStateSetEpoch() {
        return this.syncStateSetEpoch;
    }

    public String getMasterAddress() {
        return this.masterAddress;
    }

    public int getMasterEpoch() {
        return this.masterEpoch;
    }

    public void removeSyncState(String address) {
        this.syncStateSet.remove(address);
    }
}

