/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.metrics;

import com.google.common.base.Splitter;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongGauge;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.metrics.BrokerMetricsManager;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.StartAndShutdown;
import org.apache.rocketmq.proxy.config.ProxyConfig;

public class ProxyMetricsManager
implements StartAndShutdown {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    private static ProxyConfig proxyConfig;
    private static final Map<String, String> LABEL_MAP;
    public static Supplier<AttributesBuilder> attributesBuilderSupplier;
    private OtlpGrpcMetricExporter metricExporter;
    private PeriodicMetricReader periodicMetricReader;
    private PrometheusHttpServer prometheusHttpServer;
    public static ObservableLongGauge proxyUp;

    public static void initLocalMode(BrokerMetricsManager brokerMetricsManager, ProxyConfig proxyConfig) {
        if (proxyConfig.getMetricsExporterType() == BrokerConfig.MetricsExporterType.DISABLE) {
            return;
        }
        ProxyMetricsManager.proxyConfig = proxyConfig;
        LABEL_MAP.put("node_type", "proxy");
        LABEL_MAP.put("cluster", proxyConfig.getProxyClusterName());
        LABEL_MAP.put("node_id", proxyConfig.getProxyName());
        LABEL_MAP.put("proxy_mode", proxyConfig.getProxyMode().toLowerCase());
        ProxyMetricsManager.initMetrics(brokerMetricsManager.getBrokerMeter(), BrokerMetricsManager::newAttributesBuilder);
    }

    public static ProxyMetricsManager initClusterMode(ProxyConfig proxyConfig) {
        ProxyMetricsManager.proxyConfig = proxyConfig;
        return new ProxyMetricsManager();
    }

    public static AttributesBuilder newAttributesBuilder() {
        if (attributesBuilderSupplier == null) {
            AttributesBuilder attributesBuilder = Attributes.builder();
            LABEL_MAP.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
            return attributesBuilder;
        }
        AttributesBuilder attributesBuilder = attributesBuilderSupplier.get();
        LABEL_MAP.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder;
    }

    private static void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        ProxyMetricsManager.attributesBuilderSupplier = attributesBuilderSupplier;
        proxyUp = meter.gaugeBuilder("rocketmq_proxy_up").setDescription("proxy status").ofLongs().buildWithCallback(measurement -> measurement.record(1L, ProxyMetricsManager.newAttributesBuilder().build()));
    }

    private boolean checkConfig() {
        if (proxyConfig == null) {
            return false;
        }
        BrokerConfig.MetricsExporterType exporterType = proxyConfig.getMetricsExporterType();
        if (!exporterType.isEnable()) {
            return false;
        }
        switch (exporterType) {
            case OTLP_GRPC: {
                return StringUtils.isNotBlank((CharSequence)proxyConfig.getMetricsGrpcExporterTarget());
            }
            case PROM: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void start() throws Exception {
        BrokerConfig.MetricsExporterType metricsExporterType = proxyConfig.getMetricsExporterType();
        if (metricsExporterType == BrokerConfig.MetricsExporterType.DISABLE) {
            return;
        }
        if (!this.checkConfig()) {
            log.error("check metrics config failed, will not export metrics");
            return;
        }
        String labels = proxyConfig.getMetricsLabel();
        if (StringUtils.isNotBlank((CharSequence)labels)) {
            List kvPairs = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)labels);
            for (String item : kvPairs) {
                String[] split = item.split(":");
                if (split.length != 2) {
                    log.warn("metricsLabel is not valid: {}", (Object)labels);
                    continue;
                }
                LABEL_MAP.put(split[0], split[1]);
            }
        }
        if (proxyConfig.isMetricsInDelta()) {
            LABEL_MAP.put("aggregation", "delta");
        }
        LABEL_MAP.put("node_type", "proxy");
        LABEL_MAP.put("cluster", proxyConfig.getProxyClusterName());
        LABEL_MAP.put("node_id", proxyConfig.getProxyName());
        LABEL_MAP.put("proxy_mode", proxyConfig.getProxyMode().toLowerCase());
        SdkMeterProviderBuilder providerBuilder = SdkMeterProvider.builder().setResource(Resource.empty());
        if (metricsExporterType == BrokerConfig.MetricsExporterType.OTLP_GRPC) {
            String endpoint = proxyConfig.getMetricsGrpcExporterTarget();
            if (!endpoint.startsWith("http")) {
                endpoint = "https://" + endpoint;
            }
            OtlpGrpcMetricExporterBuilder metricExporterBuilder = OtlpGrpcMetricExporter.builder().setEndpoint(endpoint).setTimeout(proxyConfig.getMetricGrpcExporterTimeOutInMills(), TimeUnit.MILLISECONDS).setAggregationTemporalitySelector(type -> {
                if (proxyConfig.isMetricsInDelta() && (type == InstrumentType.COUNTER || type == InstrumentType.OBSERVABLE_COUNTER || type == InstrumentType.HISTOGRAM)) {
                    return AggregationTemporality.DELTA;
                }
                return AggregationTemporality.CUMULATIVE;
            });
            String headers = proxyConfig.getMetricsGrpcExporterHeader();
            if (StringUtils.isNotBlank((CharSequence)headers)) {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                List kvPairs = Splitter.on((char)',').omitEmptyStrings().splitToList((CharSequence)headers);
                for (String item : kvPairs) {
                    String[] split = item.split(":");
                    if (split.length != 2) {
                        log.warn("metricsGrpcExporterHeader is not valid: {}", (Object)headers);
                        continue;
                    }
                    headerMap.put(split[0], split[1]);
                }
                headerMap.forEach((arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)metricExporterBuilder).addHeader(arg_0, arg_1));
            }
            this.metricExporter = metricExporterBuilder.build();
            this.periodicMetricReader = PeriodicMetricReader.builder((MetricExporter)this.metricExporter).setInterval(proxyConfig.getMetricGrpcExporterIntervalInMills(), TimeUnit.MILLISECONDS).build();
            providerBuilder.registerMetricReader((MetricReader)this.periodicMetricReader);
        }
        if (metricsExporterType == BrokerConfig.MetricsExporterType.PROM) {
            String promExporterHost = proxyConfig.getMetricsPromExporterHost();
            if (StringUtils.isBlank((CharSequence)promExporterHost)) {
                promExporterHost = "0.0.0.0";
            }
            this.prometheusHttpServer = PrometheusHttpServer.builder().setHost(promExporterHost).setPort(proxyConfig.getMetricsPromExporterPort()).build();
            providerBuilder.registerMetricReader((MetricReader)this.prometheusHttpServer);
        }
        Meter proxyMeter = OpenTelemetrySdk.builder().setMeterProvider(providerBuilder.build()).build().getMeter("broker-meter");
        ProxyMetricsManager.initMetrics(proxyMeter, null);
    }

    @Override
    public void shutdown() throws Exception {
        if (proxyConfig.getMetricsExporterType() == BrokerConfig.MetricsExporterType.OTLP_GRPC) {
            this.periodicMetricReader.forceFlush();
            this.periodicMetricReader.shutdown();
            this.metricExporter.shutdown();
        }
        if (proxyConfig.getMetricsExporterType() == BrokerConfig.MetricsExporterType.PROM) {
            this.prometheusHttpServer.forceFlush();
            this.prometheusHttpServer.shutdown();
        }
    }

    static {
        LABEL_MAP = new HashMap<String, String>();
        proxyUp = null;
    }
}

