/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.ha.autoswitch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.rocketmq.common.utils.CheckpointFile;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.EpochEntry;

public class EpochFileCache {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final TreeMap<Integer, EpochEntry> epochMap = new TreeMap();
    private CheckpointFile<EpochEntry> checkpoint;

    public EpochFileCache() {
    }

    public EpochFileCache(String path) {
        this.checkpoint = new CheckpointFile(path, (CheckpointFile.CheckpointSerializer)new EpochEntrySerializer());
    }

    public boolean initCacheFromFile() {
        this.writeLock.lock();
        try {
            List entries = this.checkpoint.read();
            this.initEntries(entries);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("Error happen when init epoch entries from epochFile", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void initCacheFromEntries(List<EpochEntry> entries) {
        this.writeLock.lock();
        try {
            this.initEntries(entries);
            this.flush();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initEntries(List<EpochEntry> entries) {
        this.epochMap.clear();
        EpochEntry preEntry = null;
        for (EpochEntry entry : entries) {
            this.epochMap.put(entry.getEpoch(), entry);
            if (preEntry != null) {
                preEntry.setEndOffset(entry.getStartOffset());
            }
            preEntry = entry;
        }
    }

    public int getEntrySize() {
        this.readLock.lock();
        try {
            int n = this.epochMap.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendEntry(EpochEntry entry) {
        this.writeLock.lock();
        try {
            if (!this.epochMap.isEmpty()) {
                EpochEntry lastEntry = this.epochMap.lastEntry().getValue();
                if (lastEntry.getEpoch() >= entry.getEpoch() || lastEntry.getStartOffset() >= entry.getStartOffset()) {
                    log.error("The appending entry's lastEpoch or endOffset {} is not bigger than lastEntry {}, append failed", (Object)entry, (Object)lastEntry);
                    boolean bl = false;
                    return bl;
                }
                lastEntry.setEndOffset(entry.getStartOffset());
            }
            this.epochMap.put(entry.getEpoch(), new EpochEntry(entry));
            this.flush();
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastEpochEntryEndOffset(long endOffset) {
        this.writeLock.lock();
        try {
            EpochEntry lastEntry;
            if (!this.epochMap.isEmpty() && (lastEntry = this.epochMap.lastEntry().getValue()).getStartOffset() <= endOffset) {
                lastEntry.setEndOffset(endOffset);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public EpochEntry firstEntry() {
        this.readLock.lock();
        try {
            if (this.epochMap.isEmpty()) {
                EpochEntry epochEntry = null;
                return epochEntry;
            }
            EpochEntry epochEntry = new EpochEntry(this.epochMap.firstEntry().getValue());
            return epochEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public EpochEntry lastEntry() {
        this.readLock.lock();
        try {
            if (this.epochMap.isEmpty()) {
                EpochEntry epochEntry = null;
                return epochEntry;
            }
            EpochEntry epochEntry = new EpochEntry(this.epochMap.lastEntry().getValue());
            return epochEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int lastEpoch() {
        EpochEntry entry = this.lastEntry();
        if (entry != null) {
            return entry.getEpoch();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpochEntry getEntry(int epoch) {
        this.readLock.lock();
        try {
            if (this.epochMap.containsKey(epoch)) {
                EpochEntry entry = this.epochMap.get(epoch);
                EpochEntry epochEntry = new EpochEntry(entry);
                return epochEntry;
            }
            EpochEntry epochEntry = null;
            return epochEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpochEntry findEpochEntryByOffset(long offset) {
        this.readLock.lock();
        try {
            if (!this.epochMap.isEmpty()) {
                for (Map.Entry<Integer, EpochEntry> entry : this.epochMap.entrySet()) {
                    if (entry.getValue().getStartOffset() > offset || entry.getValue().getEndOffset() <= offset) continue;
                    EpochEntry epochEntry = new EpochEntry(entry.getValue());
                    return epochEntry;
                }
            }
            Iterator<Map.Entry<Integer, EpochEntry>> iterator = null;
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EpochEntry nextEntry(int epoch) {
        this.readLock.lock();
        try {
            Map.Entry<Integer, EpochEntry> entry = this.epochMap.ceilingEntry(epoch + 1);
            if (entry != null) {
                EpochEntry epochEntry = new EpochEntry(entry.getValue());
                return epochEntry;
            }
            EpochEntry epochEntry = null;
            return epochEntry;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<EpochEntry> getAllEntries() {
        this.readLock.lock();
        try {
            ArrayList<EpochEntry> result = new ArrayList<EpochEntry>(this.epochMap.size());
            this.epochMap.forEach((key, value) -> result.add(new EpochEntry(value)));
            ArrayList<EpochEntry> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findConsistentPoint(EpochFileCache compareCache) {
        this.readLock.lock();
        try {
            long consistentOffset = -1L;
            NavigableMap<Integer, EpochEntry> descendingMap = new TreeMap<Integer, EpochEntry>((SortedMap<Integer, EpochEntry>)this.epochMap).descendingMap();
            for (Map.Entry curLocalEntry : descendingMap.entrySet()) {
                EpochEntry compareEntry = compareCache.getEntry((Integer)curLocalEntry.getKey());
                if (compareEntry == null || compareEntry.getStartOffset() != ((EpochEntry)curLocalEntry.getValue()).getStartOffset()) continue;
                consistentOffset = Math.min(((EpochEntry)curLocalEntry.getValue()).getEndOffset(), compareEntry.getEndOffset());
                break;
            }
            long l = consistentOffset;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void truncateSuffixByEpoch(int truncateEpoch) {
        Predicate<EpochEntry> predict = entry -> entry.getEpoch() >= truncateEpoch;
        this.doTruncateSuffix(predict);
    }

    public void truncateSuffixByOffset(long truncateOffset) {
        Predicate<EpochEntry> predict = entry -> entry.getStartOffset() >= truncateOffset;
        this.doTruncateSuffix(predict);
    }

    private void doTruncateSuffix(Predicate<EpochEntry> predict) {
        this.writeLock.lock();
        try {
            this.epochMap.entrySet().removeIf(entry -> predict.test((EpochEntry)entry.getValue()));
            EpochEntry entry2 = this.lastEntry();
            if (entry2 != null) {
                entry2.setEndOffset(Long.MAX_VALUE);
            }
            this.flush();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncatePrefixByOffset(long truncateOffset) {
        Predicate<EpochEntry> predict = entry -> entry.getEndOffset() <= truncateOffset;
        this.writeLock.lock();
        try {
            this.epochMap.entrySet().removeIf(entry -> predict.test((EpochEntry)entry.getValue()));
            this.flush();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void flush() {
        this.writeLock.lock();
        try {
            if (this.checkpoint != null) {
                ArrayList<EpochEntry> entries = new ArrayList<EpochEntry>(this.epochMap.values());
                this.checkpoint.write(entries);
            }
        }
        catch (IOException e) {
            log.error("Error happen when flush epochEntries to epochCheckpointFile", (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    static class EpochEntrySerializer
    implements CheckpointFile.CheckpointSerializer<EpochEntry> {
        EpochEntrySerializer() {
        }

        public String toLine(EpochEntry entry) {
            if (entry != null) {
                return String.format("%d-%d", entry.getEpoch(), entry.getStartOffset());
            }
            return null;
        }

        public EpochEntry fromLine(String line) {
            String[] arr = line.split("-");
            if (arr.length == 2) {
                int epoch = Integer.parseInt(arr[0]);
                long startOffset = Long.parseLong(arr[1]);
                return new EpochEntry(epoch, startOffset);
            }
            return null;
        }
    }
}

