/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollServerSocketChannel;
import io.grpc.netty.shaded.io.netty.channel.nio.NioEventLoopGroup;
import io.grpc.netty.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.acl.AccessValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.grpc.GrpcServer;
import org.apache.rocketmq.proxy.grpc.ProxyAndTlsProtocolNegotiator;
import org.apache.rocketmq.proxy.grpc.interceptor.AuthenticationInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.ContextInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.GlobalExceptionInterceptor;
import org.apache.rocketmq.proxy.grpc.interceptor.HeaderInterceptor;

public class GrpcServerBuilder {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected NettyServerBuilder serverBuilder;

    public static GrpcServerBuilder newBuilder(ThreadPoolExecutor executor, int port) {
        return new GrpcServerBuilder(executor, port);
    }

    protected GrpcServerBuilder(ThreadPoolExecutor executor, int port) {
        this.serverBuilder = NettyServerBuilder.forPort((int)port);
        this.serverBuilder.protocolNegotiator((ProtocolNegotiator)new ProxyAndTlsProtocolNegotiator());
        int bossLoopNum = ConfigurationManager.getProxyConfig().getGrpcBossLoopNum();
        int workerLoopNum = ConfigurationManager.getProxyConfig().getGrpcWorkerLoopNum();
        int maxInboundMessageSize = ConfigurationManager.getProxyConfig().getGrpcMaxInboundMessageSize();
        long idleTimeMills = ConfigurationManager.getProxyConfig().getGrpcClientIdleTimeMills();
        if (ConfigurationManager.getProxyConfig().isEnableGrpcEpoll()) {
            this.serverBuilder.bossEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(bossLoopNum)).workerEventLoopGroup((EventLoopGroup)new EpollEventLoopGroup(workerLoopNum)).channelType(EpollServerSocketChannel.class).executor((Executor)executor);
        } else {
            this.serverBuilder.bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(bossLoopNum)).workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(workerLoopNum)).channelType(NioServerSocketChannel.class).executor((Executor)executor);
        }
        this.serverBuilder.maxInboundMessageSize(maxInboundMessageSize).maxConnectionIdle(idleTimeMills, TimeUnit.MILLISECONDS);
        log.info("grpc server has built. port: {}, tlsKeyPath: {}, tlsCertPath: {}, threadPool: {}, queueCapacity: {}, boosLoop: {}, workerLoop: {}, maxInboundMessageSize: {}", new Object[]{port, bossLoopNum, workerLoopNum, maxInboundMessageSize});
    }

    public GrpcServerBuilder addService(BindableService service) {
        this.serverBuilder.addService(service);
        return this;
    }

    public GrpcServerBuilder addService(ServerServiceDefinition service) {
        this.serverBuilder.addService(service);
        return this;
    }

    public GrpcServerBuilder appendInterceptor(ServerInterceptor interceptor) {
        this.serverBuilder.intercept(interceptor);
        return this;
    }

    public GrpcServer build() {
        return new GrpcServer(this.serverBuilder.build());
    }

    public GrpcServerBuilder configInterceptor(List<AccessValidator> accessValidators) {
        this.serverBuilder.intercept((ServerInterceptor)new AuthenticationInterceptor(accessValidators));
        ((NettyServerBuilder)((NettyServerBuilder)this.serverBuilder.intercept((ServerInterceptor)new GlobalExceptionInterceptor())).intercept((ServerInterceptor)new ContextInterceptor())).intercept((ServerInterceptor)new HeaderInterceptor());
        return this;
    }
}

