/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore;

import com.google.common.base.Stopwatch;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.BoundaryType;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.PopAckConstants;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.CommitLogDispatcher;
import org.apache.rocketmq.store.GetMessageResult;
import org.apache.rocketmq.store.GetMessageStatus;
import org.apache.rocketmq.store.MessageFilter;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.QueryMessageResult;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.plugin.AbstractPluginMessageStore;
import org.apache.rocketmq.store.plugin.MessageStorePluginContext;
import org.apache.rocketmq.tieredstore.TieredDispatcher;
import org.apache.rocketmq.tieredstore.TieredMessageFetcher;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.common.TieredStoreExecutor;
import org.apache.rocketmq.tieredstore.file.CompositeQueueFlatFile;
import org.apache.rocketmq.tieredstore.file.TieredFlatFileManager;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.util.TieredStoreUtil;

public class TieredMessageStore
extends AbstractPluginMessageStore {
    protected static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    protected final String brokerName;
    protected final TieredMessageStoreConfig storeConfig = new TieredMessageStoreConfig();
    protected final TieredMetadataStore metadataStore;
    protected final TieredDispatcher dispatcher;
    protected final TieredMessageFetcher fetcher;
    protected final TieredFlatFileManager flatFileManager;

    public TieredMessageStore(MessageStorePluginContext context, MessageStore next) {
        super(context, next);
        context.registerConfiguration((Object)this.storeConfig);
        this.brokerName = this.storeConfig.getBrokerName();
        TieredStoreUtil.addSystemTopic(this.storeConfig.getBrokerClusterName());
        TieredStoreUtil.addSystemTopic(this.brokerName);
        TieredStoreExecutor.init();
        this.metadataStore = TieredStoreUtil.getMetadataStore(this.storeConfig);
        this.fetcher = new TieredMessageFetcher(this.storeConfig);
        this.dispatcher = new TieredDispatcher(next, this.storeConfig);
        this.flatFileManager = TieredFlatFileManager.getInstance(this.storeConfig);
        next.addDispatcher((CommitLogDispatcher)this.dispatcher);
    }

    public boolean load() {
        boolean result;
        boolean loadFlatFile = this.flatFileManager.load();
        boolean loadNextStore = this.next.load();
        boolean bl = result = loadFlatFile && loadNextStore;
        if (result) {
            this.dispatcher.initScheduleTask();
            this.dispatcher.start();
        }
        return result;
    }

    public TieredMessageStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public boolean fetchFromCurrentStore(String topic, int queueId, long offset) {
        return this.fetchFromCurrentStore(topic, queueId, offset, 1);
    }

    public boolean fetchFromCurrentStore(String topic, int queueId, long offset, int batchSize) {
        TieredMessageStoreConfig.TieredStorageLevel deepStorageLevel = this.storeConfig.getTieredStorageLevel();
        if (deepStorageLevel.check(TieredMessageStoreConfig.TieredStorageLevel.FORCE)) {
            return true;
        }
        if (!deepStorageLevel.isEnable()) {
            return false;
        }
        CompositeQueueFlatFile flatFile = this.flatFileManager.getFlatFile(new MessageQueue(topic, this.brokerName, queueId));
        if (flatFile == null) {
            return false;
        }
        if (offset >= flatFile.getConsumeQueueCommitOffset()) {
            return false;
        }
        if (deepStorageLevel.check(TieredMessageStoreConfig.TieredStorageLevel.NOT_IN_DISK) && !this.next.checkInStoreByConsumeOffset(topic, queueId, offset)) {
            return true;
        }
        return deepStorageLevel.check(TieredMessageStoreConfig.TieredStorageLevel.NOT_IN_MEM) && !this.next.checkInMemByConsumeOffset(topic, queueId, offset, batchSize);
    }

    public GetMessageResult getMessage(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        return this.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter).join();
    }

    public CompletableFuture<GetMessageResult> getMessageAsync(String group, String topic, int queueId, long offset, int maxMsgNums, MessageFilter messageFilter) {
        if (TieredStoreUtil.isSystemTopic(topic) || PopAckConstants.isStartWithRevivePrefix((String)topic)) {
            return this.next.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter);
        }
        if (!this.fetchFromCurrentStore(topic, queueId, offset, maxMsgNums)) {
            logger.trace("GetMessageAsync from next store, topic: {}, queue: {}, offset: {}", new Object[]{topic, queueId, offset});
            return this.next.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter);
        }
        logger.trace("GetMessageAsync from current store, topic: {}, queue: {}, offset: {}", new Object[]{topic, queueId, offset});
        Stopwatch stopwatch = Stopwatch.createStarted();
        return ((CompletableFuture)this.fetcher.getMessageAsync(group, topic, queueId, offset, maxMsgNums, messageFilter).thenApply(result -> {
            long minOffsetInQueue;
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_message").put("topic", topic).put("group", group).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if ((result.getStatus() == GetMessageStatus.OFFSET_FOUND_NULL || result.getStatus() == GetMessageStatus.NO_MATCHED_LOGIC_QUEUE) && this.next.checkInStoreByConsumeOffset(topic, queueId, offset)) {
                TieredStoreMetricsManager.fallbackTotal.add(1L, latencyAttributes);
                logger.debug("GetMessageAsync not found, then back to next store, result: {}, topic: {}, queue: {}, queue offset: {}, offset range: {}-{}", new Object[]{result.getStatus(), topic, queueId, offset, result.getMinOffset(), result.getMaxOffset()});
                return this.next.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter);
            }
            if (result.getStatus() != GetMessageStatus.FOUND && result.getStatus() != GetMessageStatus.NO_MATCHED_LOGIC_QUEUE && result.getStatus() != GetMessageStatus.OFFSET_OVERFLOW_ONE && result.getStatus() != GetMessageStatus.OFFSET_OVERFLOW_BADLY) {
                logger.warn("GetMessageAsync not found and message is not in next store, result: {}, topic: {}, queue: {}, queue offset: {}, offset range: {}-{}", new Object[]{result.getStatus(), topic, queueId, offset, result.getMinOffset(), result.getMaxOffset()});
            }
            if (result.getStatus() == GetMessageStatus.FOUND) {
                Attributes messagesOutAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("topic", topic).put("group", group).build();
                TieredStoreMetricsManager.messagesOutTotal.add((long)result.getMessageCount(), messagesOutAttributes);
            }
            if ((minOffsetInQueue = this.next.getMinOffsetInQueue(topic, queueId)) >= 0L && minOffsetInQueue < result.getMinOffset()) {
                result.setMinOffset(minOffsetInQueue);
            }
            logger.trace("GetMessageAsync result, group: {}, topic: {}, queueId: {}, offset: {}, count:{}, {}", new Object[]{group, topic, queueId, offset, maxMsgNums, result});
            return result;
        })).exceptionally(e -> {
            logger.error("GetMessageAsync from tiered store failed", e);
            return this.next.getMessage(group, topic, queueId, offset, maxMsgNums, messageFilter);
        });
    }

    public CompletableFuture<PutMessageResult> asyncPutMessage(MessageExtBrokerInner msg) {
        return super.asyncPutMessage(msg);
    }

    public long getMinOffsetInQueue(String topic, int queueId) {
        long minOffsetInNextStore = this.next.getMinOffsetInQueue(topic, queueId);
        CompositeQueueFlatFile flatFile = this.flatFileManager.getFlatFile(new MessageQueue(topic, this.brokerName, queueId));
        if (flatFile == null) {
            return minOffsetInNextStore;
        }
        long minOffsetInTieredStore = flatFile.getConsumeQueueMinOffset();
        if (minOffsetInTieredStore < 0L) {
            return minOffsetInNextStore;
        }
        return Math.min(minOffsetInNextStore, minOffsetInTieredStore);
    }

    public long getEarliestMessageTime(String topic, int queueId) {
        return this.getEarliestMessageTimeAsync(topic, queueId).join();
    }

    public CompletableFuture<Long> getEarliestMessageTimeAsync(String topic, int queueId) {
        long nextEarliestMessageTime = this.next.getEarliestMessageTime(topic, queueId);
        long finalNextEarliestMessageTime = nextEarliestMessageTime > 0L ? nextEarliestMessageTime : Long.MAX_VALUE;
        Stopwatch stopwatch = Stopwatch.createStarted();
        return this.fetcher.getEarliestMessageTimeAsync(topic, queueId).thenApply(time -> {
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_earliest_message_time").put("topic", topic).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if (time < 0L) {
                logger.debug("GetEarliestMessageTimeAsync failed, try to get earliest message time from next store: topic: {}, queue: {}", (Object)topic, (Object)queueId);
                return finalNextEarliestMessageTime != Long.MAX_VALUE ? finalNextEarliestMessageTime : -1L;
            }
            return Math.min(finalNextEarliestMessageTime, time);
        });
    }

    public CompletableFuture<Long> getMessageStoreTimeStampAsync(String topic, int queueId, long consumeQueueOffset) {
        if (this.fetchFromCurrentStore(topic, queueId, consumeQueueOffset)) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            return this.fetcher.getMessageStoreTimeStampAsync(topic, queueId, consumeQueueOffset).thenApply(time -> {
                Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_time_by_offset").put("topic", topic).build();
                TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
                if (time == -1L) {
                    logger.debug("GetEarliestMessageTimeAsync failed, try to get message time from next store, topic: {}, queue: {}, queue offset: {}", new Object[]{topic, queueId, consumeQueueOffset});
                    return this.next.getMessageStoreTimeStamp(topic, queueId, consumeQueueOffset);
                }
                return time;
            });
        }
        return this.next.getMessageStoreTimeStampAsync(topic, queueId, consumeQueueOffset);
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp) {
        return this.getOffsetInQueueByTime(topic, queueId, timestamp, BoundaryType.LOWER);
    }

    public long getOffsetInQueueByTime(String topic, int queueId, long timestamp, BoundaryType boundaryType) {
        boolean isForce;
        long earliestTimeInNextStore = this.next.getEarliestMessageTime();
        if (earliestTimeInNextStore <= 0L) {
            logger.warn("TieredMessageStore#getOffsetInQueueByTimeAsync: get earliest message time in next store failed: {}", (Object)earliestTimeInNextStore);
            return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
        }
        boolean bl = isForce = this.storeConfig.getTieredStorageLevel() == TieredMessageStoreConfig.TieredStorageLevel.FORCE;
        if (timestamp < earliestTimeInNextStore || isForce) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            long offsetInTieredStore = this.fetcher.getOffsetInQueueByTime(topic, queueId, timestamp, boundaryType);
            Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "get_offset_by_time").put("topic", topic).build();
            TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
            if (offsetInTieredStore == -1L && !isForce) {
                return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
            }
            return offsetInTieredStore;
        }
        return this.next.getOffsetInQueueByTime(topic, queueId, timestamp);
    }

    public QueryMessageResult queryMessage(String topic, String key, int maxNum, long begin, long end) {
        return this.queryMessageAsync(topic, key, maxNum, begin, end).join();
    }

    public CompletableFuture<QueryMessageResult> queryMessageAsync(String topic, String key, int maxNum, long begin, long end) {
        long earliestTimeInNextStore = this.next.getEarliestMessageTime();
        if (earliestTimeInNextStore <= 0L) {
            logger.warn("TieredMessageStore#queryMessageAsync: get earliest message time in next store failed: {}", (Object)earliestTimeInNextStore);
        }
        boolean isForce = this.storeConfig.getTieredStorageLevel() == TieredMessageStoreConfig.TieredStorageLevel.FORCE;
        QueryMessageResult result = end < earliestTimeInNextStore || isForce ? new QueryMessageResult() : this.next.queryMessage(topic, key, maxNum, begin, end);
        int resultSize = result.getMessageBufferList().size();
        if (resultSize < maxNum && begin < earliestTimeInNextStore || isForce) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                return this.fetcher.queryMessageAsync(topic, key, maxNum - resultSize, begin, isForce ? end : earliestTimeInNextStore).thenApply(tieredStoreResult -> {
                    Attributes latencyAttributes = TieredStoreMetricsManager.newAttributesBuilder().put("operation", "query_message").put("topic", topic).build();
                    TieredStoreMetricsManager.apiLatency.record(stopwatch.elapsed(TimeUnit.MILLISECONDS), latencyAttributes);
                    for (SelectMappedBufferResult msg : tieredStoreResult.getMessageMapedList()) {
                        result.addMessage(msg);
                    }
                    return result;
                });
            }
            catch (Exception e) {
                logger.error("TieredMessageStore#queryMessageAsync: query message in tiered store failed", (Throwable)e);
                return CompletableFuture.completedFuture(result);
            }
        }
        return CompletableFuture.completedFuture(result);
    }

    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        List res = super.getMetricsView();
        res.addAll(TieredStoreMetricsManager.getMetricsView());
        return res;
    }

    public void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        super.initMetrics(meter, attributesBuilderSupplier);
        TieredStoreMetricsManager.init(meter, attributesBuilderSupplier, this.storeConfig, this.fetcher, this.next);
    }

    public void shutdown() {
        this.next.shutdown();
        this.dispatcher.shutdown();
        TieredFlatFileManager.getInstance(this.storeConfig).shutdown();
        TieredStoreExecutor.shutdown();
    }

    public void destroy() {
        this.next.destroy();
        TieredFlatFileManager.getInstance(this.storeConfig).destroy();
        try {
            this.metadataStore.destroy();
        }
        catch (Exception e) {
            logger.error("TieredMessageStore#destroy: destroy metadata store failed", (Throwable)e);
        }
    }

    public int cleanUnusedTopic(Set<String> retainTopics) {
        try {
            this.metadataStore.iterateTopic(topicMetadata -> {
                String topic = topicMetadata.getTopic();
                if (retainTopics.contains(topic) || TopicValidator.isSystemTopic((String)topic) || MixAll.isLmq((String)topic)) {
                    return;
                }
                this.destroyCompositeFlatFile(topicMetadata.getTopic());
            });
        }
        catch (Exception e) {
            logger.error("TieredMessageStore#cleanUnusedTopic: iterate topic metadata failed", (Throwable)e);
        }
        return this.next.cleanUnusedTopic(retainTopics);
    }

    public int deleteTopics(Set<String> deleteTopics) {
        for (String topic : deleteTopics) {
            this.destroyCompositeFlatFile(topic);
        }
        return this.next.deleteTopics(deleteTopics);
    }

    public void destroyCompositeFlatFile(String topic) {
        try {
            if (StringUtils.isBlank((CharSequence)topic)) {
                return;
            }
            this.metadataStore.iterateQueue(topic, queueMetadata -> this.flatFileManager.destroyCompositeFile(queueMetadata.getQueue()));
            this.metadataStore.deleteTopic(topic);
            logger.info("Destroy composite flat file in message store, topic={}", (Object)topic);
        }
        catch (Exception e) {
            logger.error("Destroy composite flat file in message store failed, topic={}", (Object)topic, (Object)e);
        }
    }
}

