/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.trace.TraceBean;
import org.apache.rocketmq.client.trace.TraceContext;
import org.apache.rocketmq.client.trace.TraceTransferBean;
import org.apache.rocketmq.client.trace.TraceType;
import org.apache.rocketmq.common.message.MessageType;

public class TraceDataEncoder {
    public static List<TraceContext> decoderFromTraceDataString(String traceData) {
        String[] contextList;
        ArrayList<TraceContext> resList = new ArrayList<TraceContext>();
        if (traceData == null || traceData.length() <= 0) {
            return resList;
        }
        for (String context : contextList = traceData.split(String.valueOf('\u0002'))) {
            TraceBean bean;
            String[] line = context.split(String.valueOf('\u0001'));
            if (line[0].equals(TraceType.Pub.name())) {
                TraceContext pubContext = new TraceContext();
                pubContext.setTraceType(TraceType.Pub);
                pubContext.setTimeStamp(Long.parseLong(line[1]));
                pubContext.setRegionId(line[2]);
                pubContext.setGroupName(line[3]);
                bean = new TraceBean();
                bean.setTopic(line[4]);
                bean.setMsgId(line[5]);
                bean.setTags(line[6]);
                bean.setKeys(line[7]);
                bean.setStoreHost(line[8]);
                bean.setBodyLength(Integer.parseInt(line[9]));
                pubContext.setCostTime(Integer.parseInt(line[10]));
                bean.setMsgType(MessageType.values()[Integer.parseInt(line[11])]);
                if (line.length == 13) {
                    pubContext.setSuccess(Boolean.parseBoolean(line[12]));
                } else if (line.length == 14) {
                    bean.setOffsetMsgId(line[12]);
                    pubContext.setSuccess(Boolean.parseBoolean(line[13]));
                }
                if (line.length >= 15) {
                    bean.setOffsetMsgId(line[12]);
                    pubContext.setSuccess(Boolean.parseBoolean(line[13]));
                    bean.setClientHost(line[14]);
                }
                pubContext.setTraceBeans(new ArrayList<TraceBean>(1));
                pubContext.getTraceBeans().add(bean);
                resList.add(pubContext);
                continue;
            }
            if (line[0].equals(TraceType.SubBefore.name())) {
                TraceContext subBeforeContext = new TraceContext();
                subBeforeContext.setTraceType(TraceType.SubBefore);
                subBeforeContext.setTimeStamp(Long.parseLong(line[1]));
                subBeforeContext.setRegionId(line[2]);
                subBeforeContext.setGroupName(line[3]);
                subBeforeContext.setRequestId(line[4]);
                bean = new TraceBean();
                bean.setMsgId(line[5]);
                bean.setRetryTimes(Integer.parseInt(line[6]));
                bean.setKeys(line[7]);
                subBeforeContext.setTraceBeans(new ArrayList<TraceBean>(1));
                subBeforeContext.getTraceBeans().add(bean);
                resList.add(subBeforeContext);
                continue;
            }
            if (line[0].equals(TraceType.SubAfter.name())) {
                TraceContext subAfterContext = new TraceContext();
                subAfterContext.setTraceType(TraceType.SubAfter);
                subAfterContext.setRequestId(line[1]);
                bean = new TraceBean();
                bean.setMsgId(line[2]);
                bean.setKeys(line[5]);
                subAfterContext.setTraceBeans(new ArrayList<TraceBean>(1));
                subAfterContext.getTraceBeans().add(bean);
                subAfterContext.setCostTime(Integer.parseInt(line[3]));
                subAfterContext.setSuccess(Boolean.parseBoolean(line[4]));
                if (line.length >= 7) {
                    subAfterContext.setContextCode(Integer.parseInt(line[6]));
                }
                if (line.length >= 9) {
                    subAfterContext.setTimeStamp(Long.parseLong(line[7]));
                    subAfterContext.setGroupName(line[8]);
                }
                resList.add(subAfterContext);
                continue;
            }
            if (!line[0].equals(TraceType.EndTransaction.name())) continue;
            TraceContext endTransactionContext = new TraceContext();
            endTransactionContext.setTraceType(TraceType.EndTransaction);
            endTransactionContext.setTimeStamp(Long.parseLong(line[1]));
            endTransactionContext.setRegionId(line[2]);
            endTransactionContext.setGroupName(line[3]);
            bean = new TraceBean();
            bean.setTopic(line[4]);
            bean.setMsgId(line[5]);
            bean.setTags(line[6]);
            bean.setKeys(line[7]);
            bean.setStoreHost(line[8]);
            bean.setMsgType(MessageType.values()[Integer.parseInt(line[9])]);
            bean.setTransactionId(line[10]);
            bean.setTransactionState(LocalTransactionState.valueOf(line[11]));
            bean.setFromTransactionCheck(Boolean.parseBoolean(line[12]));
            endTransactionContext.setTraceBeans(new ArrayList<TraceBean>(1));
            endTransactionContext.getTraceBeans().add(bean);
            resList.add(endTransactionContext);
        }
        return resList;
    }

    public static TraceTransferBean encoderFromContextBean(TraceContext ctx) {
        if (ctx == null) {
            return null;
        }
        TraceTransferBean transferBean = new TraceTransferBean();
        StringBuilder sb = new StringBuilder(256);
        switch (ctx.getTraceType()) {
            case Pub: {
                Object bean = ctx.getTraceBeans().get(0);
                sb.append((Object)ctx.getTraceType()).append('\u0001').append(ctx.getTimeStamp()).append('\u0001').append(ctx.getRegionId()).append('\u0001').append(ctx.getGroupName()).append('\u0001').append(((TraceBean)bean).getTopic()).append('\u0001').append(((TraceBean)bean).getMsgId()).append('\u0001').append(((TraceBean)bean).getTags()).append('\u0001').append(((TraceBean)bean).getKeys()).append('\u0001').append(((TraceBean)bean).getStoreHost()).append('\u0001').append(((TraceBean)bean).getBodyLength()).append('\u0001').append(ctx.getCostTime()).append('\u0001').append(((TraceBean)bean).getMsgType().ordinal()).append('\u0001').append(((TraceBean)bean).getOffsetMsgId()).append('\u0001').append(ctx.isSuccess()).append('\u0002');
                break;
            }
            case SubBefore: {
                for (TraceBean bean : ctx.getTraceBeans()) {
                    sb.append((Object)ctx.getTraceType()).append('\u0001').append(ctx.getTimeStamp()).append('\u0001').append(ctx.getRegionId()).append('\u0001').append(ctx.getGroupName()).append('\u0001').append(ctx.getRequestId()).append('\u0001').append(bean.getMsgId()).append('\u0001').append(bean.getRetryTimes()).append('\u0001').append(bean.getKeys()).append('\u0002');
                }
                break;
            }
            case SubAfter: {
                for (TraceBean bean : ctx.getTraceBeans()) {
                    sb.append((Object)ctx.getTraceType()).append('\u0001').append(ctx.getRequestId()).append('\u0001').append(bean.getMsgId()).append('\u0001').append(ctx.getCostTime()).append('\u0001').append(ctx.isSuccess()).append('\u0001').append(bean.getKeys()).append('\u0001').append(ctx.getContextCode()).append('\u0001');
                    if (ctx.getAccessChannel().equals((Object)AccessChannel.CLOUD)) continue;
                    sb.append(ctx.getTimeStamp()).append('\u0001').append(ctx.getGroupName()).append('\u0002');
                }
                break;
            }
            case EndTransaction: {
                Object bean = ctx.getTraceBeans().get(0);
                sb.append((Object)ctx.getTraceType()).append('\u0001').append(ctx.getTimeStamp()).append('\u0001').append(ctx.getRegionId()).append('\u0001').append(ctx.getGroupName()).append('\u0001').append(((TraceBean)bean).getTopic()).append('\u0001').append(((TraceBean)bean).getMsgId()).append('\u0001').append(((TraceBean)bean).getTags()).append('\u0001').append(((TraceBean)bean).getKeys()).append('\u0001').append(((TraceBean)bean).getStoreHost()).append('\u0001').append(((TraceBean)bean).getMsgType().ordinal()).append('\u0001').append(((TraceBean)bean).getTransactionId()).append('\u0001').append(((TraceBean)bean).getTransactionState().name()).append('\u0001').append(((TraceBean)bean).isFromTransactionCheck()).append('\u0002');
                break;
            }
        }
        transferBean.setTransData(sb.toString());
        for (TraceBean bean : ctx.getTraceBeans()) {
            transferBean.getTransKey().add(bean.getMsgId());
            if (bean.getKeys() == null || bean.getKeys().length() <= 0) continue;
            String[] keys = bean.getKeys().split(" ");
            transferBean.getTransKey().addAll(Arrays.asList(keys));
        }
        return transferBean;
    }
}

