/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.logfile;

import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantLock;

public class SharedByteBufferManager {
    private static volatile SharedByteBufferManager instance;
    private static final Object LOCK;
    private SharedByteBuffer[] sharedByteBuffers;
    private int bufferSize;
    private int maxSharedNum;
    private volatile boolean initialized = false;

    private SharedByteBufferManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedByteBufferManager getInstance() {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new SharedByteBufferManager();
                }
            }
        }
        return instance;
    }

    public synchronized void init(int maxMessageSize, int sharedBufferNum) {
        if (!this.initialized) {
            this.bufferSize = Integer.MAX_VALUE - maxMessageSize >= 65536 ? maxMessageSize + 65536 : Integer.MAX_VALUE;
            this.maxSharedNum = sharedBufferNum;
            this.sharedByteBuffers = new SharedByteBuffer[this.maxSharedNum];
            for (int i = 0; i < this.maxSharedNum; ++i) {
                this.sharedByteBuffers[i] = new SharedByteBuffer(this.bufferSize);
            }
            this.initialized = true;
        }
    }

    public SharedByteBuffer borrowSharedByteBuffer() {
        if (!this.initialized) {
            throw new IllegalStateException("SharedByteBufferManager not initialized");
        }
        int idx = ThreadLocalRandom.current().nextInt(this.maxSharedNum);
        return this.sharedByteBuffers[idx];
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static {
        LOCK = new Object();
    }

    public static class SharedByteBuffer {
        private final ReentrantLock lock = new ReentrantLock();
        private final ByteBuffer buffer;

        public SharedByteBuffer(int size) {
            this.buffer = ByteBuffer.allocateDirect(size);
        }

        public void release() {
            this.lock.unlock();
        }

        public ByteBuffer acquire() {
            this.lock.lock();
            return this.buffer;
        }
    }
}

