/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export const translations = {
    zh: {
        "SELECT_TRACE_TOPIC_PLACEHOLDER": "请选择消息轨迹主题",
        "TRACE_TOPIC_HINT": "消息轨迹主题",
        "ONLY_RETURN_64_MESSAGES": "仅返回64条消息",
        "SELECT_TOPIC_PLACEHOLDER": "请选择主题",
        "MESSAGE_ID_TOPIC_HINT": "消息ID主题",
        "OPERATION_FAILED": "操作失败",
        "FORM_VALIDATION_FAILED": "表单验证失败",
        "CONFIG_FOR_BROKER": "配置代理",
        "RETRY_POLICY": "重试策略",
        "CONSUME_TIMEOUT": "消费超时",
        "MINUTES": "分钟",
        "SYSTEM_FLAG": "系统标志",
        "GROUP_NAME": "组名称",
        "PLEASE_SELECT_CLUSTER_NAME": "请选择集群名称",
        "SELECT_CLUSTERS": "选择集群",
        "SELECT_BROKERS": "选择代理",
        "CONSUME_ENABLE": "启用消费",
        "ORDERLY_CONSUMPTION": "有序消费",
        "BROADCAST_CONSUMPTION": "广播消费",
        "RETRY_QUEUES": "重试队列",
        "MAX_RETRIES": "最大重试次数",
        "BROKER_ID": "代理ID",
        "SLOW_CONSUMPTION_BROKER": "慢消费代理",
        "PLEASE_INPUT_NUMBER": "请输入数字",
        "TOPIC_CONFIG": "主题配置",
        "TOPIC_ADD": "添加主题",
        "SELECT_CLUSTER_NAME": "请选择集群",
        "FETCH_TOPIC_FAILED": "获取主题列表失败",
        "CONFIRM_DELETE": "确认删除",
        "CANCEL": "取消",
        "SELECT_DELETE_BROKERS": "请选择在哪个Broker删除消费者组",
        "DELETE_CONSUMER_GROUP": "删除消费者组",
        "ENGLISH": "英文",
        "ADD_CONSUMER": "添加消费者",
        "CHINESE": "简体中文",
        "CANNOT_BE_EMPTY": "不能为空",
        "TITLE": "RocketMQ仪表板",
        "CLOSE": "关闭",
        "NO": "编号",
        "ADDRESS": "地址",
        "VERSION": "版本",
        "PRO_MSG_TPS": "生产消息TPS",
        "CUS_MSG_TPS": "消费消息TPS",
        "YESTERDAY_PRO_COUNT": "昨日生产总数",
        "YESTERDAY_CUS_COUNT": "昨日消费总数",
        "TODAY_PRO_COUNT": "今天生产总数",
        "TODAY_CUS_COUNT": "今天消费总数",
        "INSTANCE": "实例",
        "SPLIT": "分片",
        "CLUSTER": "集群",
        "CLUSTER_DETAIL": "集群详情",
        "COMMIT": "提交",
        "TOPIC": "主题",
        "SUBSCRIPTION_GROUP": "订阅组",
        "PRODUCER_GROUP": "生产组",
        "CONSUMER": "消费者",
        "PRODUCER": "生产者",
        "MESSAGE": "消息",
        "MESSAGE_DETAIL": "消息详情",
        "RESEND_MESSAGE": "重新发送",
        "VIEW_EXCEPTION": "查看异常",
        "DLQ_MESSAGE": "死信消息",
        "MESSAGETRACE": "消息轨迹",
        "OPERATION": "操作",
        "ADD": "新增",
        "UPDATE": "更新",
        "STATUS": "状态",
        "ROUTER": "路由",
        "MANAGE": "管理",
        "CONFIG": "配置",
        "SEND_MSG": "发送消息",
        "RESET_CUS_OFFSET": "重置消费位点",
        "SKIP_MESSAGE_ACCUMULATE": "跳过堆积",
        "DELETE": "删除",
        "CHANGE_LANG": "更换语言",
        "CHANGE_VERSION": "更换版本",
        "BROKER": "Broker",
        "NORMAL": "普通",
        "RETRY": "重试",
        "FIFO": "顺序",
        "TRANSACTION": "事务",
        "UNSPECIFIED": "未指定",
        "DLQ": "死信",
        "QUANTITY": "数量",
        "TYPE": "类型",
        "MODE": "模式",
        "DELAY": "延迟",
        "DASHBOARD": "驾驶舱",
        "CONSUME_DETAIL": "消费详情",
        "CLIENT": "终端",
        "LAST_CONSUME_TIME": "最后消费时间",
        "TIME": "时间点",
        "RESET": "重置",
        "DATE": "日期",
        "NO_DATA": "暂无数据",
        "SEARCH": "搜索",
        "BEGIN": "开始",
        "END": "结束",
        "TOPIC_CHANGE": "修改主题",
        "SEND": "发送",
        "SUBSCRIPTION_CHANGE": "修改订阅",
        "QUEUE": "队列",
        "MIN_OFFSET": "最小位点",
        "MAX_OFFSET": "最大位点",
        "LAST_UPDATE_TIME_STAMP": "上次更新时间",
        "QUEUE_DATAS": "队列信息",
        "READ_QUEUE_NUMS": "读队列数量",
        "WRITE_QUEUE_NUMS": "写队列数量",
        "PERM": "perm",
        "TAG": "标签",
        "KEY": "值",
        "MESSAGE_BODY": "消息主体",
        "TOPIC_NAME": "主题名",
        "ORDER": "顺序",
        "CONSUMER_CLIENT": "消费者终端",
        "BROKER_OFFSET": "代理者位点",
        "CONSUMER_OFFSET": "消费者位点",
        "DIFF_TOTAL": "差值",
        "LAST_TIME_STAMP": "上次时间",
        "RESET_OFFSET": "重置位点",
        "CLUSTER_NAME": "集群名",
        "OPS": "运维",
        "PROXY": "代理",
        "AUTO_REFRESH": "自动刷新",
        "REFRESH": "刷新",
        "LOGOUT": "退出",
        "LOGIN": "登录",
        "USER_NAME": "用户名",
        "PASSWORD": "密码",
        "SYSTEM": "系统",
        "WELCOME": "欢迎使用RocketMQ仪表盘",
        "ENABLE_MESSAGE_TRACE": "开启消息轨迹",
        "MESSAGE_TRACE_DETAIL": "消息轨迹详情",
        "TRACE_TOPIC": "消息轨迹主题",
        "SELECT_TRACE_TOPIC": "选择消息轨迹主题",
        "EXPORT": "导出",
        "NO_MATCH_RESULT": "没有查到符合条件的结果",
        "BATCH_RESEND": "批量重发",
        "BATCH_EXPORT": "批量导出",
        "ACCOUNT_INFO": "账户信息",
        "IS_ADMIN": "是否管理员",
        "DEFAULT_TOPIC_PERM": "topic默认权限",
        "DEFAULT_GROUP_PERM": "消费组默认权限",
        "TOPIC_PERM": "topic权限",
        "GROUP_PERM": "消费组权限",
        "SYNCHRONIZE": "同步",
        "SHOW": "显示",
        "HIDE": "隐藏",
        "MESSAGE_TYPE": "消息类型",
        "MESSAGE_TYPE_UNSPECIFIED": "未指定,为普通消息",
        "MESSAGE_TYPE_NORMAL": "普通消息",
        "MESSAGE_TYPE_FIFO": "顺序消息",
        "MESSAGE_TYPE_DELAY": "定时/延时消息",
        "MESSAGE_TYPE_TRANSACTION": "事务消息",
        "UPDATE_TIME": "更新时间",
        "TREND": "趋势",
        "PROXY_CONFIG": "代理配置",
        "READ_MORE": "阅读更多",
        "FETCH_PROXY_LIST_FAILED": "获取代理列表失败",
        "INPUT_PROXY_ADDR_REQUIRED": "请输入代理地址",
        "SUCCESS": "成功",
        "ADD_PROXY_FAILED": "添加代理失败",
        "INPUT_PROXY_ADDR": "输入代理地址",
        "NO_CONFIG_DATA": "无配置数据",
        "FETCH_MESSAGE_DETAIL_FAILED": "获取消息详情失败",
        "MESSAGE_INFO": "消息信息",
        "MESSAGE_PROPERTIES": "消息属性",
        "SHOW_ALL_CONTENT": "显示全部内容",
        "MESSAGE_TRACKING": "消息追踪",
        "CONSUMER_GROUP": "消费者组",
        "PLEASE_SELECT_BROKER": "请选择Broker",
        "DELETE_SUCCESS": "删除成功",
        "FAILED_TO_FETCH_DATA": "获取数据失败",
        "REFRESH_SUCCESS": "刷新成功",
        "REFRESH_FAILED": "刷新失败",
        "REFRESHED": "已刷新",
        "QUERY_BROKER_HISTORY_FAILED": "查询Broker历史失败",
        "QUERY_TOPIC_HISTORY_FAILED": "查询Topic历史失败",
        "QUERY_CLUSTER_LIST_FAILED": "查询集群列表失败",
        "QUERY_TOPIC_CURRENT_FAILED": "查询当前Topic失败",
        "BROKER_NAME": "Broker名称",
        "BROKER_ADDR": "Broker地址",
        "WARNING": "警告",
        "PLEASE_SELECT_CONSUMER_GROUP": "请选择消费者组",
        "END_TIME_LATER_THAN_BEGIN_TIME": "结束时间应晚于开始时间",
        "NO_RESULT": "无结果",
        "QUERY_FAILED": "查询失败",
        "MESSAGE_ID_AND_CONSUMER_GROUP_REQUIRED": "消息ID和消费者组为必填项",
        "RESEND_SUCCESS": "重新发送成功",
        "RESULT": "结果",
        "TOPIC_AND_KEY_REQUIRED": "Topic和Key为必填项",
        "MESSAGE_ID_REQUIRED": "消息ID为必填项",
        "REFRESHING_TOPIC_LIST": "正在刷新Topic列表",
        "TOPIC_OPERATION_SUCCESS": "Topic操作成功",
        "ARE_YOU_SURE_TO_DELETE": "您确定要删除吗？",
        "YES": "是",
        "NOT": "否",
        "BLUE": "蓝色",
        "GREEN": "绿色",
        "PINK": "粉色",
        "DEFAULT": "默认",
        "INVALID_IP_ADDRESSES": "以下IP地址不合法: ",
        "ENABLED": "启用",
        "DISABLED": "禁用",
        "GET_USERS_FAILED": "获取用户列表失败: ",
        "UNKNOWN_ERROR": "未知错误",
        "GET_USERS_EXCEPTION": "获取用户列表异常",
        "N_A": "N/A",
        "INVALID_OR_EMPTY_ACL_DATA": "收到无效或空的ACL数据。",
        "GET_ACLS_FAILED": "获取ACL列表失败: ",
        "GET_ACLS_EXCEPTION": "获取ACL列表异常",
        "USER_DELETE_SUCCESS": "用户删除成功",
        "USER_DELETE_FAILED": "用户删除失败: ",
        "USER_DELETE_EXCEPTION": "用户删除异常",
        "USER_UPDATE_SUCCESS": "用户更新成功",
        "USER_CREATE_SUCCESS": "用户创建成功",
        "SAVE_USER_FAILED": "保存用户失败",
        "ACL_DELETE_SUCCESS": "ACL 删除成功",
        "ACL_DELETE_FAILED": "ACL 删除失败: ",
        "ACL_DELETE_EXCEPTION": "ACL 删除异常",
        "ACL_UPDATE_SUCCESS": "ACL 更新成功",
        "ACL_UPDATE_FAILED": "ACL 更新失败: ",
        "ACL_CREATE_SUCCESS": "ACL 创建成功",
        "ACL_CREATE_FAILED": "ACL 创建失败: ",
        "SAVE_ACL_FAILED": "保存 ACL 失败",
        "USERNAME": "用户名",
        "VIEW": "查看",
        "USER_TYPE": "用户类型",
        "USER_STATUS": "用户状态",
        "MODIFY": "修改",
        "CONFIRM_DELETE_USER": "确定删除此用户吗？",
        "USERNAME_SUBJECT": "用户名/Subject",
        "POLICY_TYPE": "策略类型",
        "RESOURCE_NAME": "资源名",
        "OPERATION_TYPE": "操作类型",
        "SOURCE_IP": "来源IP",
        "DECISION": "决策",
        "CONFIRM_DELETE_ACL": "确定删除此ACL吗？",
        "ACL_MANAGEMENT": "ACL 管理",
        "ACL_USERS": "ACL 用户",
        "ACL_PERMISSIONS": "ACL 权限",
        "ADD_USER": "添加用户",
        "ADD_ACL_PERMISSION": "添加 ACL 权限",
        "SEARCH_PLACEHOLDER": "搜索...",
        "USER": "用户",
        "ACL_PERMISSION": "ACL 权限",
        "EDIT_USER": "编辑用户",
        "CONFIRM": "确认",
        "PLEASE_ENTER_USERNAME": "请输入用户名!",
        "PLEASE_ENTER_PASSWORD": "请输入密码!",
        "PLEASE_SELECT_USER_TYPE": "请选择用户类型!",
        "PLEASE_SELECT_USER_STATUS": "请选择用户状态!",
        "EDIT_ACL_PERMISSION": "编辑 ACL 权限",
        "SUBJECT_LABEL": "Subject (例如: User:yourUsername)",
        "PLEASE_ENTER_SUBJECT": "请输入 Subject!",
        "PLEASE_ENTER_POLICY_TYPE": "请输入策略类型!",
        "RESOURCE": "资源",
        "PLEASE_ADD_RESOURCE": "请添加资源!",
        "ENTER_IP_HINT": "请输入 IP 地址，按回车键添加，支持 IPv4、IPv6 和 CIDR",
        "PLEASE_ENTER_DECISION": "请输入决策!",
        "MENU": "菜单",
        "SELECT_PROXY": "选择代理",
        "ENABLE_PROXY": "启用代理",
        "PROXY_DISABLED": "代理禁用",
        "PROXY_ENABLED": "代理启用",
        "BROKER_OVERVIEW": "Broker概览",
        "TOTAL_MSG_RECEIVED_TODAY": "今天接收的总消息数",
        "LOGIN_SUCCESS": "登录成功",
        "LOGIN_FAILED": "登录失败",
        "USERNAME_REQUIRED": "用户名为必填项",
        "USERNAME_PLACEHOLDER": "用户名",
        "PASSWORD_REQUIRED": "密码为必填项",
        "PASSWORD_PLACEHOLDER": "密码",
        "PLEASE_INPUT_NAME":"请输入名称",
        "PLEASE_SELECT_CLUSTER": "请选择集群",
        "CLIENT_INFORMATION": "客户端信息",
        "CONSUME_TYPE": "消费类型",
        "MESSAGE_MODEL": "消息模型",
        "CONSUME_FROM_WHERE": "从何处消费",
        "CLIENT_CONNECTIONS": "客户端连接",
        "CLIENT_SUBSCRIPTIONS": "客户端订阅",
        "CONNECTION_OVERVIEW": "连接概览",
        "CLIENTID": "客户端 ID",
        "CLIENTADDR": "客户端地址",
        "LANGUAGE": "语言",
        "SUBSCRIPTION_EXPRESSION": "订阅表达式",
        "EXPRESSION_TYPE": "表达式类型",
        "SUB_VERSION": "订阅版本",
        "CODE_SET": "代码集",
        "TAGS_SET": "标签集"
    },
    en: {
        "DEFAULT": "Default",
        "BLUE": "Blue",
        "GREEN": "Green",
        "PINK": "Pink",
        "NOT": "No",
        "ARE_YOU_SURE_TO_DELETE": "Are you sure to delete?",
        "YES": "Yes",
        "SELECT_TRACE_TOPIC_PLACEHOLDER": "Please select trace topic",
        "TRACE_TOPIC_HINT": "Trace Topic",
        "ONLY_RETURN_64_MESSAGES": "Only return 64 messages",
        "SELECT_TOPIC_PLACEHOLDER": "Please select topic",
        "MESSAGE_ID_TOPIC_HINT": "Message ID Topic",
        "TOPIC_ADD": "Add Topic",
        "SKIP_MESSAGE_ACCUMULATE": "Skip Message Accumulate",
        "OPERATION_FAILED": "Operation Failed",
        "FORM_VALIDATION_FAILED": "Form Validation Failed",
        "ADD_CONSUMER": "Add Consumer",
        "CONFIG_FOR_BROKER": "Config for Broker",
        "RETRY_POLICY": "Retry Policy",
        "CONSUME_TIMEOUT": "Consume Timeout",
        "MINUTES": "Minutes",
        "SYSTEM_FLAG": "System Flag",
        "GROUP_NAME": "Group Name",
        "CANNOT_BE_EMPTY": "Cannot be empty",
        "PLEASE_SELECT_CLUSTER_NAME": "Please select cluster name",
        "SELECT_CLUSTERS": "Select Clusters",
        "SELECT_BROKERS": "Select Brokers",
        "CONSUME_ENABLE": "Consume Enable",
        "ORDERLY_CONSUMPTION": "Orderly Consumption",
        "BROADCAST_CONSUMPTION": "Broadcast Consumption",
        "RETRY_QUEUES": "Retry Queues",
        "MAX_RETRIES": "Max Retries",
        "BROKER_ID": "Broker ID",
        "SLOW_CONSUMPTION_BROKER": "Slow Consumption Broker",
        "PLEASE_INPUT_NUMBER": "Please input number",
        "FETCH_TOPIC_FAILED": "Failed to fetch topic list",
        "ENGLISH": "English",
        "CHINESE": "Chinese",
        "TITLE": "RocketMQ-Dashboard",
        "CLOSE": "Close",
        "NO": "NO.",
        "ADDRESS": "Address",
        "VERSION": "Version",
        "PRO_MSG_TPS": "Produce Message TPS",
        "CUS_MSG_TPS": "Consumer Message TPS",
        "YESTERDAY_PRO_COUNT": "Yesterday Produce Count",
        "YESTERDAY_CUS_COUNT": "Yesterday Consume Count",
        "TODAY_PRO_COUNT": "Today Produce Count",
        "TODAY_CUS_COUNT": "Today Consume Count",
        "INSTANCE": "Instance",
        "SPLIT": "Broker",
        "CLUSTER": "Cluster",
        "CLUSTER_DETAIL": "Cluster Detail",
        "TOPIC": "Topic",
        "SUBSCRIPTION_GROUP": "SubscriptionGroup",
        "PRODUCER_GROUP": "ProducerGroup",
        "CONSUMER": "Consumer",
        "PRODUCER": "Producer",
        "MESSAGE": "Message",
        "MESSAGE_DETAIL": "Message Detail",
        "RESEND_MESSAGE": "Resend Message",
        "VIEW_EXCEPTION": "View Exception",
        "MESSAGETRACE": "MessageTrace",
        "DLQ_MESSAGE": "DLQMessage",
        "COMMIT": "Commit",
        "OPERATION": "Operation",
        "ADD": "Add",
        "UPDATE": "Update",
        "STATUS": "Status",
        "ROUTER": "Router",
        "MANAGE": "Manage",
        "CONFIG": "Config",
        "SEND_MSG": "Send Massage",
        "RESET_CUS_OFFSET": "Reset Consumer Offset",
        "DELETE": "Delete",
        "CHANGE_LANG": "ChangeLanguage",
        "CHANGE_VERSION": "ChangeVersion",
        "BROKER": "Broker",
        "NORMAL": "NORMAL",
        "RETRY": "RETRY",
        "FIFO": "FIFO",
        "TRANSACTION": "TRANSACTION",
        "UNSPECIFIED": "UNSPECIFIED",
        "DLQ": "DLQ",
        "QUANTITY": "Quantity",
        "TYPE": "Type",
        "MODE": "Mode",
        "DELAY": "Delay",
        "DASHBOARD": "Dashboard",
        "CONSUME_DETAIL": "CONSUME DETAIL",
        "CLIENT": "CLIENT",
        "LAST_CONSUME_TIME": "LastConsumeTime",
        "TIME": "Time",
        "RESET": "RESET",
        "DATE": "Date",
        "NO_DATA": "NO DATA",
        "SEARCH": "Search",
        "BEGIN": "Begin",
        "END": "End",
        "TOPIC_CHANGE": "Topic Change",
        "SEND": "Send",
        "SUBSCRIPTION_CHANGE": "Subscription Change",
        "QUEUE": "Queue",
        "MIN_OFFSET": "minOffset",
        "MAX_OFFSET": "maxOffset",
        "LAST_UPDATE_TIME_STAMP": "lastUpdateTimeStamp",
        "QUEUE_DATAS": "queueDatas",
        "READ_QUEUE_NUMS": "readQueueNums",
        "WRITE_QUEUE_NUMS": "writeQueueNums",
        "PERM": "perm",
        "TAG": "Tag",
        "KEY": "Key",
        "MESSAGE_BODY": "Message Body",
        "TOPIC_NAME": "topicName",
        "ORDER": "order",
        "CONSUMER_CLIENT": "consumerClient",
        "BROKER_OFFSET": "brokerOffset",
        "CONSUMER_OFFSET": "consumerOffset",
        "DIFF_TOTAL": "diffTotal",
        "LAST_TIME_STAMP": "lastTimeStamp",
        "RESET_OFFSET": "resetOffset",
        "CLUSTER_NAME": "clusterName",
        "OPS": "OPS",
        "PROXY": "Proxy",
        "AUTO_REFRESH": "AUTO_REFRESH",
        "REFRESH": "REFRESH",
        "LOGOUT": "Logout",
        "LOGIN": "Login",
        "USER_NAME": "Username",
        "PASSWORD": "Password",
        "SYSTEM": "SYSTEM",
        "WELCOME": "Welcome using RocketMQ Dashboard",
        "ENABLE_MESSAGE_TRACE": "Enable Message Trace",
        "MESSAGE_TRACE_DETAIL": "Message Trace Detail",
        "TRACE_TOPIC": "TraceTopic",
        "SELECT_TRACE_TOPIC": "selectTraceTopic",
        "EXPORT": "export",
        "NO_MATCH_RESULT": "no match result",
        "BATCH_RESEND": "batchReSend",
        "BATCH_EXPORT": "batchExport",
        "ACCOUNT_INFO": "Account Info",
        "IS_ADMIN": "Is Admin",
        "DEFAULT_TOPIC_PERM": "Default Topic Permission",
        "DEFAULT_GROUP_PERM": "Default Group Permission",
        "TOPIC_PERM": "Topic Permission",
        "GROUP_PERM": "Group Permission",
        "SYNCHRONIZE": "Synchronize Data",
        "SHOW": "Show",
        "HIDE": "Hide",
        "MESSAGE_TYPE": "messageType",
        "MESSAGE_TYPE_UNSPECIFIED": "UNSPECIFIED, is NORMAL",
        "MESSAGE_TYPE_NORMAL": "NORMAL",
        "MESSAGE_TYPE_FIFO": "FIFO",
        "MESSAGE_TYPE_DELAY": "DELAY",
        "MESSAGE_TYPE_TRANSACTION": "TRANSACTION",
        "UPDATE_TIME": "Update Time",
        "TREND": "trend",
        "FETCH_PROXY_LIST_FAILED": "Failed to fetch proxy list",
        "INPUT_PROXY_ADDR_REQUIRED": "Input proxy address required",
        "SUCCESS": "Success",
        "ADD_PROXY_FAILED": "Failed to add proxy",
        "INPUT_PROXY_ADDR": "Input proxy address",
        "NO_CONFIG_DATA": "No configuration data",
        "FETCH_MESSAGE_DETAIL_FAILED": "Failed to fetch message details",
        "MESSAGE_INFO": "Message info",
        "MESSAGE_PROPERTIES": "Message properties",
        "SHOW_ALL_CONTENT": "Show all content",
        "MESSAGE_TRACKING": "Message tracking",
        "CONSUMER_GROUP": "Consumer group",
        "PLEASE_SELECT_BROKER": "Please select a broker",
        "DELETE_SUCCESS": "Delete successful",
        "FAILED_TO_FETCH_DATA": "Failed to fetch data",
        "REFRESH_SUCCESS": "Refresh successful",
        "REFRESH_FAILED": "Refresh failed",
        "REFRESHED": "Refreshed",
        "QUERY_BROKER_HISTORY_FAILED": "Failed to query broker history",
        "QUERY_TOPIC_HISTORY_FAILED": "Failed to query topic history",
        "QUERY_CLUSTER_LIST_FAILED": "Failed to query cluster list",
        "QUERY_TOPIC_CURRENT_FAILED": "Failed to query current topic",
        "BROKER_NAME": "Broker name",
        "BROKER_ADDR": "Broker address",
        "WARNING": "Warning",
        "PLEASE_SELECT_CONSUMER_GROUP": "Please select a consumer group",
        "END_TIME_LATER_THAN_BEGIN_TIME": "End time should be later than begin time",
        "NO_RESULT": "No result",
        "QUERY_FAILED": "Query failed",
        "MESSAGE_ID_AND_CONSUMER_GROUP_REQUIRED": "Message ID and consumer group required",
        "RESEND_SUCCESS": "Resend successful",
        "RESULT": "Result",
        "TOPIC_AND_KEY_REQUIRED": "Topic and key required",
        "MESSAGE_ID_REQUIRED": "Message ID required",
        "REFRESHING_TOPIC_LIST": "Refreshing topic list",
        "TOPIC_OPERATION_SUCCESS": "Topic operation successful",
        "INVALID_IP_ADDRESSES": "The following IP addresses are invalid: ",
        "ENABLED": "Enabled",
        "DISABLED": "Disabled",
        "GET_USERS_FAILED": "Failed to get user list: ",
        "UNKNOWN_ERROR": "Unknown error",
        "GET_USERS_EXCEPTION": "Exception getting user list",
        "N_A": "N/A",
        "INVALID_OR_EMPTY_ACL_DATA": "Received invalid or empty ACL data.",
        "GET_ACLS_FAILED": "Failed to get ACL list: ",
        "GET_ACLS_EXCEPTION": "Exception getting ACL list",
        "USER_DELETE_SUCCESS": "User deleted successfully",
        "USER_DELETE_FAILED": "User deletion failed: ",
        "USER_DELETE_EXCEPTION": "User deletion exception",
        "USER_UPDATE_SUCCESS": "User updated successfully",
        "USER_CREATE_SUCCESS": "User created successfully",
        "SAVE_USER_FAILED": "Failed to save user",
        "ACL_DELETE_SUCCESS": "ACL deleted successfully",
        "ACL_DELETE_FAILED": "ACL deletion failed: ",
        "ACL_DELETE_EXCEPTION": "ACL deletion exception",
        "ACL_UPDATE_SUCCESS": "ACL updated successfully",
        "ACL_UPDATE_FAILED": "ACL update failed: ",
        "ACL_CREATE_SUCCESS": "ACL created successfully",
        "ACL_CREATE_FAILED": "ACL creation failed: ",
        "SAVE_ACL_FAILED": "Failed to save ACL",
        "USERNAME": "Username",
        "VIEW": "View",
        "USER_TYPE": "User Type",
        "USER_STATUS": "User Status",
        "MODIFY": "Modify",
        "CONFIRM_DELETE_USER": "Are you sure you want to delete this user?",
        "USERNAME_SUBJECT": "Username/Subject",
        "POLICY_TYPE": "Policy Type",
        "RESOURCE_NAME": "Resource Name",
        "OPERATION_TYPE": "Operation Type",
        "SOURCE_IP": "Source IP",
        "DECISION": "Decision",
        "CONFIRM_DELETE_ACL": "Are you sure you want to delete this ACL?",
        "ACL_MANAGEMENT": "ACL Management",
        "ACL_USERS": "ACL Users",
        "ACL_PERMISSIONS": "ACL Permissions",
        "ADD_USER": "Add User",
        "ADD_ACL_PERMISSION": "Add ACL Permission",
        "SEARCH_PLACEHOLDER": "Search ...",
        "USER": "User",
        "ACL_PERMISSION": "ACL Permission",
        "EDIT_USER": "Edit User",
        "CANCEL": "Cancel",
        "CONFIRM": "Confirm",
        "PLEASE_ENTER_USERNAME": "Please enter username!",
        "PLEASE_ENTER_PASSWORD": "Please enter password!",
        "PLEASE_SELECT_USER_TYPE": "Please select user type!",
        "PLEASE_SELECT_USER_STATUS": "Please select user status!",
        "EDIT_ACL_PERMISSION": "Edit ACL Permission",
        "SUBJECT_LABEL": "Subject (e.g.: User:yourUsername)",
        "PLEASE_ENTER_SUBJECT": "Please enter Subject!",
        "PLEASE_ENTER_POLICY_TYPE": "Please enter policy type!",
        "RESOURCE": "Resource",
        "PLEASE_ADD_RESOURCE": "Please add resource!",
        "ENTER_IP_HINT": "Please enter IP address, press Enter to add. Supports IPv4, IPv6, and CIDR.",
        "PLEASE_ENTER_DECISION": "Please enter decision!",
        "MENU": "Menu",
        "SELECT_PROXY": "Select Proxy",
        "ENABLE_PROXY": "Enable Proxy",
        "PROXY_DISABLED": "Proxy Disabled",
        "PROXY_ENABLED": "Proxy Enabled",
        "BROKER_OVERVIEW": "Broker Overview",
        "TOTAL_MSG_RECEIVED_TODAY": "Total messages received today",
        "LOGIN_SUCCESS": "Login successful",
        "LOGIN_FAILED": "Login failed",
        "USERNAME_REQUIRED": "Username is required",
        "USERNAME_PLACEHOLDER": "Username placeholder",
        "PASSWORD_REQUIRED": "Password is required",
        "PASSWORD_PLACEHOLDER": "Password placeholder",
        "PLEASE_INPUT_NAME": "Please input name",
        "PLEASE_SELECT_CLUSTER": "Please select cluster",
        "SUBSCRIPTION": "Subscription",
        "CLIENT_INFORMATION": "Client Information",
        "CONSUME_TYPE": "Consume Type",
        "MESSAGE_MODEL": "Message Model",
        "CONSUME_FROM_WHERE": "Consume From Where",
        "CLIENT_CONNECTIONS": "Client Connections",
        "CLIENT_SUBSCRIPTIONS": "Client Subscriptions",
        "CONNECTION_OVERVIEW": "Connection Overview",
        "CLIENTID": "Client ID",
        "CLIENTADDR": "Client Address",
        "LANGUAGE": "Language",
        "SUBSCRIPTION_EXPRESSION": "Subscription Expression",
        "EXPRESSION_TYPE": "Expression Type",
        "SUB_VERSION": "Sub Version",
        "CODE_SET": "Code Set",
        "TAGS_SET": "Tags Set",
        "DELETE_CONSUMER_GROUP": "Delete Consumer Group",
        "SELECT_DELETE_BROKERS": "Please select brokers to delete consumer group",
        "CONFIRM_DELETE": "Confirm Delete",
    }

};
