/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.mqtt;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.common.hook.UpstreamHookManager;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.apache.rocketmq.mqtt.common.util.HostInfo;
import org.apache.rocketmq.mqtt.cs.channel.ChannelDecodeException;
import org.apache.rocketmq.mqtt.cs.channel.ChannelException;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttConnectHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttDisconnectHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttPingHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttPubAckHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttPubCompHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttPubRecHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttPubRelHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttPublishHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttSubscribeHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler.MqttUnSubscribeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ChannelHandler.Sharable
@Component
public class MqttPacketDispatcher
extends SimpleChannelInboundHandler<MqttMessage> {
    private static Logger logger = LoggerFactory.getLogger(MqttPacketDispatcher.class);
    @Resource
    private MqttConnectHandler mqttConnectHandler;
    @Resource
    private MqttDisconnectHandler mqttDisconnectHandler;
    @Resource
    private MqttPublishHandler mqttPublishHandler;
    @Resource
    private MqttSubscribeHandler mqttSubscribeHandler;
    @Resource
    private MqttPubAckHandler mqttPubAckHandler;
    @Resource
    private MqttPingHandler mqttPingHandler;
    @Resource
    private MqttUnSubscribeHandler mqttUnSubscribeHandler;
    @Resource
    private MqttPubRelHandler mqttPubRelHandler;
    @Resource
    private MqttPubRecHandler mqttPubRecHandler;
    @Resource
    private MqttPubCompHandler mqttPubCompHandler;
    @Resource
    private UpstreamHookManager upstreamHookManager;

    protected void channelRead0(ChannelHandlerContext ctx, MqttMessage msg) throws Exception {
        CompletableFuture upstreamHookResult;
        if (!ctx.channel().isActive()) {
            return;
        }
        if (!msg.decoderResult().isSuccess()) {
            throw new ChannelDecodeException(ChannelInfo.getClientId(ctx.channel()) + "," + msg.decoderResult());
        }
        ChannelInfo.touch(ctx.channel());
        boolean preResult = this.preHandler(ctx, msg);
        if (!preResult) {
            return;
        }
        try {
            if (msg instanceof MqttPublishMessage) {
                ((MqttPublishMessage)msg).retain();
            }
            if ((upstreamHookResult = this.upstreamHookManager.doUpstreamHook(this.buildMqttMessageUpContext(ctx), msg)) == null) {
                this._channelRead0(ctx, msg, null);
                return;
            }
        }
        catch (Throwable t) {
            logger.error("", t);
            if (msg instanceof MqttPublishMessage) {
                ReferenceCountUtil.release((Object)msg);
            }
            throw new ChannelException(t.getMessage());
        }
        upstreamHookResult.whenComplete((hookResult, throwable) -> {
            if (msg instanceof MqttPublishMessage) {
                ReferenceCountUtil.release((Object)msg);
            }
            if (throwable != null) {
                logger.error("", throwable);
                ctx.fireExceptionCaught((Throwable)new ChannelException(throwable.getMessage()));
                return;
            }
            if (hookResult == null) {
                ctx.fireExceptionCaught((Throwable)new ChannelException("UpstreamHook Result Unknown"));
                return;
            }
            try {
                this._channelRead0(ctx, msg, (HookResult)hookResult);
            }
            catch (Throwable t) {
                logger.error("", t);
                ctx.fireExceptionCaught((Throwable)new ChannelException(t.getMessage()));
            }
        });
    }

    private void _channelRead0(ChannelHandlerContext ctx, MqttMessage msg, HookResult upstreamHookResult) {
        switch (msg.fixedHeader().messageType()) {
            case CONNECT: {
                this.mqttConnectHandler.doHandler(ctx, (MqttConnectMessage)msg, upstreamHookResult);
                break;
            }
            case PUBLISH: {
                this.mqttPublishHandler.doHandler(ctx, (MqttPublishMessage)msg, upstreamHookResult);
                break;
            }
            case SUBSCRIBE: {
                this.mqttSubscribeHandler.doHandler(ctx, (MqttSubscribeMessage)msg, upstreamHookResult);
                break;
            }
            case PUBACK: {
                this.mqttPubAckHandler.doHandler(ctx, (MqttPubAckMessage)msg, upstreamHookResult);
                break;
            }
            case PINGREQ: {
                this.mqttPingHandler.doHandler(ctx, msg, upstreamHookResult);
                break;
            }
            case UNSUBSCRIBE: {
                this.mqttUnSubscribeHandler.doHandler(ctx, (MqttUnsubscribeMessage)msg, upstreamHookResult);
                break;
            }
            case PUBREL: {
                this.mqttPubRelHandler.doHandler(ctx, msg, upstreamHookResult);
                break;
            }
            case PUBREC: {
                this.mqttPubRecHandler.doHandler(ctx, msg, upstreamHookResult);
                break;
            }
            case PUBCOMP: {
                this.mqttPubCompHandler.doHandler(ctx, msg, upstreamHookResult);
                break;
            }
            case DISCONNECT: {
                this.mqttDisconnectHandler.doHandler(ctx, msg, upstreamHookResult);
                break;
            }
        }
    }

    private boolean preHandler(ChannelHandlerContext ctx, MqttMessage msg) {
        switch (msg.fixedHeader().messageType()) {
            case CONNECT: {
                return this.mqttConnectHandler.preHandler(ctx, (MqttConnectMessage)msg);
            }
            case PUBLISH: {
                return this.mqttPublishHandler.preHandler(ctx, (MqttPublishMessage)msg);
            }
            case SUBSCRIBE: {
                return this.mqttSubscribeHandler.preHandler(ctx, (MqttSubscribeMessage)msg);
            }
            case PUBACK: {
                return this.mqttPubAckHandler.preHandler(ctx, (MqttPubAckMessage)msg);
            }
            case PINGREQ: {
                return this.mqttPingHandler.preHandler(ctx, msg);
            }
            case UNSUBSCRIBE: {
                return this.mqttUnSubscribeHandler.preHandler(ctx, (MqttUnsubscribeMessage)msg);
            }
            case PUBREL: {
                return this.mqttPubRelHandler.preHandler(ctx, msg);
            }
            case PUBREC: {
                return this.mqttPubRecHandler.preHandler(ctx, msg);
            }
            case PUBCOMP: {
                return this.mqttPubCompHandler.preHandler(ctx, msg);
            }
            case DISCONNECT: {
                return this.mqttDisconnectHandler.preHandler(ctx, msg);
            }
        }
        return true;
    }

    public MqttMessageUpContext buildMqttMessageUpContext(ChannelHandlerContext ctx) {
        MqttMessageUpContext context = new MqttMessageUpContext();
        Channel channel = ctx.channel();
        context.setClientId(ChannelInfo.getClientId(channel));
        context.setChannelId(ChannelInfo.getId(channel));
        context.setNode(HostInfo.getInstall().getAddress());
        context.setNamespace(ChannelInfo.getNamespace(channel));
        return context;
    }
}

