/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.protocol.mqtt.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import javax.annotation.Resource;
import org.apache.rocketmq.mqtt.common.hook.HookResult;
import org.apache.rocketmq.mqtt.cs.channel.ChannelInfo;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.MqttPacketHandler;
import org.apache.rocketmq.mqtt.cs.protocol.mqtt.facotry.MqttMessageFactory;
import org.apache.rocketmq.mqtt.cs.session.infly.InFlyCache;
import org.springframework.stereotype.Component;

@Component
public class MqttPubRelHandler
implements MqttPacketHandler<MqttMessage> {
    @Resource
    private InFlyCache inFlyCache;

    @Override
    public boolean preHandler(ChannelHandlerContext ctx, MqttMessage mqttMessage) {
        return true;
    }

    @Override
    public void doHandler(ChannelHandlerContext ctx, MqttMessage mqttMessage, HookResult upstreamHookResult) {
        MqttMessageIdVariableHeader variableHeader = (MqttMessageIdVariableHeader)mqttMessage.variableHeader();
        String channelId = ChannelInfo.getId(ctx.channel());
        this.inFlyCache.remove(InFlyCache.CacheType.PUB, channelId, variableHeader.messageId());
        ctx.channel().writeAndFlush((Object)MqttMessageFactory.buildPubCompMessage(variableHeader));
    }
}

