/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.loop;

import com.alibaba.fastjson.JSON;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.mqtt.common.facade.WillMsgPersistManager;
import org.apache.rocketmq.mqtt.common.meta.IpUtil;
import org.apache.rocketmq.mqtt.common.model.MqttMessageUpContext;
import org.apache.rocketmq.mqtt.common.model.WillMessage;
import org.apache.rocketmq.mqtt.common.util.MessageUtil;
import org.apache.rocketmq.mqtt.cs.session.infly.MqttMsgId;
import org.apache.rocketmq.mqtt.ds.upstream.processor.PublishProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WillLoop {
    private static Logger logger = LoggerFactory.getLogger(WillLoop.class);
    private ScheduledThreadPoolExecutor aliveService = new ScheduledThreadPoolExecutor(2, (ThreadFactory)new ThreadFactoryImpl("check_alive_thread_"));
    private long checkAliveIntervalMillis = 5000L;
    private ThreadPoolExecutor executor;
    @Resource
    private WillMsgPersistManager willMsgPersistManager;
    @Resource
    private MqttMsgId mqttMsgId;
    @Resource
    private PublishProcessor publishProcessor;

    @PostConstruct
    public void init() {
        this.aliveService.scheduleWithFixedDelay(() -> this.csLoop(), 15000L, 10000L, TimeUnit.MILLISECONDS);
        this.aliveService.scheduleWithFixedDelay(() -> this.masterLoop(), 10000L, 10000L, TimeUnit.MILLISECONDS);
        this.executor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(5000), (ThreadFactory)new ThreadFactoryImpl("DispatchWillToMQ_ "));
    }

    private void csLoop() {
        try {
            String ip = IpUtil.getLocalAddressCompatible();
            String csKey = "alive1" + ip;
            String masterKey = "master";
            long currentTime = System.currentTimeMillis();
            this.willMsgPersistManager.put(csKey, String.valueOf(currentTime)).whenComplete((result, throwable) -> {
                if (result == null || throwable != null) {
                    logger.error("{} fail to put csKey", (Object)csKey, throwable);
                }
            });
            this.willMsgPersistManager.get(masterKey).whenComplete((result, throwable) -> {
                String content = new String((byte[])result);
                if ("NOT_FOUND".equals(content) || this.masterHasDown(content)) {
                    this.willMsgPersistManager.compareAndPut(masterKey, content, ip + ":" + currentTime).whenComplete((rs, tb) -> {
                        if (!rs.booleanValue() || tb != null) {
                            logger.error("{} fail to update master", (Object)ip, tb);
                            return;
                        }
                        logger.info("{} update master successfully", (Object)ip);
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private boolean masterHasDown(String masterValue) {
        String[] ipTime = masterValue.split(":");
        if (ipTime.length < 2) {
            logger.error("master ip:updateTime split error, len < 2");
            return true;
        }
        return System.currentTimeMillis() - Long.parseLong(ipTime[1]) > 10L * this.checkAliveIntervalMillis;
    }

    private void masterLoop() {
        try {
            String ip = IpUtil.getLocalAddressCompatible();
            if (ip == null) {
                logger.error("can not get local ip");
                return;
            }
            this.willMsgPersistManager.get("master").whenComplete((result, throwable) -> {
                if (result == null || throwable != null) {
                    logger.error("fail to get CS_MASTER", throwable);
                    return;
                }
                String content = new String((byte[])result);
                if ("NOT_FOUND".equals(content)) {
                    return;
                }
                if (!content.startsWith(ip)) {
                    return;
                }
                long currentTime = System.currentTimeMillis();
                this.willMsgPersistManager.compareAndPut("master", content, ip + ":" + currentTime).whenComplete((rs, tb) -> {
                    if (!rs.booleanValue() || tb != null) {
                        logger.error("{} fail to update master", (Object)ip, tb);
                    }
                });
                String startCSKey = "alive0";
                String endCSKey = "alive2";
                this.willMsgPersistManager.scan(startCSKey, endCSKey).whenComplete((rs, tb) -> {
                    if (rs == null || tb != null) {
                        logger.error("{} master fail to scan cs", (Object)ip, tb);
                        return;
                    }
                    if (rs.size() == 0) {
                        logger.info("master scanned 0 cs");
                        return;
                    }
                    for (Map.Entry entry : rs.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        logger.info("master:{} scan cs:{}, heart:{} {}", new Object[]{ip, key, value, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Long.parseLong(value))});
                        if (System.currentTimeMillis() - Long.parseLong(value) <= 10L * this.checkAliveIntervalMillis) continue;
                        String csIp = key.substring("alive1".length());
                        this.handleShutDownCS(csIp);
                        this.willMsgPersistManager.delete(key).whenComplete((resultDel, tbDel) -> {
                            if (!resultDel.booleanValue() || tbDel != null) {
                                logger.error("fail to delete shutDown cs:{} in db", (Object)key);
                                return;
                            }
                            logger.debug("delete shutDown cs:{} in db successfully", (Object)key);
                        });
                    }
                });
            });
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    private void handleShutDownCS(String ip) {
        String startClientKey = ip + 0;
        String endClientKey = ip + 2;
        this.willMsgPersistManager.scan(startClientKey, endClientKey).whenComplete((willMap, throwable) -> {
            if (willMap == null || throwable != null) {
                logger.error("{} master fail to scan cs", (Object)ip, throwable);
                return;
            }
            if (willMap.size() == 0) {
                logger.info("the cs:{} has no will", (Object)ip);
                return;
            }
            for (Map.Entry entry : willMap.entrySet()) {
                logger.info("master handle will {} {}", entry.getKey(), entry.getValue());
                final String willKey = (String)entry.getKey();
                String clientId = ((String)entry.getKey()).substring((ip + 1).length());
                WillMessage willMessage = (WillMessage)JSON.parseObject((String)((String)entry.getValue()), WillMessage.class);
                int mqttId = this.mqttMsgId.nextId(clientId);
                final MqttPublishMessage mqttMessage = MessageUtil.toMqttMessage((String)willMessage.getWillTopic(), (byte[])willMessage.getBody(), (int)willMessage.getQos(), (int)mqttId, (boolean)willMessage.isRetain());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        CompletableFuture upstreamHookResult = WillLoop.this.publishProcessor.process(new MqttMessageUpContext(), (MqttMessage)mqttMessage);
                        upstreamHookResult.whenComplete((hookResult, tb) -> {
                            try {
                                if (!hookResult.isSuccess()) {
                                    WillLoop.this.executor.submit(this);
                                } else {
                                    WillLoop.this.willMsgPersistManager.delete(willKey).whenComplete((resultDel, tbDel) -> {
                                        if (!resultDel.booleanValue() || tbDel != null) {
                                            logger.error("fail to delete will message key:{}", (Object)willKey);
                                            return;
                                        }
                                        logger.info("delete will message key {} successfully", (Object)willKey);
                                    });
                                }
                            }
                            catch (Throwable t) {
                                logger.error("", t);
                            }
                        });
                    }
                };
                this.executor.submit(runnable);
            }
        });
    }
}

