/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session.match;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.rocketmq.mqtt.common.model.MqttTopic;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.common.model.Trie;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.apache.rocketmq.mqtt.cs.session.loop.SessionLoop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MatchAction {
    private static Logger logger = LoggerFactory.getLogger(MatchAction.class);
    @Resource
    private SessionLoop sessionLoop;
    private Trie<String, Integer> trie = new Trie();
    private ConcurrentMap<String, Set<String>> topicCache = new ConcurrentHashMap<String, Set<String>>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Session, Subscription>> matchClients(String topic, String namespace) {
        HashSet<Pair<Session, Subscription>> result = new HashSet<Pair<Session, Subscription>>();
        MqttTopic mqttTopic = TopicUtils.decode((String)topic);
        String secondTopic = TopicUtils.normalizeSecondTopic((String)mqttTopic.getSecondTopic());
        if (TopicUtils.isRetryTopic((String)topic)) {
            String clientId = TopicUtils.getClientIdFromRetryTopic((String)topic);
            List<Session> sessions = this.sessionLoop.getSessionList(clientId);
            for (Session session : sessions) {
                result.add((Pair<Session, Subscription>)Pair.of((Object)session, (Object)Subscription.newRetrySubscription((String)clientId)));
            }
        } else if (TopicUtils.isP2P((String)secondTopic)) {
            String clientId = TopicUtils.getP2Peer((MqttTopic)mqttTopic, (String)namespace);
            List<Session> sessions = this.sessionLoop.getSessionList(clientId);
            for (Session session : sessions) {
                result.add((Pair<Session, Subscription>)Pair.of((Object)session, (Object)Subscription.newP2pSubscription((String)clientId)));
            }
        } else if (TopicUtils.isP2pTopic((String)topic)) {
            String clientId = TopicUtils.getClientIdFromP2pTopic((String)topic);
            List<Session> sessions = this.sessionLoop.getSessionList(clientId);
            for (Session session : sessions) {
                result.add((Pair<Session, Subscription>)Pair.of((Object)session, (Object)Subscription.newP2pSubscription((String)clientId)));
            }
        } else {
            HashSet channelIdSet = new HashSet();
            ConcurrentMap<String, Set<String>> sessions = this.topicCache;
            synchronized (sessions) {
                Set precises = (Set)this.topicCache.get(topic);
                if (precises != null && !precises.isEmpty()) {
                    channelIdSet.addAll(precises);
                }
            }
            Map map = this.trie.getNode(topic);
            if (map != null && !map.isEmpty()) {
                channelIdSet.addAll(map.keySet());
            }
            for (String channelId : channelIdSet) {
                Set<Subscription> tmp;
                Session session = this.sessionLoop.getSession(channelId);
                if (session == null || (tmp = session.subscriptionSnapshot()) == null || tmp.isEmpty()) continue;
                for (Subscription subscription : tmp) {
                    if (!TopicUtils.isMatch((String)topic, (String)subscription.getTopicFilter())) continue;
                    result.add((Pair<Session, Subscription>)Pair.of((Object)session, (Object)subscription));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(Session session, Set<Subscription> subscriptions) {
        String channelId = session.getChannelId();
        if (channelId == null || subscriptions == null || subscriptions.isEmpty()) {
            return;
        }
        for (Subscription subscription : subscriptions) {
            if (subscription.isRetry() || subscription.isP2p()) continue;
            String topicFilter = subscription.getTopicFilter();
            boolean isWildCard = TopicUtils.isWildCard((String)topicFilter);
            if (isWildCard) {
                this.trie.addNode(topicFilter, (Object)subscription.getQos(), (Object)channelId);
                continue;
            }
            ConcurrentMap<String, Set<String>> concurrentMap = this.topicCache;
            synchronized (concurrentMap) {
                this.topicCache.putIfAbsent(topicFilter, new HashSet());
                ((Set)this.topicCache.get(topicFilter)).add(channelId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(Session session, Set<Subscription> subscriptions) {
        String channelId = session.getChannelId();
        if (channelId == null || subscriptions == null || subscriptions.isEmpty()) {
            return;
        }
        for (Subscription subscription : subscriptions) {
            if (subscription.isRetry() || subscription.isP2p()) continue;
            String topicFilter = subscription.getTopicFilter();
            boolean isWildCard = TopicUtils.isWildCard((String)topicFilter);
            if (isWildCard) {
                this.trie.deleteNode(topicFilter, (Object)channelId);
                continue;
            }
            ConcurrentMap<String, Set<String>> concurrentMap = this.topicCache;
            synchronized (concurrentMap) {
                Set channelIdSet = (Set)this.topicCache.get(topicFilter);
                if (channelIdSet != null) {
                    channelIdSet.remove(channelId);
                    if (channelIdSet.isEmpty()) {
                        this.topicCache.remove(topicFilter);
                    }
                }
            }
        }
    }
}

