/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.ds.store;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.protocol.header.QueryConsumerOffsetRequestHeader;
import org.apache.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import org.apache.rocketmq.mqtt.common.facade.LmqOffsetStore;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.QueueOffset;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.ds.config.ServiceConf;
import org.apache.rocketmq.mqtt.ds.meta.FirstTopicManager;
import org.apache.rocketmq.mqtt.ds.mq.MqFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LmqOffsetStoreManager
implements LmqOffsetStore {
    private static Logger logger = LoggerFactory.getLogger(LmqOffsetStoreManager.class);
    private DefaultMQPullConsumer defaultMQPullConsumer;
    @Resource
    private ServiceConf serviceConf;
    @Resource
    private FirstTopicManager firstTopicManager;

    @PostConstruct
    public void init() throws MQClientException {
        this.defaultMQPullConsumer = MqFactory.buildDefaultMQPullConsumer("CID_RMQ_SYS_LMQ_OFFSET", this.serviceConf.getProperties());
        this.defaultMQPullConsumer.setConsumerPullTimeoutMillis(2000L);
        this.defaultMQPullConsumer.start();
    }

    public void save(String clientId, Map<Subscription, Map<Queue, QueueOffset>> offsetMap) {
        if (offsetMap == null || offsetMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Subscription, Map<Queue, QueueOffset>> entry : offsetMap.entrySet()) {
            Map<String, String> tmpBrokerAddressMap = this.findBrokers(entry.getKey());
            if (tmpBrokerAddressMap == null || tmpBrokerAddressMap.isEmpty()) continue;
            for (Map.Entry<Queue, QueueOffset> each : entry.getValue().entrySet()) {
                try {
                    Queue queue = each.getKey();
                    if (StringUtils.isBlank((CharSequence)queue.getBrokerName())) continue;
                    String brokerAddress = tmpBrokerAddressMap.get(queue.getBrokerName());
                    QueueOffset queueOffset = each.getValue();
                    UpdateConsumerOffsetRequestHeader updateHeader = new UpdateConsumerOffsetRequestHeader();
                    updateHeader.setTopic("%LMQ%" + StringUtils.replace((String)queue.getQueueName(), (String)"/", (String)"%"));
                    updateHeader.setConsumerGroup("%LMQ%" + clientId);
                    updateHeader.setQueueId(Integer.valueOf((int)queue.getQueueId()));
                    updateHeader.setCommitOffset(Long.valueOf(queueOffset.getOffset()));
                    this.defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().getMQClientAPIImpl().updateConsumerOffset(brokerAddress, updateHeader, 1000L);
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    public CompletableFuture<Map<Queue, QueueOffset>> getOffset(String clientId, Subscription subscription) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<Queue, QueueOffset> map = new HashMap<Queue, QueueOffset>();
            Map<String, String> tmpBrokerAddressMap = this.findBrokers(subscription);
            if (tmpBrokerAddressMap == null || tmpBrokerAddressMap.isEmpty()) {
                return map;
            }
            for (Map.Entry<String, String> entry : tmpBrokerAddressMap.entrySet()) {
                Queue queue = new Queue(0L, subscription.toQueueName(), entry.getKey());
                String brokerAddress = entry.getValue();
                QueueOffset queueOffset = new QueueOffset();
                map.put(queue, queueOffset);
                try {
                    QueryConsumerOffsetRequestHeader queryHeader = new QueryConsumerOffsetRequestHeader();
                    queryHeader.setTopic("%LMQ%" + StringUtils.replace((String)queue.getQueueName(), (String)"/", (String)"%"));
                    queryHeader.setConsumerGroup("%LMQ%" + clientId);
                    queryHeader.setQueueId(Integer.valueOf((int)queue.getQueueId()));
                    long offset = this.defaultMQPullConsumer.getDefaultMQPullConsumerImpl().getRebalanceImpl().getmQClientFactory().getMQClientAPIImpl().queryConsumerOffset(brokerAddress, queryHeader, 1000L);
                    queueOffset.setOffset(offset);
                }
                catch (MQBrokerException e) {
                    if (22 != e.getResponseCode()) continue;
                    queueOffset.setOffset(Long.MAX_VALUE);
                }
                catch (Exception e) {
                    logger.error("{}", (Object)clientId, (Object)e);
                    throw new RuntimeException(e);
                }
            }
            return map;
        });
    }

    private Map<String, String> findBrokers(Subscription subscription) {
        String firstTopic = subscription.toFirstTopic();
        if (subscription.isRetry()) {
            firstTopic = this.serviceConf.getClientRetryTopic();
        }
        if (subscription.isP2p()) {
            firstTopic = StringUtils.isNotBlank((CharSequence)this.serviceConf.getClientP2pTopic()) ? this.serviceConf.getClientP2pTopic() : this.serviceConf.getClientRetryTopic();
        }
        return this.firstTopicManager.getBrokerAddressMap(firstTopic);
    }
}

