/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.exporter.collector;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import org.apache.rocketmq.mqtt.exporter.collector.MqttMetricsInfo;

public class MetricsBuilderFactory {
    private static SimpleCollector.Builder newGaugeBuilder(MqttMetricsInfo mqttMetricsInfo) {
        return ((Gauge.Builder)((Gauge.Builder)Gauge.build().name(mqttMetricsInfo.getName())).help(mqttMetricsInfo.getHelp())).labelNames(mqttMetricsInfo.getLabelNames());
    }

    private static SimpleCollector.Builder newCounterBuilder(MqttMetricsInfo mqttMetricsInfo) {
        return ((Counter.Builder)((Counter.Builder)Counter.build().name(mqttMetricsInfo.getName())).help(mqttMetricsInfo.getHelp())).labelNames(mqttMetricsInfo.getLabelNames());
    }

    private static SimpleCollector.Builder newHistogramBuilder(MqttMetricsInfo mqttMetricsInfo) {
        return ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(mqttMetricsInfo.getName())).help(mqttMetricsInfo.getHelp())).labelNames(mqttMetricsInfo.getLabelNames())).buckets(mqttMetricsInfo.getBuckets());
    }

    public static SimpleCollector.Builder newCollectorBuilder(MqttMetricsInfo mqttMetricsInfo) {
        switch (mqttMetricsInfo.getType()) {
            case COUNTER: {
                return MetricsBuilderFactory.newCounterBuilder(mqttMetricsInfo);
            }
            case GAUGE: {
                return MetricsBuilderFactory.newGaugeBuilder(mqttMetricsInfo);
            }
            case HISTOGRAM: {
                return MetricsBuilderFactory.newHistogramBuilder(mqttMetricsInfo);
            }
        }
        return null;
    }
}

