/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.common.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.mqtt.common.util.TopicUtils;

public class Queue {
    protected long queueId;
    protected String queueName;
    protected String brokerName;

    public Queue() {
    }

    public Queue(long queueId, String queueName, String brokerName) {
        this.queueId = queueId;
        this.queueName = queueName;
        this.brokerName = brokerName;
    }

    public boolean isLmq() {
        return StringUtils.isNotBlank((CharSequence)this.brokerName);
    }

    public String toFirstTopic() {
        return TopicUtils.decode(this.queueName).getFirstTopic();
    }

    public boolean isRetry() {
        return TopicUtils.isRetryTopic(this.queueName);
    }

    public boolean isP2p() {
        return TopicUtils.isP2pTopic(this.queueName);
    }

    public long getQueueId() {
        return this.queueId;
    }

    public void setQueueId(long queueId) {
        this.queueId = queueId;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Queue queue = (Queue)o;
        if (this.queueId != queue.queueId) {
            return false;
        }
        if (this.queueName != null ? !this.queueName.equals(queue.queueName) : queue.queueName != null) {
            return false;
        }
        return this.brokerName != null ? this.brokerName.equals(queue.brokerName) : queue.brokerName == null;
    }

    public int hashCode() {
        int result = (int)(this.queueId ^ this.queueId >>> 32);
        result = 31 * result + (this.queueName != null ? this.queueName.hashCode() : 0);
        result = 31 * result + (this.brokerName != null ? this.brokerName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Queue{queueId=" + this.queueId + ", queueName='" + this.queueName + '\'' + ", brokerName='" + this.brokerName + '\'' + '}';
    }
}

