/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.rhea.client.RheaKVRpcService;
import com.alipay.sofa.jraft.rhea.client.failover.FailoverClosure;
import com.alipay.sofa.jraft.rhea.client.pd.AbstractPlacementDriverClient;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverClient;
import com.alipay.sofa.jraft.rhea.cmd.store.BaseRequest;
import com.alipay.sofa.jraft.rhea.cmd.store.BaseResponse;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.errors.ErrorsHelper;
import com.alipay.sofa.jraft.rhea.options.RpcOptions;
import com.alipay.sofa.jraft.rhea.rpc.ExtSerializerSupports;
import com.alipay.sofa.jraft.rhea.util.concurrent.CallerRunsPolicyWithReport;
import com.alipay.sofa.jraft.rhea.util.concurrent.NamedThreadFactory;
import com.alipay.sofa.jraft.rpc.InvokeCallback;
import com.alipay.sofa.jraft.rpc.InvokeContext;
import com.alipay.sofa.jraft.rpc.RpcClient;
import com.alipay.sofa.jraft.util.Endpoint;
import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRheaKVRpcService
implements RheaKVRpcService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRheaKVRpcService.class);
    private final PlacementDriverClient pdClient;
    private final RpcClient rpcClient;
    private final Endpoint selfEndpoint;
    private ThreadPoolExecutor rpcCallbackExecutor;
    private int rpcTimeoutMillis;
    private boolean started;

    public DefaultRheaKVRpcService(PlacementDriverClient pdClient, Endpoint selfEndpoint) {
        this.pdClient = pdClient;
        this.rpcClient = ((AbstractPlacementDriverClient)pdClient).getRpcClient();
        this.selfEndpoint = selfEndpoint;
    }

    public synchronized boolean init(RpcOptions opts) {
        if (this.started) {
            LOG.info("[DefaultRheaKVRpcService] already started.");
            return true;
        }
        this.rpcCallbackExecutor = this.createRpcCallbackExecutor(opts);
        this.rpcTimeoutMillis = opts.getRpcTimeoutMillis();
        Requires.requireTrue((this.rpcTimeoutMillis > 0 ? 1 : 0) != 0, (Object)"opts.rpcTimeoutMillis must > 0");
        LOG.info("[DefaultRheaKVRpcService] start successfully, options: {}.", (Object)opts);
        this.started = true;
        return true;
    }

    public synchronized void shutdown() {
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)this.rpcCallbackExecutor);
        this.started = false;
        LOG.info("[DefaultRheaKVRpcService] shutdown successfully.");
    }

    @Override
    public <V> CompletableFuture<V> callAsyncWithRpc(BaseRequest request, FailoverClosure<V> closure, Errors lastCause) {
        return this.callAsyncWithRpc(request, closure, lastCause, true);
    }

    @Override
    public <V> CompletableFuture<V> callAsyncWithRpc(BaseRequest request, FailoverClosure<V> closure, Errors lastCause, boolean requireLeader) {
        boolean forceRefresh = ErrorsHelper.isInvalidPeer(lastCause);
        Endpoint endpoint = this.getRpcEndpoint(request.getRegionId(), forceRefresh, this.rpcTimeoutMillis, requireLeader);
        this.internalCallAsyncWithRpc(endpoint, request, closure);
        return closure.future();
    }

    public Endpoint getLeader(long regionId, boolean forceRefresh, long timeoutMillis) {
        return this.pdClient.getLeader(regionId, forceRefresh, timeoutMillis);
    }

    public Endpoint getLuckyPeer(long regionId, boolean forceRefresh, long timeoutMillis) {
        return this.pdClient.getLuckyPeer(regionId, forceRefresh, timeoutMillis, this.selfEndpoint);
    }

    public Endpoint getRpcEndpoint(long regionId, boolean forceRefresh, long timeoutMillis, boolean requireLeader) {
        if (requireLeader) {
            return this.getLeader(regionId, forceRefresh, timeoutMillis);
        }
        return this.getLuckyPeer(regionId, forceRefresh, timeoutMillis);
    }

    private <V> void internalCallAsyncWithRpc(final Endpoint endpoint, BaseRequest request, final FailoverClosure<V> closure) {
        InvokeContext invokeCtx = new InvokeContext();
        invokeCtx.put("BOLT_CTX", (Object)ExtSerializerSupports.getInvokeContext());
        InvokeCallback invokeCallback = new InvokeCallback(){

            public void complete(Object result, Throwable err) {
                if (err == null) {
                    BaseResponse response = (BaseResponse)result;
                    if (response.isSuccess()) {
                        closure.setData(response.getValue());
                        closure.run(Status.OK());
                    } else {
                        closure.setError(response.getError());
                        closure.run(new Status(-1, "RPC failed with address: %s, response: %s", new Object[]{endpoint, response}));
                    }
                } else {
                    closure.failure(err);
                }
            }

            public Executor executor() {
                return DefaultRheaKVRpcService.this.rpcCallbackExecutor;
            }
        };
        try {
            this.rpcClient.invokeAsync(endpoint, (Object)request, invokeCtx, invokeCallback, (long)this.rpcTimeoutMillis);
        }
        catch (Throwable t) {
            closure.failure(t);
        }
    }

    private ThreadPoolExecutor createRpcCallbackExecutor(RpcOptions opts) {
        int callbackExecutorCorePoolSize = opts.getCallbackExecutorCorePoolSize();
        int callbackExecutorMaximumPoolSize = opts.getCallbackExecutorMaximumPoolSize();
        if (callbackExecutorCorePoolSize <= 0 || callbackExecutorMaximumPoolSize <= 0) {
            return null;
        }
        String name = "rheakv-rpc-callback";
        return ThreadPoolUtil.newBuilder().poolName("rheakv-rpc-callback").enableMetric(Boolean.valueOf(true)).coreThreads(Integer.valueOf(callbackExecutorCorePoolSize)).maximumThreads(Integer.valueOf(callbackExecutorMaximumPoolSize)).keepAliveSeconds(Long.valueOf(120L)).workQueue(new ArrayBlockingQueue(opts.getCallbackExecutorQueueCapacity())).threadFactory((ThreadFactory)new NamedThreadFactory("rheakv-rpc-callback", true)).rejectedHandler((RejectedExecutionHandler)new CallerRunsPolicyWithReport("rheakv-rpc-callback")).build();
    }
}

