/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.client.pd;

import com.alipay.sofa.jraft.rhea.client.FutureHelper;
import com.alipay.sofa.jraft.rhea.client.failover.RetryRunner;
import com.alipay.sofa.jraft.rhea.client.failover.impl.FailoverClosureImpl;
import com.alipay.sofa.jraft.rhea.client.pd.PlacementDriverRpcService;
import com.alipay.sofa.jraft.rhea.cmd.pd.CreateRegionIdRequest;
import com.alipay.sofa.jraft.rhea.cmd.pd.GetClusterInfoRequest;
import com.alipay.sofa.jraft.rhea.cmd.pd.GetStoreIdRequest;
import com.alipay.sofa.jraft.rhea.cmd.pd.GetStoreInfoRequest;
import com.alipay.sofa.jraft.rhea.cmd.pd.SetStoreInfoRequest;
import com.alipay.sofa.jraft.rhea.errors.Errors;
import com.alipay.sofa.jraft.rhea.metadata.Cluster;
import com.alipay.sofa.jraft.rhea.metadata.Store;
import com.alipay.sofa.jraft.util.Endpoint;
import java.util.concurrent.CompletableFuture;

public class MetadataRpcClient {
    private final PlacementDriverRpcService pdRpcService;
    private final int failoverRetries;

    public MetadataRpcClient(PlacementDriverRpcService pdRpcService, int failoverRetries) {
        this.pdRpcService = pdRpcService;
        this.failoverRetries = failoverRetries;
    }

    public Cluster getClusterInfo(long clusterId) {
        CompletableFuture<Cluster> future = new CompletableFuture<Cluster>();
        this.internalGetClusterInfo(clusterId, future, this.failoverRetries, null);
        return FutureHelper.get(future);
    }

    private void internalGetClusterInfo(long clusterId, CompletableFuture<Cluster> future, int retriesLeft, Errors lastCause) {
        RetryRunner retryRunner = retryCause -> this.internalGetClusterInfo(clusterId, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Cluster> closure = new FailoverClosureImpl<Cluster>(future, retriesLeft, retryRunner);
        GetClusterInfoRequest request = new GetClusterInfoRequest();
        request.setClusterId(clusterId);
        this.pdRpcService.callPdServerWithRpc(request, closure, lastCause);
    }

    public Long getOrCreateStoreId(long clusterId, Endpoint endpoint) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.internalGetOrCreateStoreId(clusterId, endpoint, future, this.failoverRetries, null);
        return FutureHelper.get(future);
    }

    private void internalGetOrCreateStoreId(long clusterId, Endpoint endpoint, CompletableFuture<Long> future, int retriesLeft, Errors lastCause) {
        RetryRunner retryRunner = retryCause -> this.internalGetOrCreateStoreId(clusterId, endpoint, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Long> closure = new FailoverClosureImpl<Long>(future, retriesLeft, retryRunner);
        GetStoreIdRequest request = new GetStoreIdRequest();
        request.setClusterId(clusterId);
        request.setEndpoint(endpoint);
        this.pdRpcService.callPdServerWithRpc(request, closure, lastCause);
    }

    public Store getStoreInfo(long clusterId, Endpoint selfEndpoint) {
        CompletableFuture<Store> future = new CompletableFuture<Store>();
        this.internalGetStoreInfo(clusterId, selfEndpoint, future, this.failoverRetries, null);
        return FutureHelper.get(future);
    }

    private void internalGetStoreInfo(long clusterId, Endpoint selfEndpoint, CompletableFuture<Store> future, int retriesLeft, Errors lastCause) {
        RetryRunner retryRunner = retryCause -> this.internalGetStoreInfo(clusterId, selfEndpoint, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Store> closure = new FailoverClosureImpl<Store>(future, retriesLeft, retryRunner);
        GetStoreInfoRequest request = new GetStoreInfoRequest();
        request.setClusterId(clusterId);
        request.setEndpoint(selfEndpoint);
        this.pdRpcService.callPdServerWithRpc(request, closure, lastCause);
    }

    public Store updateStoreInfo(long clusterId, Store store) {
        CompletableFuture<Store> future = new CompletableFuture<Store>();
        this.internalUpdateStoreInfo(clusterId, store, future, 1, null);
        return FutureHelper.get(future);
    }

    private void internalUpdateStoreInfo(long clusterId, Store store, CompletableFuture<Store> future, int retriesLeft, Errors lastCause) {
        RetryRunner retryRunner = retryCause -> this.internalUpdateStoreInfo(clusterId, store, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Store> closure = new FailoverClosureImpl<Store>(future, retriesLeft, retryRunner);
        SetStoreInfoRequest request = new SetStoreInfoRequest();
        request.setClusterId(clusterId);
        request.setStore(store);
        this.pdRpcService.callPdServerWithRpc(request, closure, lastCause);
    }

    public Long createRegionId(long clusterId, Endpoint endpoint) {
        CompletableFuture<Long> future = new CompletableFuture<Long>();
        this.internalCreateRegionId(clusterId, endpoint, future, this.failoverRetries, null);
        return FutureHelper.get(future);
    }

    private void internalCreateRegionId(long clusterId, Endpoint endpoint, CompletableFuture<Long> future, int retriesLeft, Errors lastCause) {
        RetryRunner retryRunner = retryCause -> this.internalCreateRegionId(clusterId, endpoint, future, retriesLeft - 1, retryCause);
        FailoverClosureImpl<Long> closure = new FailoverClosureImpl<Long>(future, retriesLeft, retryRunner);
        CreateRegionIdRequest request = new CreateRegionIdRequest();
        request.setClusterId(clusterId);
        request.setEndpoint(endpoint);
        this.pdRpcService.callPdServerWithRpc(request, closure, lastCause);
    }
}

