/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io;

import com.alipay.sofa.jraft.rhea.serialization.impl.protostuff.io.ProtocolException;
import com.alipay.sofa.jraft.util.BufferUtils;
import com.alipay.sofa.jraft.util.internal.ThrowUtil;
import com.alipay.sofa.jraft.util.internal.UnsafeUtf8Util;
import com.alipay.sofa.jraft.util.internal.UnsafeUtil;
import io.protostuff.ByteBufferInput;
import io.protostuff.ByteString;
import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.ProtobufException;
import io.protostuff.Schema;
import io.protostuff.StringSerializer;
import io.protostuff.UninitializedMessageException;
import io.protostuff.WireFormat;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class NioBufInput
implements Input {
    static final int TAG_TYPE_BITS = 3;
    static final int TAG_TYPE_MASK = 7;
    static final Method byteStringWrapMethod;
    private final ByteBuffer nioBuffer;
    private int lastTag = 0;
    private int packedLimit = 0;
    public final boolean decodeNestedMessageAsGroup;

    public NioBufInput(ByteBuffer nioBuffer, boolean protostuffMessage) {
        this.nioBuffer = nioBuffer;
        this.decodeNestedMessageAsGroup = protostuffMessage;
    }

    public int currentOffset() {
        return this.nioBuffer.position();
    }

    public int currentLimit() {
        return this.nioBuffer.limit();
    }

    public boolean isCurrentFieldPacked() {
        return this.packedLimit != 0 && this.packedLimit != this.nioBuffer.position();
    }

    public int getLastTag() {
        return this.lastTag;
    }

    public int readTag() throws IOException {
        if (!this.nioBuffer.hasRemaining()) {
            this.lastTag = 0;
            return 0;
        }
        int tag = this.readRawVarInt32();
        if (tag >>> 3 == 0) {
            throw ProtocolException.invalidTag();
        }
        this.lastTag = tag;
        return tag;
    }

    public void checkLastTagWas(int value) throws ProtobufException {
        if (this.lastTag != value) {
            throw ProtocolException.invalidEndTag();
        }
    }

    public boolean skipField(int tag) throws IOException {
        switch (WireFormat.getTagWireType((int)tag)) {
            case 0: {
                this.readInt32();
                return true;
            }
            case 1: {
                this.readRawLittleEndian64();
                return true;
            }
            case 2: {
                int size = this.readRawVarInt32();
                if (size < 0) {
                    throw ProtocolException.negativeSize();
                }
                BufferUtils.position((Buffer)this.nioBuffer, (int)(this.nioBuffer.position() + size));
                return true;
            }
            case 3: {
                this.skipMessage();
                this.checkLastTagWas(WireFormat.makeTag((int)WireFormat.getTagFieldNumber((int)tag), (int)4));
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.readRawLittleEndian32();
                return true;
            }
        }
        throw ProtocolException.invalidWireType();
    }

    public void skipMessage() throws IOException {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    public <T> void handleUnknownField(int fieldNumber, Schema<T> schema) throws IOException {
        this.skipField(this.lastTag);
    }

    public <T> int readFieldNumber(Schema<T> schema) throws IOException {
        if (!this.nioBuffer.hasRemaining()) {
            this.lastTag = 0;
            return 0;
        }
        if (this.isCurrentFieldPacked()) {
            if (this.packedLimit < this.nioBuffer.position()) {
                throw ProtocolException.misreportedSize();
            }
            return this.lastTag >>> 3;
        }
        this.packedLimit = 0;
        int tag = this.readRawVarInt32();
        int fieldNumber = tag >>> 3;
        if (fieldNumber == 0) {
            if (this.decodeNestedMessageAsGroup && 7 == (tag & 7)) {
                this.lastTag = 0;
                return 0;
            }
            throw ProtocolException.invalidTag();
        }
        if (this.decodeNestedMessageAsGroup && 4 == (tag & 7)) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = tag;
        return fieldNumber;
    }

    private void checkIfPackedField() throws IOException {
        if (this.packedLimit == 0 && WireFormat.getTagWireType((int)this.lastTag) == 2) {
            int length = this.readRawVarInt32();
            if (length < 0) {
                throw ProtocolException.negativeSize();
            }
            if (this.nioBuffer.position() + length > this.nioBuffer.limit()) {
                throw ProtocolException.misreportedSize();
            }
            this.packedLimit = this.nioBuffer.position() + length;
        }
    }

    public double readDouble() throws IOException {
        this.checkIfPackedField();
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() throws IOException {
        this.checkIfPackedField();
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt64();
    }

    public long readInt64() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt64();
    }

    public int readInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt32();
    }

    public long readFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    public int readFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    public boolean readBool() throws IOException {
        this.checkIfPackedField();
        return this.nioBuffer.get() != 0;
    }

    public int readUInt32() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt32();
    }

    public int readEnum() throws IOException {
        this.checkIfPackedField();
        return this.readRawVarInt32();
    }

    public int readSFixed32() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() throws IOException {
        this.checkIfPackedField();
        return this.readRawLittleEndian64();
    }

    public int readSInt32() throws IOException {
        this.checkIfPackedField();
        int n = this.readRawVarInt32();
        return n >>> 1 ^ -(n & 1);
    }

    public long readSInt64() throws IOException {
        this.checkIfPackedField();
        long n = this.readRawVarInt64();
        return n >>> 1 ^ -(n & 1L);
    }

    public String readString() throws IOException {
        String result;
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        int position = this.nioBuffer.position();
        if (this.nioBuffer.hasArray()) {
            if (UnsafeUtil.hasUnsafe()) {
                BufferUtils.position((Buffer)this.nioBuffer, (int)(position + length));
                result = UnsafeUtf8Util.decodeUtf8((byte[])this.nioBuffer.array(), (int)(this.nioBuffer.arrayOffset() + position), (int)length);
            } else {
                BufferUtils.position((Buffer)this.nioBuffer, (int)(position + length));
                result = StringSerializer.STRING.deser((byte[])this.nioBuffer.array(), (int)(this.nioBuffer.arrayOffset() + position), (int)length);
            }
        } else if (UnsafeUtil.hasUnsafe()) {
            BufferUtils.position((Buffer)this.nioBuffer, (int)(position + length));
            result = UnsafeUtf8Util.decodeUtf8Direct((ByteBuffer)this.nioBuffer, (int)position, (int)length);
        } else {
            byte[] tmp = new byte[length];
            this.nioBuffer.get(tmp);
            result = StringSerializer.STRING.deser((byte[])tmp);
        }
        return result;
    }

    public ByteString readBytes() throws IOException {
        try {
            return (ByteString)byteStringWrapMethod.invoke(null, new Object[]{this.readByteArray()});
        }
        catch (Exception e) {
            ThrowUtil.throwException((Throwable)e);
            return null;
        }
    }

    public void readBytes(ByteBuffer bb) throws IOException {
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        bb.put(this.nioBuffer);
    }

    public byte[] readByteArray() throws IOException {
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        byte[] copy = new byte[length];
        this.nioBuffer.get(copy);
        return copy;
    }

    public <T> T mergeObject(T value, Schema<T> schema) throws IOException {
        if (this.decodeNestedMessageAsGroup) {
            return this.mergeObjectEncodedAsGroup(value, schema);
        }
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (this.nioBuffer.remaining() < length) {
            throw ProtocolException.misreportedSize();
        }
        ByteBuffer dup = this.nioBuffer.slice();
        dup.limit(length);
        if (value == null) {
            value = schema.newMessage();
        }
        ByteBufferInput nestedInput = new ByteBufferInput(dup, false);
        schema.mergeFrom((Input)nestedInput, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        nestedInput.checkLastTagWas(0);
        BufferUtils.position((Buffer)this.nioBuffer, (int)(this.nioBuffer.position() + length));
        return value;
    }

    private <T> T mergeObjectEncodedAsGroup(T value, Schema<T> schema) throws IOException {
        if (value == null) {
            value = schema.newMessage();
        }
        schema.mergeFrom((Input)this, value);
        if (!schema.isInitialized(value)) {
            throw new UninitializedMessageException(value, schema);
        }
        this.checkLastTagWas(0);
        return value;
    }

    public int readRawVarInt32() throws IOException {
        byte tmp = this.nioBuffer.get();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        tmp = this.nioBuffer.get();
        if (tmp >= 0) {
            result |= tmp << 7;
        } else {
            result |= (tmp & 0x7F) << 7;
            tmp = this.nioBuffer.get();
            if (tmp >= 0) {
                result |= tmp << 14;
            } else {
                result |= (tmp & 0x7F) << 14;
                tmp = this.nioBuffer.get();
                if (tmp >= 0) {
                    result |= tmp << 21;
                } else {
                    result |= (tmp & 0x7F) << 21;
                    tmp = this.nioBuffer.get();
                    result |= tmp << 28;
                    if (tmp < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.nioBuffer.get() < 0) continue;
                            return result;
                        }
                        throw ProtocolException.malformedVarInt();
                    }
                }
            }
        }
        return result;
    }

    public long readRawVarInt64() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.nioBuffer.get();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw ProtocolException.malformedVarInt();
    }

    public int readRawLittleEndian32() throws IOException {
        byte[] bs = new byte[4];
        this.nioBuffer.get(bs);
        return bs[0] & 0xFF | (bs[1] & 0xFF) << 8 | (bs[2] & 0xFF) << 16 | (bs[3] & 0xFF) << 24;
    }

    public long readRawLittleEndian64() throws IOException {
        byte[] bs = new byte[8];
        this.nioBuffer.get(bs);
        return (long)bs[0] & 0xFFL | ((long)bs[1] & 0xFFL) << 8 | ((long)bs[2] & 0xFFL) << 16 | ((long)bs[3] & 0xFFL) << 24 | ((long)bs[4] & 0xFFL) << 32 | ((long)bs[5] & 0xFFL) << 40 | ((long)bs[6] & 0xFFL) << 48 | ((long)bs[7] & 0xFFL) << 56;
    }

    public void transferByteRangeTo(Output output, boolean utf8String, int fieldNumber, boolean repeated) throws IOException {
        int length = this.readRawVarInt32();
        if (length < 0) {
            throw ProtocolException.negativeSize();
        }
        if (utf8String) {
            if (this.nioBuffer.hasArray()) {
                output.writeByteRange(true, fieldNumber, this.nioBuffer.array(), this.nioBuffer.arrayOffset() + this.nioBuffer.position(), length, repeated);
                this.nioBuffer.position(this.nioBuffer.position() + length);
            } else {
                byte[] bytes = new byte[length];
                this.nioBuffer.get(bytes);
                output.writeByteRange(true, fieldNumber, bytes, 0, bytes.length, repeated);
            }
        } else {
            if (this.nioBuffer.remaining() < length) {
                throw ProtocolException.misreportedSize();
            }
            ByteBuffer dup = this.nioBuffer.slice();
            dup.limit(length);
            output.writeBytes(fieldNumber, dup, repeated);
            this.nioBuffer.position(this.nioBuffer.position() + length);
        }
    }

    public ByteBuffer readByteBuffer() throws IOException {
        return ByteBuffer.wrap(this.readByteArray());
    }

    static {
        try {
            byteStringWrapMethod = ByteString.class.getDeclaredMethod("wrap", byte[].class);
            byteStringWrapMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }
}

