/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.storage;

import com.alipay.sofa.jraft.rhea.storage.BaseRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.KVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.storage.MemoryKVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.storage.MemoryRawKVStore;
import com.alipay.sofa.jraft.rhea.storage.RocksKVStoreSnapshotFile;
import com.alipay.sofa.jraft.rhea.storage.RocksRawKVStore;
import com.alipay.sofa.jraft.util.Requires;

public final class KVStoreSnapshotFileFactory {
    public static <T> KVStoreSnapshotFile getKVStoreSnapshotFile(BaseRawKVStore<T> kvStore) {
        Requires.requireNonNull(kvStore, (String)"kvStore");
        if (kvStore instanceof RocksRawKVStore) {
            return new RocksKVStoreSnapshotFile((RocksRawKVStore)kvStore);
        }
        if (kvStore instanceof MemoryRawKVStore) {
            return new MemoryKVStoreSnapshotFile((MemoryRawKVStore)kvStore);
        }
        throw KVStoreSnapshotFileFactory.reject("fail to find a KVStoreSnapshotFile with " + kvStore.getClass().getName());
    }

    private static UnsupportedOperationException reject(String message) {
        return new UnsupportedOperationException(message);
    }

    private KVStoreSnapshotFileFactory() {
    }
}

