/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.concurrent.disruptor;

import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.Dispatcher;
import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.LoggingExceptionHandler;
import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.MessageEvent;
import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.TaskHandler;
import com.alipay.sofa.jraft.rhea.util.concurrent.disruptor.WaitStrategyType;
import com.alipay.sofa.jraft.util.Ints;
import com.alipay.sofa.jraft.util.Requires;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.LiteBlockingWaitStrategy;
import com.lmax.disruptor.LiteTimeoutBlockingWaitStrategy;
import com.lmax.disruptor.PhasedBackoffWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.TimeoutBlockingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TaskDispatcher
implements Dispatcher<Runnable> {
    private static final EventFactory<MessageEvent<Runnable>> eventFactory = MessageEvent::new;
    private final Disruptor<MessageEvent<Runnable>> disruptor;

    public TaskDispatcher(int bufSize, int numWorkers, WaitStrategyType waitStrategyType, ThreadFactory threadFactory) {
        BlockingWaitStrategy waitStrategy;
        Requires.requireTrue((bufSize > 0 ? 1 : 0) != 0, (Object)"bufSize must be larger than 0");
        if (!Ints.isPowerOfTwo((int)bufSize)) {
            bufSize = Ints.roundToPowerOfTwo((int)bufSize);
        }
        switch (waitStrategyType) {
            case BLOCKING_WAIT: {
                waitStrategy = new BlockingWaitStrategy();
                break;
            }
            case LITE_BLOCKING_WAIT: {
                waitStrategy = new LiteBlockingWaitStrategy();
                break;
            }
            case TIMEOUT_BLOCKING_WAIT: {
                waitStrategy = new TimeoutBlockingWaitStrategy(1000L, TimeUnit.MILLISECONDS);
                break;
            }
            case LITE_TIMEOUT_BLOCKING_WAIT: {
                waitStrategy = new LiteTimeoutBlockingWaitStrategy(1000L, TimeUnit.MILLISECONDS);
                break;
            }
            case PHASED_BACK_OFF_WAIT: {
                waitStrategy = PhasedBackoffWaitStrategy.withLiteLock((long)1000L, (long)1000L, (TimeUnit)TimeUnit.NANOSECONDS);
                break;
            }
            case SLEEPING_WAIT: {
                waitStrategy = new SleepingWaitStrategy();
                break;
            }
            case YIELDING_WAIT: {
                waitStrategy = new YieldingWaitStrategy();
                break;
            }
            case BUSY_SPIN_WAIT: {
                waitStrategy = new BusySpinWaitStrategy();
                break;
            }
            default: {
                throw new UnsupportedOperationException(waitStrategyType.toString());
            }
        }
        this.disruptor = new Disruptor(eventFactory, bufSize, threadFactory, ProducerType.MULTI, (WaitStrategy)waitStrategy);
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new LoggingExceptionHandler());
        if (numWorkers == 1) {
            this.disruptor.handleEventsWith(new EventHandler[]{new TaskHandler()});
        } else {
            WorkHandler[] handlers = new TaskHandler[numWorkers];
            for (int i = 0; i < numWorkers; ++i) {
                handlers[i] = new TaskHandler();
            }
            this.disruptor.handleEventsWithWorkerPool(handlers);
        }
        this.disruptor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatch(Runnable message) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        try {
            long sequence = ringBuffer.tryNext();
            try {
                MessageEvent event = (MessageEvent)ringBuffer.get(sequence);
                event.setMessage(message);
            }
            finally {
                ringBuffer.publish(sequence);
            }
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    @Override
    public void execute(Runnable message) {
        if (!this.dispatch(message)) {
            message.run();
        }
    }

    @Override
    public void shutdown() {
        this.disruptor.shutdown();
    }
}

