/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.pipeline;

import com.alipay.sofa.jraft.rhea.util.pipeline.DefaultHandlerInvoker;
import com.alipay.sofa.jraft.rhea.util.pipeline.DefaultPipeline;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerContext;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerInvoker;
import com.alipay.sofa.jraft.rhea.util.pipeline.Pipeline;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.InboundMessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.MessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.OutboundMessageEvent;

abstract class AbstractHandlerContext
implements HandlerContext {
    volatile AbstractHandlerContext next;
    volatile AbstractHandlerContext prev;
    private final boolean inbound;
    private final boolean outbound;
    private final DefaultPipeline pipeline;
    private final String name;
    private boolean removed;
    final HandlerInvoker invoker;

    public AbstractHandlerContext(DefaultPipeline pipeline, HandlerInvoker invoker, String name, boolean inbound, boolean outbound) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.pipeline = pipeline;
        this.invoker = invoker == null ? new DefaultHandlerInvoker() : invoker;
        this.name = name;
        this.inbound = inbound;
        this.outbound = outbound;
    }

    @Override
    public Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public HandlerInvoker invoker() {
        return this.invoker;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved() {
        this.removed = true;
    }

    @Override
    public HandlerContext fireInbound(InboundMessageEvent<?> event) {
        AbstractHandlerContext next = this.findContextInbound();
        next.invoker().invokeInbound(next, event);
        return this;
    }

    @Override
    public HandlerContext fireOutbound(OutboundMessageEvent<?> event) {
        AbstractHandlerContext next = this.findContextOutbound();
        next.invoker().invokeOutbound(next, event);
        return this;
    }

    @Override
    public HandlerContext fireExceptionCaught(MessageEvent<?> event, Throwable cause) {
        AbstractHandlerContext next = this.next;
        next.invoker().invokeExceptionCaught(next, event, cause);
        return this;
    }

    private AbstractHandlerContext findContextInbound() {
        AbstractHandlerContext ctx = this;
        do {
            ctx = ctx.next;
        } while (!ctx.inbound);
        return ctx;
    }

    private AbstractHandlerContext findContextOutbound() {
        AbstractHandlerContext ctx = this;
        do {
            ctx = ctx.prev;
        } while (!ctx.outbound);
        return ctx;
    }
}

