/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rhea.util.pipeline;

import com.alipay.sofa.jraft.rhea.util.StackTraceUtil;
import com.alipay.sofa.jraft.rhea.util.pipeline.AbstractHandlerContext;
import com.alipay.sofa.jraft.rhea.util.pipeline.DefaultHandlerContext;
import com.alipay.sofa.jraft.rhea.util.pipeline.Handler;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerAdapter;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerContext;
import com.alipay.sofa.jraft.rhea.util.pipeline.HandlerInvoker;
import com.alipay.sofa.jraft.rhea.util.pipeline.InboundHandler;
import com.alipay.sofa.jraft.rhea.util.pipeline.OutboundHandler;
import com.alipay.sofa.jraft.rhea.util.pipeline.Pipeline;
import com.alipay.sofa.jraft.rhea.util.pipeline.PipelineException;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.InboundMessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.MessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.event.OutboundMessageEvent;
import com.alipay.sofa.jraft.rhea.util.pipeline.future.DefaultPipelineFuture;
import com.alipay.sofa.jraft.rhea.util.pipeline.future.PipelineFuture;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultPipeline
implements Pipeline {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPipeline.class);
    private static final ThreadLocal<Map<Class<?>, String>> nameCaches = ThreadLocal.withInitial(WeakHashMap::new);
    final AbstractHandlerContext head;
    final AbstractHandlerContext tail = new TailContext(this);

    public DefaultPipeline() {
        this.head = new HeadContext(this);
        this.head.next = this.tail;
        this.tail.prev = this.head;
    }

    @Override
    public Pipeline addFirst(String name, Handler handler) {
        return this.addFirst(null, name, handler);
    }

    @Override
    public Pipeline addFirst(HandlerInvoker invoker, String name, Handler handler) {
        name = this.filterName(name, handler);
        this.addFirst0(new DefaultHandlerContext(this, invoker, name, handler));
        return this;
    }

    private void addFirst0(AbstractHandlerContext newCtx) {
        DefaultPipeline.checkMultiplicity(newCtx);
        AbstractHandlerContext nextCtx = this.head.next;
        newCtx.prev = this.head;
        newCtx.next = nextCtx;
        this.head.next = newCtx;
        nextCtx.prev = newCtx;
        this.callHandlerAdded(newCtx);
    }

    @Override
    public Pipeline addLast(String name, Handler handler) {
        return this.addLast(null, name, handler);
    }

    @Override
    public Pipeline addLast(HandlerInvoker invoker, String name, Handler handler) {
        name = this.filterName(name, handler);
        this.addLast0(new DefaultHandlerContext(this, invoker, name, handler));
        return this;
    }

    private void addLast0(AbstractHandlerContext newCtx) {
        AbstractHandlerContext prev;
        DefaultPipeline.checkMultiplicity(newCtx);
        newCtx.prev = prev = this.tail.prev;
        newCtx.next = this.tail;
        prev.next = newCtx;
        this.tail.prev = newCtx;
        this.callHandlerAdded(newCtx);
    }

    @Override
    public Pipeline addBefore(String baseName, String name, Handler handler) {
        return this.addBefore(null, baseName, name, handler);
    }

    @Override
    public Pipeline addBefore(HandlerInvoker invoker, String baseName, String name, Handler handler) {
        AbstractHandlerContext ctx = this.getContextOrDie(baseName);
        name = this.filterName(name, handler);
        this.addBefore0(ctx, new DefaultHandlerContext(this, invoker, name, handler));
        return this;
    }

    private void addBefore0(AbstractHandlerContext ctx, AbstractHandlerContext newCtx) {
        DefaultPipeline.checkMultiplicity(newCtx);
        newCtx.prev = ctx.prev;
        newCtx.next = ctx;
        ctx.prev.next = newCtx;
        ctx.prev = newCtx;
        this.callHandlerAdded(newCtx);
    }

    @Override
    public Pipeline addAfter(String baseName, String name, Handler handler) {
        return this.addAfter(null, baseName, name, handler);
    }

    @Override
    public Pipeline addAfter(HandlerInvoker invoker, String baseName, String name, Handler handler) {
        AbstractHandlerContext ctx = this.getContextOrDie(baseName);
        name = this.filterName(name, handler);
        this.addAfter0(ctx, new DefaultHandlerContext(this, invoker, name, handler));
        return this;
    }

    private void addAfter0(AbstractHandlerContext ctx, AbstractHandlerContext newCtx) {
        DefaultPipeline.checkMultiplicity(newCtx);
        newCtx.prev = ctx;
        newCtx.next = ctx.next;
        ctx.next.prev = newCtx;
        ctx.next = newCtx;
        this.callHandlerAdded(newCtx);
    }

    @Override
    public Pipeline addFirst(Handler ... handlers) {
        return this.addFirst((HandlerInvoker)null, handlers);
    }

    @Override
    public Pipeline addFirst(HandlerInvoker invoker, Handler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        if (handlers.length == 0 || handlers[0] == null) {
            return this;
        }
        for (int size = 1; size < handlers.length && handlers[size] != null; ++size) {
        }
        for (int i = size - 1; i >= 0; --i) {
            Handler h = handlers[i];
            this.addFirst(invoker, (String)null, h);
        }
        return this;
    }

    @Override
    public Pipeline addLast(Handler ... handlers) {
        return this.addLast((HandlerInvoker)null, handlers);
    }

    @Override
    public Pipeline addLast(HandlerInvoker invoker, Handler ... handlers) {
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        for (Handler h : handlers) {
            if (h == null) break;
            this.addLast(invoker, (String)null, h);
        }
        return this;
    }

    @Override
    public Pipeline remove(Handler handler) {
        this.remove(this.getContextOrDie(handler));
        return this;
    }

    @Override
    public Handler remove(String name) {
        return this.remove(this.getContextOrDie(name)).handler();
    }

    @Override
    public <T extends Handler> T remove(Class<T> handlerType) {
        return (T)this.remove(this.getContextOrDie(handlerType)).handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractHandlerContext remove(AbstractHandlerContext ctx) {
        assert (ctx != this.head && ctx != this.tail);
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            this.remove0(ctx);
            return ctx;
        }
    }

    private void remove0(AbstractHandlerContext ctx) {
        AbstractHandlerContext next;
        AbstractHandlerContext prev = ctx.prev;
        prev.next = next = ctx.next;
        next.prev = prev;
        this.callHandlerRemoved(ctx);
    }

    @Override
    public Handler removeFirst() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.head.next).handler();
    }

    @Override
    public Handler removeLast() {
        if (this.head.next == this.tail) {
            throw new NoSuchElementException();
        }
        return this.remove(this.tail.prev).handler();
    }

    @Override
    public Pipeline replace(Handler oldHandler, String newName, Handler newHandler) {
        this.replace(this.getContextOrDie(oldHandler), newName, newHandler);
        return this;
    }

    @Override
    public Handler replace(String oldName, String newName, Handler newHandler) {
        return this.replace(this.getContextOrDie(oldName), newName, newHandler);
    }

    @Override
    public <T extends Handler> T replace(Class<T> oldHandlerType, String newName, Handler newHandler) {
        return (T)this.replace(this.getContextOrDie(oldHandlerType), newName, newHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler replace(AbstractHandlerContext ctx, String newName, Handler newHandler) {
        assert (ctx != this.head && ctx != this.tail);
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            if (newName == null) {
                newName = ctx.name();
            } else if (!ctx.name().equals(newName)) {
                newName = this.filterName(newName, newHandler);
            }
            DefaultHandlerContext newCtx = new DefaultHandlerContext(this, ctx.invoker, newName, newHandler);
            this.replace0(ctx, newCtx);
            return ctx.handler();
        }
    }

    private void replace0(AbstractHandlerContext oldCtx, AbstractHandlerContext newCtx) {
        DefaultPipeline.checkMultiplicity(newCtx);
        AbstractHandlerContext prev = oldCtx.prev;
        AbstractHandlerContext next = oldCtx.next;
        newCtx.prev = prev;
        newCtx.next = next;
        prev.next = newCtx;
        next.prev = newCtx;
        oldCtx.prev = newCtx;
        oldCtx.next = newCtx;
        this.callHandlerAdded(newCtx);
        this.callHandlerRemoved(oldCtx);
    }

    @Override
    public Handler get(String name) {
        HandlerContext ctx = this.context(name);
        if (ctx == null) {
            return null;
        }
        return ctx.handler();
    }

    @Override
    public <T extends Handler> T get(Class<T> handlerType) {
        HandlerContext ctx = this.context(handlerType);
        if (ctx == null) {
            return null;
        }
        return (T)ctx.handler();
    }

    @Override
    public HandlerContext context(Handler handler) {
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        AbstractHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (ctx.handler() == handler) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public HandlerContext context(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.context0(name);
    }

    @Override
    public HandlerContext context(Class<? extends Handler> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        AbstractHandlerContext ctx = this.head.next;
        while (ctx != null) {
            if (handlerType.isAssignableFrom(ctx.handler().getClass())) {
                return ctx;
            }
            ctx = ctx.next;
        }
        return null;
    }

    @Override
    public Pipeline fireInbound(InboundMessageEvent<?> event) {
        this.head.fireInbound(event);
        return this;
    }

    @Override
    public Pipeline fireOutbound(OutboundMessageEvent<?> event) {
        this.tail.fireOutbound(event);
        return this;
    }

    @Override
    public Pipeline fireExceptionCaught(MessageEvent<?> event, Throwable cause) {
        this.head.fireExceptionCaught(event, cause);
        return this;
    }

    @Override
    public <R, M> PipelineFuture<R> invoke(InboundMessageEvent<M> event) {
        return this.invoke(event, -1L);
    }

    @Override
    public <R, M> PipelineFuture<R> invoke(InboundMessageEvent<M> event, long timeoutMillis) {
        DefaultPipelineFuture future = DefaultPipelineFuture.with(event.getInvokeId(), timeoutMillis);
        this.head.fireInbound(event);
        return future;
    }

    private void callHandlerAdded(AbstractHandlerContext ctx) {
        try {
            ctx.handler().handlerAdded(ctx);
        }
        catch (Throwable t) {
            boolean removed;
            block4: {
                removed = false;
                try {
                    this.remove(ctx);
                    removed = true;
                }
                catch (Throwable t2) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn("Failed to remove a handler: {}, {}.", (Object)ctx.name(), (Object)StackTraceUtil.stackTrace(t2));
                }
            }
            this.fireExceptionCaught(null, new PipelineException(ctx.handler().getClass().getName() + ".handlerAdded() has thrown an exception; " + (removed ? "removed." : "also failed to remove."), t));
        }
    }

    private void callHandlerRemoved(AbstractHandlerContext ctx) {
        try {
            ctx.handler().handlerRemoved(ctx);
            ctx.setRemoved();
        }
        catch (Throwable t) {
            this.fireExceptionCaught(null, new PipelineException(ctx.handler().getClass().getName() + ".handlerRemoved() has thrown an exception.", t));
        }
    }

    private static void checkMultiplicity(HandlerContext ctx) {
        Handler handler = ctx.handler();
        if (handler instanceof HandlerAdapter) {
            HandlerAdapter h = (HandlerAdapter)handler;
            if (!h.isSharable() && h.added) {
                throw new PipelineException(h.getClass().getName() + " is not a @Sharable handler, so can't be added or removed multiple times.");
            }
            h.added = true;
        }
    }

    private String filterName(String name, Handler handler) {
        if (name == null) {
            return this.generateName(handler);
        }
        if (this.context0(name) == null) {
            return name;
        }
        throw new IllegalArgumentException("Duplicate handler name: " + name);
    }

    private AbstractHandlerContext context0(String name) {
        AbstractHandlerContext context = this.head.next;
        while (context != this.tail) {
            if (context.name().equals(name)) {
                return context;
            }
            context = context.next;
        }
        return null;
    }

    private AbstractHandlerContext getContextOrDie(String name) {
        AbstractHandlerContext ctx = (AbstractHandlerContext)this.context(name);
        if (ctx == null) {
            throw new NoSuchElementException(name);
        }
        return ctx;
    }

    private AbstractHandlerContext getContextOrDie(Handler handler) {
        AbstractHandlerContext ctx = (AbstractHandlerContext)this.context(handler);
        if (ctx == null) {
            throw new NoSuchElementException(handler.getClass().getName());
        }
        return ctx;
    }

    private AbstractHandlerContext getContextOrDie(Class<? extends Handler> handlerType) {
        AbstractHandlerContext ctx = (AbstractHandlerContext)this.context(handlerType);
        if (ctx == null) {
            throw new NoSuchElementException(handlerType.getName());
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateName(Handler handler) {
        Class<?> handlerType;
        Map<Class<?>, String> cache = nameCaches.get();
        String name = cache.get(handlerType = handler.getClass());
        if (name == null) {
            name = DefaultPipeline.generateName0(handlerType);
            cache.put(handlerType, name);
        }
        DefaultPipeline defaultPipeline = this;
        synchronized (defaultPipeline) {
            if (this.context0(name) != null) {
                String baseName = name.substring(0, name.length() - 1);
                int i = 1;
                while (true) {
                    String newName;
                    if (this.context0(newName = baseName + i) == null) {
                        name = newName;
                        break;
                    }
                    ++i;
                }
            }
        }
        return name;
    }

    private static String generateName0(Class<?> handlerType) {
        if (handlerType == null) {
            throw new NullPointerException("handlerType");
        }
        String className = handlerType.getName();
        int lastDotIdx = className.lastIndexOf(46);
        if (lastDotIdx > -1) {
            className = className.substring(lastDotIdx + 1);
        }
        return className + "#0";
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getClass().getSimpleName()).append('{');
        AbstractHandlerContext ctx = this.head.next;
        while (ctx != this.tail) {
            buf.append('(').append(ctx.name()).append(" = ").append(ctx.handler().getClass().getName()).append(')');
            ctx = ctx.next;
            if (ctx == this.tail) break;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    static /* synthetic */ String access$000(Class x0) {
        return DefaultPipeline.generateName0(x0);
    }

    static final class HeadContext
    extends AbstractHandlerContext
    implements OutboundHandler {
        private static final String HEAD_NAME = DefaultPipeline.access$000(HeadContext.class);

        public HeadContext(DefaultPipeline pipeline) {
            super(pipeline, null, HEAD_NAME, false, true);
        }

        @Override
        public boolean isAcceptable(MessageEvent<?> event) {
            return true;
        }

        @Override
        public void handlerAdded(HandlerContext ctx) throws Exception {
        }

        @Override
        public void handlerRemoved(HandlerContext ctx) throws Exception {
        }

        @Override
        public void exceptionCaught(HandlerContext ctx, MessageEvent<?> event, Throwable cause) throws Exception {
            ctx.fireExceptionCaught(event, cause);
        }

        @Override
        public Handler handler() {
            return this;
        }

        @Override
        public void handleOutbound(HandlerContext ctx, OutboundMessageEvent<?> event) throws Exception {
            if (event != null) {
                DefaultPipelineFuture.received(event.getInvokeId(), event.getMessage());
            }
        }
    }

    static final class TailContext
    extends AbstractHandlerContext
    implements InboundHandler {
        private static final String TAIL_NAME = DefaultPipeline.access$000(TailContext.class);

        public TailContext(DefaultPipeline pipeline) {
            super(pipeline, null, TAIL_NAME, true, false);
        }

        @Override
        public boolean isAcceptable(MessageEvent<?> event) {
            return true;
        }

        @Override
        public void handleInbound(HandlerContext ctx, InboundMessageEvent<?> event) throws Exception {
        }

        @Override
        public void exceptionCaught(HandlerContext ctx, MessageEvent<?> event, Throwable cause) throws Exception {
            LOG.warn("An exceptionCaught() event was fired, {}.", (Object)StackTraceUtil.stackTrace(cause));
            if (event != null) {
                DefaultPipelineFuture.received(event.getInvokeId(), cause);
            }
        }

        @Override
        public void handlerAdded(HandlerContext ctx) throws Exception {
        }

        @Override
        public void handlerRemoved(HandlerContext ctx) throws Exception {
        }

        @Override
        public Handler handler() {
            return this;
        }
    }
}

