/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.google.gson.JsonObject;
import com.microsoft.playwright.impl.ChannelOwner;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;

public class Stream
extends ChannelOwner {
    private final InputStream stream = new InputStreamImpl();

    public Stream(ChannelOwner parent, String type, String guid, JsonObject initializer) {
        super(parent, type, guid, initializer);
    }

    InputStream stream() {
        return this.stream;
    }

    private class InputStreamImpl
    extends InputStream {
        private InputStreamImpl() {
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[]{0};
            int result = this.read(b, 0, 1);
            if (result == -1) {
                return result;
            }
            return 0xFF & b[0];
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (len == 0) {
                return 0;
            }
            JsonObject params = new JsonObject();
            params.addProperty("size", (Number)len);
            JsonObject json = Stream.this.sendMessage("read", params).getAsJsonObject();
            String encoded = json.get("binary").getAsString();
            if (encoded.isEmpty()) {
                return -1;
            }
            byte[] buffer = Base64.getDecoder().decode(encoded);
            int i = 0;
            while (i < buffer.length) {
                b[off++] = buffer[i++];
            }
            return buffer.length;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Stream.this.sendMessage("close");
        }
    }
}

