/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IFunctionNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class FunctionNameRule
extends LinterRule {
    public static final Pattern DEFAULT_NAME_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*$");
    public Pattern pattern;

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.FunctionID, (node, tokenQuery, problems) -> this.checkFunctionNode((IFunctionNode)node, tokenQuery, problems));
        return result;
    }

    private void checkFunctionNode(IFunctionNode functionNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        Matcher matcher;
        if (functionNode.isConstructor()) {
            return;
        }
        String functionName = functionNode.getName();
        if (functionName == null || functionName.length() == 0) {
            return;
        }
        Pattern thePattern = this.pattern;
        if (thePattern == null) {
            thePattern = DEFAULT_NAME_PATTERN;
        }
        if ((matcher = thePattern.matcher(functionName)).matches()) {
            return;
        }
        problems.add(new FunctionNameLinterProblem(functionNode, thePattern));
    }

    public static class FunctionNameLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Function name '${functionName}' does not match the pattern '${pattern}'";
        public String pattern;
        public String functionName;

        public FunctionNameLinterProblem(IFunctionNode node, Pattern pattern) {
            super((ISourceLocation)node.getNameExpressionNode());
            this.pattern = pattern.toString();
            this.functionName = node.getName();
        }
    }
}

